function mpc = case2383wp
%CASE2383WP  Power flow data for Polish system - winter 1999-2000 peak.
%   Please see CASEFORMAT for details on the case file format.
%
%   This case represents the Polish 400, 220 and 110 kV networks during
%   winter 1999-2000 peak conditions. It is part of the 7500+ bus
%   Europen UCTE system. To decrease the number of buses, the tie lines
%   to foreign networks were replaced by artificial load or generator
%   buses (180-186). Multiple generators at a bus have been aggregated.
%   Generators that are not centrally dispatchable in the Polish energy
%   market are given a cost of zero.
%
%   This data was graciously provided by, and is distributed with the
%   permission of, Roman Korab <roman.korab@polsl.pl>.

%   MATPOWER
%   $Id: case2383wp.m 1559 2010-03-10 18:08:32Z ray $

%% MATPOWER Case Format : Version 2
mpc.version = '2';

%%-----  Power Flow Data  -----%%
%% system MVA base
mpc.baseMVA = 100;

%% bus data
%	bus_i	type	Pd	Qd	Gs	Bs	area	Vm	Va	baseKV	zone	Vmax	Vmin
mpc.bus = [
	1	1	0	0	0	0	1	1.0945877	-1.4947677	220	1	1.11	0.95;
	2	1	0	0	0	0	1	1.0853611	-1.0101313	220	1	1.11	0.95;
	3	1	0	0	0	0	1	1.0745702	-26.208185	220	1	1.11	0.95;
	4	1	0	0	0	0	1	1.0714122	-8.5164763	220	1	1.11	0.95;
	5	1	0	0	0	0	1	1.0665303	-18.99745	220	1	1.11	0.95;
	6	1	0	0	0	0	1	1.0235863	-13.822343	400	1	1.05	0.95;
	7	1	0	0	0	0	1	1.0597742	-21.443703	220	1	1.11	0.95;
	8	1	0	0	0	0	1	1.0274658	-10.380289	400	1	1.05	0.95;
	9	1	0	0	0	0	1	1.0356969	-16.876105	400	1	1.05	0.95;
	10	2	12.23	9	0	0	1	1.1082311	-20.649904	220	1	1.11	0.95;
	11	1	0	0	0	0	1	1.077772	-7.0641396	220	1	1.11	0.95;
	12	1	0	0	0	0	1	1.0668445	-23.917665	220	1	1.11	0.95;
	13	1	0	0	0	0	1	1.0651982	-21.489714	220	1	1.11	0.95;
	14	1	0	0	0	0	1	1.0663588	-5.069768	220	1	1.11	0.95;
	15	1	0	0	0	0	1	1.0094205	-15.318814	400	1	1.05	0.95;
	16	2	54.88	100	0	0	1	1.0974008	-0.98470838	220	1	1.11	0.95;
	17	2	77	150	0	0	1	1.0910267	-0.14840674	220	1	1.11	0.95;
	18	3	153	350	0	0	1	1.0337129	0	400	1	1.05	0.95;
	19	1	0	0	0	0	1	1.0659295	-22.685677	220	1	1.11	0.95;
	20	1	0	0	0	0	1	1.0371271	-1.9368717	400	1	1.05	0.95;
	21	1	0	0	0	0	1	1.0594484	-21.874798	220	1	1.11	0.95;
	22	1	0	0	0	0	1	1.0814061	-12.38874	220	1	1.11	0.95;
	23	1	0	0	0	0	1	1.0623561	-16.684586	220	2	1.11	0.95;
	24	1	0	0	0	0	1	1.0544773	-12.101862	220	2	1.11	0.95;
	25	1	0	0	0	0	1	1.0566312	-10.623758	220	2	1.11	0.95;
	26	1	0	0	0	0	1	1.0514089	-19.520072	220	2	1.11	0.95;
	27	1	0	0	0	0	1	1.065879	-10.248111	220	2	1.11	0.95;
	28	1	0	0	0	0	1	1.0658528	-10.243115	220	2	1.11	0.95;
	29	2	25.98	60	0	0	1	1.0967104	-15.340069	220	2	1.11	0.95;
	30	2	25.98	60	0	0	1	1.0967037	-15.340793	220	2	1.11	0.95;
	31	2	20.98	50	0	0	1	1.0214422	-10.730991	400	2	1.05	0.95;
	32	1	0	0	0	0	1	1.0214388	-10.770221	400	2	1.05	0.95;
	33	1	0	0	0	0	1	1.0603418	-11.007759	220	2	1.11	0.95;
	34	1	0	0	0	0	1	1.0437449	-10.313949	400	2	1.05	0.95;
	35	1	0	0	0	0	1	1.0437713	-10.321962	400	2	1.05	0.95;
	36	1	0	0	0	0	1	1.0036235	-14.019908	400	2	1.05	0.95;
	37	1	0	0	0	0	1	1.0617538	-17.65358	220	2	1.11	0.95;
	38	1	0	0	0	0	1	1.0617576	-17.652543	220	2	1.11	0.95;
	39	1	0	0	0	0	1	1.0154269	-9.4424041	400	2	1.05	0.95;
	40	1	0	0	0	0	1	1.0154039	-9.4320741	400	2	1.05	0.95;
	41	2	11.99	30	0	0	1	1.0608776	-8.4979859	220	2	1.11	0.95;
	42	2	11.99	30	0	0	1	1.0608614	-8.5104656	220	2	1.11	0.95;
	43	2	23.98	60	0	0	1	1.0229141	-6.9130429	400	2	1.05	0.95;
	44	2	23.98	60	0	0	1	1.0229414	-6.9257613	400	2	1.05	0.95;
	45	2	159.84	75	0	0	1	1.0792177	-16.289871	220	2	1.11	0.95;
	46	1	0	0	0	0	1	1.0792304	-16.288302	220	2	1.11	0.95;
	47	1	0	0	0	0	1	1.0601105	-10.892212	220	2	1.11	0.95;
	48	1	0	0	0	0	1	1.0778118	-15.293456	220	2	1.11	0.95;
	49	1	0	0	0	0	1	1.0778399	-15.297932	220	2	1.11	0.95;
	50	1	0	0	0	0	1	1.0308481	-8.5192355	400	2	1.05	0.95;
	51	1	0	0	0	0	1	1.0309346	-8.5378387	400	2	1.05	0.95;
	52	1	0	0	0	0	1	1.0531367	-13.126893	220	2	1.11	0.95;
	53	1	0	0	0	0	1	1.0551341	-13.005169	220	2	1.11	0.95;
	54	1	0	0	0	0	1	1.056839	-10.553596	220	2	1.11	0.95;
	55	1	0	0	0	0	1	1.0666858	-16.701687	220	2	1.11	0.95;
	56	1	0	0	0	0	1	1.0801732	-5.1254995	220	3	1.11	0.95;
	57	1	22.98	10.96	0	0	1	1.0788131	-7.2859357	220	3	1.11	0.95;
	58	1	21.98	5.79	0	0	1	1.079041	-7.2859427	220	3	1.11	0.95;
	59	1	0	0	0	0	1	1.1053709	0.46680305	220	3	1.11	0.95;
	60	1	0	0	0	0	1	1.1034167	-3.8522131	220	3	1.11	0.95;
	61	1	0	0	0	0	1	1.1084574	2.0938304	220	3	1.11	0.95;
	62	1	0	0	0	0	1	1.1084386	2.0954656	220	3	1.11	0.95;
	63	2	37.37	52.69	0	0	1	1.11	0.81330015	220	3	1.11	0.95;
	64	2	35.37	55.32	0	0	1	1.1092626	0.64640274	220	3	1.11	0.95;
	65	1	13.39	2.02	0	0	1	1.1032007	-1.0285054	220	3	1.11	0.95;
	66	1	0	0	0	0	1	1.1002514	-8.6354732	220	3	1.11	0.95;
	67	2	60.4	92.1	0	0	1	1.05	-6.5572721	400	3	1.05	0.95;
	68	1	0	0	0	0	1	1.1001654	-6.9023386	220	3	1.11	0.95;
	69	1	0	0	0	0	1	1.1069854	-0.83820638	220	3	1.11	0.95;
	70	1	0	0	0	0	1	1.0848694	-4.3023178	220	3	1.11	0.95;
	71	1	0	0	0	0	1	1.0989066	-1.837146	220	3	1.11	0.95;
	72	1	0	0	0	0	1	1.0989066	-1.837146	220	3	1.11	0.95;
	73	1	0	0	0	0	1	1.0878356	-3.6331435	220	3	1.11	0.95;
	74	1	0	0	0	0	1	1.0848991	-4.5132859	220	3	1.11	0.95;
	75	1	0	0	0	0	1	1.0319269	-1.6723208	400	3	1.05	0.95;
	76	1	0	0	0	0	1	1.031903	-1.6782928	400	3	1.05	0.95;
	77	1	0	0	0	0	1	1.0986956	-2.26735	220	3	1.11	0.95;
	78	1	0	0	0	0	1	1.0966324	-4.9713203	220	3	1.11	0.95;
	79	1	0	0	0	0	1	1.0987986	-1.276796	220	3	1.11	0.95;
	80	1	0	0	0	0	1	1.0794572	-7.2345064	220	3	1.11	0.95;
	81	1	0	0	0	0	1	1.0794748	-7.2341604	220	3	1.11	0.95;
	82	1	0	0	0	0	1	1.1039055	1.0127598	220	3	1.11	0.95;
	83	2	15.99	22.97	0	0	1	1.1089547	-0.82047491	220	3	1.11	0.95;
	84	2	15.79	22.27	0	0	1	1.1090726	-0.82183963	220	3	1.11	0.95;
	85	2	9.99	17.01	0	0	1	1.1017195	-2.2938246	220	3	1.11	0.95;
	86	2	9.99	16.66	0	0	1	1.1016369	-2.29227	220	3	1.11	0.95;
	87	1	11.09	16.22	0	0	1	1.0893689	-3.1476165	220	3	1.11	0.95;
	88	1	0	0	0	0	1	1.0893851	-3.1479875	220	3	1.11	0.95;
	89	1	0	0	0	0	1	1.1000808	-1.2380944	220	3	1.11	0.95;
	90	1	0	0	0	0	1	1.1042303	-1.7979475	220	3	1.11	0.95;
	91	1	0	0	0	0	1	1.1025585	-0.66612181	220	3	1.11	0.95;
	92	1	0	0	0	0	1	1.0237095	-5.5065252	400	3	1.05	0.95;
	93	2	9.99	16.39	0	0	1	1.1056302	-0.2952057	220	3	1.11	0.95;
	94	1	0	0	0	0	1	1.1056158	-0.29680978	220	3	1.11	0.95;
	95	2	6.89	8.15	0	0	1	1.1075265	-0.4539646	220	3	1.11	0.95;
	96	1	0	0	0	0	1	1.1075224	-0.45839832	220	3	1.11	0.95;
	97	2	8.69	5.26	0	0	1	1.0967425	-4.8472969	220	3	1.11	0.95;
	98	1	0	0	0	0	1	1.0231775	-7.554412	400	3	1.05	0.95;
	99	1	0	0	0	0	1	1.0232586	-7.5444428	400	3	1.05	0.95;
	100	1	0	0	0	0	1	1.0319735	-5.1585252	400	3	1.05	0.95;
	101	1	0	0	0	0	1	1.0319919	-5.1492029	400	3	1.05	0.95;
	102	1	0	0	0	0	1	1.1020054	-1.14745	220	3	1.11	0.95;
	103	2	18.09	23.76	0	0	1	1.1067084	-1.913684	220	3	1.11	0.95;
	104	2	33.68	46.11	0	0	1	1.106757	-1.9078196	220	3	1.11	0.95;
	105	2	33.78	62.95	0	0	1	1.0166743	-4.8853891	400	3	1.05	0.95;
	106	1	0	0	0	0	1	1.0168266	-4.8990837	400	3	1.05	0.95;
	107	1	0	0	0	0	1	1.0835964	-4.5876186	220	3	1.11	0.95;
	108	1	0	0	0	0	1	1.0853205	-4.4168627	220	3	1.11	0.95;
	109	2	1	22.36	0	0	1	1.11	2.8143573	220	3	1.11	0.95;
	110	2	1	22.18	0	0	1	1.11	2.8158748	220	3	1.11	0.95;
	111	2	26.49	18	0	0	1	1.1066085	-14.342043	220	4	1.11	0.95;
	112	1	0	0	0	0	1	1.1064908	-14.335874	220	4	1.11	0.95;
	113	1	0	0	0	0	1	1.0622147	-26.875135	220	4	1.11	0.95;
	114	1	0	0	0	0	1	1.0754961	-26.337792	220	4	1.11	0.95;
	115	1	0	0	0	0	1	0.98336245	-20.290762	400	4	1.05	0.95;
	116	1	0	0	0	0	1	0.9833576	-20.281214	400	4	1.05	0.95;
	117	1	0	0	0	0	1	1.0726984	-30.012965	220	4	1.11	0.95;
	118	1	0	0	0	0	1	1.0671655	-38.724474	220	4	1.11	0.95;
	119	1	0	0	0	0	1	1.0671655	-38.724474	220	4	1.11	0.95;
	120	1	0	0	0	0	1	1.0513316	-37.190715	220	4	1.11	0.95;
	121	1	0	0	0	0	1	1.0699553	-26.91977	220	4	1.11	0.95;
	122	1	0	0	0	0	1	1.0699553	-26.91977	220	4	1.11	0.95;
	123	2	5.5	7	0	0	1	1.1096575	-19.400308	220	4	1.11	0.95;
	124	2	8.79	17	0	0	1	1.1096796	-19.394703	220	4	1.11	0.95;
	125	2	35.7	18.3	0	0	1	1.1062235	-35.575758	220	4	1.11	0.95;
	126	1	25.28	15.9	0	0	1	1.1060523	-35.563149	220	4	1.11	0.95;
	127	2	25.71	15.3	0	0	1	1.0330077	-27.760745	400	4	1.05	0.95;
	128	1	0	0	0	0	1	1.0329471	-27.768773	400	4	1.05	0.95;
	129	1	0	0	0	0	1	1.0451738	-32.578133	220	4	1.11	0.95;
	130	1	0	0	0	0	1	1.0345938	-33.954129	220	4	1.11	0.95;
	131	2	68.67	70	0	0	1	1.0993161	-24.081795	220	4	1.11	0.95;
	132	2	33	45	0	0	1	1.0994336	-24.0968	220	4	1.11	0.95;
	133	1	0	0	0	0	1	0.99528738	-19.61073	400	4	1.05	0.95;
	134	1	0	0	0	0	1	0.99528984	-19.609417	400	4	1.05	0.95;
	135	1	0	0	0	0	1	1.0672352	-38.652391	220	4	1.11	0.95;
	136	1	0	0	0	0	1	1.0672352	-38.652391	220	4	1.11	0.95;
	137	1	0	0	0	0	1	1.0000355	-16.649236	400	4	1.05	0.95;
	138	1	0	0	0	0	1	1.0000355	-16.649236	400	4	1.05	0.95;
	139	2	33.2	22.6	0	0	1	1.11	-19.694688	220	4	1.11	0.95;
	140	2	29.23	19.6	0	0	1	1.1099933	-19.702053	220	4	1.11	0.95;
	141	1	0	0	0	0	1	1.048715	-35.311344	220	4	1.11	0.95;
	142	1	0	0	0	0	1	1.064119	-38.929037	220	4	1.11	0.95;
	143	1	0	0	0	0	1	1.0713386	-31.500664	220	4	1.11	0.95;
	144	1	0	0	0	0	1	1.0712535	-31.499755	220	4	1.11	0.95;
	145	1	0	0	0	0	1	0.97659289	-31.179217	400	4	1.05	0.95;
	146	1	0	0	0	0	1	0.97659289	-31.179217	400	4	1.05	0.95;
	147	1	0	0	0	0	1	1.0443448	-30.604356	220	4	1.11	0.95;
	148	1	0	0	0	0	1	1.0443916	-30.598683	220	4	1.11	0.95;
	149	1	0	0	0	0	1	1.0678968	-32.197135	220	4	1.11	0.95;
	150	1	0	0	0	0	1	1.0650767	-26.052001	220	4	1.11	0.95;
	151	1	0	0	0	0	1	1.0651101	-26.059553	220	4	1.11	0.95;
	152	1	0	0	0	0	1	1.0585155	-22.471056	220	4	1.11	0.95;
	153	1	0	0	0	0	1	1.0585155	-22.471056	220	4	1.11	0.95;
	154	1	0	0	0	0	1	1.0281414	-32.398849	220	4	1.11	0.95;
	155	1	0	0	0	0	1	1.0546513	-27.826247	220	5	1.11	0.95;
	156	1	0	0	0	0	1	1.11	-30.199576	220	5	1.11	0.95;
	157	1	0	0	0	0	1	1.0249742	-28.306241	400	5	1.05	0.95;
	158	1	0	0	0	0	1	1.0249445	-28.299084	400	5	1.05	0.95;
	159	1	0	0	0	0	1	1.0281885	-25.15157	400	5	1.05	0.95;
	160	1	0	0	0	0	1	1.0282505	-25.159467	400	5	1.05	0.95;
	161	1	0	0	0	0	1	1.0551509	-31.094903	220	5	1.11	0.95;
	162	1	0	0	0	0	1	1.0551612	-31.095945	220	5	1.11	0.95;
	163	1	0	0	0	0	1	1.0871116	-28.613244	220	5	1.11	0.95;
	164	1	0	0	0	0	1	1.0870899	-28.614645	220	5	1.11	0.95;
	165	1	0	0	0	0	1	1.0015127	-22.606405	400	5	1.05	0.95;
	166	1	0	0	0	0	1	1.0669085	-27.062976	220	5	1.11	0.95;
	167	1	0	0	0	0	1	1.0669473	-27.061011	220	5	1.11	0.95;
	168	1	0	0	0	0	1	1.0301024	-26.893903	400	5	1.05	0.95;
	169	1	0	0	0	0	1	1.0300885	-26.900803	400	5	1.05	0.95;
	170	1	0	0	0	0	1	1.0558357	-27.940656	220	5	1.11	0.95;
	171	1	0	0	0	0	1	1.0558643	-27.937264	220	5	1.11	0.95;
	172	1	0	0	0	0	1	1.0622074	-29.119619	220	5	1.11	0.95;
	173	1	0	0	0	0	1	1.0621703	-29.117898	220	5	1.11	0.95;
	174	1	0	0	0	0	1	1.0599592	-26.90187	220	5	1.11	0.95;
	175	1	0	0	0	0	1	1.0599468	-26.909123	220	5	1.11	0.95;
	176	2	0	40	0	0	1	1.0312974	-23.918174	400	5	1.05	0.95;
	177	2	0	40	0	0	1	1.0314652	-23.915354	400	5	1.05	0.95;
	178	1	0	0	0	0	1	1.0784273	-32.277798	220	5	1.11	0.95;
	179	1	0	0	0	0	1	1.0784605	-32.27305	220	5	1.11	0.95;
	180	2	339.85	49.6	0	0	2	1.0088011	-7.67851	400	6	1.05	0.95;
	181	2	0	0	0	0	3	1.107243	-9.829618	220	6	1.11	0.95;
	182	2	0	0	0	0	5	0.99674384	-19.315074	400	6	1.05	0.95;
	183	1	150	0	0	0	3	1.05	-11.249574	400	6	1.05	0.95;
	184	2	317.34	50.3	0	0	2	1.0968373	-4.7574182	220	6	1.11	0.95;
	185	2	362.43	36.7	0	0	2	1.0079864	-8.4602128	400	6	1.05	0.95;
	186	2	33.33	1	0	0	5	1.1085323	-35.707557	220	6	1.11	0.95;
	187	1	7.12	1.5	0	0	1	1.0661462	-25.696348	110	1	1.12	0.95;
	188	1	7.63	1	0	0	1	1.0417885	-32.262122	110	1	1.12	0.95;
	189	1	9.77	8.7	0	0	1	0.99718305	-29.5143	110	1	1.12	0.95;
	190	1	6.12	1.5	0	0	1	1.1039302	-5.684507	110	1	1.12	0.95;
	191	1	6.12	1.6	0	0	1	1.0850303	-6.8881668	110	1	1.12	0.95;
	192	2	30.56	12	0	0	1	1.12	-22.081124	110	1	1.12	0.95;
	193	1	15.28	3	0	0	1	1.1188593	-21.954733	110	1	1.12	0.95;
	194	1	0	0	0	0	1	1.1185785	-22.247684	110	1	1.12	0.95;
	195	1	8.14	2	0	0	1	1.0830451	-26.733431	110	1	1.12	0.95;
	196	2	6.92	1.5	0	0	1	1.0192036	-33.404165	110	1	1.12	0.95;
	197	1	6.92	1.5	0	0	1	1.0731126	-15.402964	110	1	1.12	0.95;
	198	2	12.32	1.7	0	0	1	1.0753335	-26.893503	110	1	1.12	0.95;
	199	1	1.43	0.5	0	0	1	1.1078311	-8.269607	110	1	1.12	0.95;
	200	1	1.08	0.5	0	0	1	1.0976338	-25.949869	110	1	1.12	0.95;
	201	1	5.61	0.5	0	0	1	1.0920272	-27.749079	110	1	1.12	0.95;
	202	1	18.34	2	0	0	1	1.0941294	-23.627445	110	1	1.12	0.95;
	203	1	11.1	1.6	0	0	1	1.0773981	-27.109997	110	1	1.12	0.95;
	204	1	0	0	0	0	1	1.117645	-14.002284	110	1	1.12	0.95;
	205	2	6.92	2	0	0	1	1.1197782	-12.024748	110	1	1.12	0.95;
	206	1	11.2	1	0	0	1	1.0639718	-27.700762	110	1	1.12	0.95;
	207	1	7.32	1.6	0	0	1	1.0866742	-6.6763857	110	1	1.12	0.95;
	208	1	-7.32	-4.5	0	0	1	1.0817502	-14.987829	110	1	1.12	0.95;
	209	1	9.36	0.8	0	0	1	1.0822683	-28.304157	110	1	1.12	0.95;
	210	1	15.18	4.4	0	0	1	1.118031	-10.834751	110	1	1.12	0.95;
	211	1	8.75	0.2	0	0	1	1.0813257	-28.413546	110	1	1.12	0.95;
	212	1	10.18	1.5	0	0	1	1.0900681	-25.3979	110	1	1.12	0.95;
	213	2	-2.04	-1	0	0	1	1.0695123	-27.569424	110	1	1.12	0.95;
	214	1	12.02	0.5	0	0	1	1.0704783	-30.720759	110	1	1.12	0.95;
	215	1	6.92	2	0	0	1	1.1170154	-11.51124	110	1	1.12	0.95;
	216	1	8.85	0.5	0	0	1	1.1176949	-6.4597806	110	1	1.12	0.95;
	217	1	1.94	0.4	0	0	1	1.1195798	-21.183041	110	1	1.12	0.95;
	218	1	12.22	1.5	0	0	1	1.0778381	-29.362408	110	1	1.12	0.95;
	219	1	2.55	0.5	0	0	1	1.092836	-28.058717	110	1	1.12	0.95;
	220	1	2.55	0.5	0	0	1	1.0639874	-29.34072	110	1	1.12	0.95;
	221	1	4.08	0.5	0	0	1	1.0233157	-34.819624	110	1	1.12	0.95;
	222	1	6.53	0.4	0	0	1	1.0999519	-24.80992	110	1	1.12	0.95;
	223	1	18.65	4	0	0	1	1.0802245	-20.784966	110	1	1.12	0.95;
	224	1	19.86	2.5	0	0	1	1.0660683	-27.687918	110	1	1.12	0.95;
	225	1	17.3	2	0	0	1	1.0456739	-32.542949	110	1	1.12	0.95;
	226	1	24.44	1.5	0	0	1	1.0908182	-27.616309	110	1	1.12	0.95;
	227	1	5.61	1	0	0	1	1.0912032	-27.749985	110	1	1.12	0.95;
	228	1	11.4	1.1	0	0	1	1.0814662	-7.3292751	110	1	1.12	0.95;
	229	1	11	2.7	0	0	1	1.1053622	-15.168081	110	1	1.12	0.95;
	230	1	7.63	1	0	0	1	1.0196257	-35.477572	110	1	1.12	0.95;
	231	1	7.94	1.1	0	0	1	1.0956602	-24.169311	110	1	1.12	0.95;
	232	1	7.94	1.1	0	0	1	1.0659828	-24.648194	110	1	1.12	0.95;
	233	1	1.84	0.8	0	0	1	1.0772286	-29.346079	110	1	1.12	0.95;
	234	1	33.46	28	0	0	1	1.0866321	-6.4435989	110	1	1.12	0.95;
	235	1	33.76	28	0	0	1	1.092194	-4.7499346	110	1	1.12	0.95;
	236	1	1.02	0.5	0	0	1	1.0636366	-27.435845	110	1	1.12	0.95;
	237	1	13.95	1.7	0	0	1	1.0824507	-28.838877	110	1	1.12	0.95;
	238	1	9.98	1	0	0	1	1.1060729	-24.036591	110	1	1.12	0.95;
	239	1	15.28	1.5	0	0	1	1.0962692	-23.844155	110	1	1.12	0.95;
	240	1	11.2	1.5	0	0	1	1.026604	-34.175106	110	1	1.12	0.95;
	241	1	10.18	3	0	0	1	1.061752	-26.725112	110	1	1.12	0.95;
	242	1	1.22	0.1	0	0	1	1.0683021	-26.898112	110	1	1.12	0.95;
	243	1	0	0	0	0	1	1.1185057	-22.822079	110	1	1.12	0.95;
	244	1	1.02	0	0	0	1	1.1077587	-23.662685	110	1	1.12	0.95;
	245	1	12.12	5.4	0	0	1	1.1191336	-12.718707	110	1	1.12	0.95;
	246	1	-8.14	-3.6	0	0	1	1.1196966	-10.798388	110	1	1.12	0.95;
	247	1	11.2	1.5	0	0	1	1.0768511	-15.10413	110	1	1.12	0.95;
	248	1	3.06	0.5	0	0	1	1.1129597	-23.088953	110	1	1.12	0.95;
	249	1	9.16	0	0	0	1	1.103669	-24.282994	110	1	1.12	0.95;
	250	1	27.71	3	0	0	1	1.1003945	-24.225221	110	1	1.12	0.95;
	251	1	21.38	4	0	0	1	1.0908748	-4.9788547	110	1	1.12	0.95;
	252	1	21.38	4	0	0	1	1.0814312	-7.2754521	110	1	1.12	0.95;
	253	1	14.87	4.3	0	0	1	1.1175692	-12.568614	110	1	1.12	0.95;
	254	1	19.86	3.5	0	0	1	1.1060068	-14.397148	110	1	1.12	0.95;
	255	1	10.18	1	0	0	1	1.0921847	-27.219257	110	1	1.12	0.95;
	256	1	5.61	0	0	0	1	1.1076624	-24.330906	110	1	1.12	0.95;
	257	1	7.12	0.2	0	0	1	1.0632546	-26.996725	110	1	1.12	0.95;
	258	1	4.08	0.3	0	0	1	1.0872657	-18.049204	110	1	1.12	0.95;
	259	1	20.87	4.2	0	0	1	1.0976328	-24.505086	110	1	1.12	0.95;
	260	1	10.69	1.5	0	0	1	1.1029976	-23.769387	110	1	1.12	0.95;
	261	1	7.94	2	0	0	1	1.1187988	-10.733257	110	1	1.12	0.95;
	262	1	0.2	0	0	0	1	1.0975824	-25.090619	110	1	1.12	0.95;
	263	1	5.3	1	0	0	1	1.0555244	-25.922198	110	1	1.12	0.95;
	264	2	12.22	1	0	0	1	1.073985	-29.489889	110	1	1.12	0.95;
	265	1	12.22	1	0	0	1	1.0888117	-17.881936	110	1	1.12	0.95;
	266	1	8.34	1.6	0	0	1	1.0955294	-11.833681	110	1	1.12	0.95;
	267	1	10.38	3	0	0	1	1.1161032	-13.886216	110	1	1.12	0.95;
	268	1	14.87	3.7	0	0	1	1.118361	-12.133304	110	1	1.12	0.95;
	269	2	15.28	4	0	0	1	1.1075519	-22.973163	110	1	1.12	0.95;
	270	1	3.67	0.5	0	0	1	1.1189683	-10.913162	110	1	1.12	0.95;
	271	1	3.67	0.5	0	0	1	1.0978755	-9.330408	110	1	1.12	0.95;
	272	1	9.26	3	0	0	1	1.1188983	-10.720152	110	1	1.12	0.95;
	273	1	12.93	3.7	0	0	1	1.1168094	-11.490953	110	1	1.12	0.95;
	274	1	25.67	7.4	0	0	1	1.1177792	-12.661531	110	1	1.12	0.95;
	275	1	23.22	6.7	0	0	1	1.1158209	-13.965196	110	1	1.12	0.95;
	276	1	14.26	5.1	0	0	1	1.1138139	-13.110911	110	1	1.12	0.95;
	277	2	52.14	20.4	0	0	1	1.1180055	-13.145767	110	1	1.12	0.95;
	278	2	24.95	9.7	0	0	1	1.1171907	-13.892303	110	1	1.12	0.95;
	279	2	24.95	9.7	0	0	1	1.12	-11.624943	110	1	1.12	0.95;
	280	1	0	0	0	0	1	1.1159999	-13.914997	110	1	1.12	0.95;
	281	2	30.66	11.9	0	0	1	1.12	-12.590433	110	1	1.12	0.95;
	282	2	13.14	5.1	0	0	1	1.1195151	-10.80347	110	1	1.12	0.95;
	283	1	17.02	0.2	0	0	1	1.0988855	-16.441568	110	1	1.12	0.95;
	284	1	2.55	0.5	0	0	1	1.1043208	-23.511642	110	1	1.12	0.95;
	285	1	8.14	1.5	0	0	1	1.0723087	-27.610238	110	1	1.12	0.95;
	286	1	29.75	4.1	0	0	1	1.0692724	-27.840027	110	1	1.12	0.95;
	287	1	12.22	4	0	0	1	1.060725	-26.63256	110	1	1.12	0.95;
	288	1	13.14	3.8	0	0	1	1.1176508	-12.577146	110	1	1.12	0.95;
	289	2	21.28	6.1	0	0	1	1.1166798	-12.884006	110	1	1.12	0.95;
	290	1	17.32	3	0	0	1	1.1019475	-24.567866	110	1	1.12	0.95;
	291	1	16.81	5.4	0	0	1	1.1187962	-10.843463	110	1	1.12	0.95;
	292	1	17.32	5	0	0	1	1.1165148	-13.262597	110	1	1.12	0.95;
	293	1	7.43	2.1	0	0	1	1.1167873	-13.391274	110	1	1.12	0.95;
	294	2	15.28	3	0	0	1	1.1033026	-24.305673	110	1	1.12	0.95;
	295	1	21.28	3.4	0	0	1	1.0661075	-28.582212	110	1	1.12	0.95;
	296	1	17.63	5.1	0	0	1	1.116764	-13.399623	110	1	1.12	0.95;
	297	1	8.55	2	0	0	1	1.1024229	-12.239101	110	1	1.12	0.95;
	298	1	7.02	1.6	0	0	1	1.1009364	-12.378007	110	1	1.12	0.95;
	299	1	48.06	13.8	0	0	1	1.1138978	-13.105695	110	1	1.12	0.95;
	300	1	21.38	9	0	0	1	1.050035	-23.994533	110	1	1.12	0.95;
	301	1	6.22	1.3	0	0	1	1.102285	-15.393166	110	1	1.12	0.95;
	302	1	6.12	1.3	0	0	1	1.065219	-28.647386	110	1	1.12	0.95;
	303	1	6.32	0.5	0	0	1	1.061327	-32.191815	110	1	1.12	0.95;
	304	1	17.83	5.1	0	0	1	1.116657	-11.353691	110	1	1.12	0.95;
	305	1	7.53	1.1	0	0	1	1.0881007	-25.672689	110	1	1.12	0.95;
	306	1	21.38	4	0	0	1	1.1183727	-22.894328	110	1	1.12	0.95;
	307	1	18.34	4	0	0	1	1.0623487	-27.252341	110	1	1.12	0.95;
	308	1	5.1	0	0	0	1	1.1090605	-23.154089	110	1	1.12	0.95;
	309	1	0	0	0	0	1	1.1186212	-22.443695	110	1	1.12	0.95;
	310	1	0	0	0	0	1	1.0694122	-22.883222	110	1	1.12	0.95;
	311	1	32.4	5.7	0	0	1	1.0588799	-23.785657	110	1	1.12	0.95;
	312	1	0	0	0	0	1	1.0588908	-23.7857	110	1	1.12	0.95;
	313	1	7.12	0.5	0	0	1	1.0433682	-34.133062	110	1	1.12	0.95;
	314	2	7.73	1.5	0	0	1	1.0875227	-24.261155	110	1	1.12	0.95;
	315	1	9.47	0	0	0	1	1.0714939	-30.540921	110	1	1.12	0.95;
	316	1	16.2	4	0	0	1	1.1188768	-12.235334	110	1	1.12	0.95;
	317	1	7.12	2	0	0	1	1.0889218	-26.254979	110	1	1.12	0.95;
	318	1	6.12	2	0	0	1	1.0615064	-26.467069	110	1	1.12	0.95;
	319	1	0.81	0.3	0	0	1	1.0830499	-7.0203932	110	1	1.12	0.95;
	320	1	7.12	1	0	0	1	1.0998322	-25.237023	110	1	1.12	0.95;
	321	1	0	0	0	0	1	1.0921204	-24.272469	110	1	1.12	0.95;
	322	1	0	0	0	0	1	1.0726673	-26.304952	110	1	1.12	0.95;
	323	1	9.98	1.8	0	0	1	1.0555444	-25.072759	110	1	1.12	0.95;
	324	1	11.2	1.6	0	0	1	1.0664084	-27.225326	110	1	1.12	0.95;
	325	1	13.65	0.3	0	0	1	1.0986934	-27.315594	110	1	1.12	0.95;
	326	1	6.62	1.2	0	0	1	1.0790545	-15.148739	110	1	1.12	0.95;
	327	1	4.08	0.1	0	0	1	1.1189555	-21.353054	110	1	1.12	0.95;
	328	2	45.83	23	0	0	1	1.1064815	-23.856463	110	1	1.12	0.95;
	329	2	45.83	23	0	0	1	1.0978726	-27.278364	110	1	1.12	0.95;
	330	2	48.36	22	0	0	1	1.1128048	-22.513397	110	1	1.12	0.95;
	331	2	48.36	22	0	0	1	1.1186667	-25.523934	110	1	1.12	0.95;
	332	1	0	0	0	0	1	1.1194628	-21.059801	110	1	1.12	0.95;
	333	1	9.47	0.4	0	0	1	1.0713712	-27.997535	110	1	1.12	0.95;
	334	2	16.81	0.7	0	0	1	1.0844889	-28.021547	110	1	1.12	0.95;
	335	1	4.08	1	0	0	1	1.0780269	-29.556711	110	1	1.12	0.95;
	336	1	0	0	0	0	1	1.1010682	-25.045973	110	1	1.12	0.95;
	337	1	17.83	5.5	0	0	1	1.0683396	-28.077536	110	1	1.12	0.95;
	338	1	2.55	1.2	0	0	1	1.1044728	-14.632316	110	1	1.12	0.95;
	339	1	3.98	1.7	0	0	1	1.1149711	-11.428945	110	1	1.12	0.95;
	340	1	11.2	1.5	0	0	1	1.0519163	-31.663083	110	1	1.12	0.95;
	341	1	11	0.1	0	0	1	1.0736443	-30.259937	110	1	1.12	0.95;
	342	1	16.3	1.6	0	0	1	1.0812904	-15.000673	110	1	1.12	0.95;
	343	1	1.02	0.5	0	0	1	1.0684561	-27.842098	110	1	1.12	0.95;
	344	1	13.24	5	0	0	1	1.1169293	-21.388022	110	1	1.12	0.95;
	345	1	17.73	4	0	0	1	1.0951175	-25.461787	110	1	1.12	0.95;
	346	2	18.34	13	0	0	1	1.12	-21.019842	110	1	1.12	0.95;
	347	2	8.14	4.5	0	0	1	1.12	-23.920305	110	1	1.12	0.95;
	348	1	2.04	0.5	0	0	1	1.0962154	-26.144134	110	1	1.12	0.95;
	349	1	20.37	4.5	0	0	1	1.1040699	-23.813999	110	1	1.12	0.95;
	350	1	19.67	4.8	0	0	1	1.1029977	-15.738049	110	1	1.12	0.95;
	351	1	18.04	3.6	0	0	1	1.0717161	-26.543224	110	1	1.12	0.95;
	352	1	14.67	5.2	0	0	1	1.12	-12.143893	110	1	1.12	0.95;
	353	1	10.18	3.3	0	0	1	1.12	-10.629946	110	1	1.12	0.95;
	354	1	2.04	0.6	0	0	1	1.091446	-6.1044266	110	1	1.12	0.95;
	355	1	0	0	0	0	1	1.0965982	-4.4579396	110	1	1.12	0.95;
	356	1	2.96	0.6	0	0	1	1.1140155	-25.841022	110	1	1.12	0.95;
	357	1	2.04	0.1	0	0	1	1.1026127	-23.602658	110	1	1.12	0.95;
	358	1	6.92	1.6	0	0	1	1.1009556	-14.253716	110	1	1.12	0.95;
	359	2	3.57	1.2	0	0	1	1.1004731	-27.047445	110	1	1.12	0.95;
	360	1	3.57	1.1	0	0	1	1.1193487	-25.451438	110	1	1.12	0.95;
	361	1	0	0	0	0	1	1.1076344	-23.850311	110	1	1.12	0.95;
	362	1	0	0	0	0	1	1.0939099	-27.722384	110	1	1.12	0.95;
	363	1	6.12	1	0	0	1	1.0614127	-26.663616	110	1	1.12	0.95;
	364	1	-2.55	-0.8	0	0	1	1.0782242	-15.005448	110	1	1.12	0.95;
	365	2	33.61	6.7	0	0	1	1.0983817	-23.959713	110	1	1.12	0.95;
	366	1	34.62	6.7	0	0	1	1.0688695	-24.416583	110	1	1.12	0.95;
	367	1	12.02	1.6	0	0	1	1.1154634	-8.2320477	110	1	1.12	0.95;
	368	1	10.18	1.5	0	0	1	1.12	-6.9884208	110	1	1.12	0.95;
	369	1	11.2	1.5	0	0	1	1.0842836	-28.757541	110	1	1.12	0.95;
	370	1	14.57	1.6	0	0	1	1.1124012	-8.1022368	110	1	1.12	0.95;
	371	1	16.81	0.1	0	0	1	1.0991166	-27.256049	110	1	1.12	0.95;
	372	1	12.83	1	0	0	1	1.073872	-21.551305	110	1	1.12	0.95;
	373	1	2.24	0.2	0	0	1	1.0938681	-27.721686	110	1	1.12	0.95;
	374	1	0	0	0	0	1	1.12	-22.550712	110	1	1.12	0.95;
	375	1	0	0	0	0	1	1.0989711	-27.244335	110	1	1.12	0.95;
	376	1	25.16	5.4	0	0	1	1.1144464	-6.8552925	110	1	1.12	0.95;
	377	1	9.16	2	0	0	1	1.0676215	-28.012486	110	1	1.12	0.95;
	378	1	9.57	0.1	0	0	1	1.0998007	-27.153318	110	1	1.12	0.95;
	379	1	24.95	1.4	0	0	1	1.0827701	-27.971141	110	1	1.12	0.95;
	380	1	7.63	1.7	0	0	1	1.101582	-14.217843	110	1	1.12	0.95;
	381	1	10.38	0.5	0	0	1	1.1134511	-21.738748	110	1	1.12	0.95;
	382	2	8.14	3	0	0	1	1.0636816	-26.680031	110	1	1.12	0.95;
	383	2	22.4	4	0	0	1	1.0607858	-26.572205	110	1	1.12	0.95;
	384	1	14.26	3.5	0	0	1	1.0631738	-27.569981	110	1	1.12	0.95;
	385	2	21.89	6.5	0	0	1	1.0641509	-27.30172	110	1	1.12	0.95;
	386	1	12.73	2.5	0	0	1	1.089469	-27.401285	110	1	1.12	0.95;
	387	1	14.87	1.2	0	0	1	1.0724588	-25.880477	110	1	1.12	0.95;
	388	1	17.83	1.3	0	0	1	1.0389503	-27.293123	110	1	1.12	0.95;
	389	1	11.2	2.5	0	0	1	1.0660368	-27.01858	110	1	1.12	0.95;
	390	2	12.02	3.5	0	0	1	1.0799665	-7.6936807	110	1	1.12	0.95;
	391	1	5.2	1.5	0	0	1	1.1184742	-12.266711	110	1	1.12	0.95;
	392	1	11.4	2.6	0	0	1	1.0719148	-8.4933226	110	1	1.12	0.95;
	393	1	8.75	0.4	0	0	1	1.0967211	-27.427893	110	1	1.12	0.95;
	394	1	11.71	3.3	0	0	1	1.0853254	-16.390932	110	1	1.12	0.95;
	395	2	23.42	4.5	0	0	1	1.0987606	-25.874489	110	1	1.12	0.95;
	396	1	9.06	2.6	0	0	1	1.1171797	-13.735736	110	1	1.12	0.95;
	397	1	4.18	1	0	0	1	1.0870581	-25.465267	110	1	1.12	0.95;
	398	1	9.16	2	0	0	1	1.0217912	-28.650845	110	1	1.12	0.95;
	399	1	9.26	1.1	0	0	1	1.0848116	-8.7713639	110	1	1.12	0.95;
	400	1	9.16	1	0	0	1	1.0713148	-8.5698903	110	1	1.12	0.95;
	401	1	12.22	-0.5	0	0	1	1.0265588	-34.205473	110	1	1.12	0.95;
	402	1	4.28	0.9	0	0	1	1.0962964	-4.5060764	110	1	1.12	0.95;
	403	1	4.08	0.9	0	0	1	1.0859655	-6.5511638	110	1	1.12	0.95;
	404	2	12.02	3.1	0	0	1	1.0716183	-8.5353046	110	1	1.12	0.95;
	405	1	5.41	0.7	0	0	1	1.0997956	-9.0919987	110	1	1.12	0.95;
	406	1	9.06	2.4	0	0	1	1.1186855	-12.760051	110	1	1.12	0.95;
	407	1	20.11	4.9	0	0	1	1.112938	-14.428252	110	1	1.12	0.95;
	408	1	8.85	1.1	0	0	1	1.1029612	-9.3456568	110	1	1.12	0.95;
	409	1	7.12	1.2	0	0	1	1.0836445	-17.437943	110	1	1.12	0.95;
	410	1	9.47	2	0	0	1	1.094544	-13.52553	110	1	1.12	0.95;
	411	1	18.85	2.1	0	0	1	1.0562882	-26.28348	110	1	1.12	0.95;
	412	1	7.63	1.3	0	0	1	1.0566982	-26.168257	110	1	1.12	0.95;
	413	1	20.77	1.6	0	0	1	1.0577858	-25.97645	110	1	1.12	0.95;
	414	1	5.1	0.5	0	0	1	1.0236254	-34.460337	110	1	1.12	0.95;
	415	1	5.92	1.2	0	0	1	1.06965	-27.051394	110	1	1.12	0.95;
	416	1	20.87	5	0	0	1	1.0937241	-24.279506	110	1	1.12	0.95;
	417	1	2.65	0.3	0	0	1	1.1147443	-7.1682562	110	1	1.12	0.95;
	418	1	13.75	1.3	0	0	1	1.0680747	-28.356836	110	1	1.12	0.95;
	419	1	14.77	1.4	0	0	1	1.1087611	-12.326155	110	1	1.12	0.95;
	420	1	22.3	4.5	0	0	1	1.0668201	-23.34008	110	1	1.12	0.95;
	421	1	14.26	0.8	0	0	1	1.074322	-29.674149	110	1	1.12	0.95;
	422	1	14.26	0.8	0	0	1	1.0873663	-18.082732	110	1	1.12	0.95;
	423	1	18.34	2	0	0	1	1.0581068	-26.415159	110	1	1.12	0.95;
	424	1	12.63	4	0	0	1	1.1037381	-17.795564	110	1	1.12	0.95;
	425	1	33.92	4.2	0	0	1	1.0806446	-26.683792	110	1	1.12	0.95;
	426	2	16.81	4	0	0	1	1.0605844	-26.759153	110	1	1.12	0.95;
	427	1	18.04	2.1	0	0	1	1.0798695	-14.783537	110	1	1.12	0.95;
	428	1	17.83	0	0	0	1	1.1016416	-25.348935	110	1	1.12	0.95;
	429	1	12.32	3.5	0	0	1	1.118586	-10.798838	110	1	1.12	0.95;
	430	1	6.53	2	0	0	1	1.0708003	-21.420116	110	1	1.12	0.95;
	431	1	6.22	1.5	0	0	1	1.107876	-14.921915	110	1	1.12	0.95;
	432	1	3.37	0.2	0	0	1	1.1019789	-26.693192	110	1	1.12	0.95;
	433	1	5.2	1	0	0	1	1.1132556	-7.6910974	110	1	1.12	0.95;
	434	1	20.37	2.5	0	0	1	1.0282067	-34.034523	110	1	1.12	0.95;
	435	1	0.61	0.1	0	0	1	1.0694313	-22.903755	110	1	1.12	0.95;
	436	1	0.51	0.1	0	0	1	1.0976139	-24.512864	110	1	1.12	0.95;
	437	1	10.18	1	0	0	1	1.0596292	-29.902984	110	1	1.12	0.95;
	438	1	6.22	0.2	0	0	1	1.0927841	-25.632055	110	1	1.12	0.95;
	439	1	2.65	0.5	0	0	1	1.0761417	-14.970102	110	1	1.12	0.95;
	440	1	15.79	3.5	0	0	1	1.0809042	-25.401539	110	1	1.12	0.95;
	441	1	16.61	4.8	0	0	1	1.1191071	-11.885305	110	1	1.12	0.95;
	442	1	4.9	0	0	0	1	1.0656145	-31.542186	110	1	1.12	0.95;
	443	1	13.75	2.1	0	0	1	1.0081751	-29.259775	110	1	1.12	0.95;
	444	2	16.1	4.1	0	0	1	1.1015433	-8.9554415	110	1	1.12	0.95;
	445	1	14.77	1.9	0	0	1	1.0928716	-11.938675	110	1	1.12	0.95;
	446	1	14.98	1.7	0	0	1	1.0986973	-9.1929158	110	1	1.12	0.95;
	447	1	4.08	1	0	0	1	1.1191804	-6.2311482	110	1	1.12	0.95;
	448	1	4.79	2.4	0	0	1	1.12	-4.9929239	110	1	1.12	0.95;
	449	1	0	0	0	0	1	1.0928839	-11.938932	110	1	1.12	0.95;
	450	1	0	0	0	0	1	1.0987009	-9.1930063	110	1	1.12	0.95;
	451	2	9.16	4	0	0	1	1.092197	-24.282984	110	1	1.12	0.95;
	452	1	4.08	2	0	0	1	1.0713714	-26.222177	110	1	1.12	0.95;
	453	1	9.16	0.5	0	0	1	1.1192561	-22.186483	110	1	1.12	0.95;
	454	1	21.38	6	0	0	1	1.0896303	-24.447106	110	1	1.12	0.95;
	455	1	30.56	7	0	0	1	1.0636954	-26.549148	110	1	1.12	0.95;
	456	1	27.5	9	0	0	1	1.0791568	-26.328789	110	1	1.12	0.95;
	457	1	28.52	9	0	0	1	1.0875964	-26.157006	110	1	1.12	0.95;
	458	1	7.12	3	0	0	1	1.0678228	-27.481971	110	1	1.12	0.95;
	459	1	7.12	1	0	0	1	1.0685034	-28.300249	110	1	1.12	0.95;
	460	1	10.79	1.2	0	0	1	1.0708107	-26.646873	110	1	1.12	0.95;
	461	1	21.38	11	0	0	1	1.0640679	-26.691633	110	1	1.12	0.95;
	462	1	39.72	10	0	0	1	1.0703137	-26.973381	110	1	1.12	0.95;
	463	1	27.5	10	0	0	1	1.085219	-26.04956	110	1	1.12	0.95;
	464	1	21.38	8	0	0	1	1.0634761	-26.676951	110	1	1.12	0.95;
	465	1	23.42	6	0	0	1	1.0732679	-26.770977	110	1	1.12	0.95;
	466	1	7.12	1	0	0	1	1.0159123	-36.085662	110	1	1.12	0.95;
	467	1	61.09	20	0	0	1	1.0616198	-26.450181	110	1	1.12	0.95;
	468	1	30.56	10	0	0	1	1.0756299	-26.929804	110	1	1.12	0.95;
	469	1	7.63	1.4	0	0	1	1.1186866	-5.1333015	110	1	1.12	0.95;
	470	1	0	0	0	0	1	1.1042557	-8.867264	110	1	1.12	0.95;
	471	1	20.17	6.5	0	0	1	1.1188318	-10.857867	110	1	1.12	0.95;
	472	1	3.57	1.2	0	0	1	1.1182516	-12.743849	110	1	1.12	0.95;
	473	1	4.08	2	0	0	1	1.0692466	-27.659789	110	1	1.12	0.95;
	474	1	4.08	0.5	0	0	1	1.1074423	-23.836639	110	1	1.12	0.95;
	475	1	22.4	6	0	0	1	1.0700825	-26.52641	110	1	1.12	0.95;
	476	1	9.16	2	0	0	1	1.0889972	-25.716351	110	1	1.12	0.95;
	477	1	9.16	2	0	0	1	1.0577966	-25.48598	110	1	1.12	0.95;
	478	1	24.44	6	0	0	1	1.0737096	-26.989895	110	1	1.12	0.95;
	479	1	15.28	4	0	0	1	1.069449	-26.581713	110	1	1.12	0.95;
	480	1	10.18	3	0	0	1	1.0902403	-24.415729	110	1	1.12	0.95;
	481	1	18.85	3.4	0	0	1	1.0244978	-28.476153	110	1	1.12	0.95;
	482	2	31.07	2.6	0	0	1	1.1003491	-7.2254121	110	1	1.12	0.95;
	483	1	36.66	9	0	0	1	1.0608704	-26.5349	110	1	1.12	0.95;
	484	1	14.26	4	0	0	1	1.0777818	-25.054672	110	1	1.12	0.95;
	485	1	46.84	11	0	0	1	1.1030462	-23.91071	110	1	1.12	0.95;
	486	1	11.2	4	0	0	1	1.0942154	-25.037067	110	1	1.12	0.95;
	487	1	12.83	1.1	0	0	1	1.0211833	-28.674494	110	1	1.12	0.95;
	488	1	2	1	0	0	1	1.0608266	-26.55478	110	1	1.12	0.95;
	489	1	22.4	5	0	0	1	1.1084137	-23.649755	110	1	1.12	0.95;
	490	1	18.34	4	0	0	1	1.0779202	-26.363649	110	1	1.12	0.95;
	491	1	36.66	9	0	0	1	1.0789362	-26.334969	110	1	1.12	0.95;
	492	2	10.18	0.9	0	0	1	1.088631	-25.928802	110	1	1.12	0.95;
	493	2	44.81	21	0	0	1	1.12	-22.985657	110	1	1.12	0.95;
	494	2	38.7	22	0	0	1	1.0927055	-25.475488	110	1	1.12	0.95;
	495	1	11.2	3	0	0	1	1.0919721	-25.526229	110	1	1.12	0.95;
	496	1	12.22	3	0	0	1	1.1192448	-23.038895	110	1	1.12	0.95;
	497	1	24.44	6	0	0	1	1.0849032	-25.913026	110	1	1.12	0.95;
	498	1	24.44	4	0	0	1	1.0790104	-26.347927	110	1	1.12	0.95;
	499	1	21.42	3	0	0	1	1.0609439	-26.524532	110	1	1.12	0.95;
	500	1	5.1	1	0	0	1	1.1137014	-23.347522	110	1	1.12	0.95;
	501	1	52.95	12	0	0	1	1.058824	-26.348958	110	1	1.12	0.95;
	502	1	40.74	10	0	0	1	1.0611785	-26.484784	110	1	1.12	0.95;
	503	1	18.34	7	0	0	1	1.0628533	-26.705979	110	1	1.12	0.95;
	504	1	26.48	8	0	0	1	1.0697612	-26.080938	110	1	1.12	0.95;
	505	1	27.5	6	0	0	1	1.113334	-23.409756	110	1	1.12	0.95;
	506	1	17.32	5	0	0	1	1.0893468	-24.687533	110	1	1.12	0.95;
	507	1	27.5	6	0	0	1	1.0908733	-25.427328	110	1	1.12	0.95;
	508	1	31.58	7	0	0	1	1.0606984	-27.140101	110	1	1.12	0.95;
	509	1	16.4	3	0	0	1	1.0919394	-25.0086	110	1	1.12	0.95;
	510	1	5.61	1.5	0	0	1	1.051287	-31.435471	110	1	1.12	0.95;
	511	1	16.3	3	0	0	1	1.0951855	-24.778227	110	1	1.12	0.95;
	512	1	7.43	0.3	0	0	1	1.0903992	-25.192727	110	1	1.12	0.95;
	513	1	0	0	0	0	1	0.99740452	-29.521569	110	1	1.12	0.95;
	514	2	32.56	15	0	0	1	1.089524	-26.222042	110	1	1.12	0.95;
	515	2	36.69	17	0	0	1	1.0650442	-26.609855	110	1	1.12	0.95;
	516	1	0	0	0	0	1	1.0759498	-29.43019	110	1	1.12	0.95;
	517	1	0	0	0	0	1	1.0860193	-6.543541	110	1	1.12	0.95;
	518	1	0	0	0	0	1	1.046574	-26.555783	110	1	1.12	0.95;
	519	1	0	0	0	0	1	1.1165719	-13.83092	110	1	1.12	0.95;
	520	1	11.3	1.7	0	0	1	1.1132575	-23.034399	110	1	1.12	0.95;
	521	1	7.51	1	0	0	1	1.08856	-25.767747	110	1	1.12	0.95;
	522	1	16.71	2.4	0	0	1	1.0459238	-26.635522	110	1	1.12	0.95;
	523	1	5.1	0.2	0	0	1	1.1098232	-22.471802	110	1	1.12	0.95;
	524	1	20.37	3	0	0	1	1.0956352	-24.923077	110	1	1.12	0.95;
	525	2	22.1	4.1	0	0	1	1.0939325	-13.044291	110	1	1.12	0.95;
	526	1	13.04	4.7	0	0	1	1.1176439	-14.002267	110	1	1.12	0.95;
	527	1	5.61	2	0	0	1	1.1195205	-12.038075	110	1	1.12	0.95;
	528	1	7.94	0.9	0	0	1	1.0872759	-13.859001	110	1	1.12	0.95;
	529	1	6.53	1.6	0	0	1	1.0819608	-7.341805	110	1	1.12	0.95;
	530	1	5.1	2	0	0	1	1.0906294	-24.384748	110	1	1.12	0.95;
	531	1	4.08	2	0	0	1	1.0753257	-26.940135	110	1	1.12	0.95;
	532	1	7.83	2	0	0	1	1.0836164	-16.938803	110	1	1.12	0.95;
	533	1	12.22	0	0	0	1	1.0814103	-28.588762	110	1	1.12	0.95;
	534	1	8.34	2.4	0	0	1	1.1168955	-13.910316	110	1	1.12	0.95;
	535	1	1.02	0.5	0	0	1	1.0690636	-26.689379	110	1	1.12	0.95;
	536	2	21.02	6.8	0	0	1	1.0660932	-27.449876	110	1	1.12	0.95;
	537	2	13.04	1.9	0	0	1	1.0697028	-29.35773	110	1	1.12	0.95;
	538	1	16.4	4.2	0	0	1	1.0642535	-27.468967	110	1	1.12	0.95;
	539	1	0	0	0	0	1	1.0701257	-20.083588	110	2	1.12	0.95;
	540	1	6.8	1.3	0	0	1	1.0701383	-20.080655	110	2	1.12	0.95;
	541	1	3.3	0.1	0	0	1	1.060521	-16.324282	110	2	1.12	0.95;
	542	1	11.39	1	0	0	1	1.0603968	-21.230272	110	2	1.12	0.95;
	543	1	17.89	0.7	0	0	1	1.0784569	-12.912728	110	2	1.12	0.95;
	544	1	7.49	0.2	0	0	1	1.0615212	-20.487337	110	2	1.12	0.95;
	545	1	21.88	0.9	0	0	1	1.0702398	-13.906615	110	2	1.12	0.95;
	546	1	0	0	0	0	1	1.0702312	-13.908271	110	2	1.12	0.95;
	547	1	19.69	8.2	0	0	1	1.0594412	-21.248209	110	2	1.12	0.95;
	548	1	7.69	2.2	0	0	1	1.0897988	-17.880865	110	2	1.12	0.95;
	549	1	15.39	1.8	0	0	1	1.0508633	-18.118054	110	2	1.12	0.95;
	550	1	4.4	0.1	0	0	1	1.0502543	-18.260056	110	2	1.12	0.95;
	551	1	9.89	0.5	0	0	1	1.0676711	-16.93405	110	2	1.12	0.95;
	552	1	12.79	1.1	0	0	1	1.0303214	-27.298989	110	2	1.12	0.95;
	553	1	15.99	1.3	0	0	1	1.0294298	-27.234289	110	2	1.12	0.95;
	554	1	3.8	0	0	0	1	1.0495118	-14.737085	110	2	1.12	0.95;
	555	1	3.8	0.7	0	0	1	1.0624522	-19.918372	110	2	1.12	0.95;
	556	2	25.88	7.2	0	0	1	1.0503965	-19.904373	110	2	1.12	0.95;
	557	1	16.99	3.3	0	0	1	1.0609999	-11.475509	110	2	1.12	0.95;
	558	1	6	0	0	0	1	1.0605152	-11.544599	110	2	1.12	0.95;
	559	1	10.89	1.4	0	0	1	1.0593511	-20.243612	110	2	1.12	0.95;
	560	1	10.99	2.4	0	0	1	1.0814414	-13.016375	110	2	1.12	0.95;
	561	1	13.69	4.4	0	0	1	1.05254	-22.164405	110	2	1.12	0.95;
	562	1	13.69	4.4	0	0	1	1.0519657	-22.17699	110	2	1.12	0.95;
	563	1	12.19	0.1	0	0	1	1.0544147	-22.171788	110	2	1.12	0.95;
	564	1	0	0	0	0	1	1.0743382	-13.106974	110	2	1.12	0.95;
	565	1	0	0	0	0	1	1.0616814	-13.699726	110	2	1.12	0.95;
	566	1	12.69	0	0	0	1	1.0544149	-22.199693	110	2	1.12	0.95;
	567	1	5.5	1.1	0	0	1	1.0819882	-17.313937	110	2	1.12	0.95;
	568	1	0	0	0	0	1	1.0557097	-21.979072	110	2	1.12	0.95;
	569	1	0	0	0	0	1	1.0557063	-21.981847	110	2	1.12	0.95;
	570	1	8.19	0.5	0	0	1	1.0662366	-12.678907	110	2	1.12	0.95;
	571	1	9.69	0	0	0	1	1.0540288	-22.240535	110	2	1.12	0.95;
	572	1	12.29	1.2	0	0	1	1.0701662	-19.841341	110	2	1.12	0.95;
	573	1	3.3	1.1	0	0	1	1.0945778	-17.711093	110	2	1.12	0.95;
	574	1	2.2	1.1	0	0	1	1.0798802	-15.697788	110	2	1.12	0.95;
	575	1	8.79	0.5	0	0	1	1.0685373	-13.607041	110	2	1.12	0.95;
	576	1	0	0	0	0	1	1.0485411	-16.854661	110	2	1.12	0.95;
	577	1	6	0.3	0	0	1	1.0528001	-16.178835	110	2	1.12	0.95;
	578	1	21.88	5.5	0	0	1	1.0764012	-22.46396	110	2	1.12	0.95;
	579	1	3.3	0.5	0	0	1	1.0586738	-11.608801	110	2	1.12	0.95;
	580	2	8.99	1.8	0	0	1	1.0750099	-19.786606	110	2	1.12	0.95;
	581	1	11.49	3.3	0	0	1	1.0512483	-16.081626	110	2	1.12	0.95;
	582	1	6.8	8.1	0	0	1	1.0584611	-11.573963	110	2	1.12	0.95;
	583	1	15.39	0	0	0	1	1.0584795	-14.195381	110	2	1.12	0.95;
	584	2	11.69	3.3	0	0	1	1.0481329	-20.950738	110	2	1.12	0.95;
	585	2	18.39	4.1	0	0	1	1.0484704	-20.879456	110	2	1.12	0.95;
	586	1	8.39	2.2	0	0	1	1.0526885	-15.743157	110	2	1.12	0.95;
	587	1	0	0	0	0	1	1.0633015	-14.920643	110	2	1.12	0.95;
	588	1	12.59	1.1	0	0	1	1.0314485	-27.439248	110	2	1.12	0.95;
	589	1	9.89	1.1	0	0	1	1.0726476	-17.599231	110	2	1.12	0.95;
	590	1	14.59	3	0	0	1	1.0480529	-17.648001	110	2	1.12	0.95;
	591	1	13.29	1	0	0	1	1.0308934	-19.085012	110	2	1.12	0.95;
	592	1	3.8	0	0	0	1	1.0747847	-12.502784	110	2	1.12	0.95;
	593	1	13.69	0.5	0	0	1	1.0740389	-12.786366	110	2	1.12	0.95;
	594	1	8.79	2.7	0	0	1	1.08215	-18.371494	110	2	1.12	0.95;
	595	1	3.4	0.8	0	0	1	1.0315208	-27.313035	110	2	1.12	0.95;
	596	1	5.8	0	0	0	1	1.0334446	-18.776489	110	2	1.12	0.95;
	597	1	4.5	0.1	0	0	1	1.0581502	-19.679656	110	2	1.12	0.95;
	598	1	4.5	0	0	0	1	1.0724073	-13.422346	110	2	1.12	0.95;
	599	1	3.6	0.4	0	0	1	1.060748	-20.295921	110	2	1.12	0.95;
	600	1	10.99	1.2	0	0	1	1.0867338	-12.811479	110	2	1.12	0.95;
	601	1	7.69	0.5	0	0	1	1.0556242	-22.803258	110	2	1.12	0.95;
	602	1	5.5	1.1	0	0	1	1.0746337	-14.773481	110	2	1.12	0.95;
	603	1	37.27	4.4	0	0	1	1.0721113	-14.670273	110	2	1.12	0.95;
	604	1	27.38	1.1	0	0	1	1.0727261	-14.820169	110	2	1.12	0.95;
	605	1	8.79	0.5	0	0	1	1.0734166	-14.91831	110	2	1.12	0.95;
	606	1	0.9	0.1	0	0	1	1.052401	-13.848113	110	2	1.12	0.95;
	607	2	4.1	0.7	0	0	1	1.0554358	-14.068757	110	2	1.12	0.95;
	608	1	2.2	0	0	0	1	1.0660731	-10.615987	110	2	1.12	0.95;
	609	1	5.2	1.6	0	0	1	1.0654868	-14.169368	110	2	1.12	0.95;
	610	1	7.99	1.3	0	0	1	1.0596961	-20.369958	110	2	1.12	0.95;
	611	1	5.5	1.1	0	0	1	1.0711224	-16.520474	110	2	1.12	0.95;
	612	2	12.99	30	0	0	1	1.11585	-16.665432	110	2	1.12	0.95;
	613	2	12.99	30	0	0	1	1.1158385	-16.663869	110	2	1.12	0.95;
	614	1	0	0	0	0	1	1.0732681	-14.643897	110	2	1.12	0.95;
	615	2	35.07	6.6	0	0	1	1.076155	-14.717149	110	2	1.12	0.95;
	616	1	7.19	1.8	0	0	1	1.0699668	-13.924735	110	2	1.12	0.95;
	617	1	0	0	0	0	1	1.0863942	-12.819392	110	2	1.12	0.95;
	618	1	8.79	0	0	0	1	1.0704872	-13.889975	110	2	1.12	0.95;
	619	1	18.09	2.1	0	0	1	1.069122	-13.95923	110	2	1.12	0.95;
	620	1	9.69	1	0	0	1	1.0805241	-13.242256	110	2	1.12	0.95;
	621	1	7.09	1.1	0	0	1	1.0680849	-16.325148	110	2	1.12	0.95;
	622	1	1.1	0.5	0	0	1	1.0686461	-16.249509	110	2	1.12	0.95;
	623	2	26.18	7.7	0	0	1	1.0522379	-21.431018	110	2	1.12	0.95;
	624	1	8.19	2.2	0	0	1	1.0688781	-16.215912	110	2	1.12	0.95;
	625	1	10.39	0	0	0	1	1.0755278	-7.4270552	110	2	1.12	0.95;
	626	1	42.16	1.6	0	0	1	1.072245	-14.971819	110	2	1.12	0.95;
	627	1	13.69	1.1	0	0	1	1.107714	-17.169257	110	2	1.12	0.95;
	628	1	21.88	3.8	0	0	1	1.0609573	-15.238836	110	2	1.12	0.95;
	629	1	10.89	0.9	0	0	1	1.0334303	-20.239114	110	2	1.12	0.95;
	630	1	25.78	6.3	0	0	1	1.0628578	-21.32713	110	2	1.12	0.95;
	631	1	11.29	1.1	0	0	1	1.063094	-20.876437	110	2	1.12	0.95;
	632	1	16.89	0.9	0	0	1	1.0681148	-20.501997	110	2	1.12	0.95;
	633	1	10.99	3.3	0	0	1	1.0699144	-20.135755	110	2	1.12	0.95;
	634	1	0	0	0	0	1	1.0699147	-20.136191	110	2	1.12	0.95;
	635	1	12.19	1.1	0	0	1	1.048833	-16.944115	110	2	1.12	0.95;
	636	1	7.69	1.8	0	0	1	1.0706301	-11.614781	110	2	1.12	0.95;
	637	1	7.09	1.1	0	0	1	1.0499445	-16.819879	110	2	1.12	0.95;
	638	1	4.4	2.2	0	0	1	1.0726982	-19.858507	110	2	1.12	0.95;
	639	2	17.59	7.8	0	0	1	1.0725831	-19.862948	110	2	1.12	0.95;
	640	1	6.7	0.8	0	0	1	1.0734407	-19.799237	110	2	1.12	0.95;
	641	1	17.69	1.3	0	0	1	1.0732417	-19.913272	110	2	1.12	0.95;
	642	1	10.99	1.1	0	0	1	1.0740271	-17.355054	110	2	1.12	0.95;
	643	1	9.79	1.4	0	0	1	1.035332	-27.15061	110	2	1.12	0.95;
	644	1	0	0	0	0	1	1.0766682	-19.5507	110	2	1.12	0.95;
	645	1	0	0	0	0	1	1.0766608	-19.551022	110	2	1.12	0.95;
	646	1	4.4	0.9	0	0	1	1.0411524	-24.509474	110	2	1.12	0.95;
	647	1	17.19	1.1	0	0	1	1.0712972	-20.175306	110	2	1.12	0.95;
	648	1	20.68	1.6	0	0	1	1.0660865	-20.38874	110	2	1.12	0.95;
	649	1	17.19	1.3	0	0	1	1.0684057	-20.509678	110	2	1.12	0.95;
	650	1	10.99	6.6	0	0	1	1.0733248	-19.82784	110	2	1.12	0.95;
	651	2	25.78	4.6	0	0	1	1.0656923	-20.43181	110	2	1.12	0.95;
	652	1	8.69	0.7	0	0	1	1.0676491	-20.27004	110	2	1.12	0.95;
	653	1	14.99	1.2	0	0	1	1.0724236	-19.878338	110	2	1.12	0.95;
	654	2	7.69	3.3	0	0	1	1.0628986	-13.581053	110	2	1.12	0.95;
	655	1	4.4	2.2	0	0	1	1.0654834	-13.452964	110	2	1.12	0.95;
	656	1	4.3	0.1	0	0	1	1.0468145	-23.282088	110	2	1.12	0.95;
	657	1	21.38	4.4	0	0	1	1.093694	-3.9209728	110	2	1.12	0.95;
	658	1	12.69	0.5	0	0	1	1.0358568	-25.968745	110	2	1.12	0.95;
	659	1	2.2	0	0	0	1	1.0344531	-17.967108	110	2	1.12	0.95;
	660	1	8.79	1.6	0	0	1	1.0860815	-17.863589	110	2	1.12	0.95;
	661	1	1.6	0.5	0	0	1	1.0880201	-21.21177	110	2	1.12	0.95;
	662	1	0	0	0	0	1	1.0584798	-19.233483	110	2	1.12	0.95;
	663	1	0	0	0	0	1	1.0584887	-19.23282	110	2	1.12	0.95;
	664	2	50.65	19.2	0	0	1	1.0515137	-12.993173	110	2	1.12	0.95;
	665	1	30.68	4.9	0	0	1	1.0724335	-14.645609	110	2	1.12	0.95;
	666	1	7.69	1.1	0	0	1	1.0732799	-13.328997	110	2	1.12	0.95;
	667	1	16.99	1	0	0	1	1.0303684	-19.12269	110	2	1.12	0.95;
	668	1	2.7	0.5	0	0	1	1.0589165	-20.460828	110	2	1.12	0.95;
	669	1	6	0.9	0	0	1	1.0778972	-13.083667	110	2	1.12	0.95;
	670	2	25.88	1.4	0	0	1	1.0533456	-13.947447	110	2	1.12	0.95;
	671	1	9.49	2.7	0	0	1	1.0690697	-14.721953	110	2	1.12	0.95;
	672	1	2.2	0.2	0	0	1	1.0591343	-21.31956	110	2	1.12	0.95;
	673	1	9.89	2.2	0	0	1	1.0640332	-17.564362	110	2	1.12	0.95;
	674	2	10.19	1.1	0	0	1	1.0540455	-20.498322	110	2	1.12	0.95;
	675	1	2	1.1	0	0	1	1.0714639	-13.807331	110	2	1.12	0.95;
	676	1	2.7	0	0	0	1	1.0746542	-14.864405	110	2	1.12	0.95;
	677	1	9.49	9.5	0	0	1	1.0687954	-14.993851	110	2	1.12	0.95;
	678	1	25.18	8.2	0	0	1	1.0778022	-15.55866	110	2	1.12	0.95;
	679	1	25.18	8.2	0	0	1	1.0778047	-15.554159	110	2	1.12	0.95;
	680	1	1.1	0.3	0	0	1	1.063529	-13.021258	110	2	1.12	0.95;
	681	1	79.92	40	0	0	1	1.0498736	-12.156152	110	2	1.12	0.95;
	682	1	0	0	0	0	1	1.0503384	-12.138698	110	2	1.12	0.95;
	683	1	16.49	3.3	0	0	1	1.0731074	-16.2397	110	2	1.12	0.95;
	684	1	24.08	4.4	0	0	1	1.0740397	-15.963189	110	2	1.12	0.95;
	685	1	10.39	2	0	0	1	1.060919	-16.23748	110	2	1.12	0.95;
	686	1	11.39	0.4	0	0	1	1.0520285	-23.416633	110	2	1.12	0.95;
	687	1	1.1	0	0	0	1	1.0698995	-17.235142	110	2	1.12	0.95;
	688	2	11.99	30	0	0	1	1.0628636	-11.363779	110	2	1.12	0.95;
	689	1	11.99	6	0	0	1	1.0628538	-11.362788	110	2	1.12	0.95;
	690	1	9.29	1.1	0	0	1	1.0662564	-10.559452	110	2	1.12	0.95;
	691	1	1.6	0.5	0	0	1	1.0993543	-17.478949	110	2	1.12	0.95;
	692	2	6	1.6	0	0	1	1.0907887	-17.756928	110	2	1.12	0.95;
	693	1	7.99	0.7	0	0	1	1.0616969	-20.098081	110	2	1.12	0.95;
	694	1	10.79	0.4	0	0	1	1.0614259	-20.182797	110	2	1.12	0.95;
	695	1	1.6	0.2	0	0	1	1.0564776	-20.546479	110	2	1.12	0.95;
	696	1	6.7	1.2	0	0	1	1.0576918	-20.554916	110	2	1.12	0.95;
	697	1	4.3	0.2	0	0	1	1.0500915	-20.741985	110	2	1.12	0.95;
	698	1	6.8	2.2	0	0	1	1.0318406	-18.174046	110	2	1.12	0.95;
	699	2	26.78	3.7	0	0	1	1.0474999	-16.659055	110	2	1.12	0.95;
	700	1	10.99	1.1	0	0	1	1.0794478	-16.675064	110	2	1.12	0.95;
	701	1	2.9	0.7	0	0	1	1.0648015	-13.34148	110	2	1.12	0.95;
	702	1	12.09	0.7	0	0	1	1.0317168	-18.220487	110	2	1.12	0.95;
	703	1	22.48	2.7	0	0	1	1.034582	-17.949752	110	2	1.12	0.95;
	704	1	11.49	1	0	0	1	1.0320451	-18.148993	110	2	1.12	0.95;
	705	1	26.88	6.6	0	0	1	1.0744952	-18.146375	110	2	1.12	0.95;
	706	1	10.99	3.3	0	0	1	1.0770938	-13.393178	110	2	1.12	0.95;
	707	1	10.99	3.3	0	0	1	1.0770783	-13.391699	110	2	1.12	0.95;
	708	1	15.99	0.9	0	0	1	1.0517397	-23.671193	110	2	1.12	0.95;
	709	1	21.88	4.9	0	0	1	1.0740779	-18.244042	110	2	1.12	0.95;
	710	1	2.2	0	0	0	1	1.080063	-15.687081	110	2	1.12	0.95;
	711	1	4.8	0	0	0	1	1.0806835	-13.43721	110	2	1.12	0.95;
	712	2	23.98	5.9	0	0	1	1.0540547	-21.844067	110	2	1.12	0.95;
	713	1	20.29	5.5	0	0	1	1.0705156	-18.895704	110	2	1.12	0.95;
	714	1	14.39	1.2	0	0	1	1.0722523	-14.062751	110	2	1.12	0.95;
	715	1	6	0.9	0	0	1	1.0530657	-13.699452	110	2	1.12	0.95;
	716	1	2.4	1.1	0	0	1	1.0835476	-17.470271	110	2	1.12	0.95;
	717	1	2.4	1.1	0	0	1	1.0835494	-17.471155	110	2	1.12	0.95;
	718	1	18.09	6.6	0	0	1	1.0797226	-17.952683	110	2	1.12	0.95;
	719	1	19.69	3.3	0	0	1	1.0798282	-17.860003	110	2	1.12	0.95;
	720	1	20.29	6	0	0	1	1.0698923	-18.870425	110	2	1.12	0.95;
	721	1	6.7	1.1	0	0	1	1.0489408	-16.610062	110	2	1.12	0.95;
	722	1	12.19	0.9	0	0	1	1.0815883	-19.189356	110	2	1.12	0.95;
	723	1	6.89	1.8	0	0	1	1.0753878	-13.645914	110	2	1.12	0.95;
	724	1	13.69	0	0	0	1	1.071239	-14.104314	110	2	1.12	0.95;
	725	1	6.5	0.2	0	0	1	1.0713516	-13.896124	110	2	1.12	0.95;
	726	1	0	0	0	0	1	1.0905764	-12.518052	110	2	1.12	0.95;
	727	1	0	0	0	0	1	1.0905728	-12.518459	110	2	1.12	0.95;
	728	1	3.3	0.5	0	0	1	1.0759682	-18.036569	110	2	1.12	0.95;
	729	1	19.29	3.2	0	0	1	1.0808504	-13.429265	110	2	1.12	0.95;
	730	2	19.69	5.5	0	0	1	1.0698183	-14.034132	110	2	1.12	0.95;
	731	1	7.19	0.2	0	0	1	1.0740472	-15.062754	110	2	1.12	0.95;
	732	2	4.1	1.8	0	0	1	1.0485362	-16.856349	110	2	1.12	0.95;
	733	1	1.1	0	0	0	1	1.0641946	-12.157486	110	2	1.12	0.95;
	734	1	0	0	0	0	1	1.0698477	-20.228446	110	2	1.12	0.95;
	735	2	9.89	4.4	0	0	1	1.0686056	-20.330827	110	2	1.12	0.95;
	736	1	4.4	1.1	0	0	1	1.0738788	-17.346769	110	2	1.12	0.95;
	737	1	15.19	3.9	0	0	1	1.0674234	-20.436057	110	2	1.12	0.95;
	738	1	11.49	1.1	0	0	1	1.0792847	-11.449832	110	2	1.12	0.95;
	739	1	13.59	2.1	0	0	1	1.0557241	-13.865302	110	2	1.12	0.95;
	740	2	12.09	3.2	0	0	1	1.0700376	-12.28039	110	2	1.12	0.95;
	741	1	10.99	0.4	0	0	1	1.0688523	-12.678072	110	2	1.12	0.95;
	742	1	3.1	0.4	0	0	1	1.0428997	-17.751686	110	2	1.12	0.95;
	743	1	6.99	1.5	0	0	1	1.0726084	-14.345144	110	2	1.12	0.95;
	744	2	1.5	16	0	0	1	1.0736967	-10.52941	110	2	1.12	0.95;
	745	1	6.6	0.5	0	0	1	1.0686644	-17.162689	110	2	1.12	0.95;
	746	1	7.69	2.7	0	0	1	1.0663232	-16.685118	110	2	1.12	0.95;
	747	1	5.5	0.5	0	0	1	1.070776	-17.28019	110	2	1.12	0.95;
	748	1	18.79	4.9	0	0	1	1.0733246	-13.79385	110	2	1.12	0.95;
	749	1	4.5	0.9	0	0	1	1.0593194	-11.560764	110	2	1.12	0.95;
	750	1	21.88	6.6	0	0	1	1.0675412	-17.225789	110	2	1.12	0.95;
	751	1	0	0	0	0	1	1.0596336	-21.246686	110	2	1.12	0.95;
	752	1	6.1	1.6	0	0	1	1.069507	-12.410025	110	2	1.12	0.95;
	753	1	13.69	1.1	0	0	1	1.0676225	-17.308128	110	2	1.12	0.95;
	754	2	37.97	27	0	0	1	1.0733304	-14.173901	110	2	1.12	0.95;
	755	2	27.98	31	0	0	1	1.0505828	-16.228645	110	2	1.12	0.95;
	756	1	11.79	1.8	0	0	1	1.0680743	-14.145456	110	2	1.12	0.95;
	757	1	1.6	0	0	0	1	1.0686925	-16.617059	110	2	1.12	0.95;
	758	1	16.19	2.5	0	0	1	1.0709611	-14.237611	110	2	1.12	0.95;
	759	1	6.89	1	0	0	1	1.0725503	-14.200933	110	2	1.12	0.95;
	760	2	16.19	3.1	0	0	1	1.0537487	-19.101932	110	2	1.12	0.95;
	761	1	5.5	0	0	0	1	1.0494735	-18.433377	110	2	1.12	0.95;
	762	1	15.69	1.2	0	0	1	1.0555818	-14.948264	110	2	1.12	0.95;
	763	1	12.19	0	0	0	1	1.0401735	-20.611299	110	2	1.12	0.95;
	764	1	6.4	0.2	0	0	1	1.0429393	-20.450893	110	2	1.12	0.95;
	765	1	5	1.1	0	0	1	1.0517512	-15.919216	110	2	1.12	0.95;
	766	2	10.19	2.1	0	0	1	1.0517885	-20.472506	110	2	1.12	0.95;
	767	1	2.6	0	0	0	1	1.0399049	-20.742204	110	2	1.12	0.95;
	768	1	7.49	3	0	0	1	1.0698548	-11.082544	110	2	1.12	0.95;
	769	1	12.59	2.2	0	0	1	1.0940697	-19.96892	110	2	1.12	0.95;
	770	1	5.5	0.8	0	0	1	1.0416338	-25.037805	110	2	1.12	0.95;
	771	1	13.19	1	0	0	1	1.032604	-26.929937	110	2	1.12	0.95;
	772	1	9.29	1.1	0	0	1	1.0749916	-13.299151	110	2	1.12	0.95;
	773	1	7.09	0.1	0	0	1	1.041713	-24.073387	110	2	1.12	0.95;
	774	1	4.4	0	0	0	1	1.0722923	-15.605493	110	2	1.12	0.95;
	775	1	14.29	0	0	0	1	1.0882513	-10.296396	110	2	1.12	0.95;
	776	1	14.49	1.1	0	0	1	1.0670917	-20.325181	110	2	1.12	0.95;
	777	1	0	0	0	0	1	1.0721865	-17.286648	110	2	1.12	0.95;
	778	1	14.49	0	0	0	1	1.0586249	-19.39732	110	2	1.12	0.95;
	779	1	1.5	0.4	0	0	1	1.0705402	-12.104919	110	2	1.12	0.95;
	780	1	5.5	0	0	0	1	1.0551437	-18.818092	110	2	1.12	0.95;
	781	1	4.1	0.9	0	0	1	1.0494718	-18.374498	110	2	1.12	0.95;
	782	1	14.29	0.9	0	0	1	1.057644	-19.452771	110	2	1.12	0.95;
	783	1	8.39	0.3	0	0	1	1.0581288	-19.440271	110	2	1.12	0.95;
	784	2	3.8	1.6	0	0	1	1.067758	-17.053342	110	2	1.12	0.95;
	785	1	10.39	1.1	0	0	1	1.0698288	-18.481997	110	2	1.12	0.95;
	786	1	0	0	0	0	1	1.0963552	-3.4134366	110	3	1.12	0.95;
	787	1	24.18	0	0	0	1	1.100089	-5.1978608	110	3	1.12	0.95;
	788	1	4.6	4.12	0	0	1	1.0782692	-10.41259	110	3	1.12	0.95;
	789	1	0	0	0	0	1	1.079558	-10.362627	110	3	1.12	0.95;
	790	2	54.35	28.93	0	0	1	1.0795925	-10.367864	110	3	1.12	0.95;
	791	1	0	0	0	0	1	1.0795579	-10.362616	110	3	1.12	0.95;
	792	1	11.19	3.16	0	0	1	1.1052034	-2.4321681	110	3	1.12	0.95;
	793	1	0.7	0.26	0	0	1	1.1136281	0.87563172	110	3	1.12	0.95;
	794	1	8.69	2.54	0	0	1	1.0946966	-5.3686921	110	3	1.12	0.95;
	795	2	26.98	7.1	0	0	1	1.0928587	-3.3844993	110	3	1.12	0.95;
	796	1	21.28	5.44	0	0	1	1.1065065	-8.5269568	110	3	1.12	0.95;
	797	1	0	0	0	0	1	1.1065079	-8.5285949	110	3	1.12	0.95;
	798	2	7.09	3.95	0	0	1	1.1091116	-1.4586699	110	3	1.12	0.95;
	799	1	0	0	0	0	1	1.1091139	-1.4580574	110	3	1.12	0.95;
	800	1	0	0	0	0	1	1.09772	-2.7399444	110	3	1.12	0.95;
	801	1	0	0	0	0	1	1.09772	-2.7399437	110	3	1.12	0.95;
	802	1	5.5	1.93	0	0	1	1.098359	-7.0775364	110	3	1.12	0.95;
	803	1	4.6	0	0	0	1	1.0793618	-10.398386	110	3	1.12	0.95;
	804	1	38.87	4.3	0	0	1	1.1085284	-2.047058	110	3	1.12	0.95;
	805	1	13.39	0	0	0	1	1.0983316	-2.3614011	110	3	1.12	0.95;
	806	1	0	0	0	0	1	1.1021581	-2.1146625	110	3	1.12	0.95;
	807	1	0	0	0	0	1	1.1021581	-2.1146625	110	3	1.12	0.95;
	808	1	19.19	6.31	0	0	1	1.0830798	-7.7911919	110	3	1.12	0.95;
	809	1	19.99	3.95	0	0	1	1.1074743	-2.7293771	110	3	1.12	0.95;
	810	1	5.7	1.75	0	0	1	1.0812075	-10.739997	110	3	1.12	0.95;
	811	1	3.4	1.05	0	0	1	1.0709415	-8.0136931	110	3	1.12	0.95;
	812	1	0	0	0	0	1	1.07098	-8.01202	110	3	1.12	0.95;
	813	1	13.09	7.71	0	0	1	1.0931038	-3.6914192	110	3	1.12	0.95;
	814	2	16.09	10.78	0	0	1	1.0973697	-3.2746033	110	3	1.12	0.95;
	815	1	16.09	5.96	0	0	1	1.0949424	-3.4887462	110	3	1.12	0.95;
	816	1	9.09	0.35	0	0	1	1.066982	-6.6697605	110	3	1.12	0.95;
	817	1	0	0	0	0	1	1.067058	-6.6623543	110	3	1.12	0.95;
	818	1	3.8	1.05	0	0	1	1.0755362	-9.3466841	110	3	1.12	0.95;
	819	1	0	0	0	0	1	1.0763435	-9.3025905	110	3	1.12	0.95;
	820	1	32.18	8.94	0	0	1	1.0462493	-12.607231	110	3	1.12	0.95;
	821	1	0	0	0	0	1	1.1052777	-1.8665688	110	3	1.12	0.95;
	822	1	0	0	0	0	1	1.105251	-1.8667282	110	3	1.12	0.95;
	823	1	3.8	1.14	0	0	1	1.096149	-6.0870399	110	3	1.12	0.95;
	824	1	3.2	0.79	0	0	1	1.096808	-5.5121817	110	3	1.12	0.95;
	825	1	0	0	0	0	1	1.0961948	-6.0844968	110	3	1.12	0.95;
	826	1	0	0	0	0	1	1.0968439	-5.5099748	110	3	1.12	0.95;
	827	1	1.4	0.88	0	0	1	1.1186477	-3.4494684	110	3	1.12	0.95;
	828	1	5.7	1.23	0	0	1	1.0656462	-8.3533488	110	3	1.12	0.95;
	829	1	0	0	0	0	1	1.0664721	-8.2705987	110	3	1.12	0.95;
	830	1	11.09	1.23	0	0	1	1.0941258	-5.4283855	110	3	1.12	0.95;
	831	1	11.79	2.1	0	0	1	1.0851387	-8.1473878	110	3	1.12	0.95;
	832	1	4	0.7	0	0	1	1.0725659	-9.0173741	110	3	1.12	0.95;
	833	1	0	0	0	0	1	1.0869865	-8.0563011	110	3	1.12	0.95;
	834	2	30.38	21.04	0	0	1	1.1115342	-6.4702843	110	3	1.12	0.95;
	835	1	18.19	9.82	0	0	1	1.1031455	-8.6167606	110	3	1.12	0.95;
	836	1	0	0	0	0	1	1.1070412	-8.1770456	110	3	1.12	0.95;
	837	1	8.29	0	0	0	1	1.106047	-8.6822938	110	3	1.12	0.95;
	838	1	19.19	5.08	0	0	1	1.0465898	-12.552998	110	3	1.12	0.95;
	839	1	8.79	0	0	0	1	1.0532065	-11.273151	110	3	1.12	0.95;
	840	1	0	0	0	0	1	1.060038	-10.843456	110	3	1.12	0.95;
	841	1	9.59	2.02	0	0	1	1.0956279	-4.9400626	110	3	1.12	0.95;
	842	1	7.09	2.54	0	0	1	1.0964933	-3.3872574	110	3	1.12	0.95;
	843	1	4.6	2.19	0	0	1	1.1042717	-1.9244792	110	3	1.12	0.95;
	844	1	0	0	0	0	1	1.1053124	-1.8677598	110	3	1.12	0.95;
	845	1	14.19	5	0	0	1	1.0898087	-4.4262691	110	3	1.12	0.95;
	846	1	14.69	5	0	0	1	1.0907872	-4.0657811	110	3	1.12	0.95;
	847	1	10.99	5.79	0	0	1	1.0908034	-4.0625259	110	3	1.12	0.95;
	848	1	0	0	0	0	1	1.0899924	-4.4169769	110	3	1.12	0.95;
	849	1	18.79	4.73	0	0	1	1.1088748	-1.5453548	110	3	1.12	0.95;
	850	1	12.59	4.73	0	0	1	1.0976187	-7.1112473	110	3	1.12	0.95;
	851	1	14.19	1.05	0	0	1	1.0981078	-2.4599898	110	3	1.12	0.95;
	852	1	10.99	5.79	0	0	1	1.0958179	-2.5527589	110	3	1.12	0.95;
	853	1	8.09	2.54	0	0	1	1.0880382	-10.079488	110	3	1.12	0.95;
	854	1	0	0	0	0	1	1.0885524	-10.064078	110	3	1.12	0.95;
	855	1	0	0	0	0	1	1.0881383	-10.074043	110	3	1.12	0.95;
	856	1	0	0	0	0	1	1.0885513	-10.064056	110	3	1.12	0.95;
	857	1	4.4	0.44	0	0	1	1.0892334	-7.6597932	110	3	1.12	0.95;
	858	1	17.49	5.26	0	0	1	1.0905754	-5.1354067	110	3	1.12	0.95;
	859	1	8.79	4.12	0	0	1	1.0920073	-4.9606	110	3	1.12	0.95;
	860	1	17.39	2.45	0	0	1	1.0745145	-7.1426372	110	3	1.12	0.95;
	861	1	21.58	7.98	0	0	1	1.0910817	-3.4338271	110	3	1.12	0.95;
	862	1	13.19	2.89	0	0	1	1.1018111	-2.4238454	110	3	1.12	0.95;
	863	1	0	0	0	0	1	1.0875694	-10.144527	110	3	1.12	0.95;
	864	1	0	0	0	0	1	1.0875625	-10.144423	110	3	1.12	0.95;
	865	1	18.19	5.17	0	0	1	1.0890033	-5.4224299	110	3	1.12	0.95;
	866	1	6.4	2.02	0	0	1	1.0974212	-4.7726094	110	3	1.12	0.95;
	867	1	8.99	1.75	0	0	1	1.1089528	-1.5093154	110	3	1.12	0.95;
	868	1	7.79	1.84	0	0	1	1.1111663	-1.0958204	110	3	1.12	0.95;
	869	1	0	0	0	0	1	1.1095641	-1.4543043	110	3	1.12	0.95;
	870	1	6.7	2.63	0	0	1	1.0899923	-4.416974	110	3	1.12	0.95;
	871	1	3.6	1.05	0	0	1	1.0909745	-4.0561055	110	3	1.12	0.95;
	872	1	8.69	0	0	0	1	1.08913	-9.8907154	110	3	1.12	0.95;
	873	1	10.39	2.37	0	0	1	1.1021632	-8.8969956	110	3	1.12	0.95;
	874	1	0	0	0	0	1	1.1037405	-8.7494778	110	3	1.12	0.95;
	875	1	8.49	2.54	0	0	1	1.0904429	-9.1908497	110	3	1.12	0.95;
	876	1	0	0	0	0	1	1.0907126	-9.1803245	110	3	1.12	0.95;
	877	1	11.19	4.12	0	0	1	1.0916405	-3.911442	110	3	1.12	0.95;
	878	2	30.88	6.84	0	0	1	1.1045524	-2.3575942	110	3	1.12	0.95;
	879	1	0	0	0	0	1	1.1045607	-2.35418	110	3	1.12	0.95;
	880	1	0	0	0	0	1	1.1065241	-8.527262	110	3	1.12	0.95;
	881	1	0	0	0	0	1	1.1065256	-8.5289001	110	3	1.12	0.95;
	882	1	4.9	1.49	0	0	1	1.067602	-12.155756	110	3	1.12	0.95;
	883	1	7.89	2.28	0	0	1	1.0948919	-5.3496806	110	3	1.12	0.95;
	884	2	9.89	0.79	0	0	1	1.0906394	-9.3898544	110	3	1.12	0.95;
	885	1	0	0	0	0	1	1.0907803	-9.3757412	110	3	1.12	0.95;
	886	1	12.89	0.61	0	0	1	1.1070088	-6.6901937	110	3	1.12	0.95;
	887	1	7.69	2.02	0	0	1	1.0848822	-8.8230189	110	3	1.12	0.95;
	888	1	0.8	0.7	0	0	1	1.1095788	-1.4456503	110	3	1.12	0.95;
	889	1	10.89	0	0	0	1	1.1037438	-2.1040765	110	3	1.12	0.95;
	890	1	15.29	1.05	0	0	1	1.1034759	-8.5550515	110	3	1.12	0.95;
	891	1	22.08	8.33	0	0	1	1.0921269	-3.7717817	110	3	1.12	0.95;
	892	2	50.55	26.91	0	0	1	1.0940249	-7.2596593	110	3	1.12	0.95;
	893	1	0	0	0	0	1	1.0940204	-7.2590994	110	3	1.12	0.95;
	894	1	11.19	4.03	0	0	1	1.1098291	0.10340381	110	3	1.12	0.95;
	895	2	15.59	8.77	0	0	1	1.1090145	-1.3363177	110	3	1.12	0.95;
	896	1	7.89	2.45	0	0	1	1.0917156	-3.8878764	110	3	1.12	0.95;
	897	1	1.2	0.26	0	0	1	1.0604413	-10.669037	110	3	1.12	0.95;
	898	1	0	0	0	0	1	1.0604433	-10.668529	110	3	1.12	0.95;
	899	1	6.99	0.7	0	0	1	1.1047919	-8.7807598	110	3	1.12	0.95;
	900	1	11.29	3.77	0	0	1	1.0854235	-8.0547236	110	3	1.12	0.95;
	901	2	22.38	10.78	0	0	1	1.0992877	-2.3500918	110	3	1.12	0.95;
	902	1	9.59	3.42	0	0	1	1.0992703	-4.8386437	110	3	1.12	0.95;
	903	1	0	0	0	0	1	1.0995415	-4.8225174	110	3	1.12	0.95;
	904	1	28.28	6.49	0	0	1	1.1090206	-2.5597706	110	3	1.12	0.95;
	905	1	9.69	2.98	0	0	1	1.0915055	-5.1699161	110	3	1.12	0.95;
	906	1	9.89	2.54	0	0	1	1.0915236	-5.1674438	110	3	1.12	0.95;
	907	1	24.18	5.52	0	0	1	1.1104973	-2.4592358	110	3	1.12	0.95;
	908	1	20.68	3.77	0	0	1	1.1076867	-2.6851677	110	3	1.12	0.95;
	909	1	1	0.44	0	0	1	1.0995743	-2.3152615	110	3	1.12	0.95;
	910	2	11.49	5.44	0	0	1	1.0972493	-3.2900589	110	3	1.12	0.95;
	911	2	34.97	47.78	0	0	1	1.12	-3.128706	110	3	1.12	0.95;
	912	2	40.27	46.38	0	0	1	1.1196933	-4.470932	110	3	1.12	0.95;
	913	1	10.29	0.44	0	0	1	1.0893951	-7.878913	110	3	1.12	0.95;
	914	2	31.88	11.05	0	0	1	1.1077096	-1.7187315	110	3	1.12	0.95;
	915	1	0	0	0	0	1	1.0972257	-4.9057867	110	3	1.12	0.95;
	916	1	0	0	0	0	1	1.097285	-4.8946036	110	3	1.12	0.95;
	917	2	9.29	2.98	0	0	1	1.1027054	-2.6018688	110	3	1.12	0.95;
	918	1	5.9	2.28	0	0	1	1.0768963	-9.5189296	110	3	1.12	0.95;
	919	2	26.28	11.75	0	0	1	1.103471	-1.8734396	110	3	1.12	0.95;
	920	2	4.4	1.75	0	0	1	1.0995732	-2.9531526	110	3	1.12	0.95;
	921	1	0	0	0	0	1	1.1036823	-2.0994348	110	3	1.12	0.95;
	922	1	3.7	0.88	0	0	1	1.1041906	-8.8676954	110	3	1.12	0.95;
	923	1	0	0	0	0	1	1.1041972	-8.8662523	110	3	1.12	0.95;
	924	1	0	0	0	0	1	1.1056501	-1.2621592	110	3	1.12	0.95;
	925	1	4.7	1.75	0	0	1	1.0495887	-13.524599	110	3	1.12	0.95;
	926	1	0	0	0	0	1	1.0496532	-13.521317	110	3	1.12	0.95;
	927	1	0	0	0	0	1	1.0949309	-3.4899789	110	3	1.12	0.95;
	928	1	0	0	0	0	1	1.0949303	-3.4899704	110	3	1.12	0.95;
	929	2	26.98	5.87	0	0	1	1.1086058	-2.3153937	110	3	1.12	0.95;
	930	1	8.09	0	0	0	1	1.1065343	-2.1303268	110	3	1.12	0.95;
	931	1	0	0	0	0	1	1.0898086	-9.929364	110	3	1.12	0.95;
	932	1	0	0	0	0	1	1.0898085	-9.9293595	110	3	1.12	0.95;
	933	1	0	0	0	0	1	1.097226	-4.905792	110	3	1.12	0.95;
	934	1	0	0	0	0	1	1.0972853	-4.8946088	110	3	1.12	0.95;
	935	1	1.4	0.44	0	0	1	1.0860252	-9.9626826	110	3	1.12	0.95;
	936	1	0	0	0	0	1	1.0860456	-9.9611677	110	3	1.12	0.95;
	937	1	0	0	0	0	1	1.0959789	-4.9130049	110	3	1.12	0.95;
	938	1	0	0	0	0	1	1.0959789	-4.9130049	110	3	1.12	0.95;
	939	1	1.4	0.09	0	0	1	1.1109428	0.00422605	110	3	1.12	0.95;
	940	1	0	0	0	0	1	1.1115244	-1.1320443	110	3	1.12	0.95;
	941	1	0	0	0	0	1	1.1115244	-1.1320443	110	3	1.12	0.95;
	942	1	4.1	1.75	0	0	1	1.0958465	-3.4379056	110	3	1.12	0.95;
	943	1	8.09	2.54	0	0	1	1.1015481	-4.3964513	110	3	1.12	0.95;
	944	1	0.4	0	0	0	1	1.1115244	-1.1320443	110	3	1.12	0.95;
	945	1	18.39	2.02	0	0	1	1.0898232	-5.2275066	110	3	1.12	0.95;
	946	1	0	0	0	0	1	1.0920141	-4.96071	110	3	1.12	0.95;
	947	1	12.29	1.75	0	0	1	1.1026584	-2.3960121	110	3	1.12	0.95;
	948	1	22.18	2.98	0	0	1	1.1067795	-1.6735637	110	3	1.12	0.95;
	949	1	3.4	1.05	0	0	1	1.0979923	-7.016078	110	3	1.12	0.95;
	950	1	0.4	0.61	0	0	1	1.109815	-5.8928219	110	3	1.12	0.95;
	951	1	0.7	0.79	0	0	1	1.1094124	-6.0400965	110	3	1.12	0.95;
	952	1	17.89	6.58	0	0	1	1.0981277	-5.1648832	110	3	1.12	0.95;
	953	1	0	0	0	0	1	1.0987292	-5.1444725	110	3	1.12	0.95;
	954	1	9.69	1.14	0	0	1	1.0820853	-8.5403453	110	3	1.12	0.95;
	955	1	18.89	9.21	0	0	1	1.0865803	-10.176389	110	3	1.12	0.95;
	956	1	0	0	0	0	1	1.0888386	-10.047182	110	3	1.12	0.95;
	957	1	11.89	4.91	0	0	1	1.0935992	-3.6278114	110	3	1.12	0.95;
	958	1	3.3	0.79	0	0	1	1.0603867	-12.911469	110	3	1.12	0.95;
	959	2	16.49	4.03	0	0	1	1.0653863	-10.823425	110	3	1.12	0.95;
	960	1	1	0.61	0	0	1	1.1014493	-2.1390627	110	3	1.12	0.95;
	961	1	3.5	0.26	0	0	1	1.1014943	-2.1367729	110	3	1.12	0.95;
	962	1	10.09	4.38	0	0	1	1.1057344	-6.4924969	110	3	1.12	0.95;
	963	1	13.39	5	0	0	1	1.0942471	-3.6018785	110	3	1.12	0.95;
	964	1	21.78	4.3	0	0	1	1.1065772	-2.6453494	110	3	1.12	0.95;
	965	1	8.69	2.19	0	0	1	1.1137114	-5.3987078	110	3	1.12	0.95;
	966	1	0	0	0	0	1	1.0476426	-12.440493	110	3	1.12	0.95;
	967	1	0	0	0	0	1	1.0476533	-12.439697	110	3	1.12	0.95;
	968	2	10.19	4.03	0	0	1	1.0884724	-7.7322084	110	3	1.12	0.95;
	969	1	0	0	0	0	1	1.0879746	-7.4002532	110	3	1.12	0.95;
	970	1	1.9	0.7	0	0	1	1.0917386	-9.449574	110	3	1.12	0.95;
	971	1	0	0	0	0	1	1.0879746	-7.4002532	110	3	1.12	0.95;
	972	1	0	0	0	0	1	1.0917737	-9.4468221	110	3	1.12	0.95;
	973	1	8.59	0.79	0	0	1	1.1107578	-5.7681883	110	3	1.12	0.95;
	974	1	0.2	0	0	0	1	1.0984506	-3.1943472	110	3	1.12	0.95;
	975	1	3.1	1.49	0	0	1	1.0787331	-10.326128	110	3	1.12	0.95;
	976	1	5.7	1.84	0	0	1	1.1028044	-8.6260882	110	3	1.12	0.95;
	977	1	0	0	0	0	1	1.1028183	-8.6238594	110	3	1.12	0.95;
	978	1	2.7	1.05	0	0	1	1.1094401	-6.0398838	110	3	1.12	0.95;
	979	1	9.89	0	0	0	1	1.1098343	-5.8928173	110	3	1.12	0.95;
	980	1	6.89	2.02	0	0	1	1.0693353	-10.710868	110	3	1.12	0.95;
	981	1	0	0	0	0	1	1.069625	-10.699891	110	3	1.12	0.95;
	982	1	12.49	3.42	0	0	1	1.0511971	-12.898727	110	3	1.12	0.95;
	983	1	12.29	4.12	0	0	1	1.1032904	-2.0691559	110	3	1.12	0.95;
	984	1	0	0	0	0	1	1.109466	-1.2808287	110	3	1.12	0.95;
	985	1	0	0	0	0	1	1.1037501	-2.0452325	110	3	1.12	0.95;
	986	1	0	0	0	0	1	1.1094649	-1.280807	110	3	1.12	0.95;
	987	1	0	0	0	0	1	1.1110725	-1.2649345	110	3	1.12	0.95;
	988	1	17.69	4.56	0	0	1	1.0851115	-10.349159	110	3	1.12	0.95;
	989	1	0	0	0	0	1	1.111069	-1.2648741	110	3	1.12	0.95;
	990	1	0	0	0	0	1	1.0857912	-10.297741	110	3	1.12	0.95;
	991	1	0	0	0	0	1	1.1105785	-6.1930487	110	3	1.12	0.95;
	992	1	3.2	0.26	0	0	1	1.0939287	-3.6031189	110	3	1.12	0.95;
	993	2	7.99	1.05	0	0	1	1.0725907	-9.7765936	110	3	1.12	0.95;
	994	2	6.89	1.49	0	0	1	1.0725894	-9.7776403	110	3	1.12	0.95;
	995	2	5.2	8.15	0	0	1	1.107285	-3.9680435	110	3	1.12	0.95;
	996	2	3.3	3.42	0	0	1	1.1116648	-1.2048592	110	3	1.12	0.95;
	997	2	3.3	2.89	0	0	1	1.0888321	-10.047067	110	3	1.12	0.95;
	998	1	7.69	0	0	0	1	1.1153528	-5.318848	110	3	1.12	0.95;
	999	1	13.49	4.03	0	0	1	1.0900993	-3.4340418	110	3	1.12	0.95;
	1000	1	3.4	0	0	0	1	1.0832033	-5.9725305	110	3	1.12	0.95;
	1001	1	0.7	0	0	0	1	1.083224	-5.9703558	110	3	1.12	0.95;
	1002	1	5.6	1.49	0	0	1	1.096044	-5.4644747	110	3	1.12	0.95;
	1003	1	0	0	0	0	1	1.0961941	-5.452374	110	3	1.12	0.95;
	1004	2	12.19	4.91	0	0	1	1.1066209	-8.5967372	110	3	1.12	0.95;
	1005	1	4.5	1.23	0	0	1	1.0916362	-7.7542856	110	3	1.12	0.95;
	1006	1	0	0	0	0	1	1.1071439	-8.5931269	110	3	1.12	0.95;
	1007	1	0	0	0	0	1	1.091698	-7.7494046	110	3	1.12	0.95;
	1008	1	0	0	0	0	1	1.1071439	-8.5931269	110	3	1.12	0.95;
	1009	1	25.38	5.87	0	0	1	1.1054064	-8.7109069	110	3	1.12	0.95;
	1010	1	9.29	3.68	0	0	1	1.0913485	-7.763498	110	3	1.12	0.95;
	1011	1	14.69	8.15	0	0	1	1.1058726	-8.6254598	110	3	1.12	0.95;
	1012	1	9.09	2.02	0	0	1	1.0795018	-8.4358242	110	3	1.12	0.95;
	1013	1	0	0	0	0	1	1.0940266	-7.2596891	110	3	1.12	0.95;
	1014	1	17.89	2.72	0	0	1	1.1118377	-2.9737817	110	3	1.12	0.95;
	1015	1	18.49	7.45	0	0	1	1.1117865	-2.8990665	110	3	1.12	0.95;
	1016	1	63.33	18.41	0	0	1	1.112429	-0.97538721	110	3	1.12	0.95;
	1017	1	0	0	0	0	1	1.1120115	-2.9611457	110	3	1.12	0.95;
	1018	1	0	0	0	0	1	1.1131747	-0.93410495	110	3	1.12	0.95;
	1019	1	0	0	0	0	1	1.1121459	-2.8735651	110	3	1.12	0.95;
	1020	1	39.37	2.54	0	0	1	1.0889261	-9.9272652	110	3	1.12	0.95;
	1021	1	0	0	0	0	1	1.0857219	-10.334561	110	3	1.12	0.95;
	1022	1	2	0.35	0	0	1	1.0854972	-8.0546311	110	3	1.12	0.95;
	1023	1	0	0	0	0	1	1.0888355	-8.0208573	110	3	1.12	0.95;
	1024	2	18.79	3.24	0	0	1	1.1029654	-6.7075159	110	3	1.12	0.95;
	1025	1	0	0	0	0	1	1.102965	-6.7073343	110	3	1.12	0.95;
	1026	1	4.1	0.61	0	0	1	1.0994209	-4.762495	110	3	1.12	0.95;
	1027	2	30.28	10.7	0	0	1	1.1080626	-2.7589717	110	3	1.12	0.95;
	1028	2	3.3	2.45	0	0	1	1.1081096	-2.7406273	110	3	1.12	0.95;
	1029	2	30.28	11.31	0	0	1	1.1074395	-3.3070934	110	3	1.12	0.95;
	1030	1	24.08	0	0	0	1	1.1079231	-2.7440491	110	3	1.12	0.95;
	1031	1	0	0	0	0	1	1.1079248	-2.7439395	110	3	1.12	0.95;
	1032	1	7.79	2.02	0	0	1	1.1086027	-2.6241214	110	3	1.12	0.95;
	1033	1	9.99	4.12	0	0	1	1.1092104	-2.8273454	110	3	1.12	0.95;
	1034	1	6.7	1.05	0	0	1	1.1073645	-3.2936307	110	3	1.12	0.95;
	1035	1	5.6	0	0	0	1	1.1080426	-2.745258	110	3	1.12	0.95;
	1036	1	7.79	2.02	0	0	1	1.1073345	-3.2945154	110	3	1.12	0.95;
	1037	1	11.09	5.87	0	0	1	1.1093582	-2.8140919	110	3	1.12	0.95;
	1038	1	8.99	3.16	0	0	1	1.1086846	-2.6137983	110	3	1.12	0.95;
	1039	1	28.48	0	0	0	1	1.1083312	-2.6911949	110	3	1.12	0.95;
	1040	1	0	0	0	0	1	1.1083302	-2.6895002	110	3	1.12	0.95;
	1041	1	1.2	0	0	0	1	1.1082658	-3.0567456	110	3	1.12	0.95;
	1042	1	1.2	0	0	0	1	1.1083601	-3.1136168	110	3	1.12	0.95;
	1043	1	0	0	0	0	1	1.1082658	-3.056281	110	3	1.12	0.95;
	1044	1	0	0	0	0	1	1.1083601	-3.1131523	110	3	1.12	0.95;
	1045	1	1.9	0.88	0	0	1	1.1060599	-1.8825151	110	3	1.12	0.95;
	1046	1	3.2	0.7	0	0	1	1.0890933	-4.4768714	110	3	1.12	0.95;
	1047	1	0	0	0	0	1	1.0892974	-4.4578186	110	3	1.12	0.95;
	1048	1	0	0	0	0	1	1.09942	-2.6999348	110	3	1.12	0.95;
	1049	1	0	0	0	0	1	1.0994193	-2.6999263	110	3	1.12	0.95;
	1050	1	0	0	0	0	1	1.0892886	-4.457653	110	3	1.12	0.95;
	1051	1	23.58	6.93	0	0	1	1.1069275	-0.32694897	110	3	1.12	0.95;
	1052	1	0	0	0	0	1	1.1000154	-2.5188227	110	3	1.12	0.95;
	1053	2	9.49	8.42	0	0	1	1.0972671	-3.3726661	110	3	1.12	0.95;
	1054	2	7.59	8.59	0	0	1	1.0978658	-3.161751	110	3	1.12	0.95;
	1055	1	6.5	1.75	0	0	1	1.0639268	-7.554949	110	3	1.12	0.95;
	1056	1	6.99	0.88	0	0	1	1.0924022	-3.780756	110	3	1.12	0.95;
	1057	1	0	0	0	0	1	1.0924089	-3.7779705	110	3	1.12	0.95;
	1058	1	17.49	3.16	0	0	1	1.1010436	-2.2245612	110	3	1.12	0.95;
	1059	1	59.34	31.82	0	0	1	1.0945596	-3.6120178	110	3	1.12	0.95;
	1060	1	39.87	16.04	0	0	1	1.0398449	-3.1193609	110	3	1.12	0.95;
	1061	1	8.09	0.61	0	0	1	1.0931698	-3.6799219	110	3	1.12	0.95;
	1062	1	0	0	0	0	1	1.095739	-4.9334594	110	3	1.12	0.95;
	1063	1	0	0	0	0	1	1.0931745	-3.6767025	110	3	1.12	0.95;
	1064	1	3.4	1.23	0	0	1	1.1045568	-2.8971866	110	3	1.12	0.95;
	1065	1	0	0	0	0	1	1.1047712	-2.8818381	110	3	1.12	0.95;
	1066	1	17.59	4.91	0	0	1	1.0960583	-2.6084614	110	3	1.12	0.95;
	1067	1	5.7	2.02	0	0	1	1.0979014	-2.7568674	110	3	1.12	0.95;
	1068	1	1	0.09	0	0	1	1.0975156	-2.8027981	110	3	1.12	0.95;
	1069	1	0	0	0	0	1	1.0979747	-2.7531889	110	3	1.12	0.95;
	1070	1	0	0	0	0	1	1.0975249	-2.8016483	110	3	1.12	0.95;
	1071	1	1.2	0.61	0	0	1	1.1059542	-0.88504625	110	3	1.12	0.95;
	1072	1	4.7	1.05	0	0	1	1.0971668	-4.9109264	110	3	1.12	0.95;
	1073	1	4.1	1.93	0	0	1	1.0972108	-4.8986876	110	3	1.12	0.95;
	1074	1	6.6	1.75	0	0	1	1.0970176	-9.4690265	110	3	1.12	0.95;
	1075	1	10.19	2.54	0	0	1	1.0947239	-5.8242718	110	3	1.12	0.95;
	1076	1	1.4	0.09	0	0	1	1.1044317	-2.0044449	110	3	1.12	0.95;
	1077	1	12.29	4.65	0	0	1	1.1056042	-0.94365875	110	3	1.12	0.95;
	1078	1	4.4	1.49	0	0	1	1.1010993	-7.8111991	110	3	1.12	0.95;
	1079	1	11.09	4.38	0	0	1	1.063031	-6.9919944	110	3	1.12	0.95;
	1080	1	9.69	3.42	0	0	1	1.097921	-5.0800383	110	3	1.12	0.95;
	1081	1	0	0	0	0	1	1.0979468	-5.0762156	110	3	1.12	0.95;
	1082	1	7.69	1.58	0	0	1	1.0952783	-3.5092316	110	3	1.12	0.95;
	1083	1	5.1	1.14	0	0	1	1.0929967	-3.7521289	110	3	1.12	0.95;
	1084	1	5.1	0.61	0	0	1	1.103601	-2.5360005	110	3	1.12	0.95;
	1085	1	0	0	0	0	1	1.0901795	-7.6527361	110	3	1.12	0.95;
	1086	1	1.2	1.05	0	0	1	1.0986008	-2.7121652	110	3	1.12	0.95;
	1087	1	9.99	4.12	0	0	1	1.09826	-7.0576895	110	3	1.12	0.95;
	1088	1	6.7	2.89	0	0	1	1.0999415	-6.8988867	110	3	1.12	0.95;
	1089	1	12.29	2.02	0	0	1	1.0875208	-5.5193062	110	3	1.12	0.95;
	1090	1	7.09	1.93	0	0	1	1.0625864	-8.1532259	110	3	1.12	0.95;
	1091	1	7.49	1.93	0	0	1	1.0617113	-8.1475487	110	3	1.12	0.95;
	1092	1	0	0	0	0	1	1.0632583	-8.1246441	110	3	1.12	0.95;
	1093	1	0	0	0	0	1	1.062512	-8.1081992	110	3	1.12	0.95;
	1094	1	7.09	1.84	0	0	1	1.0970492	-5.0845396	110	3	1.12	0.95;
	1095	1	0	0	0	0	1	1.0957309	-4.933308	110	3	1.12	0.95;
	1096	1	0	0	0	0	1	1.0965851	-3.382684	110	3	1.12	0.95;
	1097	1	26.58	7.8	0	0	1	1.1036792	-8.7512226	110	3	1.12	0.95;
	1098	1	0	0	0	0	1	1.1036846	-8.7510473	110	3	1.12	0.95;
	1099	1	6.2	2.19	0	0	1	1.0948889	-3.5545078	110	3	1.12	0.95;
	1100	1	2.7	0.7	0	0	1	1.0951755	-6.2193131	110	3	1.12	0.95;
	1101	1	0	0	0	0	1	1.0951808	-6.2182426	110	3	1.12	0.95;
	1102	1	10.49	1.05	0	0	1	1.0974674	-3.0824185	110	3	1.12	0.95;
	1103	1	8.79	0.61	0	0	1	1.1058465	-8.5049896	110	3	1.12	0.95;
	1104	1	13.79	3.16	0	0	1	1.0484952	-12.969177	110	3	1.12	0.95;
	1105	2	13.69	9.21	0	0	1	1.1055733	-8.3897235	110	3	1.12	0.95;
	1106	2	38.57	13.94	0	0	1	1.1091357	-8.1683709	110	3	1.12	0.95;
	1107	2	47.56	14.2	0	0	1	1.0948675	-3.2094718	110	3	1.12	0.95;
	1108	1	0	0	0	0	1	1.0948743	-3.2081526	110	3	1.12	0.95;
	1109	1	2.3	1.05	0	0	1	1.0884316	-10.053988	110	3	1.12	0.95;
	1110	1	9.59	5.61	0	0	1	1.1055203	-4.1195079	110	3	1.12	0.95;
	1111	1	0	0	0	0	1	1.0884648	-10.052568	110	3	1.12	0.95;
	1112	1	0	0	0	0	1	1.1056758	-4.1142666	110	3	1.12	0.95;
	1113	1	5.7	0.7	0	0	1	1.0945899	-4.9655588	110	3	1.12	0.95;
	1114	1	0	0	0	0	1	1.0775063	-9.9923056	110	3	1.12	0.95;
	1115	1	0	0	0	0	1	1.0764211	-10.281641	110	3	1.12	0.95;
	1116	1	5.7	2.02	0	0	1	1.0872073	-4.5301067	110	3	1.12	0.95;
	1117	1	7.39	0.61	0	0	1	1.1115003	-1.1285635	110	3	1.12	0.95;
	1118	1	6.2	1.75	0	0	1	1.0948675	-3.523925	110	3	1.12	0.95;
	1119	1	0	0	0	0	1	1.0952763	-3.5034729	110	3	1.12	0.95;
	1120	1	0	0	0	0	1	1.1050693	-8.115772	110	3	1.12	0.95;
	1121	1	0	0	0	0	1	1.0902485	-7.9301773	110	3	1.12	0.95;
	1122	1	13.79	3.51	0	0	1	1.0753287	-8.8255864	110	3	1.12	0.95;
	1123	1	0	0	0	0	1	1.0900973	-7.571301	110	3	1.12	0.95;
	1124	1	5.6	0.09	0	0	1	1.089829	-9.9410581	110	3	1.12	0.95;
	1125	1	5.9	1.23	0	0	1	1.1110599	-1.267147	110	3	1.12	0.95;
	1126	1	6.7	2.1	0	0	1	1.0857752	-10.300443	110	3	1.12	0.95;
	1127	1	0	0	0	0	1	1.0901293	-9.9165993	110	3	1.12	0.95;
	1128	1	9.89	1.4	0	0	1	1.0866798	-8.5040939	110	3	1.12	0.95;
	1129	1	0	0	0	0	1	1.0871037	-8.458661	110	3	1.12	0.95;
	1130	1	4	0.7	0	0	1	1.0947603	-6.3069084	110	3	1.12	0.95;
	1131	1	0	0	0	0	1	1.0947656	-6.3053212	110	3	1.12	0.95;
	1132	1	11.09	2.54	0	0	1	1.0890844	-5.4067868	110	3	1.12	0.95;
	1133	1	10.49	2.63	0	0	1	1.0916971	-9.9186986	110	3	1.12	0.95;
	1134	1	3	1.58	0	0	1	1.1090998	-1.4598297	110	3	1.12	0.95;
	1135	1	0	0	0	0	1	1.1091141	-1.4580574	110	3	1.12	0.95;
	1136	1	10.99	2.54	0	0	1	1.0856813	-10.333884	110	3	1.12	0.95;
	1137	1	4.1	2.1	0	0	1	1.106973	-2.643955	110	3	1.12	0.95;
	1138	2	12.49	8.42	0	0	1	1.1067115	-2.0989955	110	3	1.12	0.95;
	1139	1	1.2	2.63	0	0	1	1.1067848	-2.1653245	110	3	1.12	0.95;
	1140	2	16.59	26.04	0	0	1	1.119998	-0.33676276	110	3	1.12	0.95;
	1141	2	15.59	20.43	0	0	1	1.1124853	-2.8458696	110	3	1.12	0.95;
	1142	1	19.29	6.58	0	0	1	1.1159994	-0.92683412	110	3	1.12	0.95;
	1143	1	6.5	1.4	0	0	1	1.0655235	-9.2199492	110	3	1.12	0.95;
	1144	1	4.9	0	0	0	1	1.095707	-7.9398185	110	3	1.12	0.95;
	1145	1	12.59	9.03	0	0	1	1.1026278	-4.2644355	110	3	1.12	0.95;
	1146	1	16.99	2.19	0	0	1	1.1020095	-6.9547715	110	3	1.12	0.95;
	1147	1	11.29	3.16	0	0	1	1.0880822	-4.7635992	110	3	1.12	0.95;
	1148	1	5.1	1.05	0	0	1	1.0814947	-8.1270081	110	3	1.12	0.95;
	1149	1	8.09	2.1	0	0	1	1.0479729	-12.955055	110	3	1.12	0.95;
	1150	1	11.99	2.28	0	0	1	1.1137085	-2.1296739	110	3	1.12	0.95;
	1151	1	0	0	0	0	1	1.1138315	-2.1214058	110	3	1.12	0.95;
	1152	1	0	0	0	0	1	1.0953836	-5.2839919	110	3	1.12	0.95;
	1153	1	0	0	0	0	1	1.0953808	-5.2839114	110	3	1.12	0.95;
	1154	1	5.5	1.05	0	0	1	1.073033	-8.9670457	110	3	1.12	0.95;
	1155	1	9.79	4.3	0	0	1	1.1060102	-1.8909119	110	3	1.12	0.95;
	1156	1	1.4	0.35	0	0	1	1.0958837	-3.4089749	110	3	1.12	0.95;
	1157	1	0	0	0	0	1	1.0971609	-9.2662436	110	3	1.12	0.95;
	1158	1	0	0	0	0	1	1.0971609	-9.2662436	110	3	1.12	0.95;
	1159	1	0	0	0	0	1	1.0937059	-4.2119829	110	3	1.12	0.95;
	1160	1	12.59	6.75	0	0	1	1.0873672	-5.1411108	110	3	1.12	0.95;
	1161	1	0	0	0	0	1	1.093702	-4.2118799	110	3	1.12	0.95;
	1162	1	0	0	0	0	1	1.0883545	-5.1041568	110	3	1.12	0.95;
	1163	1	9.19	2.81	0	0	1	1.1083086	-1.5684578	110	3	1.12	0.95;
	1164	1	0	0	0	0	1	1.10328	-8.7103829	110	3	1.12	0.95;
	1165	1	1.8	0	0	0	1	1.1027967	-8.7061242	110	3	1.12	0.95;
	1166	1	0	0	0	0	1	1.1032799	-8.7103793	110	3	1.12	0.95;
	1167	1	0	0	0	0	1	1.1028101	-8.7050691	110	3	1.12	0.95;
	1168	1	7.89	1.05	0	0	1	1.0736399	-10.340058	110	3	1.12	0.95;
	1169	1	11.19	1.75	0	0	1	1.0778005	-8.618191	110	3	1.12	0.95;
	1170	1	10.89	2.02	0	0	1	1.1061501	-8.3166129	110	3	1.12	0.95;
	1171	1	15.69	2.45	0	0	1	1.0820692	-5.7578248	110	3	1.12	0.95;
	1172	1	5.3	0	0	0	1	1.1014957	-4.4234267	110	3	1.12	0.95;
	1173	1	5.1	1.14	0	0	1	1.0904726	-5.1406054	110	3	1.12	0.95;
	1174	1	5.3	-0.53	0	0	1	1.0919396	-4.9673473	110	3	1.12	0.95;
	1175	2	62.23	19.2	0	0	1	1.1037953	-7.0821493	110	3	1.12	0.95;
	1176	1	9.99	2.02	0	0	1	1.1019701	-7.4117864	110	3	1.12	0.95;
	1177	1	11.09	0	0	0	1	1.1013604	-7.2507933	110	3	1.12	0.95;
	1178	1	0	0	0	0	1	1.102068	-7.4067307	110	3	1.12	0.95;
	1179	1	13.39	1.58	0	0	1	1.0888634	-9.8891569	110	3	1.12	0.95;
	1180	1	0	0	0	0	1	1.0983419	-8.7578246	110	3	1.12	0.95;
	1181	1	6.2	2.19	0	0	1	1.0621901	-11.68269	110	3	1.12	0.95;
	1182	2	7.99	10.17	0	0	1	1.1011909	-6.2935707	110	3	1.12	0.95;
	1183	2	14.59	9.82	0	0	1	1.0962214	-3.4115287	110	3	1.12	0.95;
	1184	2	10.39	9.91	0	0	1	1.1027258	-4.6768907	110	3	1.12	0.95;
	1185	1	9.09	1.84	0	0	1	1.0681492	-7.8545086	110	3	1.12	0.95;
	1186	1	7.49	2.19	0	0	1	1.1178537	-0.50597018	110	3	1.12	0.95;
	1187	1	17.69	5.26	0	0	1	1.1091433	-3.1728243	110	3	1.12	0.95;
	1188	1	0	0	0	0	1	1.1181871	-0.48935943	110	3	1.12	0.95;
	1189	1	0	0	0	0	1	1.1099443	-3.1332048	110	3	1.12	0.95;
	1190	1	26.48	5.17	0	0	1	1.0485836	-13.124301	110	3	1.12	0.95;
	1191	2	9.99	10.78	0	0	1	1.1125205	-2.8478448	110	3	1.12	0.95;
	1192	2	16.19	11.92	0	0	1	1.1141468	-0.85155949	110	3	1.12	0.95;
	1193	1	19.19	1.05	0	0	1	1.0744495	-8.8019374	110	3	1.12	0.95;
	1194	1	3.4	0.44	0	0	1	1.0953358	-3.5874655	110	3	1.12	0.95;
	1195	1	23.38	5.61	0	0	1	1.0884396	-5.4516918	110	3	1.12	0.95;
	1196	1	0	0	0	0	1	1.0999999	-4.5439642	110	3	1.12	0.95;
	1197	1	4.7	0.88	0	0	1	1.1054719	-1.8250165	110	3	1.12	0.95;
	1198	1	16.69	3.51	0	0	1	1.1005847	-2.1529136	110	3	1.12	0.95;
	1199	1	0	0	0	0	1	1.1057505	-1.8069064	110	3	1.12	0.95;
	1200	1	0	0	0	0	1	1.1016228	-2.0893156	110	3	1.12	0.95;
	1201	2	14.59	15.25	0	0	1	1.1117675	-2.2984956	110	3	1.12	0.95;
	1202	2	18.79	17.97	0	0	1	1.1118046	-2.2984788	110	3	1.12	0.95;
	1203	2	23.58	21.65	0	0	1	1.1089917	-2.436109	110	3	1.12	0.95;
	1204	1	11.09	1.93	0	0	1	1.1078287	-1.7020209	110	3	1.12	0.95;
	1205	1	13.79	2.02	0	0	1	1.0950536	-4.7960281	110	3	1.12	0.95;
	1206	1	13.39	2.02	0	0	1	1.0918941	-7.4715045	110	3	1.12	0.95;
	1207	1	2.4	0.7	0	0	1	1.1036163	-2.1128172	110	3	1.12	0.95;
	1208	1	0	0	0	0	1	1.1053445	-1.7417045	110	3	1.12	0.95;
	1209	1	0	0	0	0	1	1.1053445	-1.7417045	110	3	1.12	0.95;
	1210	1	13.79	2.98	0	0	1	1.1065052	-2.5518388	110	3	1.12	0.95;
	1211	1	22.08	4.3	0	0	1	1.109345	-2.2576688	110	3	1.12	0.95;
	1212	1	0	0	0	0	1	1.0988846	-7.0505839	110	3	1.12	0.95;
	1213	1	0	0	0	0	1	1.098882	-7.0471078	110	3	1.12	0.95;
	1214	1	8.09	2.89	0	0	1	1.0896759	-4.7503173	110	3	1.12	0.95;
	1215	1	17.99	2.45	0	0	1	1.0538334	-10.07149	110	3	1.12	0.95;
	1216	1	6	1.05	0	0	1	1.1080839	-2.7387666	110	3	1.12	0.95;
	1217	1	14.69	0	0	0	1	1.1074377	-3.286265	110	3	1.12	0.95;
	1218	1	3.4	1.23	0	0	1	1.1017485	-6.822157	110	3	1.12	0.95;
	1219	1	0	0	0	0	1	1.1018879	-6.8142659	110	3	1.12	0.95;
	1220	1	16.39	6.05	0	0	1	1.0948846	-3.4939424	110	3	1.12	0.95;
	1221	1	1.5	0.61	0	0	1	1.0937863	-9.5508546	110	3	1.12	0.95;
	1222	1	0	0	0	0	1	1.0939115	-9.5458558	110	3	1.12	0.95;
	1223	1	12.99	9.73	0	0	1	1.0963085	-3.3666174	110	3	1.12	0.95;
	1224	1	6.7	1.4	0	0	1	1.0829873	-7.8185197	110	3	1.12	0.95;
	1225	1	0	0	0	0	1	1.0820313	-7.8952537	110	3	1.12	0.95;
	1226	1	0	0	0	0	1	1.0831933	-7.8066713	110	3	1.12	0.95;
	1227	1	0	0	0	0	1	1.0820304	-7.8952246	110	3	1.12	0.95;
	1228	1	5.1	0.09	0	0	1	1.1056268	-1.9735034	110	3	1.12	0.95;
	1229	1	18.89	5	0	0	1	1.1041517	-2.3265931	110	3	1.12	0.95;
	1230	1	0	0	0	0	1	1.0855699	-8.0511089	110	3	1.12	0.95;
	1231	1	0	0	0	0	1	1.0888338	-8.0207862	110	3	1.12	0.95;
	1232	2	18.29	11.75	0	0	1	1.0955254	-6.2469561	110	3	1.12	0.95;
	1233	2	8.49	7.01	0	0	1	1.090177	-7.6526863	110	3	1.12	0.95;
	1234	1	30.98	9.47	0	0	1	1.0850837	-8.0975273	110	3	1.12	0.95;
	1235	1	6.89	1.75	0	0	1	1.0878997	-9.7839144	110	3	1.12	0.95;
	1236	1	6.89	1.23	0	0	1	1.0983563	-4.8732574	110	3	1.12	0.95;
	1237	1	1.4	0.61	0	0	1	1.0945953	-3.5939795	110	3	1.12	0.95;
	1238	1	2.7	0.7	0	0	1	1.0858528	-10.044478	110	3	1.12	0.95;
	1239	1	0	0	0	0	1	1.0858839	-10.04259	110	3	1.12	0.95;
	1240	1	17.49	4.73	0	0	1	1.1064482	-2.4150379	110	3	1.12	0.95;
	1241	1	9.89	3.16	0	0	1	1.0886424	-3.5019332	110	3	1.12	0.95;
	1242	1	7.39	1.93	0	0	1	1.0976662	-3.2697369	110	3	1.12	0.95;
	1243	1	0	0	0	0	1	1.0976808	-3.2668202	110	3	1.12	0.95;
	1244	2	31.78	10.35	0	0	1	1.0999378	-2.8008391	110	3	1.12	0.95;
	1245	1	6.6	-1.75	0	0	1	1.0962568	-2.6414144	110	3	1.12	0.95;
	1246	1	2.3	-1.75	0	0	1	1.1037943	-2.0218852	110	3	1.12	0.95;
	1247	2	10.29	12.8	0	0	1	1.1044075	-1.9077663	110	3	1.12	0.95;
	1248	1	0	0	0	0	1	1.1037719	-2.0185127	110	3	1.12	0.95;
	1249	1	31.58	8.94	0	0	1	1.0711715	-7.4903063	110	3	1.12	0.95;
	1250	2	29.08	29.63	0	0	1	1.0980872	-3.22029	110	3	1.12	0.95;
	1251	1	13.39	5.52	0	0	1	1.0980728	-3.2237524	110	3	1.12	0.95;
	1252	1	0	0	0	0	1	1.113896	0.89655339	110	3	1.12	0.95;
	1253	1	0	0	0	0	1	1.1138784	0.91189064	110	3	1.12	0.95;
	1254	1	7.39	3.59	0	0	1	1.1096994	-1.2219408	110	3	1.12	0.95;
	1255	1	5.2	2.19	0	0	1	1.1070998	-1.3906984	110	3	1.12	0.95;
	1256	1	0	0	0	0	1	1.1108298	-1.193924	110	3	1.12	0.95;
	1257	1	0	0	0	0	1	1.1078531	-1.3690374	110	3	1.12	0.95;
	1258	1	10.79	2.54	0	0	1	1.0468125	-13.063136	110	3	1.12	0.95;
	1259	1	1.3	0.7	0	0	1	1.0894628	-7.9057406	110	3	1.12	0.95;
	1260	1	22.38	5.26	0	0	1	1.0808081	-8.0036506	110	3	1.12	0.95;
	1261	1	0	0	0	0	1	1.0808202	-8.0007399	110	3	1.12	0.95;
	1262	1	15.79	2.1	0	0	1	1.0949781	-6.0951647	110	3	1.12	0.95;
	1263	1	14.59	4.12	0	0	1	1.0448001	-12.689892	110	3	1.12	0.95;
	1264	1	0	0	0	0	1	1.066522	-11.929199	110	3	1.12	0.95;
	1265	1	0	0	0	0	1	1.0665154	-11.929091	110	3	1.12	0.95;
	1266	1	20.09	7.1	0	0	1	1.0964893	-3.4201919	110	3	1.12	0.95;
	1267	1	9.19	2.89	0	0	1	1.0737644	-10.312474	110	3	1.12	0.95;
	1268	2	4.1	0.7	0	0	1	1.0609632	-9.3267266	110	3	1.12	0.95;
	1269	1	13.19	3.24	0	0	1	1.0895253	-4.3432096	110	3	1.12	0.95;
	1270	1	4.1	1.93	0	0	1	1.096859	-3.3143831	110	3	1.12	0.95;
	1271	1	0	0	0	0	1	1.0969189	-3.3119208	110	3	1.12	0.95;
	1272	1	3.3	0.79	0	0	1	1.1022208	-4.3102071	110	3	1.12	0.95;
	1273	1	3.4	1.23	0	0	1	1.1002202	-4.6954949	110	3	1.12	0.95;
	1274	1	0	0	0	0	1	1.1022268	-4.3089154	110	3	1.12	0.95;
	1275	1	0	0	0	0	1	1.1002295	-4.6941591	110	3	1.12	0.95;
	1276	1	25.28	9.38	0	0	1	1.1064487	-1.7295113	110	3	1.12	0.95;
	1277	1	15.99	3.95	0	0	1	1.0775736	-10.514827	110	3	1.12	0.95;
	1278	1	17.09	7.54	0	0	1	1.0885343	-5.4227461	110	3	1.12	0.95;
	1279	1	0	0	0	0	1	1.1077725	-1.7099386	110	3	1.12	0.95;
	1280	1	3.7	1.4	0	0	1	1.0984325	-7.0814256	110	3	1.12	0.95;
	1281	1	0	0	0	0	1	1.0989052	-7.0475112	110	3	1.12	0.95;
	1282	1	13.49	1.84	0	0	1	1.1021545	-2.0643645	110	3	1.12	0.95;
	1283	1	7.69	0.26	0	0	1	1.0793481	-8.6001921	110	3	1.12	0.95;
	1284	1	7.39	2.45	0	0	1	1.1070659	-2.638417	110	3	1.12	0.95;
	1285	1	4.4	1.84	0	0	1	1.0880746	-4.4667365	110	3	1.12	0.95;
	1286	1	11.09	3.68	0	0	1	1.1117333	-1.0473729	110	3	1.12	0.95;
	1287	1	6.7	1.23	0	0	1	1.1115364	-2.9369663	110	3	1.12	0.95;
	1288	1	0	0	0	0	1	1.1117608	-1.0431059	110	3	1.12	0.95;
	1289	1	15.29	2.02	0	0	1	1.0672784	-10.190694	110	3	1.12	0.95;
	1290	1	17.89	5.44	0	0	1	1.0972797	-3.2956506	110	3	1.12	0.95;
	1291	1	23.28	8.07	0	0	1	1.0891129	-3.2745294	110	3	1.12	0.95;
	1292	1	2.5	0.7	0	0	1	1.0700553	-10.659265	110	3	1.12	0.95;
	1293	1	13.09	3.24	0	0	1	1.1002666	-6.7625029	110	3	1.12	0.95;
	1294	1	8.89	0.7	0	0	1	1.1056507	-6.4953082	110	3	1.12	0.95;
	1295	1	8.99	0.61	0	0	1	1.0961584	-2.7172737	110	3	1.12	0.95;
	1296	1	7.49	2.45	0	0	1	1.1060633	-2.6731807	110	3	1.12	0.95;
	1297	1	7.79	1.84	0	0	1	1.0894553	-4.3704082	110	3	1.12	0.95;
	1298	1	0	0	0	0	1	1.0899631	-4.3242014	110	3	1.12	0.95;
	1299	1	0	0	0	0	1	1.109112	-1.4586773	110	3	1.12	0.95;
	1300	1	0	0	0	0	1	1.1091143	-1.4580648	110	3	1.12	0.95;
	1301	1	8.29	0.79	0	0	1	1.1005191	-8.2222942	110	3	1.12	0.95;
	1302	1	3	0.79	0	0	1	1.1119623	-2.8967459	110	3	1.12	0.95;
	1303	1	1.8	0.61	0	0	1	1.1068966	-1.4627198	110	3	1.12	0.95;
	1304	1	17.09	0	0	0	1	1.1053046	-1.9646505	110	3	1.12	0.95;
	1305	1	0	0	0	0	1	1.1102317	-1.2131717	110	3	1.12	0.95;
	1306	1	0	0	0	0	1	1.1053046	-1.9579981	110	3	1.12	0.95;
	1307	1	0	0	0	0	1	1.1102317	-1.2131717	110	3	1.12	0.95;
	1308	1	15.59	2.63	0	0	1	1.1041574	-6.5271704	110	3	1.12	0.95;
	1309	1	8.99	0.79	0	0	1	1.0554267	-11.327063	110	3	1.12	0.95;
	1310	1	7.09	2.28	0	0	1	1.096819	-3.313193	110	3	1.12	0.95;
	1311	1	3	1.23	0	0	1	1.0948337	-3.1244075	110	3	1.12	0.95;
	1312	1	12.89	5.79	0	0	1	1.0918483	-7.4407579	110	3	1.12	0.95;
	1313	1	6.5	1.75	0	0	1	1.0546746	-12.662059	110	3	1.12	0.95;
	1314	1	2.9	0.26	0	0	1	1.0951928	-3.4801219	110	3	1.12	0.95;
	1315	1	0	0	0	0	1	1.0952666	-3.4746543	110	3	1.12	0.95;
	1316	2	4.6	0.35	0	0	1	1.1026775	-6.8698128	110	3	1.12	0.95;
	1317	1	3.4	2.02	0	0	1	1.1054478	-6.5465505	110	3	1.12	0.95;
	1318	1	0	0	0	0	1	1.1028021	-6.8604827	110	3	1.12	0.95;
	1319	1	0	0	0	0	1	1.1056536	-6.5404015	110	3	1.12	0.95;
	1320	1	10.49	1.49	0	0	1	1.1059231	-2.0790571	110	3	1.12	0.95;
	1321	1	0	0	0	0	1	1.0862064	-9.5954657	110	3	1.12	0.95;
	1322	1	7.39	2.02	0	0	1	1.0811862	-9.9066301	110	3	1.12	0.95;
	1323	1	0	0	0	0	1	1.0862064	-9.5954657	110	3	1.12	0.95;
	1324	1	29.68	9.82	0	0	1	1.0434421	-12.663431	110	3	1.12	0.95;
	1325	2	15.79	3.42	0	0	1	1.1078424	-2.4566275	110	3	1.12	0.95;
	1326	1	20.88	7.8	0	0	1	1.0971838	-2.895041	110	3	1.12	0.95;
	1327	1	2.2	0.88	0	0	1	1.0957105	-2.6764467	110	3	1.12	0.95;
	1328	1	7.69	4.12	0	0	1	1.0974869	-2.5754615	110	3	1.12	0.95;
	1329	1	29.78	4.91	0	0	1	1.1009466	-2.6880892	110	3	1.12	0.95;
	1330	1	16.79	0	0	0	1	1.1015606	-2.7384239	110	3	1.12	0.95;
	1331	1	1.8	0.7	0	0	1	1.0944266	-3.6111702	110	3	1.12	0.95;
	1332	1	9.79	2.89	0	0	1	1.0937298	-5.4530227	110	3	1.12	0.95;
	1333	1	14.19	4.3	0	0	1	1.0935299	-6.032046	110	3	1.12	0.95;
	1334	1	0	0	0	0	1	1.0941239	-5.425419	110	3	1.12	0.95;
	1335	1	0	0	0	0	1	1.0941416	-5.9865433	110	3	1.12	0.95;
	1336	1	8.29	1.05	0	0	1	1.0903806	-7.8441859	110	3	1.12	0.95;
	1337	1	4.4	0.79	0	0	1	1.1072698	-4.6846925	110	3	1.12	0.95;
	1338	1	6.89	1.93	0	0	1	1.1101857	-2.4143915	110	3	1.12	0.95;
	1339	1	2.3	0.7	0	0	1	1.0794987	-10.539714	110	3	1.12	0.95;
	1340	1	20.48	6.14	0	0	1	1.0795224	-8.0797964	110	3	1.12	0.95;
	1341	1	0	0	0	0	1	1.0857356	-10.334801	110	3	1.12	0.95;
	1342	1	10.19	2.02	0	0	1	1.0919217	-8.0689952	110	3	1.12	0.95;
	1343	1	0	0	0	0	1	1.1020545	-2.7301328	110	3	1.12	0.95;
	1344	1	0	0	0	0	1	1.1020431	-2.7287212	110	3	1.12	0.95;
	1345	1	10.79	3.24	0	0	1	1.106867	-2.5167868	110	3	1.12	0.95;
	1346	1	13.39	3.24	0	0	1	1.1098984	-2.2014795	110	3	1.12	0.95;
	1347	1	6.4	0.61	0	0	1	1.0894218	-7.9063584	110	3	1.12	0.95;
	1348	1	14.39	3.42	0	0	1	1.0945366	-5.3879268	110	3	1.12	0.95;
	1349	2	17.09	2.63	0	0	1	1.0492013	-11.719368	110	3	1.12	0.95;
	1350	1	0	0	0	0	1	1.0657804	-10.836355	110	3	1.12	0.95;
	1351	1	5.1	1.23	0	0	1	1.0930562	-9.6201336	110	3	1.12	0.95;
	1352	1	3	0.7	0	0	1	1.1011597	-4.4407276	110	3	1.12	0.95;
	1353	1	0	0	0	0	1	1.1012763	-4.4297853	110	3	1.12	0.95;
	1354	1	3.1	0.7	0	0	1	1.0778786	-10.125795	110	3	1.12	0.95;
	1355	1	16.69	4.91	0	0	1	1.103196	-2.0049516	110	3	1.12	0.95;
	1356	2	20.19	7.28	0	0	1	1.0977196	-2.739938	110	3	1.12	0.95;
	1357	1	16.89	2.1	0	0	1	1.108406	-1.6869348	110	3	1.12	0.95;
	1358	1	17.89	5.26	0	0	1	1.091835	-4.6631948	110	3	1.12	0.95;
	1359	2	3.3	1.4	0	0	1	1.0527428	-12.454194	110	3	1.12	0.95;
	1360	1	11.99	2.54	0	0	1	1.085736	-9.6209117	110	3	1.12	0.95;
	1361	1	2.3	0.7	0	0	1	1.0917126	-5.0362084	110	3	1.12	0.95;
	1362	1	0	0	0	0	1	1.0917728	-5.0321766	110	3	1.12	0.95;
	1363	1	24.18	0	0	0	1	1.0879758	-8.013733	110	3	1.12	0.95;
	1364	1	14.49	4.91	0	0	1	1.0982873	-8.7632319	110	3	1.12	0.95;
	1365	1	0	0	0	0	1	1.0983244	-8.7575194	110	3	1.12	0.95;
	1366	1	17.69	4.73	0	0	1	1.0802352	-10.532401	110	3	1.12	0.95;
	1367	1	17.89	1.05	0	0	1	1.0697108	-7.7064023	110	3	1.12	0.95;
	1368	1	16.39	4.12	0	0	1	1.1053634	-2.091017	110	3	1.12	0.95;
	1369	1	4.2	1.05	0	0	1	1.0918018	-3.4822468	110	3	1.12	0.95;
	1370	1	0	0	0	0	1	1.1054505	-8.7010297	110	3	1.12	0.95;
	1371	1	0	0	0	0	1	1.1054505	-8.7010297	110	3	1.12	0.95;
	1372	1	10.29	3.42	0	0	1	1.0910954	-5.1772974	110	3	1.12	0.95;
	1373	1	0.3	0	0	0	1	1.1111754	-2.3712249	110	3	1.12	0.95;
	1374	1	5.7	0.79	0	0	1	1.0943311	-6.0918461	110	3	1.12	0.95;
	1375	1	9.59	3.24	0	0	1	1.1043577	-1.9215014	110	3	1.12	0.95;
	1376	1	0	0	0	0	1	1.104364	-1.9193818	110	3	1.12	0.95;
	1377	1	1.5	0	0	0	1	1.1056974	-4.0988479	110	3	1.12	0.95;
	1378	1	0	0	0	0	1	1.1057269	-4.0946868	110	3	1.12	0.95;
	1379	1	7.69	1.49	0	0	1	1.1051173	-8.6925494	110	3	1.12	0.95;
	1380	1	20.48	5.96	0	0	1	1.1004041	-4.1977143	110	3	1.12	0.95;
	1381	1	16.69	3.59	0	0	1	1.0890645	-10.003798	110	3	1.12	0.95;
	1382	1	0	0	0	0	1	1.0884565	-7.3626679	110	3	1.12	0.95;
	1383	1	0	0	0	0	1	1.0884483	-7.3619424	110	3	1.12	0.95;
	1384	1	0	0	0	0	1	1.0921634	-9.4192004	110	3	1.12	0.95;
	1385	1	10.29	2.02	0	0	1	1.0967255	-5.1978626	110	3	1.12	0.95;
	1386	1	16.79	1.93	0	0	1	1.1172875	-0.52113928	110	3	1.12	0.95;
	1387	1	15.79	1.84	0	0	1	1.1070395	-2.738402	110	3	1.12	0.95;
	1388	1	10.29	3.24	0	0	1	1.1049121	-8.7200951	110	3	1.12	0.95;
	1389	1	13.19	5.08	0	0	1	1.106823	-8.186082	110	3	1.12	0.95;
	1390	1	9.29	2.02	0	0	1	1.0997044	-2.5265011	110	3	1.12	0.95;
	1391	1	8.89	0.7	0	0	1	1.1043702	-1.9195958	110	3	1.12	0.95;
	1392	1	0	0	0	0	1	1.1045232	-1.9062958	110	3	1.12	0.95;
	1393	2	8.09	3.33	0	0	1	1.0620959	-11.639839	110	3	1.12	0.95;
	1394	1	0	0	0	0	1	1.0621068	-11.638856	110	3	1.12	0.95;
	1395	1	0.5	0	0	0	1	1.1119997	-2.924398	110	3	1.12	0.95;
	1396	1	0	0	0	0	1	1.12	-0.33679254	110	3	1.12	0.95;
	1397	1	0	0	0	0	1	1.1120032	-2.9240105	110	3	1.12	0.95;
	1398	1	6.3	2.63	0	0	1	1.1181601	1.5611914	110	3	1.12	0.95;
	1399	1	12.29	4.65	0	0	1	1.0947823	-2.5480912	110	3	1.12	0.95;
	1400	1	0	0	0	0	1	1.1127317	-1.0192004	110	3	1.12	0.95;
	1401	1	0	0	0	0	1	1.1127289	-1.0191471	110	3	1.12	0.95;
	1402	1	5.2	1.58	0	0	1	1.0664627	-11.006356	110	3	1.12	0.95;
	1403	2	9.69	3.95	0	0	1	1.0969355	-3.3338766	110	3	1.12	0.95;
	1404	1	11.79	3.16	0	0	1	1.1010977	-4.4487798	110	3	1.12	0.95;
	1405	1	3.3	1.05	0	0	1	1.1036236	-4.293794	110	3	1.12	0.95;
	1406	1	4.1	1.58	0	0	1	1.0783036	-9.2419143	110	3	1.12	0.95;
	1407	1	0	0	0	0	1	1.0784142	-9.2364952	110	3	1.12	0.95;
	1408	1	16.69	6.14	0	0	1	1.0877294	-4.4968265	110	3	1.12	0.95;
	1409	1	3.7	1.05	0	0	1	1.0761051	-10.152775	110	3	1.12	0.95;
	1410	1	8.09	2.02	0	0	1	1.1017992	-2.7151224	110	3	1.12	0.95;
	1411	1	10.29	3.68	0	0	1	1.0880814	-4.4992308	110	3	1.12	0.95;
	1412	1	0	0	0	0	1	1.091221	-4.5334802	110	3	1.12	0.95;
	1413	1	0	0	0	0	1	1.0912175	-4.5334184	110	3	1.12	0.95;
	1414	1	1.5	0.61	0	0	1	1.088843	-10.19536	110	3	1.12	0.95;
	1415	1	16.69	5.26	0	0	1	1.1028182	-8.6238594	110	3	1.12	0.95;
	1416	2	20.98	26.13	0	0	1	1.12	1.7896911	110	3	1.12	0.95;
	1417	2	10.79	16.57	0	0	1	1.12	-1.4249402	110	3	1.12	0.95;
	1418	2	13.69	15.43	0	0	1	1.0955824	-3.8366197	110	3	1.12	0.95;
	1419	1	11.89	0	0	0	1	1.105068	-8.6584777	110	3	1.12	0.95;
	1420	1	5.2	0.35	0	0	1	1.1146086	-5.1586232	110	3	1.12	0.95;
	1421	1	5.2	1.84	0	0	1	1.0979497	-6.8741468	110	3	1.12	0.95;
	1422	1	2.3	0.79	0	0	1	1.0979518	-6.8746639	110	3	1.12	0.95;
	1423	1	0	0	0	0	1	1.0995372	-6.5798848	110	3	1.12	0.95;
	1424	1	5.2	2.02	0	0	1	1.1064054	-1.6329466	110	3	1.12	0.95;
	1425	1	1.4	0	0	0	1	1.0961285	-2.6226203	110	3	1.12	0.95;
	1426	2	15.39	10.61	0	0	1	1.12	-0.28439471	110	3	1.12	0.95;
	1427	1	2.2	0.7	0	0	1	1.0900224	-5.5274067	110	3	1.12	0.95;
	1428	1	3.8	1.05	0	0	1	1.0626887	-8.1779496	110	3	1.12	0.95;
	1429	2	8.09	2.45	0	0	1	1.0612136	-8.2136687	110	3	1.12	0.95;
	1430	1	5.2	0.44	0	0	1	1.0897131	-10.047896	110	3	1.12	0.95;
	1431	1	0	0	0	0	1	1.0894234	-5.5069031	110	3	1.12	0.95;
	1432	1	0	0	0	0	1	1.0894296	-5.5077892	110	3	1.12	0.95;
	1433	1	11.39	3.24	0	0	1	1.0780228	-8.470483	110	3	1.12	0.95;
	1434	1	10.99	3.16	0	0	1	1.0964339	-7.2006687	110	3	1.12	0.95;
	1435	1	23.08	7.98	0	0	1	1.0896867	-3.2442227	110	3	1.12	0.95;
	1436	1	5.2	2.02	0	0	1	1.0992909	-2.6662462	110	3	1.12	0.95;
	1437	1	1.8	1.05	0	0	1	1.1010922	-2.20451	110	3	1.12	0.95;
	1438	1	5.4	2.02	0	0	1	1.1081743	-0.02825715	110	3	1.12	0.95;
	1439	1	0	0	0	0	1	1.1014186	-2.1962375	110	3	1.12	0.95;
	1440	1	0	0	0	0	1	1.1090783	-2.938e-05	110	3	1.12	0.95;
	1441	1	6.5	1.49	0	0	1	1.1065436	-3.9263423	110	3	1.12	0.95;
	1442	1	3.7	0.35	0	0	1	1.1014704	-4.4236413	110	3	1.12	0.95;
	1443	1	0	0	0	0	1	1.1067865	-3.9053948	110	3	1.12	0.95;
	1444	1	19.89	3.95	0	0	1	1.0971793	-3.8070767	110	3	1.12	0.95;
	1445	1	3.4	1.58	0	0	1	1.1054274	-1.7682669	110	3	1.12	0.95;
	1446	1	5.6	0.61	0	0	1	1.0958975	-6.9846491	110	3	1.12	0.95;
	1447	1	6.7	1.58	0	0	1	1.0956452	-6.9902807	110	3	1.12	0.95;
	1448	1	0	0	0	0	1	1.0961928	-6.9639	110	3	1.12	0.95;
	1449	1	0	0	0	0	1	1.0960637	-6.9674877	110	3	1.12	0.95;
	1450	1	12.89	5.08	0	0	1	1.0976481	-3.0428079	110	3	1.12	0.95;
	1451	1	2.3	0.26	0	0	1	1.0971831	-3.0213195	110	3	1.12	0.95;
	1452	1	13.19	1.58	0	0	1	1.0911998	-9.800488	110	3	1.12	0.95;
	1453	1	10.99	1.58	0	0	1	1.0972138	-9.2486209	110	3	1.12	0.95;
	1454	1	3.4	0.79	0	0	1	1.0823853	-8.4267733	110	3	1.12	0.95;
	1455	1	0	0	0	0	1	1.091013	-4.876494	110	3	1.12	0.95;
	1456	1	0	0	0	0	1	1.091013	-4.876494	110	3	1.12	0.95;
	1457	1	5.5	2.02	0	0	1	1.0936014	-3.6245752	110	3	1.12	0.95;
	1458	1	6.3	2.19	0	0	1	1.0949748	-3.5264996	110	3	1.12	0.95;
	1459	1	0	0	0	0	1	1.0936167	-3.6223882	110	3	1.12	0.95;
	1460	1	0	0	0	0	1	1.0951839	-3.5107728	110	3	1.12	0.95;
	1461	1	17.59	4.73	0	0	1	1.0885486	-3.661762	110	3	1.12	0.95;
	1462	1	13.39	4.91	0	0	1	1.096705	-3.3213807	110	3	1.12	0.95;
	1463	1	1.2	0	0	0	1	1.1004397	-6.4187319	110	3	1.12	0.95;
	1464	1	1.8	0.88	0	0	1	1.0930088	-3.6865136	110	3	1.12	0.95;
	1465	1	0	0	0	0	1	1.0948125	-2.5485814	110	3	1.12	0.95;
	1466	1	0	0	0	0	1	1.0857568	-7.9201801	110	3	1.12	0.95;
	1467	1	19.69	9.56	0	0	1	1.1012598	-6.8492584	110	3	1.12	0.95;
	1468	1	0	0	0	0	1	1.0857232	-10.334561	110	3	1.12	0.95;
	1469	2	18.49	3.95	0	0	1	1.0605666	-12.900502	110	3	1.12	0.95;
	1470	1	0	0	0	0	1	1.06056	-12.899563	110	3	1.12	0.95;
	1471	1	5.6	0.61	0	0	1	1.1032872	-8.7800375	110	3	1.12	0.95;
	1472	1	16.09	6.05	0	0	1	1.1020913	-8.820125	110	3	1.12	0.95;
	1473	1	11.09	5.17	0	0	1	1.0480379	-13.15115	110	3	1.12	0.95;
	1474	1	6.7	2.02	0	0	1	1.0483843	-13.139915	110	3	1.12	0.95;
	1475	2	11.79	5.08	0	0	1	1.0935556	-3.0016282	110	3	1.12	0.95;
	1476	1	20.68	4.73	0	0	1	1.0825197	-9.8162913	110	3	1.12	0.95;
	1477	1	12.89	1.75	0	0	1	1.071346	-6.3505484	110	3	1.12	0.95;
	1478	1	14.69	1.14	0	0	1	1.1134508	-4.8813704	110	3	1.12	0.95;
	1479	1	8.09	4.91	0	0	1	1.1048727	-1.7725874	110	3	1.12	0.95;
	1480	1	3.7	0.7	0	0	1	1.1106314	-5.7802205	110	3	1.12	0.95;
	1481	1	16.09	0.79	0	0	1	1.1103481	-5.822944	110	3	1.12	0.95;
	1482	1	18.89	0	0	0	1	1.0857461	-7.9200026	110	3	1.12	0.95;
	1483	1	11.79	3.59	0	0	1	1.0795576	-10.36261	110	3	1.12	0.95;
	1484	1	0	0	0	0	1	1.0784183	-10.411231	110	3	1.12	0.95;
	1485	1	5.4	0.09	0	0	1	1.0881003	-5.0006631	110	3	1.12	0.95;
	1486	1	2.3	1.05	0	0	1	1.0951534	-3.6824799	110	3	1.12	0.95;
	1487	1	12.29	2.02	0	0	1	1.0972532	-3.3069512	110	3	1.12	0.95;
	1488	1	16.59	1.58	0	0	1	1.0964141	-3.3924104	110	3	1.12	0.95;
	1489	1	21.98	2.45	0	0	1	1.0688916	-7.8553908	110	3	1.12	0.95;
	1490	1	52.45	19.2	0	0	1	1.0953538	-5.3031083	110	3	1.12	0.95;
	1491	1	0	0	0	0	1	1.0953714	-5.3020628	110	3	1.12	0.95;
	1492	1	6.99	1.58	0	0	1	1.0966901	-3.3678411	110	3	1.12	0.95;
	1493	1	8.09	1.23	0	0	1	1.1092682	-8.0361916	110	3	1.12	0.95;
	1494	1	0	0	0	0	1	1.1094511	-8.0153039	110	3	1.12	0.95;
	1495	1	7.99	2.19	0	0	1	1.096667	-3.3601058	110	3	1.12	0.95;
	1496	1	14.79	2.02	0	0	1	1.0857865	-8.0287984	110	3	1.12	0.95;
	1497	1	8.79	1.05	0	0	1	1.0875504	-8.0869947	110	3	1.12	0.95;
	1498	1	0	0	0	0	1	1.0864547	-7.991167	110	3	1.12	0.95;
	1499	1	0	0	0	0	1	1.087938	-8.0643664	110	3	1.12	0.95;
	1500	1	3.2	0.88	0	0	1	1.0766362	-10.417299	110	3	1.12	0.95;
	1501	1	3.4	2.1	0	0	1	1.1096242	-6.040293	110	3	1.12	0.95;
	1502	1	0	0	0	0	1	1.0831867	-10.562637	110	3	1.12	0.95;
	1503	1	0	0	0	0	1	1.0831188	-10.56292	110	3	1.12	0.95;
	1504	2	64.73	20.95	0	0	1	1.0909989	-4.8763703	110	3	1.12	0.95;
	1505	2	60.04	5.44	0	0	1	1.1055242	-6.6330498	110	3	1.12	0.95;
	1506	1	13.19	3.95	0	0	1	1.1004205	-2.074938	110	3	1.12	0.95;
	1507	1	13.39	4.03	0	0	1	1.102935	-1.8329385	110	3	1.12	0.95;
	1508	1	28.08	8.07	0	0	1	1.1017662	-1.9259915	110	3	1.12	0.95;
	1509	1	7.69	2.19	0	0	1	1.0947486	-4.968029	110	3	1.12	0.95;
	1510	1	8.19	2.28	0	0	1	1.0963611	-3.4002931	110	3	1.12	0.95;
	1511	1	0	0	0	0	1	1.0948398	-4.9628279	110	3	1.12	0.95;
	1512	1	21.88	6.75	0	0	1	1.0876729	-10.125077	110	3	1.12	0.95;
	1513	1	9.29	2.02	0	0	1	1.1087725	-0.53495672	110	3	1.12	0.95;
	1514	2	10.29	2.98	0	0	1	1.1138939	0.89658884	110	3	1.12	0.95;
	1515	1	6.99	0.09	0	0	1	1.0772894	-11.22064	110	3	1.12	0.95;
	1516	1	8.59	1.14	0	0	1	1.0871048	-7.8951886	110	3	1.12	0.95;
	1517	1	16.09	4.73	0	0	1	1.1000132	-2.1306102	110	3	1.12	0.95;
	1518	1	14.79	4.73	0	0	1	1.0874044	-3.5003308	110	3	1.12	0.95;
	1519	1	11.29	0	0	0	1	1.0950304	-3.3607234	110	3	1.12	0.95;
	1520	1	0	0	0	0	1	1.095705	-3.3158881	110	3	1.12	0.95;
	1521	1	0.3	0.79	0	0	1	1.0888546	-9.9043243	110	3	1.12	0.95;
	1522	1	0	0	0	0	1	1.0888606	-9.904204	110	3	1.12	0.95;
	1523	1	0	0	0	0	1	1.109572	-2.8035504	110	3	1.12	0.95;
	1524	1	0	0	0	0	1	1.1088221	-2.604621	110	3	1.12	0.95;
	1525	1	14.79	3.42	0	0	1	1.1048681	-2.3888668	110	3	1.12	0.95;
	1526	1	7.29	2.02	0	0	1	1.089523	-7.7150285	110	3	1.12	0.95;
	1527	1	13.29	4.03	0	0	1	1.1104126	-2.2921605	110	3	1.12	0.95;
	1528	1	12.89	3.16	0	0	1	1.0889216	-7.1841852	110	3	1.12	0.95;
	1529	1	6.6	1.93	0	0	1	1.0961842	-4.8869744	110	3	1.12	0.95;
	1530	1	6.8	1.93	0	0	1	1.0937102	-5.0697743	110	3	1.12	0.95;
	1531	1	0	0	0	0	1	1.0962559	-4.883832	110	3	1.12	0.95;
	1532	1	0	0	0	0	1	1.0938052	-5.0624589	110	3	1.12	0.95;
	1533	1	11.39	2.98	0	0	1	1.0888614	-3.7070959	110	3	1.12	0.95;
	1534	2	12.19	4.73	0	0	1	1.0920172	-4.3188185	110	3	1.12	0.95;
	1535	1	3.5	2.1	0	0	1	1.0870749	-10.058999	110	3	1.12	0.95;
	1536	2	16.99	21.22	0	0	1	1.1094014	-1.5197797	110	3	1.12	0.95;
	1537	2	16.69	26.56	0	0	1	1.12	-7.0252269	110	3	1.12	0.95;
	1538	2	17.79	21.13	0	0	1	1.1122931	-0.99396049	110	3	1.12	0.95;
	1539	1	0	0	0	0	1	1.1015739	-4.4109917	110	3	1.12	0.95;
	1540	1	8.69	2.63	0	0	1	1.1037654	-4.2834159	110	3	1.12	0.95;
	1541	1	8.69	1.93	0	0	1	1.0855734	-3.684325	110	3	1.12	0.95;
	1542	2	10.19	3.33	0	0	1	1.1054495	-6.6397046	110	3	1.12	0.95;
	1543	2	28.08	5.79	0	0	1	1.0951516	-3.3823228	110	3	1.12	0.95;
	1544	1	15.89	5.44	0	0	1	1.1156602	1.206715	110	3	1.12	0.95;
	1545	1	3.4	0.61	0	0	1	1.0996314	-4.7766995	110	3	1.12	0.95;
	1546	1	23.08	4.3	0	0	1	1.0973876	-2.853262	110	3	1.12	0.95;
	1547	1	9.19	2.89	0	0	1	1.1136979	-1.9275158	110	3	1.12	0.95;
	1548	1	0	0	0	0	1	1.1138518	-1.914567	110	3	1.12	0.95;
	1549	1	25.88	4.12	0	0	1	1.0952123	-3.6604786	110	3	1.12	0.95;
	1550	2	15.49	6.05	0	0	1	1.0944657	-3.9133791	110	3	1.12	0.95;
	1551	1	5.6	2.02	0	0	1	1.1195662	1.759492	110	3	1.12	0.95;
	1552	1	15.99	-26.65	0	0	1	1.1075338	-8.5914165	110	3	1.12	0.95;
	1553	1	4.6	0.09	0	0	1	1.0925098	-7.7151076	110	3	1.12	0.95;
	1554	1	3.1	0.35	0	0	1	1.0603186	-12.917718	110	3	1.12	0.95;
	1555	1	1.9	0.7	0	0	1	1.0603579	-12.908372	110	3	1.12	0.95;
	1556	1	13.09	2.63	0	0	1	1.0832292	-5.9697866	110	3	1.12	0.95;
	1557	1	0.4	0.09	0	0	1	1.1020808	-6.8448212	110	3	1.12	0.95;
	1558	1	0.3	0.09	0	0	1	1.1052702	-1.8698682	110	3	1.12	0.95;
	1559	1	0.3	0.09	0	0	1	1.1052439	-1.8700334	110	3	1.12	0.95;
	1560	1	0	0	0	0	1	1.0983433	-2.3470623	110	3	1.12	0.95;
	1561	1	0	0	0	0	1	1.0998025	-2.3641374	110	3	1.12	0.95;
	1562	1	0	0	0	0	1	1.0589257	-10.940692	110	3	1.12	0.95;
	1563	1	0	0	0	0	1	1.0876216	-7.9712655	110	3	1.12	0.95;
	1564	1	0	0	0	0	1	1.0873497	-7.9876325	110	3	1.12	0.95;
	1565	1	58.04	24.64	0	0	1	1.085444	-10.025114	110	3	1.12	0.95;
	1566	2	5.9	7.01	0	0	1	1.098642	-5.6422872	110	3	1.12	0.95;
	1567	1	9.99	2.54	0	0	1	1.0904972	-5.2638943	110	3	1.12	0.95;
	1568	1	3.3	0.7	0	0	1	1.091499	-5.128723	110	3	1.12	0.95;
	1569	1	0	0	0	0	1	1.0905165	-5.2598994	110	3	1.12	0.95;
	1570	1	0	0	0	0	1	1.0915043	-5.1274057	110	3	1.12	0.95;
	1571	1	8.69	0.61	0	0	1	1.1050761	-8.2039214	110	3	1.12	0.95;
	1572	1	26.78	2.1	0	0	1	1.1167563	-5.1323296	110	3	1.12	0.95;
	1573	1	21.88	8.59	0	0	1	1.0860373	-10.117609	110	3	1.12	0.95;
	1574	1	14.39	1.4	0	0	1	1.0877417	-5.235049	110	3	1.12	0.95;
	1575	1	10.79	1.05	0	0	1	1.0940321	-4.0750325	110	3	1.12	0.95;
	1576	1	7.89	0.79	0	0	1	1.078296	-8.4545183	110	3	1.12	0.95;
	1577	1	0	0	0	0	1	1.0966118	-7.1845747	110	3	1.12	0.95;
	1578	1	12.89	9.12	0	0	1	1.1015015	-1.9507864	110	3	1.12	0.95;
	1579	1	13.29	3.51	0	0	1	1.1100128	-2.2071547	110	3	1.12	0.95;
	1580	1	7.69	2.28	0	0	1	1.1029853	-7.0981798	110	3	1.12	0.95;
	1581	1	0	0	0	0	1	1.1029813	-7.0983335	110	3	1.12	0.95;
	1582	1	8.69	0	0	0	1	1.0987006	-7.0656829	110	3	1.12	0.95;
	1583	1	0	0	0	0	1	1.1008984	-4.5818806	110	3	1.12	0.95;
	1584	1	11.79	2.1	0	0	1	1.0967314	-2.4095878	110	3	1.12	0.95;
	1585	1	13.39	2.02	0	0	1	1.0921564	-3.3472712	110	3	1.12	0.95;
	1586	1	2.3	0	0	0	1	1.0984622	-7.0754086	110	3	1.12	0.95;
	1587	2	34.87	12.36	0	0	1	1.1021522	-2.7013721	110	3	1.12	0.95;
	1588	1	5.4	2.98	0	0	1	1.0953304	-2.6140924	110	3	1.12	0.95;
	1589	1	0	0	0	0	1	1.0957585	-2.5931399	110	3	1.12	0.95;
	1590	1	9.59	1.75	0	0	1	1.0977587	-2.4169087	110	3	1.12	0.95;
	1591	1	0	0	0	0	1	1.1115347	-1.1322217	110	3	1.12	0.95;
	1592	1	0	0	0	0	1	1.0983316	-2.3561226	110	3	1.12	0.95;
	1593	1	11.09	2.02	0	0	1	1.0989046	-7.0336895	110	3	1.12	0.95;
	1594	1	14.69	5.44	0	0	1	1.0982488	-7.0847181	110	3	1.12	0.95;
	1595	1	2.1	0.26	0	0	1	1.091245	-9.4044943	110	3	1.12	0.95;
	1596	1	12.89	2.1	0	0	1	1.1057748	-8.5720537	110	3	1.12	0.95;
	1597	1	6	0.7	0	0	1	1.1061903	-8.5502852	110	3	1.12	0.95;
	1598	1	15.59	4.65	0	0	1	1.1096759	-1.2096466	110	3	1.12	0.95;
	1599	1	3.7	0.35	0	0	1	1.0916562	-7.5017571	110	3	1.12	0.95;
	1600	2	41.46	8.94	0	0	1	1.0905728	-3.5417833	110	3	1.12	0.95;
	1601	1	0	0	0	0	1	1.0984356	-2.9064394	110	3	1.12	0.95;
	1602	2	8.46	6.1	0	0	1	1.12	-14.503506	110	4	1.12	0.95;
	1603	2	8.57	5.9	0	0	1	1.12	-15.374426	110	4	1.12	0.95;
	1604	1	5.5	3	0	0	1	1.1156152	-15.529624	110	4	1.12	0.95;
	1605	1	13.19	6	0	0	1	1.11588	-15.521172	110	4	1.12	0.95;
	1606	1	8.57	-1.7	0	0	1	1.0951873	-36.138093	110	4	1.12	0.95;
	1607	1	8.24	2.1	0	0	1	1.0889216	-24.528742	110	4	1.12	0.95;
	1608	1	1.65	0	0	0	1	1.0854175	-39.728419	110	4	1.12	0.95;
	1609	2	12.19	3.2	0	0	1	1.0713897	-39.06494	110	4	1.12	0.95;
	1610	1	3.85	0.6	0	0	1	1.1180709	-29.312375	110	4	1.12	0.95;
	1611	1	9.78	1.4	0	0	1	1.1180696	-29.312823	110	4	1.12	0.95;
	1612	1	7.58	2.1	0	0	1	1.0807037	-39.791227	110	4	1.12	0.95;
	1613	1	21.31	4.3	0	0	1	1.0918821	-42.559103	110	4	1.12	0.95;
	1614	1	6.71	1.3	0	0	1	1.0921209	-36.407418	110	4	1.12	0.95;
	1615	1	2.2	0.5	0	0	1	1.0293148	-40.746269	110	4	1.12	0.95;
	1616	1	10.33	6.4	0	0	1	1.0883112	-40.910059	110	4	1.12	0.95;
	1617	2	18.68	1.5	0	0	1	1.1092741	-26.402772	110	4	1.12	0.95;
	1618	1	0	0	0	0	1	1.1092767	-26.403369	110	4	1.12	0.95;
	1619	1	10.99	0	0	0	1	1.1084477	-26.555075	110	4	1.12	0.95;
	1620	2	19.35	4.5	0	0	1	1.109853	-28.629199	110	4	1.12	0.95;
	1621	1	0	0	0	0	1	1.109853	-28.629199	110	4	1.12	0.95;
	1622	1	22.19	7.2	0	0	1	1.0876183	-36.597275	110	4	1.12	0.95;
	1623	1	7.14	1.1	0	0	1	1.1189708	-29.246774	110	4	1.12	0.95;
	1624	1	5.5	0.4	0	0	1	1.1188015	-29.101323	110	4	1.12	0.95;
	1625	1	8.79	2	0	0	1	1.0664101	-37.176894	110	4	1.12	0.95;
	1626	1	5.94	1.2	0	0	1	1.0869633	-35.704421	110	4	1.12	0.95;
	1627	2	7.14	2.1	0	0	1	1.0485994	-40.112006	110	4	1.12	0.95;
	1628	1	11.87	1.8	0	0	1	1.0909013	-34.603057	110	4	1.12	0.95;
	1629	1	3.08	0.7	0	0	1	1.1070615	-37.914344	110	4	1.12	0.95;
	1630	2	9.34	2	0	0	1	1.1168569	-24.868817	110	4	1.12	0.95;
	1631	1	0	0	0	0	1	1.12	-29.069615	110	4	1.12	0.95;
	1632	1	0	0	0	0	1	1.1192622	-36.825194	110	4	1.12	0.95;
	1633	1	7.36	0.7	0	0	1	1.0795843	-37.448607	110	4	1.12	0.95;
	1634	1	6.27	2	0	0	1	1.0723957	-36.64758	110	4	1.12	0.95;
	1635	2	9.45	1.5	0	0	1	1.0968454	-29.234156	110	4	1.12	0.95;
	1636	1	0	0	0	0	1	1.0968454	-29.234156	110	4	1.12	0.95;
	1637	1	9.89	4.2	0	0	1	1.0815507	-28.2281	110	4	1.12	0.95;
	1638	2	5.5	4	0	0	1	1.0967382	-27.108938	110	4	1.12	0.95;
	1639	1	4.51	1.9	0	0	1	1.0946211	-17.690737	110	4	1.12	0.95;
	1640	1	19.68	4.3	0	0	1	1.0561919	-38.531876	110	4	1.12	0.95;
	1641	1	7.69	2.6	0	0	1	1.0964112	-38.80121	110	4	1.12	0.95;
	1642	1	3.41	0.2	0	0	1	1.1188887	-28.340476	110	4	1.12	0.95;
	1643	1	10.55	3.2	0	0	1	1.0982226	-42.85149	110	4	1.12	0.95;
	1644	1	2.53	0.7	0	0	1	1.0833136	-30.396682	110	4	1.12	0.95;
	1645	1	1.1	1	0	0	1	1.102647	-27.311807	110	4	1.12	0.95;
	1646	1	0.44	0.2	0	0	1	1.1041995	-35.542428	110	4	1.12	0.95;
	1647	1	0	0	0	0	1	1.1195176	-29.05973	110	4	1.12	0.95;
	1648	1	0	0	0	0	1	1.1195176	-29.05973	110	4	1.12	0.95;
	1649	1	0	0	0	0	1	1.12	-28.205326	110	4	1.12	0.95;
	1650	1	0	0	0	0	1	1.0939178	-28.027062	110	4	1.12	0.95;
	1651	1	3.3	0	0	0	1	1.1111095	-26.311189	110	4	1.12	0.95;
	1652	1	7.69	1.7	0	0	1	1.0692907	-43.098711	110	4	1.12	0.95;
	1653	1	21.21	2.7	0	0	1	1.0957566	-36.119335	110	4	1.12	0.95;
	1654	1	3.3	1.1	0	0	1	1.0889359	-38.502283	110	4	1.12	0.95;
	1655	1	6.38	2.9	0	0	1	1.1056429	-34.995758	110	4	1.12	0.95;
	1656	1	3.08	1	0	0	1	1.0931834	-36.301984	110	4	1.12	0.95;
	1657	1	13.63	8.4	0	0	1	1.04923	-39.742517	110	4	1.12	0.95;
	1658	1	20.11	5.1	0	0	1	1.0950937	-41.488939	110	4	1.12	0.95;
	1659	1	4.62	0.1	0	0	1	1.1058025	-38.384399	110	4	1.12	0.95;
	1660	1	7.79	3	0	0	1	1.066145	-21.15792	110	4	1.12	0.95;
	1661	1	6.38	3	0	0	1	1.059022	-42.221008	110	4	1.12	0.95;
	1662	1	9.55	3.8	0	0	1	1.0797417	-39.830742	110	4	1.12	0.95;
	1663	1	6.81	1.1	0	0	1	1.076242	-43.038904	110	4	1.12	0.95;
	1664	2	18.02	6.6	0	0	1	1.1193937	-36.785122	110	4	1.12	0.95;
	1665	1	0	0	0	0	1	1.1193937	-36.785122	110	4	1.12	0.95;
	1666	1	6.92	3.5	0	0	1	1.0655247	-40.94524	110	4	1.12	0.95;
	1667	1	11.31	3.2	0	0	1	1.0609771	-41.155743	110	4	1.12	0.95;
	1668	1	5.72	1	0	0	1	1.0883016	-30.141157	110	4	1.12	0.95;
	1669	2	0.22	0.2	0	0	1	1.1058985	-37.193175	110	4	1.12	0.95;
	1670	1	0	0	0	0	1	1.1058985	-37.193175	110	4	1.12	0.95;
	1671	1	4.4	1	0	0	1	1.1143587	-29.621966	110	4	1.12	0.95;
	1672	1	15.39	2	0	0	1	1.1094977	-28.537752	110	4	1.12	0.95;
	1673	2	12.09	7	0	0	1	1.0974667	-36.199632	110	4	1.12	0.95;
	1674	2	18.68	9	0	0	1	1.1040448	-35.625044	110	4	1.12	0.95;
	1675	1	10.33	2.6	0	0	1	1.0714723	-36.382566	110	4	1.12	0.95;
	1676	1	3.3	1.2	0	0	1	1.0726018	-45.088855	110	4	1.12	0.95;
	1677	1	3.52	0.8	0	0	1	1.0928603	-35.853308	110	4	1.12	0.95;
	1678	1	10	3.3	0	0	1	1.0821499	-36.414714	110	4	1.12	0.95;
	1679	2	15.71	3.8	0	0	1	1.0218166	-48.370875	110	4	1.12	0.95;
	1680	1	3.85	1.4	0	0	1	1.0959337	-42.378631	110	4	1.12	0.95;
	1681	1	0	0	0	0	1	1.095921	-42.38171	110	4	1.12	0.95;
	1682	1	14.95	4.2	0	0	1	1.0680593	-35.224606	110	4	1.12	0.95;
	1683	2	15.94	2.3	0	0	1	1.0654337	-36.097563	110	4	1.12	0.95;
	1684	1	9.12	2	0	0	1	1.0654449	-36.100488	110	4	1.12	0.95;
	1685	2	12.64	1.8	0	0	1	1.0688734	-36.490001	110	4	1.12	0.95;
	1686	2	20.88	9	0	0	1	1.1064659	-39.24687	110	4	1.12	0.95;
	1687	1	11.43	5.2	0	0	1	1.0889342	-39.505776	110	4	1.12	0.95;
	1688	1	18.25	4.3	0	0	1	1.0674118	-43.802046	110	4	1.12	0.95;
	1689	1	12.64	3.8	0	0	1	1.0865639	-39.619889	110	4	1.12	0.95;
	1690	1	8.24	3	0	0	1	0.99116574	-34.819875	110	4	1.12	0.95;
	1691	1	15.39	4.9	0	0	1	1.0691869	-38.777742	110	4	1.12	0.95;
	1692	1	1.43	0	0	0	1	1.118827	-28.368804	110	4	1.12	0.95;
	1693	1	14.18	5.2	0	0	1	1.1123509	-37.880635	110	4	1.12	0.95;
	1694	1	7.69	1.5	0	0	1	1.1082879	-29.608024	110	4	1.12	0.95;
	1695	1	0	0	0	0	1	1.1082879	-29.608024	110	4	1.12	0.95;
	1696	1	16.38	2.7	0	0	1	1.1012318	-39.714724	110	4	1.12	0.95;
	1697	1	9.55	3.6	0	0	1	1.1019485	-39.668703	110	4	1.12	0.95;
	1698	2	21.21	5.1	0	0	1	1.063755	-37.321166	110	4	1.12	0.95;
	1699	1	20.65	3.4	0	0	1	0.97704062	-36.072927	110	4	1.12	0.95;
	1700	2	10.88	3.6	0	0	1	1.0832453	-38.314049	110	4	1.12	0.95;
	1701	1	21.65	7.6	0	0	1	1.0876149	-42.80447	110	4	1.12	0.95;
	1702	1	7.25	3.6	0	0	1	1.0877002	-39.561396	110	4	1.12	0.95;
	1703	1	6.27	2.7	0	0	1	1.0713504	-40.197585	110	4	1.12	0.95;
	1704	1	3.41	0.6	0	0	1	1.1047156	-31.567458	110	4	1.12	0.95;
	1705	1	2.53	0.8	0	0	1	1.0419921	-37.605561	110	4	1.12	0.95;
	1706	2	46.26	8.2	0	0	1	1.0896404	-34.735697	110	4	1.12	0.95;
	1707	1	29.23	16.1	0	0	1	1.0861868	-35.720021	110	4	1.12	0.95;
	1708	1	39.56	13.9	0	0	1	1.0843647	-35.873658	110	4	1.12	0.95;
	1709	1	17.37	5.3	0	0	1	1.0882731	-34.885165	110	4	1.12	0.95;
	1710	2	18.9	6.6	0	0	1	1.0956761	-29.925214	110	4	1.12	0.95;
	1711	1	5.94	0.8	0	0	1	1.0927048	-29.458064	110	4	1.12	0.95;
	1712	2	115.37	52	0	0	1	1.1168221	-19.889429	110	4	1.12	0.95;
	1713	1	0	0	0	0	1	1.1168221	-19.889429	110	4	1.12	0.95;
	1714	1	5.72	1.1	0	0	1	1.1051347	-27.054152	110	4	1.12	0.95;
	1715	1	3.52	0.4	0	0	1	1.1088196	-27.619661	110	4	1.12	0.95;
	1716	1	8.79	2	0	0	1	1.0811497	-36.026614	110	4	1.12	0.95;
	1717	2	18.25	2.5	0	0	1	1.112427	-29.473919	110	4	1.12	0.95;
	1718	1	5.5	1.5	0	0	1	1.1124257	-29.474174	110	4	1.12	0.95;
	1719	2	18.35	5.6	0	0	1	1.0505302	-39.637146	110	4	1.12	0.95;
	1720	1	14.51	4.3	0	0	1	1.1057688	-39.332526	110	4	1.12	0.95;
	1721	1	3.85	0.4	0	0	1	1.0715412	-28.966187	110	4	1.12	0.95;
	1722	1	2.09	0.3	0	0	1	1.089006	-27.567999	110	4	1.12	0.95;
	1723	1	9.89	2	0	0	1	1.1165741	-29.320643	110	4	1.12	0.95;
	1724	1	19.46	3.7	0	0	1	1.0888388	-36.341525	110	4	1.12	0.95;
	1725	1	9.89	2	0	0	1	1.1183968	-19.379514	110	4	1.12	0.95;
	1726	2	21.31	5.2	0	0	1	1.001831	-33.690936	110	4	1.12	0.95;
	1727	1	12.09	4.9	0	0	1	1.0047094	-33.466241	110	4	1.12	0.95;
	1728	2	8.67	0.3	0	0	1	1.0406388	-39.848876	110	4	1.12	0.95;
	1729	1	7.03	3.2	0	0	1	1.112904	-15.081822	110	4	1.12	0.95;
	1730	2	18.58	3.1	0	0	1	1.0962904	-30.103666	110	4	1.12	0.95;
	1731	1	10.99	4	0	0	1	1.1173957	-29.247213	110	4	1.12	0.95;
	1732	1	0	0	0	0	1	1.1192189	-29.097574	110	4	1.12	0.95;
	1733	1	14.62	7.2	0	0	1	1.0703096	-20.277823	110	4	1.12	0.95;
	1734	2	7.47	2	0	0	1	1.1158679	-29.397897	110	4	1.12	0.95;
	1735	2	15.39	5.5	0	0	1	1.0729985	-19.920024	110	4	1.12	0.95;
	1736	1	0	0	0	0	1	1.0228465	-33.055719	110	4	1.12	0.95;
	1737	1	20.34	4.2	0	0	1	1.0667768	-21.106495	110	4	1.12	0.95;
	1738	1	6.6	2	0	0	1	1.11923	-26.599731	110	4	1.12	0.95;
	1739	2	24.17	5.5	0	0	1	1.0764134	-36.372416	110	4	1.12	0.95;
	1740	1	0	0	0	0	1	1.1029117	-28.997188	110	4	1.12	0.95;
	1741	1	10.99	3	0	0	1	1.1160107	-19.497341	110	4	1.12	0.95;
	1742	2	9.23	1.2	0	0	1	1.0933711	-29.804593	110	4	1.12	0.95;
	1743	1	12.64	2.2	0	0	1	1.093365	-29.804971	110	4	1.12	0.95;
	1744	1	14.51	3.3	0	0	1	1.0882073	-36.677465	110	4	1.12	0.95;
	1745	1	25.83	8.9	0	0	1	1.0594505	-9.3356878	110	4	1.12	0.95;
	1746	1	8.24	2.4	0	0	1	1.0516662	-38.561368	110	4	1.12	0.95;
	1747	1	0	0	0	0	1	1.1018345	-27.08612	110	4	1.12	0.95;
	1748	1	0	0	0	0	1	1.1004391	-28.008005	110	4	1.12	0.95;
	1749	2	25.61	4.3	0	0	1	1.0432747	-31.887897	110	4	1.12	0.95;
	1750	1	12.31	6.3	0	0	1	1.0971017	-33.644308	110	4	1.12	0.95;
	1751	1	12.42	7.6	0	0	1	1.0645583	-30.025974	110	4	1.12	0.95;
	1752	1	3.96	1.5	0	0	1	1.1079306	-30.858406	110	4	1.12	0.95;
	1753	1	14.83	2.8	0	0	1	1.0857761	-18.163205	110	4	1.12	0.95;
	1754	1	6.38	2.3	0	0	1	1.0533447	-30.896734	110	4	1.12	0.95;
	1755	1	4.4	1	0	0	1	1.0446444	-31.767809	110	4	1.12	0.95;
	1756	1	7.58	2.1	0	0	1	0.99818559	-33.820492	110	4	1.12	0.95;
	1757	1	9.89	2.1	0	0	1	1.0453133	-46.926755	110	4	1.12	0.95;
	1758	2	17.04	4.6	0	0	1	1.105806	-37.175016	110	4	1.12	0.95;
	1759	1	24.4	7.9	0	0	1	1.0961296	-17.13741	110	4	1.12	0.95;
	1760	2	4.4	3	0	0	1	1.1146402	-19.893897	110	4	1.12	0.95;
	1761	2	15.39	7	0	0	1	1.113448	-26.763582	110	4	1.12	0.95;
	1762	1	0	0	0	0	1	1.1183421	-19.870769	110	4	1.12	0.95;
	1763	2	5.5	3.8	0	0	1	1.0560738	-18.758322	15	4	1.12	0.95;
	1764	2	5.94	3.6	0	0	1	1.0674351	-18.56707	15	4	1.12	0.95;
	1765	1	6.6	3	0	0	1	1.1190015	-26.622785	110	4	1.12	0.95;
	1766	1	3.3	1	0	0	1	0.99719482	-34.021784	110	4	1.12	0.95;
	1767	1	12.09	2.5	0	0	1	1.1157296	-29.351815	110	4	1.12	0.95;
	1768	2	26.71	4.2	0	0	1	1.0995953	-33.535591	110	4	1.12	0.95;
	1769	1	19.56	8.5	0	0	1	1.0994934	-33.523663	110	4	1.12	0.95;
	1770	1	13.41	4.3	0	0	1	1.0538341	-30.874728	110	4	1.12	0.95;
	1771	1	8.35	4.9	0	0	1	1.0535641	-30.902563	110	4	1.12	0.95;
	1772	1	9.34	2.1	0	0	1	1.0869769	-18.032623	110	4	1.12	0.95;
	1773	1	9.89	5	0	0	1	1.0511032	-31.112392	110	4	1.12	0.95;
	1774	1	0	0	0	0	1	1.0873451	-35.73191	110	4	1.12	0.95;
	1775	1	0	0	0	0	1	1.12	-36.701191	110	4	1.12	0.95;
	1776	1	5.83	1.3	0	0	1	1.1061515	-26.861868	110	4	1.12	0.95;
	1777	1	0	0	0	0	1	1.1061529	-26.860966	110	4	1.12	0.95;
	1778	1	13.19	0.1	0	0	1	1.1010339	-33.201869	110	4	1.12	0.95;
	1779	1	59.33	17	0	0	1	1.0518734	-31.03022	110	4	1.12	0.95;
	1780	1	0	0	0	0	1	1.096566	-33.857461	110	4	1.12	0.95;
	1781	1	7.03	2.9	0	0	1	1.0624451	-30.257878	110	4	1.12	0.95;
	1782	1	8.24	3.5	0	0	1	1.1026463	-32.38536	110	4	1.12	0.95;
	1783	1	0	0	0	0	1	1.1026328	-32.380298	110	4	1.12	0.95;
	1784	1	9.89	5	0	0	1	1.0990207	-33.635424	110	4	1.12	0.95;
	1785	1	8.79	2	0	0	1	1.053939	-30.889031	110	4	1.12	0.95;
	1786	1	1.21	0.5	0	0	1	1.087645	-35.681231	110	4	1.12	0.95;
	1787	1	10.22	2.8	0	0	1	1.1040525	-15.90198	110	4	1.12	0.95;
	1788	2	20.55	3.7	0	0	1	1.0718802	-40.238538	110	4	1.12	0.95;
	1789	1	5.5	6.6	0	0	1	1.0942773	-34.301097	110	4	1.12	0.95;
	1790	1	0	0	0	0	1	1.0942805	-34.304161	110	4	1.12	0.95;
	1791	1	3.41	0.5	0	0	1	1.0873194	-35.731511	110	4	1.12	0.95;
	1792	1	5.39	0.8	0	0	1	1.0996572	-33.571164	110	4	1.12	0.95;
	1793	2	8.79	4.8	0	0	1	0.99315649	-34.024604	110	4	1.12	0.95;
	1794	1	9.45	2.6	0	0	1	0.99633054	-33.738966	110	4	1.12	0.95;
	1795	1	23.19	5.2	0	0	1	1.0870134	-36.56942	110	4	1.12	0.95;
	1796	1	15.39	6	0	0	1	0.99652752	-33.711061	110	4	1.12	0.95;
	1797	1	0	0	0	0	1	1.0864645	-30.246065	110	4	1.12	0.95;
	1798	1	5.5	1.6	0	0	1	1.086463	-30.246332	110	4	1.12	0.95;
	1799	2	8.46	2.1	0	0	1	1.0847396	-29.95526	110	4	1.12	0.95;
	1800	1	5.39	0	0	0	1	1.1005525	-27.210484	110	4	1.12	0.95;
	1801	1	6.6	1.5	0	0	1	1.0937315	-17.368925	110	4	1.12	0.95;
	1802	1	0	0	0	0	1	1.0550573	-11.304714	110	4	1.12	0.95;
	1803	1	5.5	1.6	0	0	1	1.0550558	-11.304997	110	4	1.12	0.95;
	1804	1	9.45	2.5	0	0	1	1.0626947	-42.905449	110	4	1.12	0.95;
	1805	1	13.41	3.4	0	0	1	1.0654506	-21.220468	110	4	1.12	0.95;
	1806	1	5.61	2.7	0	0	1	1.0227215	-33.019903	110	4	1.12	0.95;
	1807	2	19.35	2	0	0	1	1.1094119	-26.282055	110	4	1.12	0.95;
	1808	1	4.4	0.5	0	0	1	1.1154269	-29.45834	110	4	1.12	0.95;
	1809	1	4.4	1	0	0	1	1.0982246	-22.38383	110	4	1.12	0.95;
	1810	1	9.89	3	0	0	1	1.0991175	-28.67665	110	4	1.12	0.95;
	1811	1	0	0	0	0	1	1.0991175	-28.67665	110	4	1.12	0.95;
	1812	1	0	0	0	0	1	1.1051302	-29.048188	110	4	1.12	0.95;
	1813	1	0.44	0.1	0	0	1	1.1051301	-29.048209	110	4	1.12	0.95;
	1814	1	0	0	0	0	1	1.0757425	-36.2264	110	4	1.12	0.95;
	1815	1	25.83	4.8	0	0	1	1.075738	-36.227679	110	4	1.12	0.95;
	1816	1	5.28	0.7	0	0	1	1.0910448	-29.162451	110	4	1.12	0.95;
	1817	1	7.69	0.5	0	0	1	1.0954013	-29.76631	110	4	1.12	0.95;
	1818	1	10.66	1.4	0	0	1	1.0912397	-29.264126	110	4	1.12	0.95;
	1819	1	15.06	2	0	0	1	1.0909066	-29.378482	110	4	1.12	0.95;
	1820	1	16.49	2.3	0	0	1	1.0736305	-36.456694	110	4	1.12	0.95;
	1821	1	5.5	1.8	0	0	1	1.1044172	-41.514778	110	4	1.12	0.95;
	1822	1	0	0	0	0	1	1.1128968	-36.728345	110	4	1.12	0.95;
	1823	1	0	0	0	0	1	1.1092734	-37.230731	110	4	1.12	0.95;
	1824	1	9.12	2.5	0	0	1	1.0872723	-36.150594	110	4	1.12	0.95;
	1825	1	2.86	0.8	0	0	1	1.0230712	-32.317865	110	4	1.12	0.95;
	1826	1	7.14	1.6	0	0	1	1.083772	-39.80183	110	4	1.12	0.95;
	1827	1	3.63	0.8	0	0	1	1.1053466	-39.19473	110	4	1.12	0.95;
	1828	1	11.98	3.7	0	0	1	1.1049244	-37.578732	110	4	1.12	0.95;
	1829	1	7.69	2	0	0	1	1.1062927	-26.74267	110	4	1.12	0.95;
	1830	1	12.09	3	0	0	1	1.115598	-29.416957	110	4	1.12	0.95;
	1831	1	4.4	1.6	0	0	1	1.0924402	-43.650226	110	4	1.12	0.95;
	1832	1	9.34	1.8	0	0	1	1.1138693	-29.447386	110	4	1.12	0.95;
	1833	1	7.36	3.8	0	0	1	1.0419318	-36.543132	110	4	1.12	0.95;
	1834	1	8.79	1.6	0	0	1	1.0950975	-42.45157	110	4	1.12	0.95;
	1835	1	0	0	0	0	1	1.0588878	-44.968579	110	4	1.12	0.95;
	1836	1	5.5	1.4	0	0	1	1.0652379	-40.290178	110	4	1.12	0.95;
	1837	1	12.19	3.1	0	0	1	1.0773518	-40.506632	110	4	1.12	0.95;
	1838	1	0.55	0	0	0	1	1.1159627	-29.390081	110	4	1.12	0.95;
	1839	1	6.6	3	0	0	1	1.1192153	-25.250021	110	4	1.12	0.95;
	1840	1	0	0	0	0	1	1.12	-24.610841	110	4	1.12	0.95;
	1841	1	7.14	1.4	0	0	1	1.0397547	-40.037517	110	4	1.12	0.95;
	1842	1	2.86	0.5	0	0	1	1.068962	-32.740725	110	4	1.12	0.95;
	1843	1	13.63	2	0	0	1	1.0339856	-30.826238	110	4	1.12	0.95;
	1844	2	11.76	1.1	0	0	1	1.089176	-27.556129	110	4	1.12	0.95;
	1845	2	21.43	5.5	0	0	1	1.1064391	-41.339279	110	4	1.12	0.95;
	1846	1	0	0	0	0	1	1.1078043	-42.046719	110	4	1.12	0.95;
	1847	1	17.59	4.2	0	0	1	1.0856598	-35.716783	110	4	1.12	0.95;
	1848	1	2.86	0.8	0	0	1	1.0887704	-41.04921	110	4	1.12	0.95;
	1849	1	7.47	2.1	0	0	1	1.0887655	-40.853594	110	4	1.12	0.95;
	1850	1	7.91	1.9	0	0	1	1.0534908	-46.392039	110	4	1.12	0.95;
	1851	1	0	0	0	0	1	1.0974721	-36.199714	110	4	1.12	0.95;
	1852	1	7.91	0.2	0	0	1	1.097103	-36.046847	110	4	1.12	0.95;
	1853	1	4.4	4.4	0	0	1	1.0828584	-36.38818	110	4	1.12	0.95;
	1854	1	14.51	3.3	0	0	1	1.102063	-35.706052	110	4	1.12	0.95;
	1855	1	9.34	0	0	0	1	1.1000522	-27.687168	110	4	1.12	0.95;
	1856	1	8.67	2.5	0	0	1	1.0651641	-35.811448	110	4	1.12	0.95;
	1857	1	4.4	1.3	0	0	1	1.1112824	-36.892715	110	4	1.12	0.95;
	1858	1	4.18	1.5	0	0	1	1.0167494	-48.88895	110	4	1.12	0.95;
	1859	1	10.11	3.9	0	0	1	1.0929182	-42.532167	110	4	1.12	0.95;
	1860	1	8.02	1.9	0	0	1	1.0580965	-37.658857	110	4	1.12	0.95;
	1861	1	14.4	4.3	0	0	1	1.0667322	-39.319314	110	4	1.12	0.95;
	1862	1	17.04	5	0	0	1	1.0544557	-37.979724	110	4	1.12	0.95;
	1863	1	16.59	4.3	0	0	1	1.1123432	-19.239634	110	4	1.12	0.95;
	1864	1	9.12	2.9	0	0	1	1.0840356	-44.228252	110	4	1.12	0.95;
	1865	1	0	0	0	0	1	1.1051336	-29.047776	110	4	1.12	0.95;
	1866	1	11.54	2	0	0	1	1.1051318	-29.048318	110	4	1.12	0.95;
	1867	1	13.85	1.1	0	0	1	1.0302212	-40.669065	110	4	1.12	0.95;
	1868	1	9.67	1.5	0	0	1	1.0768439	-26.707925	110	4	1.12	0.95;
	1869	1	9.89	3.1	0	0	1	1.0351109	-31.834839	110	4	1.12	0.95;
	1870	2	5.28	0.9	0	0	1	1.0396357	-39.968151	110	4	1.12	0.95;
	1871	2	22.09	3.1	0	0	1	1.0721551	-28.878206	110	4	1.12	0.95;
	1872	1	0	0	0	0	1	1.103244	-6.7151251	110	4	1.12	0.95;
	1873	1	24.17	3.3	0	0	1	1.0794847	-27.927105	110	4	1.12	0.95;
	1874	2	13.95	3.2	0	0	1	1.0723046	-38.316435	110	4	1.12	0.95;
	1875	2	22.64	5.7	0	0	1	1.0223711	-32.824016	110	4	1.12	0.95;
	1876	1	25.28	4.9	0	0	1	1.0076033	-33.554723	110	4	1.12	0.95;
	1877	1	0	0	0	0	1	1.0270257	-32.59124	110	4	1.12	0.95;
	1878	1	0	0	0	0	1	1.0027572	-33.80531	110	4	1.12	0.95;
	1879	1	12.64	4	0	0	1	0.98672124	-35.215788	110	4	1.12	0.95;
	1880	1	0	0	0	0	1	1.086159	-25.827532	110	4	1.12	0.95;
	1881	1	0	0	0	0	1	1.101191	-25.851288	110	4	1.12	0.95;
	1882	2	12.86	8.5	0	0	1	1.12	-19.283439	110	4	1.12	0.95;
	1883	2	12.86	8.5	0	0	1	1.12	-26.561693	110	4	1.12	0.95;
	1884	1	8.24	0	0	0	1	1.0967625	-29.881197	110	4	1.12	0.95;
	1885	1	0	0	0	0	1	1.092994	-29.437987	110	4	1.12	0.95;
	1886	1	8.79	1.5	0	0	1	1.1180174	-29.16828	110	4	1.12	0.95;
	1887	1	0	0	0	0	1	1.1195513	-29.060572	110	4	1.12	0.95;
	1888	1	13.07	2.8	0	0	1	1.1040456	-20.353763	110	4	1.12	0.95;
	1889	1	17.04	2.9	0	0	1	1.1168936	-29.286189	110	4	1.12	0.95;
	1890	1	0.55	0.1	0	0	1	1.1168935	-29.286214	110	4	1.12	0.95;
	1891	1	2.97	0	0	0	1	1.1049757	-27.012226	110	4	1.12	0.95;
	1892	1	5.39	1	0	0	1	1.1049665	-27.013118	110	4	1.12	0.95;
	1893	1	8.9	5.4	0	0	1	1.1012086	-35.795692	110	4	1.12	0.95;
	1894	2	17.26	4.6	0	0	1	1.0868604	-36.601498	110	4	1.12	0.95;
	1895	2	15.94	4.8	0	0	1	1.0577623	-38.457989	110	4	1.12	0.95;
	1896	1	0	0	0	0	1	1.1148036	-29.586076	110	4	1.12	0.95;
	1897	1	10.43	2	0	0	1	1.1107307	-28.663724	110	4	1.12	0.95;
	1898	1	15.06	1.5	0	0	1	1.1175602	-29.281877	110	4	1.12	0.95;
	1899	1	0	0	0	0	1	1.1175602	-29.281877	110	4	1.12	0.95;
	1900	1	8.02	8.5	0	0	1	1.0593576	-38.332899	110	4	1.12	0.95;
	1901	1	15.61	2.4	0	0	1	1.1000075	-35.705993	110	4	1.12	0.95;
	1902	1	0	0	0	0	1	1.0673459	-37.784198	110	4	1.12	0.95;
	1903	1	0	0	0	0	1	1.0634987	-37.953259	110	4	1.12	0.95;
	1904	2	73.62	29	0	0	1	1.099172	-42.354016	110	4	1.12	0.95;
	1905	1	12.09	2	0	0	1	0.98762519	-39.576165	110	4	1.12	0.95;
	1906	1	0	0	0	0	1	1.0931525	-35.837787	110	4	1.12	0.95;
	1907	1	0	0	0	0	1	1.0931809	-35.834266	110	4	1.12	0.95;
	1908	1	3.08	2.6	0	0	1	1.0543301	-30.849821	110	4	1.12	0.95;
	1909	1	2.86	2	0	0	1	1.1002886	-33.492708	110	4	1.12	0.95;
	1910	1	11.21	2.6	0	0	1	1.1050391	-37.679388	110	4	1.12	0.95;
	1911	1	3.3	2.1	0	0	1	1.0727667	-36.484274	110	4	1.12	0.95;
	1912	1	23.07	4.3	0	0	1	1.0837566	-43.062171	110	4	1.12	0.95;
	1913	1	13.19	2.3	0	0	1	1.0887431	-41.994021	110	4	1.12	0.95;
	1914	1	0	0	0	0	1	1.0626231	-39.296913	110	4	1.12	0.95;
	1915	1	13.52	4.2	0	0	1	1.0626191	-39.297599	110	4	1.12	0.95;
	1916	1	9.89	1.5	0	0	1	1.1118535	-26.192619	110	4	1.12	0.95;
	1917	1	5.72	0.9	0	0	1	1.078709	-36.427348	110	4	1.12	0.95;
	1918	2	28.02	10.8	0	0	1	1.0972414	-36.029866	110	4	1.12	0.95;
	1919	1	0	0	0	0	1	1.1002968	-33.492383	110	4	1.12	0.95;
	1920	1	0	0	0	0	1	1.0543434	-30.849346	110	4	1.12	0.95;
	1921	2	19.46	5.8	0	0	1	1.0922111	-42.495247	110	4	1.12	0.95;
	1922	1	0	0	0	0	1	1.0922043	-42.497549	110	4	1.12	0.95;
	1923	1	13.95	3.2	0	0	1	1.0929794	-36.325888	110	4	1.12	0.95;
	1924	1	16.27	3.6	0	0	1	1.1004328	-35.734115	110	4	1.12	0.95;
	1925	1	9.67	-0.2	0	0	1	1.096988	-35.011499	110	4	1.12	0.95;
	1926	1	7.25	0.6	0	0	1	1.0850534	-36.27189	110	4	1.12	0.95;
	1927	1	19.78	0.9	0	0	1	1.0584065	-38.461919	110	4	1.12	0.95;
	1928	1	13.63	2.8	0	0	1	1.0913502	-35.987527	110	4	1.12	0.95;
	1929	1	14.29	3.3	0	0	1	1.0933433	-36.10342	110	4	1.12	0.95;
	1930	1	14.51	0.9	0	0	1	1.0867549	-28.641424	110	4	1.12	0.95;
	1931	1	7.69	0	0	0	1	1.0950332	-28.423223	110	4	1.12	0.95;
	1932	2	29.13	1.5	0	0	1	1.0831707	-26.828711	110	4	1.12	0.95;
	1933	1	20.65	8	0	0	1	1.0925968	-35.606572	110	4	1.12	0.95;
	1934	1	5.28	0.3	0	0	1	1.1030902	-29.143821	110	4	1.12	0.95;
	1935	1	17.59	5.3	0	0	1	0.99378865	-34.264259	110	4	1.12	0.95;
	1936	1	7.69	1.3	0	0	1	1.0963482	-27.188259	110	4	1.12	0.95;
	1937	1	6.6	1	0	0	1	1.0791969	-28.392248	110	4	1.12	0.95;
	1938	1	5.5	1.2	0	0	1	1.1135374	-27.603249	110	4	1.12	0.95;
	1939	1	10.88	2.9	0	0	1	1.0926726	-41.458595	110	4	1.12	0.95;
	1940	2	13.52	3	0	0	1	1.0598151	-37.45022	110	4	1.12	0.95;
	1941	1	16.92	2.5	0	0	1	1.0589374	-27.945644	110	4	1.12	0.95;
	1942	1	3.19	0.1	0	0	1	1.1061162	-26.844278	110	4	1.12	0.95;
	1943	1	6.49	1.8	0	0	1	1.091903	-20.731752	110	4	1.12	0.95;
	1944	1	0	0	0	0	1	1.0535544	-45.624727	110	4	1.12	0.95;
	1945	1	9.45	1.8	0	0	1	1.0609076	-45.988084	110	4	1.12	0.95;
	1946	1	14.73	1.9	0	0	1	1.0332342	-40.198408	110	4	1.12	0.95;
	1947	2	61.52	28	0	0	1	1.0684211	-28.193321	110	4	1.12	0.95;
	1948	1	0	0	0	0	1	1.0684435	-28.19299	110	4	1.12	0.95;
	1949	1	5.5	1	0	0	1	1.1093864	-28.713948	110	4	1.12	0.95;
	1950	1	4.95	3.4	0	0	1	1.0803583	-39.29003	110	4	1.12	0.95;
	1951	1	10.99	2.9	0	0	1	1.0736728	-40.024709	110	4	1.12	0.95;
	1952	1	10.88	3.7	0	0	1	1.0852861	-38.560877	110	4	1.12	0.95;
	1953	1	8.02	1.9	0	0	1	1.082336	-38.746205	110	4	1.12	0.95;
	1954	1	8.57	1	0	0	1	1.110806	-29.692308	110	4	1.12	0.95;
	1955	1	4.29	0	0	0	1	1.1151484	-28.872989	110	4	1.12	0.95;
	1956	1	0	0	0	0	1	1.115164	-28.873712	110	4	1.12	0.95;
	1957	1	12.09	2.5	0	0	1	1.115792	-29.492843	110	4	1.12	0.95;
	1958	1	0	0	0	0	1	1.115792	-29.492843	110	4	1.12	0.95;
	1959	1	7.47	2.3	0	0	1	1.085947	-36.106893	110	4	1.12	0.95;
	1960	2	10.55	1.1	0	0	1	1.095224	-42.431476	110	4	1.12	0.95;
	1961	2	2.86	0	0	0	1	1.1179144	-29.190995	110	4	1.12	0.95;
	1962	2	5.83	0.3	0	0	1	1.0899256	-40.044088	110	4	1.12	0.95;
	1963	1	6.05	1.6	0	0	1	1.0996071	-29.619342	110	4	1.12	0.95;
	1964	2	7.79	4.6	0	0	1	1.1041411	-21.22377	110	4	1.12	0.95;
	1965	1	20.77	6.7	0	0	1	1.0899195	-38.100108	110	4	1.12	0.95;
	1966	2	24.28	6.2	0	0	1	1.100111	-28.479771	110	4	1.12	0.95;
	1967	1	10.77	3.8	0	0	1	1.1143463	-29.424283	110	4	1.12	0.95;
	1968	1	4.84	1.5	0	0	1	1.0831555	-36.869865	110	4	1.12	0.95;
	1969	1	9.34	3.1	0	0	1	1.0746498	-36.398529	110	4	1.12	0.95;
	1970	2	22.53	4	0	0	1	1.066866	-39.189702	110	4	1.12	0.95;
	1971	1	16.49	2.6	0	0	1	1.0706408	-32.241269	110	4	1.12	0.95;
	1972	1	0	0	0	0	1	1.1152972	-27.52716	110	4	1.12	0.95;
	1973	1	10.43	3	0	0	1	1.0982972	-29.723766	110	4	1.12	0.95;
	1974	2	29.78	5.9	0	0	1	1.0396997	-37.718469	110	4	1.12	0.95;
	1975	1	12.64	2.2	0	0	1	1.0623315	-39.946041	110	4	1.12	0.95;
	1976	2	31.11	5.5	0	0	1	1.033558	-37.499791	110	4	1.12	0.95;
	1977	2	21.65	2.1	0	0	1	1.0972368	-28.574283	110	4	1.12	0.95;
	1978	1	1.76	0.8	0	0	1	1.044272	-31.0153	110	4	1.12	0.95;
	1979	1	10.99	0.8	0	0	1	1.0687352	-29.835021	110	4	1.12	0.95;
	1980	1	0	0.6	0	0	1	1.0822634	-28.818251	110	4	1.12	0.95;
	1981	1	21.98	7	0	0	1	1.1053143	-29.726354	110	4	1.12	0.95;
	1982	1	0	0	0	0	1	1.1053143	-29.726354	110	4	1.12	0.95;
	1983	1	9.01	1.9	0	0	1	1.0752804	-40.426916	110	4	1.12	0.95;
	1984	1	0.55	0	0	0	1	1.1094358	-26.422844	110	4	1.12	0.95;
	1985	1	8.24	2.1	0	0	1	1.1045859	-38.896581	110	4	1.12	0.95;
	1986	1	24.17	5.9	0	0	1	1.0830126	-36.416502	110	4	1.12	0.95;
	1987	1	0	0	0	0	1	1.1186645	-29.199769	110	4	1.12	0.95;
	1988	1	14.29	2.6	0	0	1	1.1171771	-28.550643	110	4	1.12	0.95;
	1989	1	17.37	2.6	0	0	1	1.0498957	-46.521025	110	4	1.12	0.95;
	1990	1	6.16	0.6	0	0	1	1.0973699	-26.699241	110	4	1.12	0.95;
	1991	1	2.64	1	0	0	1	1.0511512	-46.482759	110	4	1.12	0.95;
	1992	1	16.82	2.8	0	0	1	1.092667	-42.642437	110	4	1.12	0.95;
	1993	2	13.63	4.5	0	0	1	1.0758039	-21.092965	110	4	1.12	0.95;
	1994	1	11.21	4.3	0	0	1	1.0725179	-28.454595	110	4	1.12	0.95;
	1995	2	26.49	8.5	0	0	1	1.0924373	-42.213371	110	4	1.12	0.95;
	1996	2	12.53	3	0	0	1	1.0626196	-37.670443	110	4	1.12	0.95;
	1997	1	5.61	2	0	0	1	1.0950235	-42.436418	110	4	1.12	0.95;
	1998	2	8.57	1.7	0	0	1	1.0183069	-48.748922	110	4	1.12	0.95;
	1999	1	20.44	4.5	0	0	1	1.0759753	-38.033067	110	4	1.12	0.95;
	2000	1	9.89	1.6	0	0	1	1.0850062	-27.469377	110	4	1.12	0.95;
	2001	1	18.68	1.5	0	0	1	1.1182398	-15.00683	110	4	1.12	0.95;
	2002	1	13.41	3.2	0	0	1	1.0541484	-39.180278	110	4	1.12	0.95;
	2003	1	7.69	3	0	0	1	1.1180395	-24.260172	110	4	1.12	0.95;
	2004	1	8.79	3	0	0	1	1.1140095	-24.475874	110	4	1.12	0.95;
	2005	1	1.65	1	0	0	1	1.117861	-24.280826	110	4	1.12	0.95;
	2006	1	26.38	10	0	0	1	1.1145326	-24.440124	110	4	1.12	0.95;
	2007	1	7.69	2	0	0	1	1.1180188	-24.273845	110	4	1.12	0.95;
	2008	1	19.78	10	0	0	1	1.1101311	-24.686494	110	4	1.12	0.95;
	2009	1	0	0	0	0	1	1.118113	-24.275323	110	4	1.12	0.95;
	2010	2	18.68	13	0	0	1	1.1185839	-24.232217	110	4	1.12	0.95;
	2011	1	24.95	20.7	0	0	1	1.1185629	-24.233711	110	4	1.12	0.95;
	2012	1	28.57	10	0	0	1	1.0914573	-42.601423	110	4	1.12	0.95;
	2013	1	9.23	1.5	0	0	1	1.0582744	-29.804105	110	4	1.12	0.95;
	2014	1	0	0	0	0	1	1.1181652	-29.240709	110	4	1.12	0.95;
	2015	1	21.65	6.2	0	0	1	1.0465899	-39.058227	110	4	1.12	0.95;
	2016	1	3.3	2	0	0	1	1.1194077	-19.324124	110	4	1.12	0.95;
	2017	1	0	0	0	0	1	1.1168255	-19.889451	110	4	1.12	0.95;
	2018	1	24.4	3.9	0	0	1	1.0946113	-36.160777	110	4	1.12	0.95;
	2019	1	0	0	0	0	1	1.0946113	-36.160777	110	4	1.12	0.95;
	2020	1	3.3	1	0	0	1	1.1103925	-37.563427	110	4	1.12	0.95;
	2021	2	12.86	2.7	0	0	1	1.1085293	-26.880258	110	4	1.12	0.95;
	2022	2	11.87	3	0	0	1	1.1152381	-27.276436	110	4	1.12	0.95;
	2023	1	2.2	1.5	0	0	1	1.1150937	-16.711997	110	4	1.12	0.95;
	2024	1	3.19	1.2	0	0	1	1.0967969	-42.991882	110	4	1.12	0.95;
	2025	1	0	0	0	0	1	1.1111814	-28.5614	110	4	1.12	0.95;
	2026	2	9.89	8	0	0	1	1.1111832	-28.560699	110	4	1.12	0.95;
	2027	2	28.57	2	0	0	1	1.1192044	-29.097261	110	4	1.12	0.95;
	2028	1	16.71	4.5	0	0	1	1.119092	-29.094278	110	4	1.12	0.95;
	2029	1	4.95	0.8	0	0	1	1.0783497	-33.074339	110	4	1.12	0.95;
	2030	1	3.85	0.5	0	0	1	1.1082347	-26.581675	110	4	1.12	0.95;
	2031	1	0	0	0	0	1	1.1093183	-26.40353	110	4	1.12	0.95;
	2032	1	16.92	3.5	0	0	1	1.0453116	-39.621425	110	4	1.12	0.95;
	2033	2	18.25	1.6	0	0	1	1.1073388	-27.953381	110	4	1.12	0.95;
	2034	2	11.65	2.7	0	0	1	1.0911204	-26.430777	110	4	1.12	0.95;
	2035	1	7.69	1	0	0	1	1.1080272	-26.634448	110	4	1.12	0.95;
	2036	2	8.13	0.5	0	0	1	1.1051375	-28.039189	110	4	1.12	0.95;
	2037	1	6.16	0	0	0	1	1.1051386	-28.038316	110	4	1.12	0.95;
	2038	1	14.4	3.5	0	0	1	1.0587405	-39.905834	110	4	1.12	0.95;
	2039	1	10.88	1	0	0	1	1.104253	-28.15869	110	4	1.12	0.95;
	2040	1	14.4	2.3	0	0	1	1.1071592	-27.03189	110	4	1.12	0.95;
	2041	1	8.67	1.5	0	0	1	1.1023944	-27.084874	110	4	1.12	0.95;
	2042	1	7.25	1.5	0	0	1	1.099507	-28.060306	110	4	1.12	0.95;
	2043	1	23.19	10.4	0	0	1	1.0655869	-8.9084572	110	4	1.12	0.95;
	2044	1	12.19	1.7	0	0	1	1.0966375	-27.156783	110	4	1.12	0.95;
	2045	1	8.46	1.3	0	0	1	1.0794389	-28.364209	110	4	1.12	0.95;
	2046	2	12.53	4.1	0	0	1	1.0743642	-36.147845	110	4	1.12	0.95;
	2047	1	21.53	2.5	0	0	1	1.056933	-35.26097	110	4	1.12	0.95;
	2048	1	16.92	6.7	0	0	1	1.0805304	-37.804057	110	4	1.12	0.95;
	2049	1	6.81	1.4	0	0	1	1.0503034	-46.403023	110	4	1.12	0.95;
	2050	1	14.73	2.2	0	0	1	1.0902925	-26.365988	110	4	1.12	0.95;
	2051	1	19.68	2.5	0	0	1	1.0966446	-26.655796	110	4	1.12	0.95;
	2052	1	12.97	2.8	0	0	1	1.0730171	-28.866197	110	4	1.12	0.95;
	2053	1	14.73	3.9	0	0	1	1.0974091	-28.19867	110	4	1.12	0.95;
	2054	1	11.65	3.2	0	0	1	1.069574	-32.644164	110	4	1.12	0.95;
	2055	1	16.49	2	0	0	1	1.1008542	-28.108714	110	4	1.12	0.95;
	2056	1	9.89	1.4	0	0	1	1.1052019	-27.04792	110	4	1.12	0.95;
	2057	1	17.47	4.2	0	0	1	1.0728825	-28.881294	110	4	1.12	0.95;
	2058	1	15.71	3.2	0	0	1	1.0987435	-26.698563	110	4	1.12	0.95;
	2059	1	0	0	0	0	1	1.1098325	-28.506265	110	4	1.12	0.95;
	2060	1	0	0	0	0	1	1.1148036	-29.586076	110	4	1.12	0.95;
	2061	1	0	0	0	0	1	1.0965925	-29.598048	110	4	1.12	0.95;
	2062	1	0	0	0	0	1	1.0865719	-39.620131	110	4	1.12	0.95;
	2063	1	0	0	0	0	1	1.1095188	-26.425295	110	4	1.12	0.95;
	2064	1	0	0	0	0	1	1.102843	-28.99517	110	4	1.12	0.95;
	2065	1	0	0	0	0	1	1.0231656	-32.995612	110	4	1.12	0.95;
	2066	1	0	0	0	0	1	1.0538057	-30.89018	110	4	1.12	0.95;
	2067	1	0	0	0	0	1	1.0965659	-33.85746	110	4	1.12	0.95;
	2068	1	0	0	0	0	1	1.0914531	-29.111242	110	4	1.12	0.95;
	2069	1	0	0	0	0	1	1.0742325	-36.167782	110	4	1.12	0.95;
	2070	1	0	0	0	0	1	1.0907491	-27.43281	110	4	1.12	0.95;
	2071	1	0	0	0	0	1	1.091327	-40.613149	110	4	1.12	0.95;
	2072	1	0	0	0	0	1	1.0647017	-30.021811	110	4	1.12	0.95;
	2073	1	0	0	0	0	1	1.0595053	-38.337428	110	4	1.12	0.95;
	2074	1	0	0	0	0	1	1.0693262	-29.787474	110	4	1.12	0.95;
	2075	1	0	0	0	0	1	1.0625254	-38.194921	110	4	1.12	0.95;
	2076	1	0	0	0	0	1	1.0910803	-36.429193	110	4	1.12	0.95;
	2077	1	0	0	0	0	1	1.0823122	-28.819729	110	4	1.12	0.95;
	2078	1	0	0	0	0	1	1.0939275	-41.702449	110	4	1.12	0.95;
	2079	1	0	0	0	0	1	1.0979086	-26.503855	110	4	1.12	0.95;
	2080	1	0	0	0	0	1	1.0945703	-42.458279	110	4	1.12	0.95;
	2081	1	0	0	0	0	1	1.0910803	-36.429193	110	4	1.12	0.95;
	2082	1	7.79	1.4	0	0	1	1.0998736	-27.223257	110	4	1.12	0.95;
	2083	1	4.29	-1	0	0	1	1.1021681	-7.0105384	110	4	1.12	0.95;
	2084	1	1.98	0.5	0	0	1	1.1005295	-37.638537	110	4	1.12	0.95;
	2085	2	16.82	4.1	0	0	1	1.0521037	-39.101852	110	4	1.12	0.95;
	2086	1	9.23	3.4	0	0	1	1.081969	-42.543746	110	4	1.12	0.95;
	2087	1	39.78	13.4	0	0	1	1.0527868	-39.89278	110	4	1.12	0.95;
	2088	2	12.09	2.5	0	0	1	1.0565621	-10.907906	110	4	1.12	0.95;
	2089	1	0	0	0	0	1	1.0565632	-10.90699	110	4	1.12	0.95;
	2090	1	0	0	0	0	1	1.1148349	-27.517637	110	4	1.12	0.95;
	2091	1	14.29	2.5	0	0	1	1.1148368	-27.520119	110	4	1.12	0.95;
	2092	1	0	0	0	0	1	1.0558364	-11.148302	110	4	1.12	0.95;
	2093	1	11.87	3	0	0	1	1.0718242	-39.281628	110	4	1.12	0.95;
	2094	1	9.67	3.4	0	0	1	1.093383	-41.727271	110	4	1.12	0.95;
	2095	1	23.07	5.3	0	0	1	1.0925263	-35.972232	110	4	1.12	0.95;
	2096	1	43.29	15.8	0	0	1	1.0838416	-43.001123	110	4	1.12	0.95;
	2097	1	9.01	1.8	0	0	1	1.104503	-37.791858	110	4	1.12	0.95;
	2098	1	17.92	5.7	0	0	1	1.1034234	-37.797435	110	4	1.12	0.95;
	2099	2	24.17	6.3	0	0	1	1.1048338	-37.854815	110	4	1.12	0.95;
	2100	1	16.49	2.5	0	0	1	1.1140733	-25.890233	110	4	1.12	0.95;
	2101	1	5.5	1.9	0	0	1	1.0602363	-30.035915	110	4	1.12	0.95;
	2102	1	5.5	1.7	0	0	1	1.0699804	-40.46115	110	4	1.12	0.95;
	2103	1	7.69	1	0	0	1	1.1187172	-15.497159	110	4	1.12	0.95;
	2104	1	18.35	4.4	0	0	1	1.0422163	-39.569069	110	4	1.12	0.95;
	2105	1	5.39	1.5	0	0	1	1.0664417	-27.42384	110	4	1.12	0.95;
	2106	2	12.64	3.6	0	0	1	1.0492321	-39.846823	110	4	1.12	0.95;
	2107	2	12.64	1.4	0	0	1	1.091692	-34.438977	110	4	1.12	0.95;
	2108	2	9.34	2.6	0	0	1	1.1135029	-28.9222	110	4	1.12	0.95;
	2109	1	0	0	0	0	1	1.1135029	-28.9222	110	4	1.12	0.95;
	2110	1	12.64	2.5	0	0	1	1.0930479	-30.207183	110	4	1.12	0.95;
	2111	1	0	0	0	0	1	1.0931901	-29.442696	110	4	1.12	0.95;
	2112	1	0	0	0	0	1	1.0909686	-34.619817	110	4	1.12	0.95;
	2113	1	0	0	0	0	1	1.0880787	-35.621045	110	4	1.12	0.95;
	2114	1	14.29	2.5	0	0	1	1.0974466	-28.4963	110	4	1.12	0.95;
	2115	2	9.45	3.7	0	0	1	1.0945532	-42.458841	110	4	1.12	0.95;
	2116	1	13.59	3.8	0	0	1	1.0743739	-31.195488	110	5	1.12	0.95;
	2117	1	11.49	2	0	0	1	1.0495572	-33.397507	110	5	1.12	0.95;
	2118	1	19.99	5	0	0	1	1.0801894	-30.689634	110	5	1.12	0.95;
	2119	2	19.99	19	0	0	1	1.0796589	-30.027539	110	5	1.12	0.95;
	2120	1	10.49	1.5	0	0	1	1.0606733	-32.499487	110	5	1.12	0.95;
	2121	2	10.69	1.2	0	0	1	1.0942323	-34.649921	110	5	1.12	0.95;
	2122	1	8.99	1.2	0	0	1	1.0942299	-34.650985	110	5	1.12	0.95;
	2123	1	8.29	3	0	0	1	1.0783845	-30.232534	110	5	1.12	0.95;
	2124	1	14.79	3.2	0	0	1	1.0517927	-32.708673	110	5	1.12	0.95;
	2125	1	9.79	2.4	0	0	1	1.1097625	-29.889535	110	5	1.12	0.95;
	2126	1	22.98	6.5	0	0	1	1.0794411	-30.350112	110	5	1.12	0.95;
	2127	2	9.99	3	0	0	1	1.0647986	-33.779579	110	5	1.12	0.95;
	2128	1	5.5	1.5	0	0	1	1.0717595	-31.423173	110	5	1.12	0.95;
	2129	1	8.99	2.9	0	0	1	1.053541	-32.681223	110	5	1.12	0.95;
	2130	1	5	1.7	0	0	1	1.0012249	-35.229145	110	5	1.12	0.95;
	2131	1	21.98	8	0	0	1	1.0769666	-30.621119	110	5	1.12	0.95;
	2132	1	13.99	5.5	0	0	1	1.079675	-30.187176	110	5	1.12	0.95;
	2133	1	0	0	0	0	1	1.0914751	-30.43366	110	5	1.12	0.95;
	2134	1	0	0	0	0	1	1.0914839	-30.431527	110	5	1.12	0.95;
	2135	1	14.99	0.6	0	0	1	1.0805898	-35.067566	110	5	1.12	0.95;
	2136	1	5.3	1.2	0	0	1	1.0663118	-32.449665	110	5	1.12	0.95;
	2137	1	10.99	4.1	0	0	1	1.0043888	-34.908049	110	5	1.12	0.95;
	2138	2	14.79	4.5	0	0	1	1.0851476	-30.893598	110	5	1.12	0.95;
	2139	2	11.69	2.4	0	0	1	1.0851467	-30.893007	110	5	1.12	0.95;
	2140	2	14.49	3.4	0	0	1	1.0650571	-31.795932	110	5	1.12	0.95;
	2141	1	24.98	14	0	0	1	1.0654705	-31.117382	110	5	1.12	0.95;
	2142	1	10.49	3	0	0	1	1.0054501	-34.856479	110	5	1.12	0.95;
	2143	1	15.19	3.9	0	0	1	1.0763847	-29.255469	110	5	1.12	0.95;
	2144	1	8.49	2.2	0	0	1	1.0255272	-36.218991	110	5	1.12	0.95;
	2145	1	6.5	1.1	0	0	1	1.0272888	-36.053926	110	5	1.12	0.95;
	2146	1	14.99	2.8	0	0	1	0.99700205	-35.440953	110	5	1.12	0.95;
	2147	1	16.49	4.2	0	0	1	1.0746944	-31.28335	110	5	1.12	0.95;
	2148	1	4.5	0.6	0	0	1	1.0177513	-39.174415	110	5	1.12	0.95;
	2149	1	3.5	0.3	0	0	1	1.0387895	-37.402454	110	5	1.12	0.95;
	2150	1	5	1	0	0	1	1.0924218	-32.915745	110	5	1.12	0.95;
	2151	1	1	0.2	0	0	1	1.0815686	-34.967992	110	5	1.12	0.95;
	2152	1	7.99	1.5	0	0	1	1.0726745	-32.030236	110	5	1.12	0.95;
	2153	2	0	0.6	0	0	1	1.0179247	-39.134735	110	5	1.12	0.95;
	2154	1	0.9	0.2	0	0	1	1.0670149	-31.398507	110	5	1.12	0.95;
	2155	1	5.1	1	0	0	1	1.0821579	-29.255468	110	5	1.12	0.95;
	2156	1	11.59	0	0	0	1	1.0867079	-35.278875	110	5	1.12	0.95;
	2157	1	0	0	0	0	1	1.104475	-33.669326	110	5	1.12	0.95;
	2158	1	0	0	0	0	1	1.1044664	-33.672382	110	5	1.12	0.95;
	2159	2	29.98	8	0	0	1	1.0646335	-34.249719	110	5	1.12	0.95;
	2160	1	17.99	6	0	0	1	1.0606854	-34.374865	110	5	1.12	0.95;
	2161	1	12.99	2	0	0	1	1.0638025	-34.408544	110	5	1.12	0.95;
	2162	1	14.99	5.5	0	0	1	1.0795504	-30.072752	110	5	1.12	0.95;
	2163	1	0	0	0	0	1	1.0813042	-29.949199	110	5	1.12	0.95;
	2164	2	-2	0.2	0	0	1	1.0822727	-34.923395	110	5	1.12	0.95;
	2165	1	0	0	0	0	1	1.0754483	-30.970367	110	5	1.12	0.95;
	2166	1	0	0	0	0	1	1.0757412	-30.952781	110	5	1.12	0.95;
	2167	2	19.09	4.5	0	0	1	1.0744861	-31.295579	110	5	1.12	0.95;
	2168	2	18.99	4	0	0	1	1.0724665	-31.385875	110	5	1.12	0.95;
	2169	1	0	0	0	0	1	1.0765106	-31.398376	110	5	1.12	0.95;
	2170	1	0	0	0	0	1	1.0671896	-32.283697	110	5	1.12	0.95;
	2171	2	18.49	3.6	0	0	1	1.0728105	-31.274489	110	5	1.12	0.95;
	2172	1	10.49	3	0	0	1	1.0749282	-31.577937	110	5	1.12	0.95;
	2173	1	7.99	2	0	0	1	1.0749317	-31.575865	110	5	1.12	0.95;
	2174	1	6.5	1.5	0	0	1	1.0714191	-31.615498	110	5	1.12	0.95;
	2175	1	15.39	3.2	0	0	1	1.0763911	-31.32726	110	5	1.12	0.95;
	2176	1	9.99	3.5	0	0	1	1.0504772	-27.551283	110	5	1.12	0.95;
	2177	1	8.79	2.7	0	0	1	1.0635337	-30.559352	110	5	1.12	0.95;
	2178	1	6.1	0	0	0	1	1.089722	-35.470701	110	5	1.12	0.95;
	2179	1	17.09	3.7	0	0	1	1.0729057	-31.743246	110	5	1.12	0.95;
	2180	1	16.29	3.6	0	0	1	1.0746822	-31.601116	110	5	1.12	0.95;
	2181	1	0	0	0	0	1	1.0700843	-31.39875	110	5	1.12	0.95;
	2182	1	2	2	0	0	1	1.069875	-31.399242	110	5	1.12	0.95;
	2183	1	3.5	1	0	0	1	1.0580366	-32.873423	110	5	1.12	0.95;
	2184	1	3.9	0.3	0	0	1	1.0749065	-31.109215	110	5	1.12	0.95;
	2185	1	15.49	3.5	0	0	1	1.0760208	-31.36278	110	5	1.12	0.95;
	2186	1	0	0	0	0	1	1.0791264	-31.068439	110	5	1.12	0.95;
	2187	1	0	0	0	0	1	1.0863701	-27.671256	110	5	1.12	0.95;
	2188	1	0	0	0	0	1	1.0791674	-31.068111	110	5	1.12	0.95;
	2189	1	2	0.5	0	0	1	0.9965869	-35.492999	110	5	1.12	0.95;
	2190	1	8.19	1.8	0	0	1	1.0884445	-34.223719	110	5	1.12	0.95;
	2191	1	22.98	4	0	0	1	1.0579714	-32.60015	110	5	1.12	0.95;
	2192	1	19.99	7	0	0	1	1.0576964	-26.783098	110	5	1.12	0.95;
	2193	1	9.69	4.2	0	0	1	1.0618914	-32.175582	110	5	1.12	0.95;
	2194	2	23.98	10	0	0	1	1.0805446	-30.41586	110	5	1.12	0.95;
	2195	1	7.49	2.5	0	0	1	1.0812785	-29.948339	110	5	1.12	0.95;
	2196	1	5	1.6	0	0	1	1.0812849	-29.948894	110	5	1.12	0.95;
	2197	2	24.58	19	0	0	1	1.0660734	-25.654896	110	5	1.12	0.95;
	2198	1	6	1.5	0	0	1	1.075303	-30.9541	110	5	1.12	0.95;
	2199	1	7.99	2.4	0	0	1	1.090686	-35.083534	110	5	1.12	0.95;
	2200	1	10.49	4.3	0	0	1	1.0680723	-31.075426	110	5	1.12	0.95;
	2201	1	1.5	0.5	0	0	1	1.0399352	-27.733433	110	5	1.12	0.95;
	2202	1	2.9	0.8	0	0	1	1.0399357	-27.733353	110	5	1.12	0.95;
	2203	1	26.08	4.6	0	0	1	1.0277118	-35.408175	110	5	1.12	0.95;
	2204	2	0	0	0	0	1	1.0693579	-30.879585	110	5	1.12	0.95;
	2205	1	17.49	4.4	0	0	1	1.0447972	-33.910118	110	5	1.12	0.95;
	2206	1	12.99	3	0	0	1	1.0673967	-32.281621	110	5	1.12	0.95;
	2207	1	13.89	0	0	0	1	1.089797	-35.694423	110	5	1.12	0.95;
	2208	1	16.99	3.7	0	0	1	1.0763761	-31.506245	110	5	1.12	0.95;
	2209	1	11.29	0	0	0	1	1.0904517	-35.599587	110	5	1.12	0.95;
	2210	1	10.69	3.5	0	0	1	1.0662231	-31.168153	110	5	1.12	0.95;
	2211	1	16.49	2.4	0	0	1	1.0980459	-34.305544	110	5	1.12	0.95;
	2212	1	7.99	2.6	0	0	1	1.0671931	-31.069213	110	5	1.12	0.95;
	2213	2	15.69	1.2	0	0	1	1.1006936	-34.070811	110	5	1.12	0.95;
	2214	1	13.19	2.5	0	0	1	1.0986202	-34.248972	110	5	1.12	0.95;
	2215	1	6	2	0	0	1	1.0634864	-27.159044	110	5	1.12	0.95;
	2216	1	6	1.5	0	0	1	1.0439112	-33.852768	110	5	1.12	0.95;
	2217	2	16.99	3.7	0	0	1	1.0606393	-27.111935	110	5	1.12	0.95;
	2218	2	17.99	2	0	0	1	1.0424111	-33.896166	110	5	1.12	0.95;
	2219	1	6	1.5	0	0	1	1.0593847	-33.73265	110	5	1.12	0.95;
	2220	1	14.99	3.5	0	0	1	1.0799596	-30.024147	110	5	1.12	0.95;
	2221	2	94.9	25	0	0	1	1.0899167	-32.914643	110	5	1.12	0.95;
	2222	1	7.69	2.9	0	0	1	1.0669254	-30.88383	110	5	1.12	0.95;
	2223	1	11.99	3.5	0	0	1	1.0866996	-33.032497	110	5	1.12	0.95;
	2224	1	15.39	3.6	0	0	1	1.0964065	-34.448255	110	5	1.12	0.95;
	2225	2	8.69	3.9	0	0	1	1.0740657	-29.401277	110	5	1.12	0.95;
	2226	1	12.59	4.2	0	0	1	1.0811326	-27.168068	110	5	1.12	0.95;
	2227	1	0	0	0	0	1	1.0691492	-31.235672	110	5	1.12	0.95;
	2228	1	9.99	3	0	0	1	1.0575573	-32.613939	110	5	1.12	0.95;
	2229	1	13.99	1.5	0	0	1	1.1033263	-31.290572	110	5	1.12	0.95;
	2230	1	10.99	1	0	0	1	1.1034579	-31.188158	110	5	1.12	0.95;
	2231	1	3	0.5	0	0	1	1.0547583	-33.133546	110	5	1.12	0.95;
	2232	1	17.39	6.2	0	0	1	1.0648589	-30.677641	110	5	1.12	0.95;
	2233	1	13.99	3.8	0	0	1	1.0751529	-31.064638	110	5	1.12	0.95;
	2234	2	16.99	9.5	0	0	1	1.0884515	-28.497512	110	5	1.12	0.95;
	2235	1	10.99	2	0	0	1	1.0595057	-32.774893	110	5	1.12	0.95;
	2236	1	16.39	4.3	0	0	1	1.0544587	-33.081483	110	5	1.12	0.95;
	2237	2	19.49	18	0	0	1	1.0580106	-26.939873	110	5	1.12	0.95;
	2238	1	13.99	3	0	0	1	1.0679414	-34.509251	110	5	1.12	0.95;
	2239	1	11.99	1	0	0	1	1.0874014	-34.189364	110	5	1.12	0.95;
	2240	1	12.99	4	0	0	1	1.0746945	-33.263083	110	5	1.12	0.95;
	2241	1	15.99	3.2	0	0	1	1.0584868	-32.951633	110	5	1.12	0.95;
	2242	1	5	2	0	0	1	1.0604598	-33.481782	110	5	1.12	0.95;
	2243	1	1.9	0.1	0	0	1	1.0730392	-31.458444	110	5	1.12	0.95;
	2244	1	11.49	3.5	0	0	1	1.0746072	-27.421257	110	5	1.12	0.95;
	2245	1	14.49	4	0	0	1	1.0449185	-33.881501	110	5	1.12	0.95;
	2246	1	13.99	2.5	0	0	1	1.0644658	-32.680116	110	5	1.12	0.95;
	2247	1	17.99	4.8	0	0	1	1.0539239	-27.286068	110	5	1.12	0.95;
	2248	2	13.49	4	0	0	1	1.0759998	-31.963659	110	5	1.12	0.95;
	2249	1	11.49	1	0	0	1	1.0694207	-30.941786	110	5	1.12	0.95;
	2250	1	15.69	5.4	0	0	1	1.0498447	-32.979596	110	5	1.12	0.95;
	2251	1	11.99	3	0	0	1	1.0620049	-33.553046	110	5	1.12	0.95;
	2252	1	3.5	1	0	0	1	1.0760765	-30.391234	110	5	1.12	0.95;
	2253	1	7.99	1.5	0	0	1	1.0586894	-26.592444	110	5	1.12	0.95;
	2254	1	4	0.5	0	0	1	1.0869371	-34.355389	110	5	1.12	0.95;
	2255	1	10.99	2.4	0	0	1	1.0785379	-31.363764	110	5	1.12	0.95;
	2256	1	23.98	4.4	0	0	1	1.0666727	-32.127208	110	5	1.12	0.95;
	2257	1	0	0	0	0	1	1.0776655	-30.657967	110	5	1.12	0.95;
	2258	1	0	0	0	0	1	1.0776737	-30.653896	110	5	1.12	0.95;
	2259	1	9.99	2.4	0	0	1	1.0750501	-31.07414	110	5	1.12	0.95;
	2260	1	16.99	3	0	0	1	1.0792814	-30.713013	110	5	1.12	0.95;
	2261	1	0	0	0	0	1	1.0792614	-30.713015	110	5	1.12	0.95;
	2262	1	8.99	2	0	0	1	1.0713533	-31.038545	110	5	1.12	0.95;
	2263	1	19.49	4	0	0	1	1.0725586	-31.351897	110	5	1.12	0.95;
	2264	1	22.98	5.5	0	0	1	1.0727667	-31.179949	110	5	1.12	0.95;
	2265	1	8.69	1.4	0	0	1	1.1194155	-28.276448	110	5	1.12	0.95;
	2266	1	8.99	2	0	0	1	1.0784653	-30.767475	110	5	1.12	0.95;
	2267	1	24.48	3	0	0	1	1.062497	-32.277659	110	5	1.12	0.95;
	2268	2	2.5	0.4	0	0	1	1.0823122	-34.749459	110	5	1.12	0.95;
	2269	1	17.99	5	0	0	1	1.0854822	-30.995283	110	5	1.12	0.95;
	2270	1	6.99	1.5	0	0	1	1.0737138	-31.094359	110	5	1.12	0.95;
	2271	2	15.99	4	0	0	1	1.0739468	-31.105672	110	5	1.12	0.95;
	2272	2	22.98	8	0	0	1	1.0752672	-30.965791	110	5	1.12	0.95;
	2273	2	13.29	4	0	0	1	1.0610213	-26.37461	110	5	1.12	0.95;
	2274	1	6	2.5	0	0	1	1.0610149	-26.373456	110	5	1.12	0.95;
	2275	1	20.98	4.3	0	0	1	1.0694361	-31.762327	110	5	1.12	0.95;
	2276	1	0.1	0.1	0	0	1	1.0614799	-31.84055	110	5	1.12	0.95;
	2277	1	4	0.3	0	0	1	1.0811702	-35.568646	110	5	1.12	0.95;
	2278	2	12.79	4.1	0	0	1	1.0845922	-27.149336	110	5	1.12	0.95;
	2279	1	11.99	4	0	0	1	1.0583881	-34.126273	110	5	1.12	0.95;
	2280	1	0	0	0	0	1	1.0583864	-34.125369	110	5	1.12	0.95;
	2281	1	2.1	0.2	0	0	1	1.0567257	-33.025469	110	5	1.12	0.95;
	2282	1	5	0.9	0	0	1	1.0720912	-31.474992	110	5	1.12	0.95;
	2283	1	12.99	3.3	0	0	1	1.065437	-32.263455	110	5	1.12	0.95;
	2284	1	3	1	0	0	1	1.0643771	-34.035698	110	5	1.12	0.95;
	2285	1	7.09	2.4	0	0	1	1.0854051	-34.614745	110	5	1.12	0.95;
	2286	1	7.09	1.6	0	0	1	1.0742814	-31.262396	110	5	1.12	0.95;
	2287	1	14.29	3.3	0	0	1	1.0693383	-31.832696	110	5	1.12	0.95;
	2288	1	11.59	4.1	0	0	1	1.0596726	-32.123655	110	5	1.12	0.95;
	2289	1	5.5	2	0	0	1	1.0583909	-27.165592	110	5	1.12	0.95;
	2290	2	6	2	0	0	1	1.0690469	-33.021092	110	5	1.12	0.95;
	2291	1	2.7	1	0	0	1	1.0277447	-33.85765	110	5	1.12	0.95;
	2292	1	6.5	2	0	0	1	1.0517506	-32.082366	110	5	1.12	0.95;
	2293	2	16.69	3.4	0	0	1	1.0678125	-32.024595	110	5	1.12	0.95;
	2294	2	7.99	2.8	0	0	1	1.0745322	-29.864587	110	5	1.12	0.95;
	2295	1	12.09	3.8	0	0	1	1.0626258	-31.55889	110	5	1.12	0.95;
	2296	2	5	2.2	0	0	1	1.0754887	-30.983927	110	5	1.12	0.95;
	2297	1	5	1.1	0	0	1	1.0756422	-30.962345	110	5	1.12	0.95;
	2298	2	16.99	4	0	0	1	1.0662106	-34.60495	110	5	1.12	0.95;
	2299	1	20.98	4.1	0	0	1	1.0723048	-31.793244	110	5	1.12	0.95;
	2300	1	23.98	4.7	0	0	1	1.0920917	-30.37021	110	5	1.12	0.95;
	2301	1	6	1.5	0	0	1	1.0409103	-34.04671	110	5	1.12	0.95;
	2302	1	1	0.5	0	0	1	1.0812628	-29.950179	110	5	1.12	0.95;
	2303	1	23.58	6.8	0	0	1	1.0664022	-31.58629	110	5	1.12	0.95;
	2304	1	11.59	3.2	0	0	1	1.0870729	-30.749777	110	5	1.12	0.95;
	2305	1	3.5	1.3	0	0	1	1.0284373	-33.693198	110	5	1.12	0.95;
	2306	1	23.98	7	0	0	1	1.0768729	-30.539843	110	5	1.12	0.95;
	2307	2	11.79	3.4	0	0	1	1.0762497	-31.419568	110	5	1.12	0.95;
	2308	1	18.89	4.1	0	0	1	1.0485497	-32.620247	110	5	1.12	0.95;
	2309	1	8.29	3.2	0	0	1	1.075332	-31.339382	110	5	1.12	0.95;
	2310	1	21.98	9	0	0	1	1.0606667	-26.926839	110	5	1.12	0.95;
	2311	1	8.49	2	0	0	1	1.0774809	-30.262793	110	5	1.12	0.95;
	2312	1	26.98	3.6	0	0	1	1.0380537	-37.467218	110	5	1.12	0.95;
	2313	1	15.89	3.6	0	0	1	1.039391	-37.292635	110	5	1.12	0.95;
	2314	1	0	0	0	0	1	1.0858371	-34.619954	110	5	1.12	0.95;
	2315	1	13.19	2.4	0	0	1	1.0880813	-35.200249	110	5	1.12	0.95;
	2316	1	9.49	3	0	0	1	1.0290783	-33.510288	110	5	1.12	0.95;
	2317	1	21.98	2	0	0	1	1.0763471	-35.477332	110	5	1.12	0.95;
	2318	1	5.7	1.2	0	0	1	1.0892599	-34.843139	110	5	1.12	0.95;
	2319	1	3.5	0	0	0	1	1.0304296	-38.141812	110	5	1.12	0.95;
	2320	1	8.99	2.3	0	0	1	1.0207365	-35.856756	110	5	1.12	0.95;
	2321	1	8.99	0.4	0	0	1	1.0841969	-35.069976	110	5	1.12	0.95;
	2322	1	8.99	0.5	0	0	1	1.0822632	-34.4275	110	5	1.12	0.95;
	2323	2	24.98	3	0	0	1	1.0808472	-34.968375	110	5	1.12	0.95;
	2324	1	8.49	4.3	0	0	1	1.0718074	-31.529234	110	5	1.12	0.95;
	2325	1	0	0	0	0	1	1.0760246	-31.362847	110	5	1.12	0.95;
	2326	1	24.68	5	0	0	1	1.0644052	-32.395798	110	5	1.12	0.95;
	2327	1	0.5	0.2	0	0	1	1.06762	-32.122395	110	5	1.12	0.95;
	2328	2	29.98	4.8	0	0	1	1.0359467	-35.096288	110	5	1.12	0.95;
	2329	1	11.99	2	0	0	1	1.079157	-35.134404	110	5	1.12	0.95;
	2330	2	0.4	0.1	0	0	1	1.0694516	-31.77017	110	5	1.12	0.95;
	2331	1	20.98	3	0	0	1	1.0658079	-30.718951	110	5	1.12	0.95;
	2332	1	4.8	1	0	0	1	1.0747609	-31.593112	110	5	1.12	0.95;
	2333	1	5.3	1	0	0	1	1.091551	-22.517637	110	5	1.12	0.95;
	2334	1	7.99	2.4	0	0	1	1.0552913	-33.116107	110	5	1.12	0.95;
	2335	1	6.5	3	0	0	1	1.0641083	-33.037799	110	5	1.12	0.95;
	2336	2	68.93	43	0	0	1	1.0745781	-29.915079	110	5	1.12	0.95;
	2337	1	6.5	2.5	0	0	1	1.0889328	-30.626306	110	5	1.12	0.95;
	2338	1	22.98	4.6	0	0	1	1.0583228	-32.911792	110	5	1.12	0.95;
	2339	2	34.97	6.5	0	0	1	1.0700813	-31.398646	110	5	1.12	0.95;
	2340	1	0	0	0	0	1	1.0701039	-31.396656	110	5	1.12	0.95;
	2341	1	5.1	1.2	0	0	1	1.0753497	-31.559337	110	5	1.12	0.95;
	2342	1	15.49	5.2	0	0	1	1.0665995	-31.653852	110	5	1.12	0.95;
	2343	1	23.58	7.1	0	0	1	1.0672554	-31.573076	110	5	1.12	0.95;
	2344	1	12.09	0	0	0	1	1.0605578	-32.110542	110	5	1.12	0.95;
	2345	1	17.49	4.9	0	0	1	1.0593761	-31.932342	110	5	1.12	0.95;
	2346	1	9.99	2.7	0	0	1	1.0705361	-27.651853	110	5	1.12	0.95;
	2347	1	18.19	5.3	0	0	1	1.0656839	-31.701924	110	5	1.12	0.95;
	2348	1	12.49	3.8	0	0	1	1.0198084	-34.069725	110	5	1.12	0.95;
	2349	1	8.29	3.9	0	0	1	1.0636052	-31.893292	110	5	1.12	0.95;
	2350	1	11.99	1	0	0	1	1.0772393	-35.686239	110	5	1.12	0.95;
	2351	1	8.79	0	0	0	1	1.0954645	-34.962188	110	5	1.12	0.95;
	2352	1	18.49	6.2	0	0	1	1.0670838	-30.222895	110	5	1.12	0.95;
	2353	1	21.98	4.6	0	0	1	1.1042369	-29.650834	110	5	1.12	0.95;
	2354	1	19.59	4.4	0	0	1	1.1008499	-29.695343	110	5	1.12	0.95;
	2355	1	8.99	0.3	0	0	1	1.1100473	-30.405814	110	5	1.12	0.95;
	2356	1	19.19	4.3	0	0	1	1.0692879	-32.101777	110	5	1.12	0.95;
	2357	1	0	0	0	0	1	1.0916163	-29.174648	110	5	1.12	0.95;
	2358	1	4.1	2	0	0	1	1.0916018	-29.174942	110	5	1.12	0.95;
	2359	1	12.49	4.5	0	0	1	1.0628662	-32.26635	110	5	1.12	0.95;
	2360	1	22.78	7.9	0	0	1	1.0805571	-29.463386	110	5	1.12	0.95;
	2361	2	18.59	5.7	0	0	1	1.0834723	-29.106835	110	5	1.12	0.95;
	2362	1	0	0	0	0	1	1.083454	-29.108701	110	5	1.12	0.95;
	2363	1	23.38	5.9	0	0	1	1.0821686	-29.515995	110	5	1.12	0.95;
	2364	1	6.5	0.5	0	0	1	1.0648545	-32.408644	110	5	1.12	0.95;
	2365	1	0	0	0	0	1	1.0720275	-31.400049	110	5	1.12	0.95;
	2366	1	0	0	0	0	1	1.0811816	-35.567389	110	5	1.12	0.95;
	2367	1	0	0	0	0	1	1.0648735	-32.406542	110	5	1.12	0.95;
	2368	1	32.98	6	0	0	1	1.0794752	-30.054477	110	5	1.12	0.95;
	2369	1	2	1	0	0	1	1.0795552	-30.033595	110	5	1.12	0.95;
	2370	1	11.49	2.7	0	0	1	1.0716062	-31.465081	110	5	1.12	0.95;
	2371	1	12.99	3.3	0	0	1	1.0734793	-31.384206	110	5	1.12	0.95;
	2372	2	49.95	13	0	0	1	1.0901753	-29.261172	110	5	1.12	0.95;
	2373	1	39.97	13	0	0	1	1.0901634	-29.263099	110	5	1.12	0.95;
	2374	1	9.59	1.2	0	0	1	1.0178542	-39.165348	110	5	1.12	0.95;
	2375	1	10.99	5	0	0	1	1.0640798	-34.319506	110	5	1.12	0.95;
	2376	2	21.98	4.8	0	0	1	1.0425808	-27.572248	110	5	1.12	0.95;
	2377	1	0	0	0	0	1	1.1199873	-28.177197	110	5	1.12	0.95;
	2378	1	0	0	0	0	1	1.12	-28.175349	110	5	1.12	0.95;
	2379	2	12.99	6.5	0	0	1	1.0535756	-32.447533	110	5	1.12	0.95;
	2380	2	0	0	0	0	1	1.0964598	-33.305123	110	5	1.12	0.95;
	2381	2	0	0	0	0	1	1.0964544	-33.305306	110	5	1.12	0.95;
	2382	1	3	0.4	0	0	1	1.0939913	-33.633139	110	5	1.12	0.95;
	2383	1	50	20	0	0	2	1.0968483	-30.102203	110	6	1.12	0.95;
];

%% generator data
%	bus	Pg	Qg	Qmax	Qmin	Vg	mBase	status	Pmax	Pmin	Pc1	Pc2	Qc1min	Qc1max	Qc2min	Qc2max	ramp_agc	ramp_10	ramp_30	ramp_q	apf
mpc.gen = [
	10	400	120	120	0	1	168	1	400	70	0	0	0	0	0	0	0	0	0	0	0;
	16	720	160.532	440	-40	1	823	1	720	120	0	0	0	0	0	0	0	0	0	0	0;
	17	1080	212.82	660	-60	1	1234	1	1080	120	0	0	0	0	0	0	0	0	0	0	0;
	18	2520	160.59	1540	-140	1	2879	1	2520	120	0	0	0	0	0	0	0	0	0	0	0;
	29	70	240	240	0	1	511	1	400	70	0	0	0	0	0	0	0	0	0	0	0;
	30	70	129.949	240	0	1	511	1	800	70	0	0	0	0	0	0	0	0	0	0	0;
	31	1000	0	350	0	1	420	1	1000	150	0	0	0	0	0	0	0	0	0	0	0;
	41	200	0	120	0	1	241	1	200	70	0	0	0	0	0	0	0	0	0	0	0;
	42	70	0	120	0	1	241	1	410	70	0	0	0	0	0	0	0	0	0	0	0;
	43	410	0	240	0	1	482	1	410	70	0	0	0	0	0	0	0	0	0	0	0;
	44	410	0	240	0	1	482	1	410	70	0	0	0	0	0	0	0	0	0	0	0;
	45	42.2	21	21	0	1	49	1	42.2	39.14	0	0	0	0	0	0	0	0	0	0	0;
	63	650	103.63	302	0	1	473	1	650	145	0	0	0	0	0	0	0	0	0	0	0;
	64	450	78.8702	311	2	1	475	1	450	145	0	0	0	0	0	0	0	0	0	0	0;
	67	750	413.726	449	0	1	864	1	750	220	0	0	0	0	0	0	0	0	0	0	0;
	83	225	-89	190	-89	1	239	1	225	140	0	0	0	0	0	0	0	0	0	0	0;
	84	225	167.231	190	-89	1	251	1	225	140	0	0	0	0	0	0	0	0	0	0	0;
	85	120	119.623	125	-50	1	133	1	120	40	0	0	0	0	0	0	0	0	0	0	0;
	86	120	-6.01871	125	-50	1	133	1	120	40	0	0	0	0	0	0	0	0	0	0	0;
	93	120	50.5085	90	5	1	123	1	120	80	0	0	0	0	0	0	0	0	0	0	0;
	95	110	27	68	27	1	105	1	110	50	0	0	0	0	0	0	0	0	0	0	0;
	97	87.6	41.8528	68	27	1	105	1	87.6	83.26	0	0	0	0	0	0	0	0	0	0	0;
	103	160	68.7599	177	-82	1	239	1	400	160	0	0	0	0	0	0	0	0	0	0	0;
	104	225	97.3097	379	-177	1	490	1	225	140	0	0	0	0	0	0	0	0	0	0	0;
	105	430	-165	353	-165	1	502	1	430	160	0	0	0	0	0	0	0	0	0	0	0;
	109	250	17.6233	65	0	1	277	1	250	80	0	0	0	0	0	0	0	0	0	0	0;
	110	250	17.7852	65	0	1	280	1	250	80	0	0	0	0	0	0	0	0	0	0	0;
	111	360	126.446	270	0	1	401	1	360	40	0	0	0	0	0	0	0	0	0	0	0;
	123	20	40	40	0	1	98	1	110	20	0	0	0	0	0	0	0	0	0	0	0;
	124	125	90	90	0	1	132	1	125	45	0	0	0	0	0	0	0	0	0	0	0;
	125	70	360	360	0	1	654	1	860	70	0	0	0	0	0	0	0	0	0	0	0;
	127	690	0	360	0	1	540	1	690	70	0	0	0	0	0	0	0	0	0	0	0;
	131	645.377	52.6305	360	0	1	696	1	1060	70	0	0	0	0	0	0	0	0	0	0	0;
	132	70	286.7	480	0	1	732	1	600	70	0	0	0	0	0	0	0	0	0	0	0;
	139	408.67	147.319	360	0	1	714	1	600	70	0	0	0	0	0	0	0	0	0	0	0;
	140	200	120	120	0	1	240	1	200	70	0	0	0	0	0	0	0	0	0	0	0;
	176	600	-120	220	-120	1	430	1	600	70	0	0	0	0	0	0	0	0	0	0	0;
	177	200	201.005	220	-120	1	430	1	200	70	0	0	0	0	0	0	0	0	0	0	0;
	180	0	16.8544	99999	-99999	1	7485	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	181	175	26.1506	99999	-99999	1	210	1	175	174	0	0	0	0	0	0	0	0	0	0	0;
	182	307.59	48.5395	99999	-99999	1	13465	1	307.59	306	0	0	0	0	0	0	0	0	0	0	0;
	184	0	69.5787	99999	-99999	1	8353	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	185	0	12.233	99999	-99999	1	14254	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	186	0	32.0974	99999	-99999	1	7401	1	0	0	0	0	0	0	0	0	0	0	0	0	0;
	192	95	28.3494	50	0	1	114	1	95	90.25	0	0	0	0	0	0	0	0	0	0	0;
	196	0.9	1	1	0	1	1	1	0.9	0.86	0	0	0	0	0	0	0	0	0	0	0;
	198	0.8	1	1	0	1	1	1	0.8	0.76	0	0	0	0	0	0	0	0	0	0	0;
	205	15	6.20319	10	0	1	18	1	15	14.25	0	0	0	0	0	0	0	0	0	0	0;
	213	11	8	8	0	1	13	1	11	10.45	0	0	0	0	0	0	0	0	0	0	0;
	264	2.5	2	2	0	1	3	1	2.5	2.38	0	0	0	0	0	0	0	0	0	0	0;
	269	6	5	5	0	1	7	1	6	5.7	0	0	0	0	0	0	0	0	0	0	0;
	277	70	40.2687	42	0	1	84	1	70	66.5	0	0	0	0	0	0	0	0	0	0	0;
	278	60	12.5429	40	0	1	72	1	60	57	0	0	0	0	0	0	0	0	0	0	0;
	279	60	17.8785	40	0	1	72	1	60	57	0	0	0	0	0	0	0	0	0	0	0;
	281	120	34.0803	90	0	1	144	1	120	114	0	0	0	0	0	0	0	0	0	0	0;
	282	40	16.9838	40	0	1	48	1	40	38	0	0	0	0	0	0	0	0	0	0	0;
	289	2.5	3	3	0	1	3	1	2.5	2.38	0	0	0	0	0	0	0	0	0	0	0;
	294	2	1	1	0	1	2	1	2	1.9	0	0	0	0	0	0	0	0	0	0	0;
	314	1.5	1	1	0	1	2	1	1.5	1.43	0	0	0	0	0	0	0	0	0	0	0;
	328	44	19.2819	21	0	1	53	1	44	41.8	0	0	0	0	0	0	0	0	0	0	0;
	329	44	21	21	0	1	53	1	44	41.8	0	0	0	0	0	0	0	0	0	0	0;
	330	44	0	21	0	1	53	1	44	41.8	0	0	0	0	0	0	0	0	0	0	0;
	331	43	21	21	0	1	52	1	43	40.85	0	0	0	0	0	0	0	0	0	0	0;
	334	1.5	1	1	0	1	2	1	1.5	1.43	0	0	0	0	0	0	0	0	0	0	0;
	346	200	25.128	120	0	1	180	1	200	70	0	0	0	0	0	0	0	0	0	0	0;
	347	10	9.77566	15	0	1	12	1	10	10	0	0	0	0	0	0	0	0	0	0	0;
	359	1.5	1	1	0	1	2	1	1.5	1.43	0	0	0	0	0	0	0	0	0	0	0;
	365	5.1	3	3	0	1	6	1	5.1	4.85	0	0	0	0	0	0	0	0	0	0	0;
	382	8	5	5	0	1	10	1	8	7.6	0	0	0	0	0	0	0	0	0	0	0;
	383	8	5	5	0	1	10	1	8	7.6	0	0	0	0	0	0	0	0	0	0	0;
	385	6	4	4	0	1	7	1	6	5.7	0	0	0	0	0	0	0	0	0	0	0;
	390	4.5	3	3	0	1	5	1	4.5	4.28	0	0	0	0	0	0	0	0	0	0	0;
	395	10	5.15536	8	0	1	12	1	10	9.5	0	0	0	0	0	0	0	0	0	0	0;
	404	3	3	3	0	1	4	1	3	2.85	0	0	0	0	0	0	0	0	0	0	0;
	426	3.2	2	2	0	1	4	1	3.2	3.04	0	0	0	0	0	0	0	0	0	0	0;
	444	1	0	1	0	1	1	1	1	0.95	0	0	0	0	0	0	0	0	0	0	0;
	451	4.5	3	3	0	1	5	1	4.5	4.28	0	0	0	0	0	0	0	0	0	0	0;
	482	1	0	1	0	1	1	1	1	0.95	0	0	0	0	0	0	0	0	0	0	0;
	492	2	1	1	0	1	2	1	2	1.9	0	0	0	0	0	0	0	0	0	0	0;
	493	234	108.562	130	0	1	281	1	234	222.3	0	0	0	0	0	0	0	0	0	0	0;
	494	234	130	130	0	1	281	1	234	222.3	0	0	0	0	0	0	0	0	0	0	0;
	514	115	90	90	0	1	138	1	115	109.25	0	0	0	0	0	0	0	0	0	0	0;
	515	115	90	90	0	1	138	1	115	109.25	0	0	0	0	0	0	0	0	0	0	0;
	525	6	4	4	0	1	7	1	6	5.7	0	0	0	0	0	0	0	0	0	0	0;
	536	6	6	6	0	1	7	1	6	5.7	0	0	0	0	0	0	0	0	0	0	0;
	537	3.5	3	3	0	1	4	1	3.5	3.33	0	0	0	0	0	0	0	0	0	0	0;
	556	2.7	1	1	0	1	3	1	2.7	2.57	0	0	0	0	0	0	0	0	0	0	0;
	580	1.6	1	1	0	1	2	1	1.6	1.52	0	0	0	0	0	0	0	0	0	0	0;
	584	2.7	2	2	0	1	3	1	2.7	2.57	0	0	0	0	0	0	0	0	0	0	0;
	585	4	2	2	0	1	5	1	4	3.8	0	0	0	0	0	0	0	0	0	0	0;
	607	0.8	0	0	0	1	1	1	0.8	0.76	0	0	0	0	0	0	0	0	0	0	0;
	612	152.955	70.2917	120	0	1	256	1	200	70	0	0	0	0	0	0	0	0	0	0	0;
	613	200	94.9498	120	0	1	256	1	200	70	0	0	0	0	0	0	0	0	0	0	0;
	615	1.4	1	1	0	1	2	1	1.4	1.33	0	0	0	0	0	0	0	0	0	0	0;
	623	7.6	5	5	0	1	9	1	7.6	7.22	0	0	0	0	0	0	0	0	0	0	0;
	639	9.6	4	4	0	1	12	1	9.6	9.12	0	0	0	0	0	0	0	0	0	0	0;
	651	4.7	2	2	0	1	6	1	4.7	4.47	0	0	0	0	0	0	0	0	0	0	0;
	654	1.4	0	1	0	1	2	1	1.4	1.33	0	0	0	0	0	0	0	0	0	0	0;
	664	6.2	6	6	0	1	7	1	6.2	5.89	0	0	0	0	0	0	0	0	0	0	0;
	670	2.7	0	2	0	1	3	1	2.7	2.57	0	0	0	0	0	0	0	0	0	0	0;
	674	1	0	0	0	1	1	1	1	0.95	0	0	0	0	0	0	0	0	0	0	0;
	688	70	18.0507	120	0	1	242	1	202	70	0	0	0	0	0	0	0	0	0	0	0;
	692	1.4	1	1	0	1	2	1	1.4	1.33	0	0	0	0	0	0	0	0	0	0	0;
	699	3.8	0	2	0	1	5	1	3.8	3.61	0	0	0	0	0	0	0	0	0	0	0;
	712	1.2	1	1	0	1	1	1	1.2	1.14	0	0	0	0	0	0	0	0	0	0	0;
	730	6.9	0	3	0	1	8	1	6.9	6.56	0	0	0	0	0	0	0	0	0	0	0;
	732	1.1	0	1	0	1	1	1	1.1	1.05	0	0	0	0	0	0	0	0	0	0	0;
	735	4.1	2	2	0	1	5	1	4.1	3.9	0	0	0	0	0	0	0	0	0	0	0;
	740	4	0	1	0	1	5	1	4	3.8	0	0	0	0	0	0	0	0	0	0	0;
	744	134	0	60	0	1	161	1	134	127.3	0	0	0	0	0	0	0	0	0	0	0;
	754	80	0.56718	30	0	1	54	1	80	10	0	0	0	0	0	0	0	0	0	0	0;
	755	85	14.8352	80	0	1	110	1	250	85	0	0	0	0	0	0	0	0	0	0	0;
	760	3.1	2	2	0	1	4	1	3.1	2.95	0	0	0	0	0	0	0	0	0	0	0;
	766	2.1	1	1	0	1	3	1	2.1	2	0	0	0	0	0	0	0	0	0	0	0;
	784	0.7	0	0	0	1	1	1	0.7	0.67	0	0	0	0	0	0	0	0	0	0	0;
	790	49.8	35	35	35	1	60	1	49.8	47.31	0	0	0	0	0	0	0	0	0	0	0;
	795	1.89	1	1	1	1	2	1	1.89	1.8	0	0	0	0	0	0	0	0	0	0	0;
	798	2.99	3	3	3	1	4	1	2.99	2.84	0	0	0	0	0	0	0	0	0	0	0;
	814	44.92	16.1224	42	0	1	54	1	44.92	42.67	0	0	0	0	0	0	0	0	0	0	0;
	834	55	81.2873	83	0	1	110	1	55	23	0	0	0	0	0	0	0	0	0	0	0;
	878	2.99	0	0	0	1	4	1	2.99	2.84	0	0	0	0	0	0	0	0	0	0	0;
	884	2.49	0	0	0	1	3	1	2.49	2.37	0	0	0	0	0	0	0	0	0	0	0;
	892	31.87	34.124	42	6	1	38	1	31.87	30.28	0	0	0	0	0	0	0	0	0	0	0;
	895	8.96	7	7	7	1	11	1	8.96	8.51	0	0	0	0	0	0	0	0	0	0	0;
	901	3.68	2	2	2	1	4	1	3.68	3.5	0	0	0	0	0	0	0	0	0	0	0;
	910	4.58	3	3	3	1	6	1	4.58	4.35	0	0	0	0	0	0	0	0	0	0	0;
	911	370	59.1031	224	0	1	415	1	370	280	0	0	0	0	0	0	0	0	0	0	0;
	912	370	67.4296	224	0	1	415	1	370	280	0	0	0	0	0	0	0	0	0	0	0;
	914	15.93	10	10	10	1	19	1	15.93	15.13	0	0	0	0	0	0	0	0	0	0	0;
	917	2.09	0	0	0	1	3	1	2.09	1.99	0	0	0	0	0	0	0	0	0	0	0;
	919	21.91	12	12	12	1	26	1	21.91	20.81	0	0	0	0	0	0	0	0	0	0	0;
	920	1.99	0	0	0	1	2	1	1.99	1.89	0	0	0	0	0	0	0	0	0	0	0;
	929	63.73	32.3057	50	29	1	77	1	63.73	60.54	0	0	0	0	0	0	0	0	0	0	0;
	959	2.49	1	1	1	1	3	1	2.49	2.37	0	0	0	0	0	0	0	0	0	0	0;
	968	0.7	0	0	0	1	1	1	0.7	0.67	0	0	0	0	0	0	0	0	0	0	0;
	993	3.98	1	1	1	1	5	1	3.98	3.78	0	0	0	0	0	0	0	0	0	0	0;
	994	1.99	1	1	1	1	2	1	1.99	1.89	0	0	0	0	0	0	0	0	0	0	0;
	995	20	38	38	0	1	60	1	100	20	0	0	0	0	0	0	0	0	0	0	0;
	996	20	12.3996	38	0	1	60	1	50	20	0	0	0	0	0	0	0	0	0	0	0;
	997	20	38	38	0	1	60	1	50	20	0	0	0	0	0	0	0	0	0	0	0;
	1004	4.28	3	3	3	1	5	1	4.28	4.07	0	0	0	0	0	0	0	0	0	0	0;
	1024	0.1	0	0	0	1	0	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0;
	1027	24.9	13	13	13	1	30	1	24.9	23.66	0	0	0	0	0	0	0	0	0	0	0;
	1028	2.99	3	3	3	1	4	1	2.99	2.84	0	0	0	0	0	0	0	0	0	0	0;
	1029	24.9	14	14	14	1	30	1	24.9	23.66	0	0	0	0	0	0	0	0	0	0	0;
	1053	59.76	30.2709	53	0	1	72	1	59.76	56.77	0	0	0	0	0	0	0	0	0	0	0;
	1054	29.88	31	31	0	1	36	1	29.88	28.39	0	0	0	0	0	0	0	0	0	0	0;
	1105	7.97	10	10	10	1	10	1	7.97	7.57	0	0	0	0	0	0	0	0	0	0	0;
	1106	22.91	13	13	13	1	28	1	22.91	21.76	0	0	0	0	0	0	0	0	0	0	0;
	1107	10.56	3	3	3	1	13	1	10.56	10.03	0	0	0	0	0	0	0	0	0	0	0;
	1138	44.82	41	41	0	1	54	1	44.82	42.58	0	0	0	0	0	0	0	0	0	0	0;
	1140	230	66.7193	199	-87	1	252	1	230	70	0	0	0	0	0	0	0	0	0	0	0;
	1141	94.917	48.8205	190	-89	1	251	1	225	70	0	0	0	0	0	0	0	0	0	0	0;
	1175	37.84	20	20	20	1	45	1	37.84	35.95	0	0	0	0	0	0	0	0	0	0	0;
	1182	40	12.325	125	-50	1	133	1	120	40	0	0	0	0	0	0	0	0	0	0	0;
	1183	120	19.5012	125	-50	1	133	1	120	40	0	0	0	0	0	0	0	0	0	0	0;
	1184	120	61.2682	125	-50	1	133	1	120	40	0	0	0	0	0	0	0	0	0	0	0;
	1191	106.56	23.6932	129	-47	1	128	1	106.56	101.23	0	0	0	0	0	0	0	0	0	0	0;
	1192	250	69.2945	125	-50	1	123	1	250	80	0	0	0	0	0	0	0	0	0	0	0;
	1201	99.59	0	90	0	1	120	1	99.59	94.61	0	0	0	0	0	0	0	0	0	0	0;
	1202	99.59	71.827	90	0	1	120	1	99.59	94.61	0	0	0	0	0	0	0	0	0	0	0;
	1203	99.59	44.4643	90	0	1	120	1	99.59	94.61	0	0	0	0	0	0	0	0	0	0	0;
	1232	51.79	25.1424	41	0	1	62	1	51.79	49.2	0	0	0	0	0	0	0	0	0	0	0;
	1233	14.94	19.5029	41	0	1	18	1	14.94	14.19	0	0	0	0	0	0	0	0	0	0	0;
	1244	18.92	20	20	20	1	23	1	18.92	17.97	0	0	0	0	0	0	0	0	0	0	0;
	1247	15.93	12	12	12	1	19	1	15.93	15.13	0	0	0	0	0	0	0	0	0	0	0;
	1250	197.19	65.5075	151	0	1	237	1	197.19	187.33	0	0	0	0	0	0	0	0	0	0	0;
	1268	0.5	0	0	0	1	1	1	0.5	0.48	0	0	0	0	0	0	0	0	0	0	0;
	1316	1	0	0	0	1	1	1	1	0.95	0	0	0	0	0	0	0	0	0	0	0;
	1325	1.39	0	0	0	1	2	1	1.39	1.32	0	0	0	0	0	0	0	0	0	0	0;
	1349	1.49	0	0	0	1	2	1	1.49	1.42	0	0	0	0	0	0	0	0	0	0	0;
	1356	1	2	2	2	1	1	1	1	0.95	0	0	0	0	0	0	0	0	0	0	0;
	1359	0.8	1	1	1	1	1	1	0.8	0.76	0	0	0	0	0	0	0	0	0	0	0;
	1393	12.75	0	11	0	1	15	1	12.75	12.11	0	0	0	0	0	0	0	0	0	0	0;
	1403	4.28	1	1	1	1	5	1	4.28	4.07	0	0	0	0	0	0	0	0	0	0	0;
	1416	371	29.1325	180	10	1	246	1	371	80	0	0	0	0	0	0	0	0	0	0	0;
	1417	120	34.9276	120	5	1	123	1	120	80	0	0	0	0	0	0	0	0	0	0	0;
	1418	20	32.5842	90	5	1	123	1	20	5	0	0	0	0	0	0	0	0	0	0	0;
	1426	495	38.8902	68	27	1	106	1	495	20	0	0	0	0	0	0	0	0	0	0	0;
	1429	0.2	0	0	0	1	0	1	0.2	0.19	0	0	0	0	0	0	0	0	0	0	0;
	1469	0.6	0	0	0	1	1	1	0.6	0.57	0	0	0	0	0	0	0	0	0	0	0;
	1475	2.09	2	2	2	1	3	1	2.09	1.99	0	0	0	0	0	0	0	0	0	0	0;
	1504	31.17	2	2	2	1	37	1	31.17	29.61	0	0	0	0	0	0	0	0	0	0	0;
	1505	48.8	4	4	4	1	59	1	48.8	46.36	0	0	0	0	0	0	0	0	0	0	0;
	1514	2.29	1	1	1	1	3	1	2.29	2.18	0	0	0	0	0	0	0	0	0	0	0;
	1534	0.3	0	0	0	1	0	1	0.3	0.29	0	0	0	0	0	0	0	0	0	0	0;
	1536	160	45.7739	190	-89	1	251	1	225	160	0	0	0	0	0	0	0	0	0	0	0;
	1537	225	71.9112	203	-95	1	255	1	225	160	0	0	0	0	0	0	0	0	0	0	0;
	1538	215	40.2171	190	-89	1	255	1	215	70	0	0	0	0	0	0	0	0	0	0	0;
	1542	8.96	3	3	3	1	11	1	8.96	8.51	0	0	0	0	0	0	0	0	0	0	0;
	1543	1.2	0	0	0	1	1	1	1.2	1.14	0	0	0	0	0	0	0	0	0	0	0;
	1550	1.79	1	1	1	1	2	1	1.79	1.7	0	0	0	0	0	0	0	0	0	0	0;
	1566	54.77	22.117	47	20	1	66	1	54.77	52.03	0	0	0	0	0	0	0	0	0	0	0;
	1587	63.74	27	27	27	1	77	1	63.74	60.55	0	0	0	0	0	0	0	0	0	0	0;
	1600	17.43	3	3	3	1	21	1	17.43	16.56	0	0	0	0	0	0	0	0	0	0	0;
	1602	120	18.6395	90	0	1	144	1	120	40	0	0	0	0	0	0	0	0	0	0	0;
	1603	120	58.0213	90	0	1	144	1	120	40	0	0	0	0	0	0	0	0	0	0	0;
	1609	0.3	0	0	0	1	0	1	0.3	0.29	0	0	0	0	0	0	0	0	0	0	0;
	1617	2	0	0	0	1	2	1	2	1.9	0	0	0	0	0	0	0	0	0	0	0;
	1620	1.6	0	0	0	1	2	1	1.6	1.52	0	0	0	0	0	0	0	0	0	0	0;
	1627	1.6	0	0	0	1	2	1	1.6	1.52	0	0	0	0	0	0	0	0	0	0	0;
	1630	0.5	0	0	0	1	1	1	0.5	0.48	0	0	0	0	0	0	0	0	0	0	0;
	1635	0.1	0	0	0	1	0	1	0.1	0.1	0	0	0	0	0	0	0	0	0	0	0;
	1638	30	10	10	0	1	36	1	30	28.5	0	0	0	0	0	0	0	0	0	0	0;
	1664	150	13.0887	120	0	1	180	1	150	142.5	0	0	0	0	0	0	0	0	0	0	0;
	1669	51	16	16	0	1	61	1	51	48.45	0	0	0	0	0	0	0	0	0	0	0;
	1673	50	77.2214	85	0	1	60	1	50	47.5	0	0	0	0	0	0	0	0	0	0	0;
	1674	90	90	90	0	1	108	1	90	85.5	0	0	0	0	0	0	0	0	0	0	0;
	1679	3	0	0	0	1	4	1	3	2.85	0	0	0	0	0	0	0	0	0	0	0;
	1683	2.3	0	0	0	1	3	1	2.3	2.19	0	0	0	0	0	0	0	0	0	0	0;
	1685	3	0	0	0	1	4	1	3	2.85	0	0	0	0	0	0	0	0	0	0	0;
	1686	50	20	20	0	1	60	1	50	47.5	0	0	0	0	0	0	0	0	0	0	0;
	1698	2.8	0	0	0	1	3	1	2.8	2.66	0	0	0	0	0	0	0	0	0	0	0;
	1700	0.5	0	0	0	1	1	1	0.5	0.48	0	0	0	0	0	0	0	0	0	0	0;
	1706	15	0	0	0	1	18	1	15	14.25	0	0	0	0	0	0	0	0	0	0	0;
	1710	3	0	0	0	1	4	1	3	2.85	0	0	0	0	0	0	0	0	0	0	0;
	1712	110	71.1308	90	0	1	132	1	110	104.5	0	0	0	0	0	0	0	0	0	0	0;
	1717	2.1	0	0	0	1	3	1	2.1	2	0	0	0	0	0	0	0	0	0	0	0;
	1719	1.8	0	0	0	1	2	1	1.8	1.71	0	0	0	0	0	0	0	0	0	0	0;
	1726	3.5	0	0	0	1	4	1	3.5	3.33	0	0	0	0	0	0	0	0	0	0	0;
	1728	2.7	0	0	0	1	3	1	2.7	2.57	0	0	0	0	0	0	0	0	0	0	0;
	1730	1.4	0	0	0	1	2	1	1.4	1.33	0	0	0	0	0	0	0	0	0	0	0;
	1734	0.8	0	0	0	1	1	1	0.8	0.76	0	0	0	0	0	0	0	0	0	0	0;
	1735	5	2	2	0	1	6	1	5	4.75	0	0	0	0	0	0	0	0	0	0	0;
	1739	3	0	0	0	1	4	1	3	2.85	0	0	0	0	0	0	0	0	0	0	0;
	1742	0.4	0	0	0	1	1	1	0.4	0.38	0	0	0	0	0	0	0	0	0	0	0;
	1749	6	0	0	0	1	7	1	6	5.7	0	0	0	0	0	0	0	0	0	0	0;
	1758	1.7	0	0	0	1	2	1	1.7	1.62	0	0	0	0	0	0	0	0	0	0	0;
	1760	55	12	12	0	1	30	1	55	20	0	0	0	0	0	0	0	0	0	0	0;
	1761	78	22	22	0	1	72	1	78	30	0	0	0	0	0	0	0	0	0	0	0;
	1763	50	12	12	0	1	48	1	50	20	0	0	0	0	0	0	0	0	0	0	0;
	1764	20	8.4016	12	0	1	48	1	50	20	0	0	0	0	0	0	0	0	0	0	0;
	1768	4	0	0	0	1	5	1	4	3.8	0	0	0	0	0	0	0	0	0	0	0;
	1788	3.3	0	0	0	1	4	1	3.3	3.14	0	0	0	0	0	0	0	0	0	0	0;
	1793	3	0	0	0	1	4	1	3	2.85	0	0	0	0	0	0	0	0	0	0	0;
	1799	1.5	0	0	0	1	2	1	1.5	1.43	0	0	0	0	0	0	0	0	0	0	0;
	1807	2.6	0	0	0	1	3	1	2.6	2.47	0	0	0	0	0	0	0	0	0	0	0;
	1844	1.2	0	0	0	1	1	1	1.2	1.14	0	0	0	0	0	0	0	0	0	0	0;
	1845	1.2	0	0	0	1	1	1	1.2	1.14	0	0	0	0	0	0	0	0	0	0	0;
	1870	1.2	0	0	0	1	1	1	1.2	1.14	0	0	0	0	0	0	0	0	0	0	0;
	1871	0.6	0	0	0	1	1	1	0.6	0.57	0	0	0	0	0	0	0	0	0	0	0;
	1874	4	0	0	0	1	5	1	4	3.8	0	0	0	0	0	0	0	0	0	0	0;
	1875	0.5	0	0	0	1	1	1	0.5	0.48	0	0	0	0	0	0	0	0	0	0	0;
	1882	200	35.5952	120	0	1	240	1	200	70	0	0	0	0	0	0	0	0	0	0	0;
	1883	200	101.199	120	0	1	218	1	200	70	0	0	0	0	0	0	0	0	0	0	0;
	1894	1.5	0	0	0	1	2	1	1.5	1.43	0	0	0	0	0	0	0	0	0	0	0;
	1895	0.3	0	0	0	1	0	1	0.3	0.29	0	0	0	0	0	0	0	0	0	0	0;
	1904	17	0	0	0	1	20	1	17	16.15	0	0	0	0	0	0	0	0	0	0	0;
	1918	6	2	2	0	1	7	1	6	5.7	0	0	0	0	0	0	0	0	0	0	0;
	1921	50.7	15	15	0	1	61	1	50.7	48.17	0	0	0	0	0	0	0	0	0	0	0;
	1932	2.5	0	0	0	1	3	1	2.5	2.38	0	0	0	0	0	0	0	0	0	0	0;
	1940	2	0	0	0	1	2	1	2	1.9	0	0	0	0	0	0	0	0	0	0	0;
	1947	6	0	0	0	1	7	1	6	5.7	0	0	0	0	0	0	0	0	0	0	0;
	1960	1.5	0	0	0	1	2	1	1.5	1.43	0	0	0	0	0	0	0	0	0	0	0;
	1961	0.6	0	0	0	1	1	1	0.6	0.57	0	0	0	0	0	0	0	0	0	0	0;
	1962	0.6	0	0	0	1	1	1	0.6	0.57	0	0	0	0	0	0	0	0	0	0	0;
	1964	0.5	0	0	0	1	1	1	0.5	0.48	0	0	0	0	0	0	0	0	0	0	0;
	1966	2.9	0	0	0	1	4	1	2.9	2.76	0	0	0	0	0	0	0	0	0	0	0;
	1970	2	0	0	0	1	2	1	2	1.9	0	0	0	0	0	0	0	0	0	0	0;
	1974	3.5	0	0	0	1	4	1	3.5	3.33	0	0	0	0	0	0	0	0	0	0	0;
	1976	2.8	0	0	0	1	3	1	2.8	2.66	0	0	0	0	0	0	0	0	0	0	0;
	1977	3	0	0	0	1	4	1	3	2.85	0	0	0	0	0	0	0	0	0	0	0;
	1993	2.6	0	0	0	1	3	1	2.6	2.47	0	0	0	0	0	0	0	0	0	0	0;
	1995	21	8	8	0	1	25	1	21	19.95	0	0	0	0	0	0	0	0	0	0	0;
	1996	0.2	0	0	0	1	0	1	0.2	0.19	0	0	0	0	0	0	0	0	0	0	0;
	1998	0.4	0	0	0	1	1	1	0.4	0.38	0	0	0	0	0	0	0	0	0	0	0;
	2010	200	42.3885	120	0	1	240	1	200	190	0	0	0	0	0	0	0	0	0	0	0;
	2021	83.4	65.4069	80	0	1	100	1	83.4	79.23	0	0	0	0	0	0	0	0	0	0	0;
	2022	81	75.9589	80	0	1	97	1	81	76.95	0	0	0	0	0	0	0	0	0	0	0;
	2026	25	10	10	0	1	30	1	25	23.75	0	0	0	0	0	0	0	0	0	0	0;
	2027	12	0	0	0	1	14	1	12	11.4	0	0	0	0	0	0	0	0	0	0	0;
	2033	5.6	0	0	0	1	7	1	5.6	5.32	0	0	0	0	0	0	0	0	0	0	0;
	2034	0.5	0	0	0	1	1	1	0.5	0.48	0	0	0	0	0	0	0	0	0	0	0;
	2036	0.4	0	0	0	1	1	1	0.4	0.38	0	0	0	0	0	0	0	0	0	0	0;
	2046	1	0	0	0	1	1	1	1	0.95	0	0	0	0	0	0	0	0	0	0	0;
	2085	0.3	0	0	0	1	0	1	0.3	0.29	0	0	0	0	0	0	0	0	0	0	0;
	2088	0.5	0	0	0	1	1	1	0.5	0.48	0	0	0	0	0	0	0	0	0	0	0;
	2099	18	20	20	0	1	22	1	18	17.1	0	0	0	0	0	0	0	0	0	0	0;
	2106	1	0	0	0	1	1	1	1	0.95	0	0	0	0	0	0	0	0	0	0	0;
	2107	3	0	0	0	1	4	1	3	2.85	0	0	0	0	0	0	0	0	0	0	0;
	2108	0.6	0	0	0	1	1	1	0.6	0.57	0	0	0	0	0	0	0	0	0	0	0;
	2115	2.4	0	0	0	1	3	1	2.4	2.28	0	0	0	0	0	0	0	0	0	0	0;
	2119	110	20	20	0	1	132	1	110	104.5	0	0	0	0	0	0	0	0	0	0	0;
	2121	1	0	0	0	1	1	1	1	0.95	0	0	0	0	0	0	0	0	0	0	0;
	2127	2.2	1	1	0	1	3	1	2.2	2.09	0	0	0	0	0	0	0	0	0	0	0;
	2138	50	10	10	0	1	60	1	50	47.5	0	0	0	0	0	0	0	0	0	0	0;
	2139	40	8	8	0	1	48	1	40	38	0	0	0	0	0	0	0	0	0	0	0;
	2140	7.7	1	1	0	1	9	1	7.7	7.32	0	0	0	0	0	0	0	0	0	0	0;
	2153	0.7	0	0	0	1	1	1	0.7	0.67	0	0	0	0	0	0	0	0	0	0	0;
	2159	12	54.4934	999	-999	1	14	1	12	11.4	0	0	0	0	0	0	0	0	0	0	0;
	2164	4.1	0	1	0	1	5	1	4.1	3.9	0	0	0	0	0	0	0	0	0	0	0;
	2167	90	20	20	0	1	108	1	90	85.5	0	0	0	0	0	0	0	0	0	0	0;
	2168	50	8	8	0	1	60	1	50	47.5	0	0	0	0	0	0	0	0	0	0	0;
	2171	6.5	1	1	0	1	8	1	6.5	6.18	0	0	0	0	0	0	0	0	0	0	0;
	2194	10	4	4	0	1	12	1	10	9.5	0	0	0	0	0	0	0	0	0	0	0;
	2197	27	18	18	0	1	32	1	27	25.65	0	0	0	0	0	0	0	0	0	0	0;
	2204	26	10	10	0	1	31	1	26	24.7	0	0	0	0	0	0	0	0	0	0	0;
	2213	2.6	0	1	0	1	3	1	2.6	2.47	0	0	0	0	0	0	0	0	0	0	0;
	2217	4	1	1	0	1	5	1	4	3.8	0	0	0	0	0	0	0	0	0	0	0;
	2218	1.5	0	0	0	1	2	1	1.5	1.43	0	0	0	0	0	0	0	0	0	0	0;
	2221	49	98.1831	999	-999	1	59	1	49	46.55	0	0	0	0	0	0	0	0	0	0	0;
	2225	1.6	0	0	0	1	2	1	1.6	1.52	0	0	0	0	0	0	0	0	0	0	0;
	2234	2.7	1	1	0	1	3	1	2.7	2.57	0	0	0	0	0	0	0	0	0	0	0;
	2237	16.5	18	18	0	1	20	1	16.5	15.68	0	0	0	0	0	0	0	0	0	0	0;
	2248	2	1	1	0	1	2	1	2	1.9	0	0	0	0	0	0	0	0	0	0	0;
	2268	1.8	0	0	0	1	2	1	1.8	1.71	0	0	0	0	0	0	0	0	0	0	0;
	2271	2.4	0	0	0	1	3	1	2.4	2.28	0	0	0	0	0	0	0	0	0	0	0;
	2272	10	4	4	0	1	12	1	10	9.5	0	0	0	0	0	0	0	0	0	0	0;
	2273	6.3	2	2	0	1	8	1	6.3	5.99	0	0	0	0	0	0	0	0	0	0	0;
	2278	1.5	0	0	0	1	2	1	1.5	1.43	0	0	0	0	0	0	0	0	0	0	0;
	2290	0.2	0	0	0	1	0	1	0.2	0.19	0	0	0	0	0	0	0	0	0	0	0;
	2293	2.5	1	1	0	1	3	1	2.5	2.38	0	0	0	0	0	0	0	0	0	0	0;
	2294	1	1	1	0	1	1	1	1	0.95	0	0	0	0	0	0	0	0	0	0	0;
	2296	13.5	4	4	0	1	16	1	13.5	12.83	0	0	0	0	0	0	0	0	0	0	0;
	2298	0.4	0	0	0	1	1	1	0.4	0.38	0	0	0	0	0	0	0	0	0	0	0;
	2307	0.4	0	0	0	1	1	1	0.4	0.38	0	0	0	0	0	0	0	0	0	0	0;
	2323	1.1	0	0	0	1	1	1	1.1	1.05	0	0	0	0	0	0	0	0	0	0	0;
	2328	3	1	1	0	1	4	1	3	2.85	0	0	0	0	0	0	0	0	0	0	0;
	2330	0.3	0	0	0	1	0	1	0.3	0.29	0	0	0	0	0	0	0	0	0	0	0;
	2336	55	41	41	0	1	66	1	55	52.25	0	0	0	0	0	0	0	0	0	0	0;
	2339	17	6	6	0	1	20	1	17	16.15	0	0	0	0	0	0	0	0	0	0	0;
	2361	51	10	10	0	1	61	1	51	48.45	0	0	0	0	0	0	0	0	0	0	0;
	2372	37	19	19	0	1	44	1	37	35.15	0	0	0	0	0	0	0	0	0	0	0;
	2376	2	1	1	0	1	2	1	2	1.9	0	0	0	0	0	0	0	0	0	0	0;
	2379	7	2	2	0	1	8	1	7	6.65	0	0	0	0	0	0	0	0	0	0	0;
	2380	50	-18	22	-18	1	60	1	50	47.5	0	0	0	0	0	0	0	0	0	0	0;
	2381	50	-13.4913	22	-18	1	60	1	50	47.5	0	0	0	0	0	0	0	0	0	0	0;
];

%% branch data
%	fbus	tbus	r	x	b	rateA	rateB	rateC	ratio	angle	status	angmin	angmax
mpc.branch = [
	16	1	0.00155	0.01169	0.0182	160	160	160	0	0	1	-360	360;
	355	1	0.00157	0.06612	0	160	160	160	1.0099	0	1	-360	360;
	17	2	0.00155	0.01169	0.0182	160	160	160	0	0	1	-360	360;
	354	2	0.00157	0.06612	0	160	160	160	1.022	0	1	-360	360;
	10	3	0.01068	0.07895	0.1226	274	274	274	0	0	1	-360	360;
	219	3	0.00165	0.06736	0	160	160	160	1.027	0	1	-360	360;
	220	3	0.00165	0.06736	0	160	160	160	0.9955	0	1	-360	360;
	7	4	0.01674	0.09711	0.14423	377	377	377	0	0	1	-360	360;
	11	4	0.00293	0.01599	0.02478	335	335	335	0	0	1	-360	360;
	14	4	0.00442	0.03223	0.04985	464	464	464	0	0	1	-360	360;
	16	4	0.00888	0.06665	0.08896	377	377	377	0	0	1	-360	360;
	22	4	0.00783	0.043	0.04962	350	350	350	0	0	1	-360	360;
	245	4	0.00165	0.06901	0	160	160	160	1.0594	0	1	-360	360;
	246	4	0.00165	0.06901	0	160	160	160	1.0448	0	1	-360	360;
	5	6	0.00064	0.0305	0	400	400	400	1.0435	-0.6	1	-360	360;
	7	5	0.00525	0.03988	0.06195	381	381	381	0	0	1	-360	360;
	10	5	0.01459	0.11219	0.16553	381	381	381	0	0	1	-360	360;
	309	5	0.00165	0.0686	0	160	160	160	1.0646	0	1	-360	360;
	309	5	0.00165	0.0686	0	160	160	160	1.0523	0	1	-360	360;
	6	8	0.00112	0.01329	0.34125	1316	1316	1316	0	0	1	-360	360;
	6	9	0.00299	0.03675	0.9184	1427	1427	1427	0	0	1	-360	360;
	15	6	0.00298	0.03417	0.93504	1427	1427	1427	0	0	1	-360	360;
	31	6	0.0015	0.01506	0.4032	1385	1385	1385	0	0	1	-360	360;
	310	6	0.0015	0.06188	0	250	250	250	1.0613	0	1	-360	360;
	12	7	0.01211	0.08742	0.14017	381	381	381	0	0	1	-360	360;
	13	7	0.00205	0.01326	0.02243	335	335	335	0	0	1	-360	360;
	19	7	0.0057	0.0407	0.06021	323	323	323	0	0	1	-360	360;
	21	7	0.00093	0.00651	0.01113	160	160	160	0	0	1	-360	360;
	29	7	0.01269	0.07498	0.1302	362	362	362	0	0	1	-360	360;
	321	7	0.00041	0.03368	0	250	250	250	1.0323	0	1	-360	360;
	322	7	0.00165	0.06775	0	160	160	160	1.0569	0	1	-360	360;
	8	18	0.00336	0.03977	1.02163	1316	1316	1316	0	0	1	-360	360;
	332	9	0.00087	0.05244	-0.02144	330	330	330	1.0781	0	1	-360	360;
	171	10	0.01409	0.10413	0.15972	464	464	464	0	0	1	-360	360;
	346	10	0.00124	0.06839	0	160	160	160	1.0054	0	1	-360	360;
	347	10	0.00124	0.06839	0	160	160	160	1.024	0	1	-360	360;
	16	11	0.0057	0.03952	0.07553	464	464	464	0	0	1	-360	360;
	17	11	0.0057	0.03952	0.07553	464	464	464	0	0	1	-360	360;
	111	11	0.01068	0.06196	0.09496	394	394	394	0	0	1	-360	360;
	352	11	0.00165	0.06901	0	160	160	160	1.0412	0	1	-360	360;
	353	11	0.00165	0.06901	0	160	160	160	1.0559	0	1	-360	360;
	140	12	0.01465	0.10589	0.17085	464	464	464	0	0	1	-360	360;
	359	12	0.00155	0.06612	0	160	160	160	1.0395	0	1	-360	360;
	360	12	0.00157	0.06612	0	160	160	160	1.059	0	1	-360	360;
	29	13	0.01345	0.08114	0.14113	339	339	339	0	0	1	-360	360;
	365	13	0.00165	0.06901	0	160	160	160	1.0312	0	1	-360	360;
	366	13	0.00165	0.06901	0	160	160	160	0.9872	0	1	-360	360;
	17	14	0.00384	0.02853	0.04588	464	464	464	0	0	1	-360	360;
	367	14	0.00157	0.06798	0	160	160	160	1.0664	0	1	-360	360;
	368	14	0.00165	0.06901	0	160	160	160	1.0777	0	1	-360	360;
	18	15	0.00358	0.04262	1.0944	1662	1662	1662	0	0	1	-360	360;
	15	165	0.00207	0.02474	0.664	831	831	831	0	0	1	-360	360;
	374	15	0.0015	0.06188	0	250	250	250	1.1502	0	1	-360	360;
	16	18	0.00036	0.02519	0	500	500	500	1.0605	0	1	-360	360;
	16	73	0.00909	0.0624	0.11142	464	464	464	0	0	1	-360	360;
	17	18	0.00036	0.02519	0	500	500	500	1.0607	0	1	-360	360;
	17	74	0.00868	0.06405	0.09699	464	464	464	0	0	1	-360	360;
	20	18	0.00063	0.00749	0.39226	1427	1427	1427	0	0	1	-360	360;
	75	18	0.00219	0.02369	0.59584	1434	1434	1434	0	0	1	-360	360;
	18	76	0.00137	0.01625	0.41184	1662	1662	1662	0	0	1	-360	360;
	18	101	0.00231	0.02769	0.70144	1662	1662	1662	0	0	1	-360	360;
	124	19	0.01696	0.12366	0.19699	464	464	464	0	0	1	-360	360;
	425	19	0.00165	0.06818	0	160	160	160	1.0241	0	1	-360	360;
	67	20	0.00331	0.03425	0.85888	831	831	831	0	0	1	-360	360;
	447	20	0.00137	0.06119	-0.01504	250	250	250	1.0796	0	1	-360	360;
	448	20	0.00137	0.06119	-0.01504	250	250	250	1.0923	0	1	-360	360;
	502	21	0.00165	0.07107	0	160	160	160	0.9922	0	1	-360	360;
	112	22	0.00465	0.02618	0.02962	362	362	362	0	0	1	-360	360;
	526	22	0.00165	0.06901	0	160	160	160	1.0685	0	1	-360	360;
	527	22	0.00165	0.06901	0	160	160	160	1.0424	0	1	-360	360;
	37	23	0.01163	0.07031	0.1058	394	394	394	0	0	1	-360	360;
	46	23	0.00837	0.04868	0.07348	457	457	457	0	0	1	-360	360;
	53	23	0.01122	0.06558	0.09835	274	274	274	0	0	1	-360	360;
	540	23	0.0014	0.0668	0	160	160	160	1.0182	0	1	-360	360;
	54	24	0.00769	0.05727	0.08789	160	160	160	0	0	1	-360	360;
	545	24	0.00151	0.06715	0	160	160	160	1.0161	0	1	-360	360;
	41	25	0.00556	0.04145	0.0636	274	274	274	0	0	1	-360	360;
	53	25	0.00452	0.03368	0.05169	464	464	464	0	0	1	-360	360;
	54	25	0.00019	0.0014	0.00213	464	464	464	0	0	1	-360	360;
	564	25	0.00157	0.07808	0	160	160	160	1.0276	0	1	-360	360;
	38	26	0.00698	0.05196	0.07967	160	160	160	0	0	1	-360	360;
	568	26	0.00149	0.06616	0	160	160	160	1.013	0	1	-360	360;
	28	27	0	0.0001	0	876	876	876	0	0	1	-360	360;
	33	27	0.0024	0.01494	0.02253	160	160	160	0	0	1	-360	360;
	48	27	0.01213	0.06215	0.09371	362	362	362	0	0	1	-360	360;
	27	74	0.01116	0.07231	0.10367	304	304	304	0	0	1	-360	360;
	47	28	0.00248	0.01798	0.02759	464	464	464	0	0	1	-360	360;
	28	88	0.01488	0.08161	0.1148	362	362	362	0	0	1	-360	360;
	30	29	0	0.0001	0	876	876	876	0	0	1	-360	360;
	29	32	0.00034	0.02097	0	500	500	500	1.0619	0	1	-360	360;
	45	29	0.00545	0.04021	0.06699	464	464	464	0	0	1	-360	360;
	48	29	0.00574	0.04283	0.06573	464	464	464	0	0	1	-360	360;
	613	29	0.00157	0.06775	0	160	160	160	1.0016	0	1	-360	360;
	46	30	0.00545	0.04021	0.06699	464	464	464	0	0	1	-360	360;
	49	30	0.00707	0.04541	0.06931	362	362	362	0	0	1	-360	360;
	32	31	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	39	31	0.00176	0.02144	0.57344	1385	1385	1385	0	0	1	-360	360;
	36	32	0.00167	0.0189	0.54176	498	498	498	0	0	1	-360	360;
	615	33	0.00163	0.06946	0	160	160	160	1.0291	0	1	-360	360;
	35	34	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	34	51	0.00113	0.01406	0.37488	1385	1385	1385	0	0	1	-360	360;
	183	34	0.00188	0.02287	0.6432	1385	1385	1385	0	0	1	-360	360;
	183	35	0.00188	0.02287	0.6432	1385	1385	1385	0	0	1	-360	360;
	617	35	0.00135	0.06052	0	250	250	250	1.0654	0	1	-360	360;
	644	36	0.00135	0.06052	0	250	250	250	1.1003	0	1	-360	360;
	645	36	0.00153	0.06156	0	250	250	250	1.0971	0	1	-360	360;
	38	37	0	0.0001	0	876	876	876	0	0	1	-360	360;
	663	37	0.00157	0.06616	0	160	160	160	1.0009	0	1	-360	360;
	55	38	0.00316	0.02076	0.03146	394	394	394	0	0	1	-360	360;
	40	39	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	682	39	0.00139	0.05984	0	250	250	250	1.0603	0	1	-360	360;
	44	40	0.00109	0.01277	0.34176	1385	1385	1385	0	0	1	-360	360;
	679	40	0.0014	0.06235	0	250	250	250	1.0996	0	1	-360	360;
	42	41	0	0.0001	0	876	876	876	0	0	1	-360	360;
	41	43	0.00081	0.03	0	400	400	400	1.0377	0	1	-360	360;
	80	41	0.00372	0.0438	0.10096	609	609	609	0	0	1	-360	360;
	47	42	0.00882	0.06564	0.10066	274	274	274	0	0	1	-360	360;
	54	42	0.00355	0.02643	0.04056	392	392	392	0	0	1	-360	360;
	689	42	0.00145	0.06839	0	160	160	160	1.0037	0	1	-360	360;
	44	43	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	99	43	0.00169	0.01994	0.50624	831	831	831	0	0	1	-360	360;
	50	44	0.00094	0.01097	0.29376	1662	1662	1662	0	0	1	-360	360;
	46	45	0	0.0001	0	876	876	876	0	0	1	-360	360;
	49	45	0.01048	0.06097	0.09205	394	394	394	0	0	1	-360	360;
	706	47	0.00157	0.06775	0	160	160	160	1.0249	0	1	-360	360;
	707	47	0.00165	0.06775	0	160	160	160	1.0201	0	1	-360	360;
	49	48	0	0.0001	0	876	876	876	0	0	1	-360	360;
	717	48	0.00163	0.06783	0	160	160	160	1.023	0	1	-360	360;
	716	49	0.00143	0.06831	0	160	160	160	1.0238	0	1	-360	360;
	51	50	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	98	50	0.0015	0.01788	0.4512	831	831	831	0	0	1	-360	360;
	100	50	0.00469	0.05544	1.4048	831	831	831	0	0	1	-360	360;
	726	50	0.00139	0.0608	0	250	250	250	1.0815	0	1	-360	360;
	727	51	0.0014	0.06235	0	250	250	250	1.0819	0	1	-360	360;
	53	52	0.00151	0.00878	0.01316	160	160	160	0	0	1	-360	360;
	754	52	0.00163	0.06754	0	160	160	160	1.0317	0	1	-360	360;
	181	55	0.01434	0.08353	0.12603	394	394	394	0	0	1	-360	360;
	778	55	0.00161	0.06762	0	160	160	160	0.9979	0	1	-360	360;
	74	56	0.00207	0.01281	0.02052	394	394	394	0	0	1	-360	360;
	796	56	0.00207	0.06777	-0.003	160	160	160	1.0389	0	1	-360	360;
	81	57	0.00083	0.00496	0.00726	137	137	137	0	0	1	-360	360;
	80	58	0.00083	0.00496	0.00726	137	137	137	0	0	1	-360	360;
	63	59	0.00207	0.01405	0.02265	362	362	362	0	0	1	-360	360;
	82	59	0.01116	0.07045	0.11606	362	362	362	0	0	1	-360	360;
	821	59	0.00165	0.06798	-0.00319	160	160	160	1.0178	0	1	-360	360;
	60	85	0.01095	0.0593	0.08441	362	362	362	0	0	1	-360	360;
	104	60	0.00599	0.04091	0.07212	464	464	464	0	0	1	-360	360;
	834	60	0.00145	0.06921	-0.00532	160	160	160	0.9936	0	1	-360	360;
	836	60	0.00372	0.12583	-0.00242	100	100	100	1.0154	0	1	-360	360;
	62	61	0	0.0001	0	876	876	876	0	0	1	-360	360;
	64	61	0.00517	0.03843	0.05876	464	464	464	0	0	1	-360	360;
	109	61	0.00083	0.0062	0.00958	464	464	464	0	0	1	-360	360;
	184	61	0.01219	0.07066	0.11742	274	274	274	0	0	1	-360	360;
	82	62	0.00165	0.01095	0.01955	464	464	464	0	0	1	-360	360;
	110	62	0.00083	0.0062	0.00949	464	464	464	0	0	1	-360	360;
	71	63	0.00475	0.03079	0.04879	362	362	362	0	0	1	-360	360;
	91	63	0.00455	0.02769	0.04608	394	394	394	0	0	1	-360	360;
	94	63	0.00186	0.0126	0.02236	464	464	464	0	0	1	-360	360;
	96	63	0.00826	0.04236	0.06118	362	362	362	0	0	1	-360	360;
	64	69	0.00434	0.02975	0.05266	464	464	464	0	0	1	-360	360;
	79	64	0.00351	0.02438	0.03998	362	362	362	0	0	1	-360	360;
	93	64	0.00186	0.0126	0.02236	464	464	464	0	0	1	-360	360;
	95	64	0.00826	0.04236	0.06118	362	362	362	0	0	1	-360	360;
	90	65	0.00785	0.04132	0.06389	394	394	394	0	0	1	-360	360;
	65	91	0.00227	0.01446	0.02585	394	394	394	0	0	1	-360	360;
	66	67	0.00031	0.02094	0	500	500	500	1.0616	0	1	-360	360;
	66	68	0.00248	0.02355	0.04763	457	457	457	0	0	1	-360	360;
	152	66	0.01033	0.08285	0.13959	464	464	464	0	0	1	-360	360;
	138	67	0.00194	0.02056	0.51584	866	866	866	0	0	1	-360	360;
	911	67	0.00156	0.06269	-0.00992	250	250	250	1.0656	0	1	-360	360;
	912	67	0.00156	0.06269	-0.00992	250	250	250	1.066	0	1	-360	360;
	68	78	0.00579	0.04153	0.06621	464	464	464	0	0	1	-360	360;
	978	68	0.00165	0.06694	-0.0031	160	160	160	1.0083	0	1	-360	360;
	979	68	0.00145	0.06653	-0.00319	160	160	160	1.006	0	1	-360	360;
	83	69	0.00145	0.00992	0.01762	464	464	464	0	0	1	-360	360;
	995	69	0.00145	0.0655	-0.00252	160	160	160	1.0107	0	1	-360	360;
	996	69	0.00145	0.07045	-0.00252	160	160	160	1.0025	0	1	-360	360;
	70	73	0.00145	0.00971	0.01626	457	457	457	0	0	1	-360	360;
	107	70	0.00062	0.00413	0.00697	457	457	457	0	0	1	-360	360;
	72	71	0	0.0001	0	876	876	876	0	0	1	-360	360;
	86	71	0.00165	0.00971	0.01423	362	362	362	0	0	1	-360	360;
	1059	71	0.00145	0.06983	-0.00232	160	160	160	1.0193	0	1	-360	360;
	1060	71	0.00165	0.06777	-0.00281	160	160	160	0.9558	0	1	-360	360;
	73	75	0.00075	0.02444	-0.00832	330	330	330	1.0544	1.7	1	-360	360;
	87	73	0.00393	0.02851	0.04501	464	464	464	0	0	1	-360	360;
	74	76	0.00075	0.02469	-0.008	330	330	330	1.0606	1.7	1	-360	360;
	74	108	0.00083	0.00517	0.00871	464	464	464	0	0	1	-360	360;
	76	75	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	76	105	0.00244	0.02756	0.768	845	845	845	0	0	1	-360	360;
	84	77	0.00393	0.02665	0.04617	457	457	457	0	0	1	-360	360;
	85	77	0.00186	0.01384	0.02284	464	464	464	0	0	1	-360	360;
	1095	77	0.00165	0.06694	-0.0029	160	160	160	1.0162	0	1	-360	360;
	1096	77	0.00145	0.06736	-0.00658	160	160	160	1.0085	0	1	-360	360;
	78	103	0.00496	0.03368	0.05963	464	464	464	0	0	1	-360	360;
	1106	78	0.00145	0.06839	-0.00319	160	160	160	1.0272	0	1	-360	360;
	88	79	0.0031	0.02335	0.0362	464	464	464	0	0	1	-360	360;
	81	80	0	0.0001	0	876	876	876	0	0	1	-360	360;
	80	96	0.01591	0.0876	0.11684	362	362	362	0	0	1	-360	360;
	1114	80	0.00165	0.06694	-0.00232	160	160	160	0.9876	0	1	-360	360;
	93	81	0.01777	0.11674	0.16359	362	362	362	0	0	1	-360	360;
	1115	81	0.00165	0.06694	-0.00319	160	160	160	0.9847	0	1	-360	360;
	1138	82	0.00165	0.06756	-0.00319	160	160	160	1.0035	0	1	-360	360;
	1139	82	0.00145	0.06756	-0.00223	160	160	160	1.0148	0	1	-360	360;
	84	83	0	0.0001	0	876	876	876	0	0	1	-360	360;
	103	83	0.0031	0.02169	0.03843	464	464	464	0	0	1	-360	360;
	1141	83	0.00145	0.06653	-0.0029	160	160	160	1.0054	0	1	-360	360;
	184	84	0.01178	0.07087	0.11684	274	274	274	0	0	1	-360	360;
	1192	84	0.00165	0.0686	-0.0029	160	160	160	1.001	0	1	-360	360;
	86	85	0	0.0001	0	876	876	876	0	0	1	-360	360;
	1182	85	0.00207	0.0936	-0.00339	160	160	160	1.0033	0	1	-360	360;
	86	108	0.00537	0.0405	0.06002	464	464	464	0	0	1	-360	360;
	1184	86	0.00186	0.09277	-0.003	160	160	160	0.9967	0	1	-360	360;
	88	87	0	0.0001	0	876	876	876	0	0	1	-360	360;
	94	87	0.00599	0.03512	0.05237	362	362	362	0	0	1	-360	360;
	1213	87	0.00145	0.06715	-0.00223	160	160	160	1.0209	0	1	-360	360;
	89	94	0.00599	0.04153	0.07366	464	464	464	0	0	1	-360	360;
	102	89	0.00207	0.01343	0.02207	362	362	362	0	0	1	-360	360;
	1217	89	0.00145	0.0657	-0.00523	160	160	160	1.0212	0	1	-360	360;
	104	90	0.00455	0.0314	0.05489	464	464	464	0	0	1	-360	360;
	1244	90	0.00145	0.06756	-0.00348	160	160	160	0	0	1	-360	360;
	1343	91	0.00145	0.06756	-0.0029	160	160	160	1.0144	0	1	-360	360;
	100	92	0.00094	0.01038	0.28992	845	845	845	0	0	1	-360	360;
	92	106	0.00094	0.0105	0.2928	845	845	845	0	0	1	-360	360;
	1382	92	0.00156	0.06269	-0.00864	250	250	250	1.0686	0	1	-360	360;
	1384	92	0.00156	0.06294	-0.00864	250	250	250	1.0794	0	1	-360	360;
	94	93	0	0.0001	0	876	876	876	0	0	1	-360	360;
	1418	93	0.00145	0.06736	-0.00223	160	160	160	1.0031	0	1	-360	360;
	96	95	0	0.0001	0	876	876	876	0	0	1	-360	360;
	102	95	0.00455	0.02459	0.0362	362	362	362	0	0	1	-360	360;
	1426	96	0.00145	0.06674	-0.00658	160	160	160	1.0075	0	1	-360	360;
	1427	97	0.00041	0.01818	0	125	125	125	0.9996	0	1	-360	360;
	99	98	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	1502	98	0.00137	0.05988	-0.01504	250	250	250	1.1628	0	1	-360	360;
	101	99	0.00313	0.03562	0.99104	845	845	845	0	0	1	-360	360;
	101	100	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	1504	100	0.00137	0.06119	-0.00992	250	250	250	1.0798	0	1	-360	360;
	1505	101	0.00156	0.06269	-0.00992	250	250	250	1.0818	0	1	-360	360;
	1524	102	0.00165	0.06694	-0.003	160	160	160	1.0081	0	1	-360	360;
	104	103	0	0.0001	0	876	876	876	0	0	1	-360	360;
	103	106	0.0005	0.02875	-0.016	400	400	400	1.0641	0	1	-360	360;
	1536	103	0.00145	0.0686	-0.00232	160	160	160	1.0043	0	1	-360	360;
	1538	104	0.00165	0.06818	-0.0029	160	160	160	1.004	0	1	-360	360;
	106	105	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	105	185	0.00187	0.01763	0.4832	1108	1108	1108	0	0	1	-360	360;
	106	180	0.0015	0.01469	0.40384	1108	1108	1108	0	0	1	-360	360;
	108	107	0.00062	0.00496	0.00755	464	464	464	0	0	1	-360	360;
	1552	107	0.00145	0.06756	-0.00378	160	160	160	1.0333	0	1	-360	360;
	1553	107	0.00145	0.0655	-0.0029	160	160	160	1.0192	0	1	-360	360;
	112	111	0	0.0001	0	876	876	876	0	0	1	-360	360;
	123	111	0.00438	0.03188	0.05072	464	464	464	0	0	1	-360	360;
	124	111	0.00614	0.03252	0.05246	362	362	362	0	0	1	-360	360;
	1603	111	0.00165	0.0625	0	160	160	160	1.0034	0	1	-360	360;
	113	114	0.00506	0.03654	0.0636	304	304	304	0	0	1	-360	360;
	151	113	0.00221	0.01655	0.02478	304	304	304	0	0	1	-360	360;
	1623	113	0.00145	0.06818	0	160	160	160	1.0733	0	1	-360	360;
	1624	113	0.00165	0.06818	0	160	160	160	1.0618	0	1	-360	360;
	114	131	0.00583	0.04231	0.07066	464	464	464	0	0	1	-360	360;
	1647	114	0.00151	0.06688	0	160	160	160	1.0504	0	1	-360	360;
	116	115	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	133	115	0.00274	0.02696	0.70592	1385	1385	1385	0	0	1	-360	360;
	1649	115	0.00153	0.06206	0	250	250	250	1.1835	0	1	-360	360;
	138	116	0.0017	0.01733	0.45632	1385	1385	1385	0	0	1	-360	360;
	1650	116	0.00152	0.06206	0	250	250	250	1.1614	0	1	-360	360;
	140	117	0.01103	0.08057	0.12413	304	304	304	0	0	1	-360	360;
	143	117	0.00355	0.02593	0.04124	464	464	464	0	0	1	-360	360;
	1655	117	0.00151	0.06688	0	160	160	160	1.0335	0	1	-360	360;
	119	118	0	0.0001	0	876	876	876	0	0	1	-360	360;
	126	118	0.00647	0.0413	0.06921	464	464	464	0	0	1	-360	360;
	142	118	0.00105	0.00721	0.01028	464	464	464	0	0	1	-360	360;
	1680	118	0.00151	0.06688	0	160	160	160	1.0498	0	1	-360	360;
	125	120	0.01043	0.07789	0.12206	464	464	464	0	0	1	-360	360;
	130	120	0.01054	0.07686	0.12236	464	464	464	0	0	1	-360	360;
	1686	120	0.00161	0.06653	0	160	160	160	1.0639	0	1	-360	360;
	1687	120	0.00161	0.06653	0	160	160	160	1.0532	0	1	-360	360;
	122	121	0	0.0001	0	876	876	876	0	0	1	-360	360;
	151	121	0.00603	0.04401	0.06979	464	464	464	0	0	1	-360	360;
	1747	121	0.00145	0.06818	0	160	160	160	1.0226	0	1	-360	360;
	1748	121	0.00145	0.06818	0	160	160	160	1.028	0	1	-360	360;
	124	123	0	0.0001	0	876	876	876	0	0	1	-360	360;
	140	123	0.00048	0.00331	0.00571	464	464	464	0	0	1	-360	360;
	144	123	0.0186	0.09638	0.14094	362	362	362	0	0	1	-360	360;
	1760	123	0.00341	0.22521	0	80	80	80	0.9794	0	1	-360	360;
	1762	123	0.00165	0.06851	0	160	160	160	1.0321	0	1	-360	360;
	1764	123	0.00562	0.23161	0	80	80	80	0.9407	0	1	-360	360;
	139	124	0.00048	0.00331	0.00571	304	304	304	0	0	1	-360	360;
	1761	124	0.00341	0.2314	0	80	80	80	0.9794	0	1	-360	360;
	1763	124	0.00562	0.22624	0	80	80	80	0.9407	0	1	-360	360;
	126	125	0	0.0001	0	876	876	876	0	0	1	-360	360;
	135	125	0.00469	0.03465	0.05382	464	464	464	0	0	1	-360	360;
	186	125	0.00165	0.01591	0.04695	464	464	464	0	0	1	-360	360;
	1775	125	0.00163	0.06136	0.00416	160	160	160	1.0176	0	1	-360	360;
	126	127	0.00064	0.0305	0	400	400	400	1.0488	0	1	-360	360;
	186	126	0.00165	0.01591	0.04695	464	464	464	0	0	1	-360	360;
	128	127	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	157	127	0.00294	0.03463	0.9216	831	831	831	0	0	1	-360	360;
	145	128	0.00371	0.04326	1.18688	748	748	748	0	0	1	-360	360;
	143	129	0.00934	0.05225	0.0877	394	394	394	0	0	1	-360	360;
	129	148	0.01058	0.053	0.08848	394	394	394	0	0	1	-360	360;
	1814	129	0.00165	0.0593	0	160	160	160	1.0499	0	1	-360	360;
	130	132	0.01252	0.09136	0.14539	381	381	381	0	0	1	-360	360;
	130	154	0.00771	0.05696	0.08838	381	381	381	0	0	1	-360	360;
	1822	130	0.00165	0.0593	0	160	160	160	1.088	0	1	-360	360;
	1823	130	0.00165	0.0593	0	160	160	160	1.094	0	1	-360	360;
	132	131	0	0.0001	0	876	876	876	0	0	1	-360	360;
	131	133	0.00084	0.02756	0	330	330	330	1.1147	2.4	1	-360	360;
	147	131	0.01545	0.07335	0.12661	464	464	464	0	0	1	-360	360;
	151	131	0.01457	0.07955	0.14007	394	394	394	0	0	1	-360	360;
	1839	131	0.00165	0.09277	0	160	160	160	1.0343	0	1	-360	360;
	132	134	0.00084	0.02756	0	330	330	330	1.1147	2.4	1	-360	360;
	148	132	0.01545	0.07335	0.12661	464	464	464	0	0	1	-360	360;
	150	132	0.01457	0.07955	0.14007	394	394	394	0	0	1	-360	360;
	1840	132	0.00165	0.06694	0	160	160	160	1.0225	0	1	-360	360;
	134	133	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	182	133	0.00031	0.00338	0.0992	1385	1385	1385	0	0	1	-360	360;
	182	134	0.00031	0.00338	0.0992	1385	1385	1385	0	0	1	-360	360;
	136	135	0	0.0001	0	876	876	876	0	0	1	-360	360;
	142	135	0.0061	0.04483	0.07095	464	464	464	0	0	1	-360	360;
	1845	135	0.00029	0.06136	0.00416	160	160	160	1.0654	0	1	-360	360;
	1846	135	0.00165	0.0686	0	160	160	160	1.0626	0	1	-360	360;
	138	137	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	1880	138	0.00138	0.05931	0	250	250	250	1.1019	0	1	-360	360;
	1881	138	0.00138	0.05931	0	250	250	250	1.1019	0	1	-360	360;
	140	139	0	0.0001	0	876	876	876	0	0	1	-360	360;
	166	139	0.01386	0.08702	0.13504	304	304	304	0	0	1	-360	360;
	174	139	0.01176	0.06829	0.1028	381	381	381	0	0	1	-360	360;
	167	140	0.01717	0.0894	0.12903	304	304	304	0	0	1	-360	360;
	1882	140	0.00163	0.07033	0	160	160	160	1.003	0	1	-360	360;
	144	141	0.01312	0.07622	0.11664	381	381	381	0	0	1	-360	360;
	178	141	0.01676	0.09717	0.14868	274	274	274	0	0	1	-360	360;
	1902	141	0.00165	0.0593	0	160	160	160	1.0291	0	1	-360	360;
	1903	141	0.00165	0.0593	0	160	160	160	1.0279	0	1	-360	360;
	1904	142	0.00281	0.10601	0	100	100	100	1.0771	0	1	-360	360;
	1905	142	0.00281	0.10601	0	100	100	100	0.9302	0	1	-360	360;
	144	143	0	0.0001	0	876	876	876	0	0	1	-360	360;
	143	145	0.00035	0.02375	0	500	500	500	1.1409	0	1	-360	360;
	149	143	0.00244	0.01318	0.0213	160	160	160	0	0	1	-360	360;
	144	147	0.01849	0.0956	0.15914	304	304	304	0	0	1	-360	360;
	1907	144	0.00165	0.0593	0	160	160	160	1.0366	0	1	-360	360;
	146	145	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	1906	145	0.00153	0.06206	0	250	250	250	1.1273	0	1	-360	360;
	148	147	0	0.0001	0	876	876	876	0	0	1	-360	360;
	154	147	0.0024	0.01779	0.02759	381	381	381	0	0	1	-360	360;
	1919	147	0.00165	0.06653	0	160	160	160	1.0906	0	1	-360	360;
	1920	148	0.00165	0.06775	0	160	160	160	1.0137	0	1	-360	360;
	1925	149	0.00165	0.05229	0	160	160	160	1.0317	0	1	-360	360;
	151	150	0	0.0001	0	876	876	876	0	0	1	-360	360;
	152	150	0.00517	0.03698	0.05895	464	464	464	0	0	1	-360	360;
	1987	150	0.00165	0.06818	0	160	160	160	1.0702	0	1	-360	360;
	1988	151	0.00165	0.06818	0	160	160	160	1.0633	0	1	-360	360;
	153	152	0	0.0001	0	876	876	876	0	0	1	-360	360;
	2090	152	0.00165	0.06632	0	160	160	160	1.0646	0	1	-360	360;
	2112	154	0.00165	0.06632	0	160	160	160	1.0891	0	1	-360	360;
	2113	154	0.00165	0.06632	0	160	160	160	1.0903	0	1	-360	360;
	166	155	0.0018	0.02114	0.0515	160	160	160	0	0	1	-360	360;
	2134	155	0.00155	0.06585	0	160	160	160	1.0712	0	1	-360	360;
	156	158	0.00059	0.03093	0	400	400	400	1.1047	0	1	-360	360;
	179	156	0.0057	0.04236	0.12971	365	365	365	0	0	1	-360	360;
	158	157	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	2157	157	0.00137	0.05969	0	250	250	250	1.0995	0	1	-360	360;
	176	158	0.00281	0.03312	0.88096	831	831	831	0	0	1	-360	360;
	160	159	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	159	165	0.00224	0.02583	0.72352	831	831	831	0	0	1	-360	360;
	159	176	0.00133	0.01569	0.41821	831	831	831	0	0	1	-360	360;
	2165	159	0.00129	0.06437	0	250	250	250	1.0465	0	1	-360	360;
	168	160	0.0021	0.02475	0.65792	831	831	831	0	0	1	-360	360;
	160	177	0.00133	0.01569	0.41821	831	831	831	0	0	1	-360	360;
	2166	160	0.00129	0.06437	0	250	250	250	1.0537	0	1	-360	360;
	162	161	0	0.0001	0	876	876	876	0	0	1	-360	360;
	161	166	0.02738	0.14254	0.20047	274	274	274	0	0	1	-360	360;
	2170	161	0.00159	0.06694	0	160	160	160	1.0229	0	1	-360	360;
	162	179	0.01905	0.11132	0.16785	274	274	274	0	0	1	-360	360;
	2169	162	0.0037	0.18657	0	120	120	120	1.0617	0	1	-360	360;
	164	163	0	0.0001	0	876	876	876	0	0	1	-360	360;
	163	165	0.0004	0.03	0	500	500	500	1.1321	3.6	1	-360	360;
	163	172	0.00564	0.04196	0.06437	274	274	274	0	0	1	-360	360;
	2188	163	0.00163	0.06671	0	160	160	160	1.0201	0	1	-360	360;
	164	167	0.00795	0.05919	0.0908	274	274	274	0	0	1	-360	360;
	2186	164	0.00163	0.06671	0	160	160	160	0.9844	0	1	-360	360;
	2187	165	0.00059	0.04206	0	330	330	330	1.0822	0	1	-360	360;
	167	166	0	0.0001	0	876	876	876	0	0	1	-360	360;
	2195	166	0.00159	0.06736	0	160	160	160	1.0261	0	1	-360	360;
	2196	167	0.00159	0.06736	0	160	160	160	1.0259	0	1	-360	360;
	169	168	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	2258	169	0.00089	0.05411	0	330	330	330	1.0528	0	1	-360	360;
	171	170	0	0.0001	0	876	876	876	0	0	1	-360	360;
	170	174	0.02756	0.16014	0.24287	274	274	274	0	0	1	-360	360;
	2260	170	0.00161	0.06756	0	160	160	160	1.0503	0	1	-360	360;
	2261	171	0.00161	0.06756	0	160	160	160	1.024	0	1	-360	360;
	173	172	0	0.0001	0	876	876	876	0	0	1	-360	360;
	2339	172	0.00157	0.0675	0	160	160	160	1.0215	0	1	-360	360;
	173	175	0.00731	0.05579	0.08364	274	274	274	0	0	1	-360	360;
	2340	173	0.00277	0.1062	0	100	100	100	1.0355	0	1	-360	360;
	175	174	0	0.0001	0	876	876	876	0	0	1	-360	360;
	2357	174	0.00161	0.06736	0	160	160	160	1.05	0	1	-360	360;
	2357	175	0.00165	0.06671	0	160	160	160	1.0491	0	1	-360	360;
	177	176	0	0.0001	0	1593	1593	1593	0	0	1	-360	360;
	2377	176	0.00137	0.05969	0	250	250	250	1.1045	0	1	-360	360;
	2378	176	0.00137	0.05969	0	250	250	250	1.105	0	1	-360	360;
	179	178	0	0.0001	0	876	876	876	0	0	1	-360	360;
	2380	178	0.00155	0.06798	0	160	160	160	1.0297	0	1	-360	360;
	2381	179	0.00161	0.06775	0	160	160	160	1.0286	0	1	-360	360;
	202	187	0.10041	0.17736	0.01665	68	68	68	0	0	1	-360	360;
	423	187	0.0386	0.08364	0.00735	90	90	90	0	0	1	-360	360;
	434	188	0.04017	0.11711	0.01446	140	140	140	0	0	1	-360	360;
	437	188	0.0414	0.1257	0.01489	140	140	140	0	0	1	-360	360;
	443	189	0.04719	0.08273	0.00785	90	90	90	0	0	1	-360	360;
	513	189	0.03909	0.06843	0.00649	91	91	91	0	0	1	-360	360;
	355	190	0.01967	0.0638	0.0066	120	120	120	0	0	1	-360	360;
	376	190	0.02231	0.07248	0.0075	120	120	120	0	0	1	-360	360;
	207	191	0.00686	0.02215	0.00229	120	120	120	0	0	1	-360	360;
	529	191	0.02058	0.06694	0.00691	120	120	120	0	0	1	-360	360;
	193	192	0.00694	0.02256	0.00231	140	140	140	0	0	1	-360	360;
	194	192	0.00264	0.00851	0.00088	140	140	140	0	0	1	-360	360;
	308	192	0.03942	0.12033	0.01413	137	137	137	0	0	1	-360	360;
	453	192	0.00818	0.02545	0.00289	122	122	122	0	0	1	-360	360;
	193	332	0.0205	0.07347	0.00782	140	140	140	0	0	1	-360	360;
	248	194	0.02893	0.08719	0.0105	140	140	140	0	0	1	-360	360;
	256	194	0.02802	0.08446	0.01016	140	140	140	0	0	1	-360	360;
	332	194	0.02545	0.08099	0.00735	120	120	120	0	0	1	-360	360;
	285	195	0.01959	0.06355	0.00659	137	137	137	0	0	1	-360	360;
	514	195	0.00992	0.02975	0.00316	120	120	120	0	0	1	-360	360;
	1736	196	0.06182	0.10504	0.01014	90	90	90	0	0	1	-360	360;
	197	247	0.0443	0.09347	0.00876	90	90	90	0	0	1	-360	360;
	351	198	0.03529	0.10818	0.011	90	90	90	0	0	1	-360	360;
	425	198	0.02744	0.08264	0.00995	76	76	76	0	0	1	-360	360;
	433	199	0.00983	0.03198	0.0033	120	120	120	0	0	1	-360	360;
	444	199	0.01198	0.03893	0.00402	120	120	120	0	0	1	-360	360;
	200	428	0.0076	0.02298	0.00272	120	120	120	0	0	1	-360	360;
	533	200	0.03339	0.10124	0.01199	120	120	120	0	0	1	-360	360;
	219	201	0.02793	0.08496	0.01006	140	140	140	0	0	1	-360	360;
	201	255	0.02702	0.08215	0.00973	140	140	140	0	0	1	-360	360;
	239	202	0.05198	0.09	0.00889	68	68	68	0	0	1	-360	360;
	202	332	0.05992	0.11628	0.01298	68	68	68	0	0	1	-360	360;
	425	203	0.00843	0.02769	0.00279	76	76	76	0	0	1	-360	360;
	203	459	0.0357	0.11719	0.01184	120	120	120	0	0	1	-360	360;
	204	526	0.00132	0.0043	0.00045	140	140	140	0	0	1	-360	360;
	205	527	0.00132	0.0043	0.00045	140	140	140	0	0	1	-360	360;
	224	206	0.00917	0.02983	0.00307	140	140	140	0	0	1	-360	360;
	384	206	0.00785	0.02545	0.00262	140	140	140	0	0	1	-360	360;
	354	207	0.01372	0.04446	0.00461	120	120	120	0	0	1	-360	360;
	208	326	0.02909	0.09438	0.00976	120	120	120	0	0	1	-360	360;
	208	342	0.00355	0.01157	0.00121	137	137	137	0	0	1	-360	360;
	209	211	0.00678	0.02215	0.00224	101	101	101	0	0	1	-360	360;
	334	209	0.00917	0.03	0.00303	101	101	101	0	0	1	-360	360;
	282	210	0.01661	0.04702	0.00505	120	120	120	0	0	1	-360	360;
	353	210	0.01388	0.03628	0.00396	120	120	120	0	0	1	-360	360;
	233	211	0.01909	0.06273	0.00634	101	101	101	0	0	1	-360	360;
	333	211	0.09165	0.15901	0.01657	90	90	90	0	0	1	-360	360;
	386	211	0.02455	0.07967	0.00818	120	120	120	0	0	1	-360	360;
	305	212	0.02975	0.07686	0.00795	91	91	91	0	0	1	-360	360;
	511	212	0.02917	0.07438	0.00774	91	91	91	0	0	1	-360	360;
	333	213	0.02736	0.05992	0.00581	90	90	90	0	0	1	-360	360;
	343	213	0.01504	0.03075	0.00298	90	90	90	0	0	1	-360	360;
	415	213	0.01165	0.04298	0.0039	90	90	90	0	0	1	-360	360;
	458	213	0.00355	0.0114	0.00118	140	140	140	0	0	1	-360	360;
	473	213	0.00289	0.00926	0.00096	140	140	140	0	0	1	-360	360;
	442	214	0.0214	0.07157	0.00699	120	120	120	0	0	1	-360	360;
	533	214	0.03124	0.10421	0.01018	120	120	120	0	0	1	-360	360;
	2249	214	0.03702	0.06719	0.00639	68	68	68	0	0	1	-360	360;
	273	215	0.00107	0.00281	0.00033	120	120	120	0	0	1	-360	360;
	279	215	0.00992	0.02636	0.00299	120	120	120	0	0	1	-360	360;
	447	216	0.00314	0.00942	0.00096	120	120	120	0	0	1	-360	360;
	1120	216	0.03306	0.08099	0.01008	120	120	120	0	0	1	-360	360;
	327	217	0.02686	0.0881	0.0089	90	90	90	0	0	1	-360	360;
	217	346	0.01678	0.05661	0.00575	90	90	90	0	0	1	-360	360;
	219	218	0.02207	0.04273	0.00416	90	90	90	0	0	1	-360	360;
	340	218	0.04992	0.08967	0.00898	90	90	90	0	0	1	-360	360;
	227	219	0.03736	0.06314	0.00687	90	90	90	0	0	1	-360	360;
	437	220	0.00785	0.02388	0.00284	140	140	140	0	0	1	-360	360;
	510	220	0.03165	0.09537	0.01148	140	140	140	0	0	1	-360	360;
	230	221	0.02678	0.0805	0.0097	140	140	140	0	0	1	-360	360;
	240	221	0.01909	0.06198	0.00644	140	140	140	0	0	1	-360	360;
	262	222	0.00868	0.02826	0.00293	91	91	91	0	0	1	-360	360;
	361	222	0.02314	0.07413	0.00785	120	120	120	0	0	1	-360	360;
	372	223	0.01777	0.03124	0.00297	106	106	106	0	0	1	-360	360;
	613	223	0.05661	0.1305	0.01307	90	90	90	0	0	1	-360	360;
	425	224	0.03083	0.10008	0.01034	76	76	76	0	0	1	-360	360;
	225	510	0.01868	0.05678	0.00673	140	140	140	0	0	1	-360	360;
	2218	225	0.03884	0.12645	0.013	68	68	68	0	0	1	-360	360;
	227	226	0.00661	0.01992	0.0024	90	90	90	0	0	1	-360	360;
	226	348	0.02678	0.08058	0.0097	140	140	140	0	0	1	-360	360;
	354	228	0.0195	0.06314	0.00654	120	120	120	0	0	1	-360	360;
	392	228	0.02521	0.08223	0.00841	120	120	120	0	0	1	-360	360;
	301	229	0.04314	0.08281	0.0075	90	90	90	0	0	1	-360	360;
	431	229	0.01066	0.03231	0.00383	120	120	120	0	0	1	-360	360;
	466	230	0.05099	0.15479	0.01833	140	140	140	0	0	1	-360	360;
	231	365	0.03182	0.05851	0.00559	90	90	90	0	0	1	-360	360;
	232	366	0.03256	0.06124	0.00549	90	90	90	0	0	1	-360	360;
	341	233	0.01975	0.06496	0.00656	101	101	101	0	0	1	-360	360;
	354	234	0.00182	0.01273	0.00142	182	182	182	0	0	1	-360	360;
	517	234	0.00116	0.00802	0.0009	182	182	182	0	0	1	-360	360;
	251	235	0.00256	0.02273	0.00199	182	182	182	0	0	1	-360	360;
	355	235	0.00174	0.01207	0.00134	182	182	182	0	0	1	-360	360;
	236	384	0.00347	0.01132	0.00117	140	140	140	0	0	1	-360	360;
	236	385	0.00331	0.01091	0.0011	140	140	140	0	0	1	-360	360;
	373	237	0.01992	0.06438	0.00667	140	140	140	0	0	1	-360	360;
	516	237	0.01587	0.05388	0.00533	140	140	140	0	0	1	-360	360;
	238	361	0.00306	0.01	0.00103	120	120	120	0	0	1	-360	360;
	492	238	0.04405	0.13372	0.01585	120	120	120	0	0	1	-360	360;
	284	239	0.04339	0.07157	0.00774	68	68	68	0	0	1	-360	360;
	340	240	0.06769	0.11901	0.01104	90	90	90	0	0	1	-360	360;
	240	401	0.0043	0.01388	0.00144	140	140	140	0	0	1	-360	360;
	414	240	0.06107	0.10165	0.01102	90	90	90	0	0	1	-360	360;
	241	287	0.01116	0.03041	0.00329	137	137	137	0	0	1	-360	360;
	503	241	0.00421	0.01165	0.00126	137	137	137	0	0	1	-360	360;
	324	242	0.00851	0.02793	0.00285	120	120	120	0	0	1	-360	360;
	440	242	0.05554	0.12165	0.01065	90	90	90	0	0	1	-360	360;
	306	243	0.00207	0.00529	0.00054	120	120	120	0	0	1	-360	360;
	309	243	0.00868	0.02826	0.00287	120	120	120	0	0	1	-360	360;
	486	244	0.01314	0.03471	0.00364	120	120	120	0	0	1	-360	360;
	520	244	0.00488	0.01579	0.00166	120	120	120	0	0	1	-360	360;
	253	245	0.01876	0.05198	0.00571	120	120	120	0	0	1	-360	360;
	254	245	0.01967	0.06455	0.00652	120	120	120	0	0	1	-360	360;
	281	245	0.00306	0.00959	0.001	120	120	120	0	0	1	-360	360;
	299	245	0.00711	0.02273	0.00242	137	137	137	0	0	1	-360	360;
	396	245	0.01802	0.04636	0.0047	120	120	120	0	0	1	-360	360;
	270	246	0.02091	0.06876	0.00694	120	120	120	0	0	1	-360	360;
	304	246	0.01058	0.02802	0.00316	120	120	120	0	0	1	-360	360;
	339	246	0.02281	0.07446	0.00759	137	137	137	0	0	1	-360	360;
	471	246	0.00463	0.01488	0.00145	120	120	120	0	0	1	-360	360;
	247	427	0.01413	0.03727	0.004	90	90	90	0	0	1	-360	360;
	474	248	0.03033	0.09124	0.01099	140	140	140	0	0	1	-360	360;
	249	294	0.00397	0.01215	0.00138	140	140	140	0	0	1	-360	360;
	474	249	0.02364	0.07149	0.00851	140	140	140	0	0	1	-360	360;
	259	250	0.00901	0.02917	0.00302	140	140	140	0	0	1	-360	360;
	250	349	0.0057	0.01851	0.00193	140	140	140	0	0	1	-360	360;
	252	319	0.00364	0.02504	0.0028	182	182	182	0	0	1	-360	360;
	352	253	0.01711	0.04669	0.00509	120	120	120	0	0	1	-360	360;
	338	254	0.00413	0.01347	0.00139	120	120	120	0	0	1	-360	360;
	336	255	0.0243	0.07975	0.00805	137	137	137	0	0	1	-360	360;
	369	255	0.03124	0.09496	0.01125	140	140	140	0	0	1	-360	360;
	320	256	0.02165	0.04008	0.00386	90	90	90	0	0	1	-360	360;
	257	363	0.00711	0.02281	0.00242	137	137	137	0	0	1	-360	360;
	458	257	0.01372	0.04471	0.0046	137	137	137	0	0	1	-360	360;
	265	258	0.01661	0.04298	0.00429	120	120	120	0	0	1	-360	360;
	1753	258	0.02372	0.06124	0.00624	120	120	120	0	0	1	-360	360;
	436	259	0.00942	0.03041	0.00315	140	140	140	0	0	1	-360	360;
	260	365	0.0062	0.01777	0.00191	120	120	120	0	0	1	-360	360;
	493	260	0.02091	0.05273	0.0058	120	120	120	0	0	1	-360	360;
	261	272	0.00562	0.0181	0.00191	120	120	120	0	0	1	-360	360;
	261	353	0.01198	0.0386	0.00406	120	120	120	0	0	1	-360	360;
	438	262	0.01702	0.05512	0.00581	120	120	120	0	0	1	-360	360;
	323	263	0.02124	0.06975	0.00704	76	76	76	0	0	1	-360	360;
	411	263	0.01174	0.03793	0.00392	91	91	91	0	0	1	-360	360;
	516	264	0.01066	0.01868	0.00186	140	140	140	0	0	1	-360	360;
	537	264	0.03678	0.0638	0.00623	90	90	90	0	0	1	-360	360;
	283	265	0.02702	0.08744	0.00905	140	140	140	0	0	1	-360	360;
	422	265	0.00975	0.0295	0.00355	120	120	120	0	0	1	-360	360;
	408	266	0.03124	0.07942	0.00808	120	120	120	0	0	1	-360	360;
	525	266	0.01711	0.04364	0.00444	120	120	120	0	0	1	-360	360;
	280	267	0.00223	0.00678	0.00082	120	120	120	0	0	1	-360	360;
	267	519	0.00215	0.00645	0.00078	120	120	120	0	0	1	-360	360;
	268	527	0.00504	0.01521	0.00181	140	140	140	0	0	1	-360	360;
	332	269	0.02868	0.08818	0.00783	120	120	120	0	0	1	-360	360;
	511	269	0.03537	0.10331	0.00917	120	120	120	0	0	1	-360	360;
	271	446	0.0243	0.07893	0.00815	120	120	120	0	0	1	-360	360;
	272	353	0.00612	0.01975	0.00208	120	120	120	0	0	1	-360	360;
	304	273	0.00339	0.01124	0.00111	120	120	120	0	0	1	-360	360;
	281	274	0.0057	0.01372	0.00155	120	120	120	0	0	1	-360	360;
	288	274	0.00579	0.01661	0.00179	120	120	120	0	0	1	-360	360;
	275	280	0.00372	0.0119	0.00125	120	120	120	0	0	1	-360	360;
	275	534	0.00306	0.00992	0.00104	120	120	120	0	0	1	-360	360;
	276	299	0.00033	0.00091	0.00011	140	140	140	0	0	1	-360	360;
	292	277	0.00504	0.01612	0.0017	120	120	120	0	0	1	-360	360;
	293	277	0.00264	0.0086	0.0009	120	120	120	0	0	1	-360	360;
	406	277	0.00488	0.0124	0.00121	120	120	120	0	0	1	-360	360;
	526	278	0.00529	0.01645	0.00189	137	137	137	0	0	1	-360	360;
	534	278	0.00058	0.00198	0.00021	140	140	140	0	0	1	-360	360;
	441	279	0.00463	0.01388	0.00167	120	120	120	0	0	1	-360	360;
	472	281	0.00256	0.00826	0.00084	140	140	140	0	0	1	-360	360;
	291	282	0.00223	0.00727	0.00073	120	120	120	0	0	1	-360	360;
	471	282	0.00388	0.01256	0.00132	120	120	120	0	0	1	-360	360;
	350	283	0.01372	0.04455	0.00461	120	120	120	0	0	1	-360	360;
	1787	283	0.02471	0.06281	0.00641	120	120	120	0	0	1	-360	360;
	284	308	0.01826	0.05537	0.00656	137	137	137	0	0	1	-360	360;
	286	285	0.00694	0.02281	0.0023	137	137	137	0	0	1	-360	360;
	286	337	0.02017	0.06405	0.00675	140	140	140	0	0	1	-360	360;
	473	286	0.00694	0.02256	0.00234	90	90	90	0	0	1	-360	360;
	287	318	0.00669	0.01934	0.00207	140	140	140	0	0	1	-360	360;
	352	288	0.01281	0.04116	0.00434	120	120	120	0	0	1	-360	360;
	299	289	0.00769	0.02471	0.00261	137	137	137	0	0	1	-360	360;
	472	289	0.00256	0.00818	0.0008	140	140	140	0	0	1	-360	360;
	294	290	0.00612	0.0124	0.00117	90	90	90	0	0	1	-360	360;
	336	290	0.02	0.0338	0.00368	90	90	90	0	0	1	-360	360;
	429	291	0.00909	0.03058	0.00315	120	120	120	0	0	1	-360	360;
	296	293	8e-05	0.00033	4e-05	140	140	140	0	0	1	-360	360;
	346	294	0.03149	0.10347	0.01045	137	137	137	0	0	1	-360	360;
	524	294	0.02694	0.0819	0.0097	140	140	140	0	0	1	-360	360;
	302	295	0.01099	0.02322	0.00218	120	120	120	0	0	1	-360	360;
	425	295	0.05455	0.09471	0.00914	90	90	90	0	0	1	-360	360;
	537	295	0.05926	0.10455	0.00969	90	90	90	0	0	1	-360	360;
	519	296	0.00736	0.02388	0.00248	137	137	137	0	0	1	-360	360;
	298	297	0.00248	0.00802	0.00082	120	120	120	0	0	1	-360	360;
	297	353	0.02364	0.07736	0.00789	120	120	120	0	0	1	-360	360;
	525	298	0.01413	0.04653	0.0047	120	120	120	0	0	1	-360	360;
	430	300	0.03322	0.10785	0.01114	120	120	120	0	0	1	-360	360;
	658	300	0.05992	0.10149	0.01089	90	90	90	0	0	1	-360	360;
	708	300	0.04231	0.07529	0.00702	90	90	90	0	0	1	-360	360;
	442	303	0.02165	0.0724	0.00706	120	120	120	0	0	1	-360	360;
	2124	303	0.07686	0.09504	0.01016	68	68	68	0	0	1	-360	360;
	345	305	0.02314	0.05587	0.00629	120	120	120	0	0	1	-360	360;
	460	305	0.03942	0.12769	0.01323	140	140	140	0	0	1	-360	360;
	512	305	0.05322	0.13512	0.01374	91	91	91	0	0	1	-360	360;
	493	306	0.0081	0.01959	0.00219	120	120	120	0	0	1	-360	360;
	462	307	0.01967	0.05355	0.00578	120	120	120	0	0	1	-360	360;
	508	307	0.01248	0.03215	0.00319	120	120	120	0	0	1	-360	360;
	349	309	0.01545	0.04488	0.00434	120	120	120	0	0	1	-360	360;
	309	520	0.00413	0.01331	0.0014	140	140	140	0	0	1	-360	360;
	312	310	0.02339	0.0619	0.00629	120	120	120	0	0	1	-360	360;
	420	310	0.00248	0.00777	0.00087	140	140	140	0	0	1	-360	360;
	435	310	0.01967	0.05959	0.00587	120	120	120	0	0	1	-360	360;
	477	310	0.01405	0.04446	0.00484	137	137	137	0	0	1	-360	360;
	312	311	0	0.0001	0	438	438	438	0	0	1	-360	360;
	372	311	0.0686	0.12	0.01149	90	90	90	0	0	1	-360	360;
	323	312	0.02314	0.07521	0.00774	91	91	91	0	0	1	-360	360;
	2245	313	0.0214	0.0676	0.00692	34	34	34	0	0	1	-360	360;
	381	314	0.06091	0.10124	0.01098	68	68	68	0	0	1	-360	360;
	387	314	0.04306	0.07157	0.00754	90	90	90	0	0	1	-360	360;
	315	341	0.01826	0.03157	0.00307	90	90	90	0	0	1	-360	360;
	2249	315	0.05446	0.10132	0.00968	90	90	90	0	0	1	-360	360;
	352	316	0.00339	0.01017	0.00123	120	120	120	0	0	1	-360	360;
	391	316	0.00479	0.01446	0.00175	120	120	120	0	0	1	-360	360;
	317	468	0.01273	0.03562	0.00353	120	120	120	0	0	1	-360	360;
	514	317	0.0005	0.00149	0.00015	120	120	120	0	0	1	-360	360;
	318	467	0.0005	0.00149	0.00015	140	140	140	0	0	1	-360	360;
	319	517	0.00661	0.04521	0.00505	182	182	182	0	0	1	-360	360;
	348	320	0.0157	0.04736	0.0057	140	140	140	0	0	1	-360	360;
	451	321	0.00157	0.00512	0.00053	120	120	120	0	0	1	-360	360;
	454	321	0.00744	0.01901	0.00208	137	137	137	0	0	1	-360	360;
	321	467	0.02364	0.05843	0.0063	120	120	120	0	0	1	-360	360;
	485	321	0.01083	0.02719	0.003	120	120	120	0	0	1	-360	360;
	506	321	0.00438	0.01083	0.00119	140	140	140	0	0	1	-360	360;
	321	530	0.00529	0.01694	0.00178	120	120	120	0	0	1	-360	360;
	351	322	0.00645	0.02025	0.00223	120	120	120	0	0	1	-360	360;
	389	322	0.01223	0.02868	0.00295	120	120	120	0	0	1	-360	360;
	452	322	0.00207	0.00669	0.00071	120	120	120	0	0	1	-360	360;
	455	322	0.00314	0.01975	0.00178	120	120	120	0	0	1	-360	360;
	322	475	0.00397	0.01281	0.00135	120	120	120	0	0	1	-360	360;
	322	478	0.03752	0.09504	0.01036	120	120	120	0	0	1	-360	360;
	490	322	0.01364	0.03397	0.00375	120	120	120	0	0	1	-360	360;
	538	324	0.02264	0.03769	0.00397	90	90	90	0	0	1	-360	360;
	371	325	0.0043	0.01298	0.00157	120	120	120	0	0	1	-360	360;
	375	325	0.01132	0.03777	0.00369	120	120	120	0	0	1	-360	360;
	364	326	0.02868	0.09314	0.00962	120	120	120	0	0	1	-360	360;
	361	328	0.01182	0.03	0.00305	120	120	120	0	0	1	-360	360;
	375	329	0.0162	0.05405	0.00527	120	120	120	0	0	1	-360	360;
	374	330	0.01066	0.03463	0.00358	120	120	120	0	0	1	-360	360;
	360	331	0.00959	0.03099	0.0032	120	120	120	0	0	1	-360	360;
	395	334	0.03884	0.1276	0.01288	120	120	120	0	0	1	-360	360;
	369	335	0.04066	0.07066	0.00682	68	68	68	0	0	1	-360	360;
	2331	335	0.09669	0.11901	0.01258	68	68	68	0	0	1	-360	360;
	347	336	0.04736	0.08314	0.00789	90	90	90	0	0	1	-360	360;
	377	337	0.00545	0.01752	0.00183	137	137	137	0	0	1	-360	360;
	379	337	0.03702	0.12132	0.0121	120	120	120	0	0	1	-360	360;
	394	338	0.06058	0.10603	0.01006	90	90	90	0	0	1	-360	360;
	419	339	0.04041	0.13264	0.01339	137	137	137	0	0	1	-360	360;
	342	445	0.02595	0.08512	0.0086	120	120	120	0	0	1	-360	360;
	624	342	0.04727	0.08388	0.00774	90	90	90	0	0	1	-360	360;
	710	342	0.01397	0.04504	0.00462	122	122	122	0	0	1	-360	360;
	377	343	0.01182	0.01967	0.00207	90	90	90	0	0	1	-360	360;
	346	344	0.00397	0.01298	0.00132	140	140	140	0	0	1	-360	360;
	344	346	0.00678	0.01446	0.00132	90	90	90	0	0	1	-360	360;
	381	344	0.00653	0.01207	0.00129	90	90	90	0	0	1	-360	360;
	523	344	0.01702	0.05512	0.00542	140	140	140	0	0	1	-360	360;
	347	345	0.03967	0.1286	0.01323	140	140	140	0	0	1	-360	360;
	386	347	0.05926	0.19198	0.01974	91	91	91	0	0	1	-360	360;
	526	350	0.0238	0.07215	0.00855	120	120	120	0	0	1	-360	360;
	406	352	0.00595	0.01793	0.00216	137	137	137	0	0	1	-360	360;
	429	353	0.00785	0.02537	0.00267	120	120	120	0	0	1	-360	360;
	370	354	0.03529	0.13702	0.01374	120	120	120	0	0	1	-360	360;
	402	355	0.00355	0.02421	0.00271	182	182	182	0	0	1	-360	360;
	360	356	0.0076	0.02545	0.00249	120	120	120	0	0	1	-360	360;
	432	356	0.01835	0.06025	0.00608	120	120	120	0	0	1	-360	360;
	509	357	0.03116	0.08463	0.00843	140	140	140	0	0	1	-360	360;
	523	357	0.01975	0.06479	0.00655	90	90	90	0	0	1	-360	360;
	358	380	0.00719	0.01256	0.0012	90	90	90	0	0	1	-360	360;
	375	359	0.02455	0.0743	0.00772	120	120	120	0	0	1	-360	360;
	378	359	0.00198	0.0062	0.00069	120	120	120	0	0	1	-360	360;
	393	359	0.00562	0.01711	0.0018	90	90	90	0	0	1	-360	360;
	374	361	0.01289	0.04116	0.00443	120	120	120	0	0	1	-360	360;
	362	373	0.00835	0.0262	0.00292	120	120	120	0	0	1	-360	360;
	477	363	0.02066	0.06645	0.00698	137	137	137	0	0	1	-360	360;
	439	364	0.01983	0.06438	0.00665	120	120	120	0	0	1	-360	360;
	416	365	0.01074	0.03421	0.00352	140	140	140	0	0	1	-360	360;
	440	365	0.04058	0.07612	0.00678	90	90	90	0	0	1	-360	360;
	484	366	0.0162	0.04017	0.00436	120	120	120	0	0	1	-360	360;
	504	366	0.01893	0.06355	0.00649	140	140	140	0	0	1	-360	360;
	578	366	0.07463	0.13025	0.01244	68	68	68	0	0	1	-360	360;
	370	367	0.00488	0.01587	0.00164	120	120	120	0	0	1	-360	360;
	445	367	0.03	0.08868	0.00884	120	120	120	0	0	1	-360	360;
	376	368	0.00843	0.0214	0.00218	120	120	120	0	0	1	-360	360;
	433	368	0.01074	0.03479	0.00359	120	120	120	0	0	1	-360	360;
	378	371	0.00273	0.00818	0.00099	120	120	120	0	0	1	-360	360;
	393	373	0.00479	0.01603	0.00156	120	120	120	0	0	1	-360	360;
	395	374	0.04397	0.14529	0.01447	120	120	120	0	0	1	-360	360;
	428	374	0.02504	0.08223	0.00831	120	120	120	0	0	1	-360	360;
	432	379	0.03033	0.09967	0.01006	120	120	120	0	0	1	-360	360;
	410	380	0.03033	0.07331	0.00825	120	120	120	0	0	1	-360	360;
	1602	380	0.04207	0.1086	0.01107	120	120	120	0	0	1	-360	360;
	464	382	0.0014	0.00587	0.03104	68	68	68	0	0	1	-360	360;
	383	488	0.00057	0.00231	0.0121	93	93	93	0	0	1	-360	360;
	389	385	0.00496	0.01421	0.00145	120	120	120	0	0	1	-360	360;
	415	387	0.0238	0.0781	0.00789	120	120	120	0	0	1	-360	360;
	481	388	0.01372	0.03719	0.00363	90	90	90	0	0	1	-360	360;
	388	518	0.00554	0.01802	0.00184	137	137	137	0	0	1	-360	360;
	529	390	0.02934	0.09512	0.00992	137	137	137	0	0	1	-360	360;
	404	392	0.00149	0.00471	0.00049	140	140	140	0	0	1	-360	360;
	532	394	0.01471	0.04769	0.00493	120	120	120	0	0	1	-360	360;
	526	396	0.00496	0.01496	0.00177	120	120	120	0	0	1	-360	360;
	512	397	0.07868	0.13934	0.01292	90	90	90	0	0	1	-360	360;
	481	398	0.0224	0.03926	0.00372	90	90	90	0	0	1	-360	360;
	1129	399	0.02149	0.07107	0.00724	120	120	120	0	0	1	-360	360;
	404	400	0.00273	0.00785	0.00079	90	90	90	0	0	1	-360	360;
	434	401	0.01975	0.03736	0.00401	90	90	90	0	0	1	-360	360;
	403	517	0.00058	0.00397	0.00044	182	182	182	0	0	1	-360	360;
	405	444	0.00711	0.01248	0.00119	90	90	90	0	0	1	-360	360;
	446	405	0.00579	0.01174	0.00114	90	90	90	0	0	1	-360	360;
	407	431	0.01579	0.04785	0.00568	140	140	140	0	0	1	-360	360;
	526	407	0.00752	0.02264	0.0027	137	137	137	0	0	1	-360	360;
	417	408	0.02802	0.06182	0.00747	120	120	120	0	0	1	-360	360;
	532	409	0.0195	0.06331	0.00654	120	120	120	0	0	1	-360	360;
	660	409	0.02826	0.09669	0.00936	122	122	122	0	0	1	-360	360;
	525	410	0.01785	0.03273	0.00346	90	90	90	0	0	1	-360	360;
	412	411	0.00636	0.02091	0.00212	140	140	140	0	0	1	-360	360;
	423	411	0.11182	0.19074	0.01909	90	90	90	0	0	1	-360	360;
	426	411	0.0324	0.09587	0.00967	90	90	90	0	0	1	-360	360;
	413	412	0.00636	0.02074	0.00214	140	140	140	0	0	1	-360	360;
	612	413	0.04678	0.32397	0.03151	137	137	137	0	0	1	-360	360;
	643	413	0.07438	0.13025	0.01236	68	68	68	0	0	1	-360	360;
	451	416	0.01372	0.04438	0.0046	137	137	137	0	0	1	-360	360;
	447	417	0.01	0.02628	0.00267	120	120	120	0	0	1	-360	360;
	459	418	0.00256	0.00843	0.00087	137	137	137	0	0	1	-360	360;
	477	420	0.01397	0.04397	0.00485	140	140	140	0	0	1	-360	360;
	516	421	0.01074	0.03496	0.00361	91	91	91	0	0	1	-360	360;
	612	424	0.01636	0.05314	0.00619	122	122	122	0	0	1	-360	360;
	722	424	0.05223	0.09008	0.00866	68	68	68	0	0	1	-360	360;
	425	438	0.04893	0.15504	0.01573	120	120	120	0	0	1	-360	360;
	492	425	0.02256	0.07322	0.0075	120	120	120	0	0	1	-360	360;
	536	425	0.05446	0.09421	0.00934	90	90	90	0	0	1	-360	360;
	535	426	0.04174	0.07628	0.00695	68	68	68	0	0	1	-360	360;
	528	427	0.01653	0.05388	0.0055	91	91	91	0	0	1	-360	360;
	613	430	0.05653	0.18587	0.01908	122	122	122	0	0	1	-360	360;
	676	439	0.01719	0.0557	0.00569	122	122	122	0	0	1	-360	360;
	527	441	0.00405	0.01298	0.00134	140	140	140	0	0	1	-360	360;
	487	443	0.03289	0.05744	0.00521	90	90	90	0	0	1	-360	360;
	449	445	0.00645	0.01612	0.00139	68	68	68	0	0	1	-360	360;
	450	446	0.00405	0.00835	0.00078	68	68	68	0	0	1	-360	360;
	469	448	0.01298	0.04215	0.00436	137	137	137	0	0	1	-360	360;
	482	448	0.01893	0.06248	0.01932	137	137	137	0	0	1	-360	360;
	504	452	0.00314	0.00992	0.00102	120	120	120	0	0	1	-360	360;
	464	455	0.00562	0.01777	0.00195	120	120	120	0	0	1	-360	360;
	502	455	0.00099	0.00711	0.00068	120	120	120	0	0	1	-360	360;
	490	456	0.00479	0.01231	0.00125	120	120	120	0	0	1	-360	360;
	494	456	0.01339	0.03322	0.00356	120	120	120	0	0	1	-360	360;
	498	456	0.00041	0.00165	0.00866	144	144	144	0	0	1	-360	360;
	476	457	0.00868	0.02785	0.00293	137	137	137	0	0	1	-360	360;
	514	457	0.00653	0.01736	0.00199	120	120	120	0	0	1	-360	360;
	535	460	0.00537	0.01752	0.00177	68	68	68	0	0	1	-360	360;
	508	461	0.01017	0.02463	0.00274	120	120	120	0	0	1	-360	360;
	515	461	0.00124	0.00306	0.00035	120	120	120	0	0	1	-360	360;
	465	462	0.00264	0.00851	0.00089	140	140	140	0	0	1	-360	360;
	497	463	0.00207	0.00694	0.0007	120	120	120	0	0	1	-360	360;
	514	463	0.00727	0.02066	0.00202	120	120	120	0	0	1	-360	360;
	515	464	0.00727	0.02066	0.00202	120	120	120	0	0	1	-360	360;
	494	465	0.01339	0.03876	0.0041	120	120	120	0	0	1	-360	360;
	468	531	0.00058	0.00174	0.00018	140	140	140	0	0	1	-360	360;
	470	923	0.00992	0.02975	0.00356	140	140	140	0	0	1	-360	360;
	479	475	0.0024	0.00785	0.00082	120	120	120	0	0	1	-360	360;
	507	476	0.00463	0.01231	0.00126	120	120	120	0	0	1	-360	360;
	521	476	0.00455	0.01471	0.00154	137	137	137	0	0	1	-360	360;
	501	477	0.00851	0.02207	0.00241	120	120	120	0	0	1	-360	360;
	518	477	0.00686	0.02207	0.00232	137	137	137	0	0	1	-360	360;
	478	531	0.00355	0.0114	0.00119	140	140	140	0	0	1	-360	360;
	480	530	0.00215	0.00694	0.00073	120	120	120	0	0	1	-360	360;
	487	481	0.00595	0.01157	0.0011	90	90	90	0	0	1	-360	360;
	482	1078	0.05702	0.11322	0.01232	90	90	90	0	0	1	-360	360;
	2043	482	0.05926	0.10397	0.01048	90	90	90	0	0	1	-360	360;
	488	483	0.00057	0.00231	0.0121	93	93	93	0	0	1	-360	360;
	483	502	0.00041	0.0019	0.00993	89	89	89	0	0	1	-360	360;
	494	484	0.01793	0.04802	0.00522	120	120	120	0	0	1	-360	360;
	489	485	0.00322	0.00793	0.00088	120	120	120	0	0	1	-360	360;
	507	486	0.00413	0.01099	0.00117	120	120	120	0	0	1	-360	360;
	500	489	0.00388	0.00942	0.00105	120	120	120	0	0	1	-360	360;
	505	489	0.00661	0.02231	0.00218	140	140	140	0	0	1	-360	360;
	491	490	0.00231	0.00686	0.0007	140	140	140	0	0	1	-360	360;
	494	491	0.01273	0.04132	0.00422	140	140	140	0	0	1	-360	360;
	496	493	0.00438	0.01058	0.0012	120	120	120	0	0	1	-360	360;
	500	493	0.00438	0.01066	0.00119	101	101	101	0	0	1	-360	360;
	505	493	0.00579	0.01893	0.00198	140	140	140	0	0	1	-360	360;
	495	494	0.00438	0.01058	0.0012	120	120	120	0	0	1	-360	360;
	497	506	0.01405	0.03967	0.00432	140	140	140	0	0	1	-360	360;
	502	499	0.00083	0.00372	0.01949	144	144	144	0	0	1	-360	360;
	515	501	0.00727	0.0176	0.00196	120	120	120	0	0	1	-360	360;
	515	503	0.00355	0.00992	0.00106	137	137	137	0	0	1	-360	360;
	512	509	0.01107	0.01934	0.00184	90	90	90	0	0	1	-360	360;
	524	511	0.0395	0.06909	0.00656	90	90	90	0	0	1	-360	360;
	518	522	0.00273	0.0095	0.001	137	137	137	0	0	1	-360	360;
	526	519	0.00562	0.01818	0.0019	137	137	137	0	0	1	-360	360;
	525	528	0.01215	0.03934	0.00405	120	120	120	0	0	1	-360	360;
	538	536	0.01488	0.02612	0.00246	90	90	90	0	0	1	-360	360;
	540	539	0	0.0001	0	438	438	438	0	0	1	-360	360;
	559	539	0.02562	0.08281	0.00847	137	137	137	0	0	1	-360	360;
	633	539	0.00397	0.01298	0.00133	137	137	137	0	0	1	-360	360;
	737	539	0.01207	0.03893	0.00402	137	137	137	0	0	1	-360	360;
	776	539	0.01174	0.02025	0.00195	108	108	108	0	0	1	-360	360;
	544	540	0.02975	0.07983	0.00823	137	137	137	0	0	1	-360	360;
	634	540	0.00397	0.01281	0.00131	137	137	137	0	0	1	-360	360;
	650	540	0.00413	0.03066	0.00293	137	137	137	0	0	1	-360	360;
	652	540	0.00562	0.00992	0.00092	58	58	58	0	0	1	-360	360;
	653	540	0.01372	0.04438	0.00454	137	137	137	0	0	1	-360	360;
	541	685	0.0157	0.05074	0.00519	137	137	137	0	0	1	-360	360;
	712	542	0.02678	0.08653	0.00885	137	137	137	0	0	1	-360	360;
	737	542	0.01884	0.06099	0.00624	137	137	137	0	0	1	-360	360;
	751	542	0.02512	0.08107	0.0083	137	137	137	0	0	1	-360	360;
	560	543	0.01793	0.05802	0.00593	137	137	137	0	0	1	-360	360;
	617	543	0.02207	0.05917	0.00611	137	137	137	0	0	1	-360	360;
	740	543	0.02537	0.06736	0.00695	137	137	137	0	0	1	-360	360;
	544	696	0.01421	0.04603	0.00471	137	137	137	0	0	1	-360	360;
	546	545	0	0.0001	0	438	438	438	0	0	1	-360	360;
	587	545	0.03124	0.10107	0.01034	137	137	137	0	0	1	-360	360;
	727	545	0.03306	0.10686	0.01094	89	89	89	0	0	1	-360	360;
	756	545	0.02355	0.07562	0.00782	137	137	137	0	0	1	-360	360;
	575	546	0.03198	0.10347	0.01058	137	137	137	0	0	1	-360	360;
	725	546	0.00612	0.01992	0.00204	137	137	137	0	0	1	-360	360;
	730	546	0.00463	0.01479	0.0016	108	108	108	0	0	1	-360	360;
	739	546	0.03182	0.07959	0.00806	137	137	137	0	0	1	-360	360;
	755	546	0.1362	0.23512	0.02235	78	78	78	0	0	1	-360	360;
	631	547	0.00777	0.02512	0.00257	137	137	137	0	0	1	-360	360;
	672	547	0.00355	0.01157	0.0012	137	137	137	0	0	1	-360	360;
	751	547	0.00413	0.01322	0.00136	137	137	137	0	0	1	-360	360;
	573	548	0.01628	0.05273	0.00541	137	137	137	0	0	1	-360	360;
	660	548	0.02074	0.06727	0.00688	137	137	137	0	0	1	-360	360;
	550	549	0.00835	0.02702	0.00277	137	137	137	0	0	1	-360	360;
	671	549	0.08678	0.14975	0.01423	76	76	76	0	0	1	-360	360;
	760	549	0.05818	0.10041	0.00954	76	76	76	0	0	1	-360	360;
	761	550	0.01843	0.0595	0.00608	137	137	137	0	0	1	-360	360;
	746	551	0.03826	0.06562	0.01263	108	108	108	0	0	1	-360	360;
	551	750	0.04	0.06182	0.00676	108	108	108	0	0	1	-360	360;
	757	551	0.01025	0.0181	0.0017	108	108	108	0	0	1	-360	360;
	784	551	0.00587	0.01033	0.00097	108	108	108	0	0	1	-360	360;
	553	552	0.0057	0.0186	0.00189	137	137	137	0	0	1	-360	360;
	588	552	0.03107	0.10041	0.01029	137	137	137	0	0	1	-360	360;
	643	552	0.03322	0.10736	0.01099	137	137	137	0	0	1	-360	360;
	771	552	0.03231	0.10438	0.01068	137	137	137	0	0	1	-360	360;
	658	553	0.05835	0.09876	0.0106	108	108	108	0	0	1	-360	360;
	703	554	0.03843	0.10074	0.01041	137	137	137	0	0	1	-360	360;
	744	554	0.04893	0.12777	0.01321	137	137	137	0	0	1	-360	360;
	555	693	0.00496	0.01339	0.00138	137	137	137	0	0	1	-360	360;
	555	785	0.03628	0.09421	0.00974	137	137	137	0	0	1	-360	360;
	559	556	0.02934	0.09479	0.0097	137	137	137	0	0	1	-360	360;
	674	556	0.03033	0.0981	0.01004	137	137	137	0	0	1	-360	360;
	781	556	0.02256	0.07289	0.00746	137	137	137	0	0	1	-360	360;
	558	557	0.0057	0.01851	0.00189	108	108	108	0	0	1	-360	360;
	690	557	0.02174	0.03835	0.00359	108	108	108	0	0	1	-360	360;
	733	557	0.02463	0.05959	0.00496	108	108	108	0	0	1	-360	360;
	579	558	0.03562	0.11521	0.01178	108	108	108	0	0	1	-360	360;
	617	560	0.0124	0.05413	0.00675	137	137	137	0	0	1	-360	360;
	568	561	0.01479	0.03083	0.00298	108	108	108	0	0	1	-360	360;
	569	562	0.01843	0.03331	0.00326	108	108	108	0	0	1	-360	360;
	569	563	0.00793	0.01893	0.00187	108	108	108	0	0	1	-360	360;
	571	563	0.00785	0.01835	0.0018	108	108	108	0	0	1	-360	360;
	598	564	0.01595	0.03174	0.00302	76	76	76	0	0	1	-360	360;
	655	564	0.01124	0.01975	0.00173	108	108	108	0	0	1	-360	360;
	669	564	0.02628	0.04694	0.0044	108	108	108	0	0	1	-360	360;
	654	565	0.00529	0.01686	0.00173	137	137	137	0	0	1	-360	360;
	655	565	0.01083	0.01909	0.00166	108	108	108	0	0	1	-360	360;
	664	565	0.07694	0.13256	0.01263	108	108	108	0	0	1	-360	360;
	762	565	0.01579	0.05107	0.00523	137	137	137	0	0	1	-360	360;
	568	566	0.00851	0.02785	0.00285	137	137	137	0	0	1	-360	360;
	571	566	0.00942	0.0305	0.00312	137	137	137	0	0	1	-360	360;
	700	567	0.02397	0.08322	0.00799	137	137	137	0	0	1	-360	360;
	716	567	0.00901	0.03107	0.00298	137	137	137	0	0	1	-360	360;
	569	568	0	0.0001	0	438	438	438	0	0	1	-360	360;
	672	568	0.04116	0.13289	0.01359	137	137	137	0	0	1	-360	360;
	712	568	0.03116	0.05504	0.00515	108	108	108	0	0	1	-360	360;
	656	569	0.0557	0.0995	0.00934	76	76	76	0	0	1	-360	360;
	712	569	0.03215	0.05504	0.00515	108	108	108	0	0	1	-360	360;
	666	570	0.04777	0.09058	0.00862	108	108	108	0	0	1	-360	360;
	733	570	0.02273	0.04661	0.0045	108	108	108	0	0	1	-360	360;
	694	572	0.04843	0.08438	0.00809	91	91	91	0	0	1	-360	360;
	722	572	0.0376	0.06554	0.00624	108	108	108	0	0	1	-360	360;
	594	573	0.01777	0.05736	0.00587	137	137	137	0	0	1	-360	360;
	613	573	0.02058	0.06612	0.00686	137	137	137	0	0	1	-360	360;
	710	574	0.00355	0.01157	0.00119	137	137	137	0	0	1	-360	360;
	741	575	0.03851	0.12463	0.01275	137	137	137	0	0	1	-360	360;
	576	721	0.02207	0.07124	0.00729	76	76	76	0	0	1	-360	360;
	732	576	0.00016	0.0005	5e-05	137	137	137	0	0	1	-360	360;
	581	577	0.01306	0.02455	0.00198	108	108	108	0	0	1	-360	360;
	685	577	0.04455	0.08926	0.00679	108	108	108	0	0	1	-360	360;
	661	578	0.0295	0.05182	0.00488	137	137	137	0	0	1	-360	360;
	582	579	0.01124	0.02777	0.00276	108	108	108	0	0	1	-360	360;
	580	644	0.02033	0.06562	0.00671	137	137	137	0	0	1	-360	360;
	755	581	0.04521	0.07926	0.0064	108	108	108	0	0	1	-360	360;
	765	581	0.00826	0.01463	0.00137	108	108	108	0	0	1	-360	360;
	688	582	0.03521	0.07645	0.00743	137	137	137	0	0	1	-360	360;
	749	582	0.00818	0.02645	0.00271	137	137	137	0	0	1	-360	360;
	607	583	0.00967	0.0262	0.00263	108	108	108	0	0	1	-360	360;
	619	583	0.02074	0.06702	0.00686	137	137	137	0	0	1	-360	360;
	584	585	0.0105	0.03306	0.00338	137	137	137	0	0	1	-360	360;
	697	584	0.02661	0.08603	0.0088	137	137	137	0	0	1	-360	360;
	585	778	0.04876	0.15769	0.01613	137	137	137	0	0	1	-360	360;
	762	586	0.01479	0.04769	0.00488	137	137	137	0	0	1	-360	360;
	765	586	0.00744	0.01314	0.00123	108	108	108	0	0	1	-360	360;
	628	587	0.00983	0.03182	0.00325	137	137	137	0	0	1	-360	360;
	595	588	0.01917	0.06231	0.00637	137	137	137	0	0	1	-360	360;
	643	588	0.02636	0.08521	0.00871	137	137	137	0	0	1	-360	360;
	717	589	0.04066	0.11116	0.01147	137	137	137	0	0	1	-360	360;
	753	589	0.02777	0.07769	0.00801	137	137	137	0	0	1	-360	360;
	755	590	0.03298	0.10669	0.01091	137	137	137	0	0	1	-360	360;
	780	590	0.0614	0.1986	0.02032	137	137	137	0	0	1	-360	360;
	591	596	0.00942	0.03041	0.00311	108	108	108	0	0	1	-360	360;
	667	591	0.00512	0.0124	0.00123	108	108	108	0	0	1	-360	360;
	592	593	0.00959	0.02017	0.00196	108	108	108	0	0	1	-360	360;
	592	738	0.03488	0.06488	0.00614	108	108	108	0	0	1	-360	360;
	772	593	0.03917	0.06603	0.00396	108	108	108	0	0	1	-360	360;
	713	594	0.02099	0.06785	0.00694	137	137	137	0	0	1	-360	360;
	771	595	0.03066	0.09909	0.01014	137	137	137	0	0	1	-360	360;
	596	742	0.0314	0.07818	0.00775	137	137	137	0	0	1	-360	360;
	597	778	0.03554	0.11504	0.01903	108	108	108	0	0	1	-360	360;
	675	598	0.0162	0.05223	0.00535	76	76	76	0	0	1	-360	360;
	694	599	0.01917	0.06198	0.00634	137	137	137	0	0	1	-360	360;
	669	600	0.04545	0.08091	0.00757	108	108	108	0	0	1	-360	360;
	727	600	0.00967	0.03149	0.00322	137	137	137	0	0	1	-360	360;
	630	601	0.02826	0.0914	0.00934	137	137	137	0	0	1	-360	360;
	708	601	0.02182	0.07066	0.00723	137	137	137	0	0	1	-360	360;
	604	602	0.00455	0.01471	0.0015	137	137	137	0	0	1	-360	360;
	602	615	0.00306	0.00983	0.00101	137	137	137	0	0	1	-360	360;
	604	603	0.00446	0.01455	0.00148	137	137	137	0	0	1	-360	360;
	706	603	0.01405	0.04537	0.00465	137	137	137	0	0	1	-360	360;
	605	615	0.0076	0.02455	0.00252	137	137	137	0	0	1	-360	360;
	626	605	0.00446	0.01388	0.00143	137	137	137	0	0	1	-360	360;
	606	670	0.0062	0.02	0.00204	137	137	137	0	0	1	-360	360;
	606	926	0.01901	0.05868	0.00682	140	140	140	0	0	1	-360	360;
	670	607	0.0062	0.02	0.00204	108	108	108	0	0	1	-360	360;
	690	608	0.01521	0.04901	0.00502	167	167	167	0	0	1	-360	360;
	677	609	0.0181	0.05851	0.00599	137	137	137	0	0	1	-360	360;
	609	680	0.02132	0.06893	0.00705	137	137	137	0	0	1	-360	360;
	668	610	0.0127	0.03297	0.00341	58	58	58	0	0	1	-360	360;
	694	610	0.01075	0.0282	0.00291	58	58	58	0	0	1	-360	360;
	683	611	0.01281	0.02182	0.00175	108	108	108	0	0	1	-360	360;
	750	611	0.03992	0.06793	0.00543	108	108	108	0	0	1	-360	360;
	613	612	0	0.0001	0	438	438	438	0	0	1	-360	360;
	769	612	0.03471	0.11256	0.01158	137	137	137	0	0	1	-360	360;
	627	613	0.01372	0.04446	0.00454	137	137	137	0	0	1	-360	360;
	614	626	0.00603	0.01942	0.00199	137	137	137	0	0	1	-360	360;
	707	614	0.02289	0.07413	0.00758	137	137	137	0	0	1	-360	360;
	665	615	0.05736	0.10083	0.00949	108	108	108	0	0	1	-360	360;
	774	615	0.02446	0.04322	0.00405	108	108	108	0	0	1	-360	360;
	618	616	0.00058	0.0019	0.00019	137	137	137	0	0	1	-360	360;
	616	619	0.00149	0.00264	0.00025	108	108	108	0	0	1	-360	360;
	617	620	0.0057	0.01603	0.00165	137	137	137	0	0	1	-360	360;
	620	618	0.01149	0.02967	0.00301	108	108	108	0	0	1	-360	360;
	756	619	0.02223	0.0714	0.00738	137	137	137	0	0	1	-360	360;
	622	621	0.00413	0.00711	0.00137	108	108	108	0	0	1	-360	360;
	746	621	0.02893	0.04975	0.00953	108	108	108	0	0	1	-360	360;
	624	622	0.00157	0.00306	0.00029	68	68	68	0	0	1	-360	360;
	663	623	0.04579	0.12752	0.01314	137	137	137	0	0	1	-360	360;
	712	623	0.01901	0.05116	0.00528	137	137	137	0	0	1	-360	360;
	690	625	0.0343	0.11099	0.01136	137	137	137	0	0	1	-360	360;
	625	1348	0.03719	0.06033	0.00656	90	90	90	0	0	1	-360	360;
	691	627	0.01851	0.06	0.00614	137	137	137	0	0	1	-360	360;
	699	628	0.02017	0.06529	0.0067	137	137	137	0	0	1	-360	360;
	727	628	0.03893	0.12595	0.01288	137	137	137	0	0	1	-360	360;
	667	629	0.04455	0.14413	0.01475	76	76	76	0	0	1	-360	360;
	763	629	0.08306	0.14868	0.01396	76	76	76	0	0	1	-360	360;
	645	630	0.01967	0.06364	0.00651	137	137	137	0	0	1	-360	360;
	645	631	0.02314	0.06628	0.00678	137	137	137	0	0	1	-360	360;
	634	632	0.01306	0.04207	0.00431	137	137	137	0	0	1	-360	360;
	649	632	0.00777	0.02512	0.00257	137	137	137	0	0	1	-360	360;
	634	633	0	0.0001	0	438	438	438	0	0	1	-360	360;
	645	633	0.03322	0.10752	0.011	137	137	137	0	0	1	-360	360;
	637	635	0.00207	0.00661	0.00068	137	137	137	0	0	1	-360	360;
	732	635	0.01992	0.03711	0.00351	76	76	76	0	0	1	-360	360;
	742	635	0.01694	0.05488	0.00561	137	137	137	0	0	1	-360	360;
	636	740	0.01405	0.03645	0.00377	137	137	137	0	0	1	-360	360;
	744	636	0.01917	0.04983	0.00516	76	76	76	0	0	1	-360	360;
	743	637	0.03488	0.11281	0.01154	137	137	137	0	0	1	-360	360;
	639	638	0.00124	0.00397	0.00044	68	68	68	0	0	1	-360	360;
	650	638	0.00314	0.01025	0.00105	68	68	68	0	0	1	-360	360;
	650	639	0.00545	0.00959	0.0009	137	137	137	0	0	1	-360	360;
	639	653	0.00107	0.00802	0.00018	137	137	137	0	0	1	-360	360;
	640	644	0.01083	0.01917	0.0018	137	137	137	0	0	1	-360	360;
	653	640	0.00455	0.00802	0.00075	108	108	108	0	0	1	-360	360;
	644	641	0.01339	0.02686	0.00257	137	137	137	0	0	1	-360	360;
	645	641	0.00959	0.03116	0.00318	108	108	108	0	0	1	-360	360;
	647	641	0.00463	0.01579	0.00161	137	137	137	0	0	1	-360	360;
	678	642	0.03132	0.1014	0.01038	137	137	137	0	0	1	-360	360;
	785	642	0.04719	0.08521	0.00803	108	108	108	0	0	1	-360	360;
	645	644	0	0.0001	0	438	438	438	0	0	1	-360	360;
	650	644	0.0038	0.0286	0.00273	182	182	182	0	0	1	-360	360;
	686	644	0.06372	0.20612	0.02108	137	137	137	0	0	1	-360	360;
	734	644	0.01132	0.04926	0.00489	89	89	89	0	0	1	-360	360;
	650	645	0.00231	0.02413	0.00373	182	182	182	0	0	1	-360	360;
	646	770	0.03917	0.12669	0.01296	137	137	137	0	0	1	-360	360;
	773	646	0.02066	0.06686	0.00684	137	137	137	0	0	1	-360	360;
	649	647	0.01273	0.04099	0.0042	108	108	108	0	0	1	-360	360;
	651	648	0.00256	0.00826	0.00085	137	137	137	0	0	1	-360	360;
	652	648	0.00446	0.00793	0.00075	58	58	58	0	0	1	-360	360;
	776	651	0.01306	0.02165	0.00208	108	108	108	0	0	1	-360	360;
	655	654	0.00876	0.01455	0.00152	108	108	108	0	0	1	-360	360;
	701	655	0.01091	0.01926	0.0018	108	108	108	0	0	1	-360	360;
	773	656	0.04099	0.07364	0.00692	76	76	76	0	0	1	-360	360;
	1444	657	0.01901	0.03388	0.00697	57	57	57	0	0	1	-360	360;
	1486	657	0.02149	0.0405	0.00799	57	57	57	0	0	1	-360	360;
	659	703	0.01678	0.02959	0.00277	108	108	108	0	0	1	-360	360;
	659	703	0.01455	0.0257	0.00241	108	108	108	0	0	1	-360	360;
	769	661	0.01512	0.05132	0.00251	137	137	137	0	0	1	-360	360;
	663	662	0	0.0001	0	438	438	438	0	0	1	-360	360;
	760	662	0.02463	0.04488	0.00423	76	76	76	0	0	1	-360	360;
	782	662	0.01017	0.03298	0.00336	137	137	137	0	0	1	-360	360;
	778	663	0.01496	0.04661	0.00475	76	76	76	0	0	1	-360	360;
	780	663	0.06909	0.12273	0.01151	108	108	108	0	0	1	-360	360;
	689	664	0.02132	0.06595	0.00671	108	108	108	0	0	1	-360	360;
	676	665	0.01364	0.07041	0.00728	137	137	137	0	0	1	-360	360;
	706	665	0.02198	0.06843	0.00702	137	137	137	0	0	1	-360	360;
	707	666	0.00967	0.03157	0.00322	137	137	137	0	0	1	-360	360;
	703	667	0.04463	0.07884	0.00738	76	76	76	0	0	1	-360	360;
	696	668	0.03485	0.07019	0.00683	58	58	58	0	0	1	-360	360;
	670	1469	0.04959	0.07521	0.01215	90	90	90	0	0	1	-360	360;
	754	671	0.01207	0.02074	0.00198	76	76	76	0	0	1	-360	360;
	750	673	0.02488	0.07223	0.00824	167	167	167	0	0	1	-360	360;
	674	695	0.01107	0.03579	0.00366	137	137	137	0	0	1	-360	360;
	675	758	0.02066	0.06678	0.00683	108	108	108	0	0	1	-360	360;
	679	677	0.01636	0.05306	0.00542	137	137	137	0	0	1	-360	360;
	679	678	0	0.0001	0	438	438	438	0	0	1	-360	360;
	684	678	0.02306	0.07157	0.00818	167	167	167	0	0	1	-360	360;
	731	678	0.07207	0.1381	0.01321	108	108	108	0	0	1	-360	360;
	750	678	0.06909	0.1238	0.01008	108	108	108	0	0	1	-360	360;
	683	679	0.01322	0.0343	0.00329	108	108	108	0	0	1	-360	360;
	684	679	0.02306	0.07157	0.00818	167	167	167	0	0	1	-360	360;
	685	679	0.05	0.10909	0.0107	108	108	108	0	0	1	-360	360;
	680	688	0.02967	0.06636	0.00649	137	137	137	0	0	1	-360	360;
	680	701	0.02157	0.04744	0.00462	108	108	108	0	0	1	-360	360;
	682	681	0.00033	0.00058	0.0242	274	274	274	0	0	1	-360	360;
	770	686	0.03793	0.12298	0.01258	137	137	137	0	0	1	-360	360;
	745	687	0.00405	0.01298	0.00133	137	137	137	0	0	1	-360	360;
	687	747	0.00281	0.00901	0.00092	68	68	68	0	0	1	-360	360;
	689	688	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1359	688	0.04793	0.06281	0.01111	90	90	90	0	0	1	-360	360;
	749	689	0.0224	0.0724	0.00741	137	137	137	0	0	1	-360	360;
	689	1402	0.04132	0.13967	0.01241	120	120	120	0	0	1	-360	360;
	691	692	0.01934	0.06264	0.00641	137	137	137	0	0	1	-360	360;
	718	692	0.02702	0.0876	0.009	137	137	137	0	0	1	-360	360;
	694	693	0.00372	0.00884	0.00067	137	137	137	0	0	1	-360	360;
	695	696	0.00521	0.01694	0.00173	137	137	137	0	0	1	-360	360;
	766	697	0.01752	0.05678	0.00581	137	137	137	0	0	1	-360	360;
	698	702	0.01802	0.03182	0.00298	108	108	108	0	0	1	-360	360;
	704	698	0.00165	0.00537	0.00055	108	108	108	0	0	1	-360	360;
	699	703	0.03769	0.1219	0.01247	137	137	137	0	0	1	-360	360;
	710	700	0.02322	0.07521	0.0077	137	137	137	0	0	1	-360	360;
	702	703	0.0238	0.0538	0.0055	108	108	108	0	0	1	-360	360;
	703	704	0.01083	0.01917	0.0018	76	76	76	0	0	1	-360	360;
	709	705	0.00777	0.01686	0.00165	137	137	137	0	0	1	-360	360;
	728	705	0.00355	0.00628	0.00542	108	108	108	0	0	1	-360	360;
	707	706	0	0.0001	0	438	438	438	0	0	1	-360	360;
	772	707	0.0162	0.02843	0.00269	108	108	108	0	0	1	-360	360;
	716	709	0.02289	0.0519	0.00506	108	108	108	0	0	1	-360	360;
	720	709	0.02521	0.05744	0.00561	108	108	108	0	0	1	-360	360;
	714	711	0.01777	0.05736	0.00587	137	137	137	0	0	1	-360	360;
	727	711	0.02438	0.07802	0.00807	137	137	137	0	0	1	-360	360;
	729	711	0.00174	0.00562	0.00058	137	137	137	0	0	1	-360	360;
	720	713	0.00579	0.00992	0.00105	137	137	137	0	0	1	-360	360;
	724	714	0.00322	0.0105	0.00109	137	137	137	0	0	1	-360	360;
	739	715	0.00917	0.02289	0.00232	137	137	137	0	0	1	-360	360;
	715	1190	0.02397	0.05372	0.00881	68	68	68	0	0	1	-360	360;
	717	716	0	0.0001	0	438	438	438	0	0	1	-360	360;
	750	716	0.05331	0.13339	0.01064	143	143	143	0	0	1	-360	360;
	785	716	0.0519	0.1314	0.01312	137	137	137	0	0	1	-360	360;
	719	717	0.01521	0.02562	0.00245	108	108	108	0	0	1	-360	360;
	728	717	0.01686	0.02983	0.00281	108	108	108	0	0	1	-360	360;
	736	717	0.03826	0.06752	0.00633	108	108	108	0	0	1	-360	360;
	719	718	0.00851	0.01438	0.00155	108	108	108	0	0	1	-360	360;
	755	721	0.01719	0.0557	0.0057	137	137	137	0	0	1	-360	360;
	726	723	0.02264	0.07314	0.00748	137	137	137	0	0	1	-360	360;
	748	723	0.00372	0.0119	0.00121	137	137	137	0	0	1	-360	360;
	730	724	0.00744	0.02405	0.00247	137	137	137	0	0	1	-360	360;
	748	725	0.00818	0.02653	0.00271	137	137	137	0	0	1	-360	360;
	727	726	0	0.0001	0	438	438	438	0	0	1	-360	360;
	729	726	0.02711	0.08777	0.00898	137	137	137	0	0	1	-360	360;
	743	726	0.02306	0.07463	0.00764	137	137	137	0	0	1	-360	360;
	754	731	0.05876	0.12025	0.01158	108	108	108	0	0	1	-360	360;
	735	734	0.0024	0.0076	0.00078	89	89	89	0	0	1	-360	360;
	737	735	0.00298	0.00959	0.00099	137	137	137	0	0	1	-360	360;
	777	736	0.00884	0.01488	0.0015	108	108	108	0	0	1	-360	360;
	1430	738	0.03884	0.06446	0.00695	90	90	90	0	0	1	-360	360;
	752	740	0.00256	0.00818	0.00083	137	137	137	0	0	1	-360	360;
	779	740	0.00868	0.01537	0.00143	108	108	108	0	0	1	-360	360;
	752	741	0.00636	0.02058	0.0021	137	137	137	0	0	1	-360	360;
	768	744	0.02058	0.03628	0.00339	108	108	108	0	0	1	-360	360;
	784	745	0.0038	0.0124	0.00127	108	108	108	0	0	1	-360	360;
	777	747	0.00041	0.0119	0.00122	68	68	68	0	0	1	-360	360;
	753	750	0.00289	0.00777	0.0008	137	137	137	0	0	1	-360	360;
	759	754	0.00397	0.00694	0.00066	108	108	108	0	0	1	-360	360;
	781	755	0.02868	0.09281	0.00949	108	108	108	0	0	1	-360	360;
	774	757	0.03124	0.05512	0.00516	108	108	108	0	0	1	-360	360;
	758	759	0.00851	0.02744	0.00281	108	108	108	0	0	1	-360	360;
	764	763	0.01413	0.02694	0.00257	108	108	108	0	0	1	-360	360;
	767	763	0.02777	0.08975	0.00918	137	137	137	0	0	1	-360	360;
	778	764	0.06347	0.1138	0.0107	108	108	108	0	0	1	-360	360;
	778	766	0.03752	0.1214	0.01242	137	137	137	0	0	1	-360	360;
	779	768	0.02802	0.0905	0.00924	108	108	108	0	0	1	-360	360;
	771	770	0.04041	0.13058	0.01336	137	137	137	0	0	1	-360	360;
	775	1133	0.04545	0.07934	0.00854	90	90	90	0	0	1	-360	360;
	775	1414	0.01405	0.04298	0.00513	140	140	140	0	0	1	-360	360;
	783	778	0.00347	0.00901	0.00094	137	137	137	0	0	1	-360	360;
	783	782	0.00678	0.0219	0.00222	137	137	137	0	0	1	-360	360;
	1183	786	0.0124	0.04545	0.00537	114	114	114	0	0	1	-360	360;
	1184	787	0.0124	0.04545	0.00537	114	114	114	0	0	1	-360	360;
	1484	788	0.00165	0.00207	0.00036	90	90	90	0	0	1	-360	360;
	1483	789	0.00165	0.00207	0.00036	90	90	90	0	0	1	-360	360;
	1483	790	0.00083	0.00124	0.00012	90	90	90	0	0	1	-360	360;
	1483	791	0.00083	0.00165	0.00024	90	90	90	0	0	1	-360	360;
	1240	792	0.00496	0.01405	0.00169	114	114	114	0	0	1	-360	360;
	1525	792	0.00413	0.0124	0.00148	114	114	114	0	0	1	-360	360;
	793	1514	0.04793	0.06033	0.00525	52	52	52	0	0	1	-360	360;
	1334	794	0.00331	0.01157	0.00123	140	140	140	0	0	1	-360	360;
	1385	794	0.00661	0.01983	0.00215	140	140	140	0	0	1	-360	360;
	1108	795	0.01405	0.02479	0.00257	90	90	90	0	0	1	-360	360;
	795	1520	0.01818	0.02397	0.00428	90	90	90	0	0	1	-360	360;
	797	796	0	0.0001	0	438	438	438	0	0	1	-360	360;
	880	796	0.00579	0.01736	0.00184	114	114	114	0	0	1	-360	360;
	1011	796	0.01074	0.03306	0.0039	114	114	114	0	0	1	-360	360;
	1103	796	0.00331	0.00992	0.00099	114	114	114	0	0	1	-360	360;
	1419	796	0.00413	0.01074	0.00174	114	114	114	0	0	1	-360	360;
	1596	796	0.00496	0.00826	0.00082	90	90	90	0	0	1	-360	360;
	881	797	0.00579	0.01736	0.00184	114	114	114	0	0	1	-360	360;
	899	797	0.01736	0.05041	0.00627	120	120	120	0	0	1	-360	360;
	1004	797	0.0124	0.02397	0.00324	120	120	120	0	0	1	-360	360;
	1379	797	0.00826	0.02645	0.0031	114	114	114	0	0	1	-360	360;
	1597	797	0.00496	0.00826	0.00082	90	90	90	0	0	1	-360	360;
	799	798	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1134	798	0	0.00083	0.00012	114	114	114	0	0	1	-360	360;
	1163	798	0.0124	0.03967	0.00428	140	140	140	0	0	1	-360	360;
	798	1299	0.00083	0.00248	0.00031	140	140	140	0	0	1	-360	360;
	799	996	0.01405	0.0438	0.00489	140	140	140	0	0	1	-360	360;
	1135	799	0	0.00165	0.00017	114	114	114	0	0	1	-360	360;
	799	1300	0.00083	0.00248	0.00031	140	140	140	0	0	1	-360	360;
	800	1356	0.00083	0.00248	0.00027	114	114	114	0	0	1	-360	360;
	801	1356	0.00083	0.00248	0.00024	114	114	114	0	0	1	-360	360;
	1087	802	0.00496	0.01322	0.00179	120	120	120	0	0	1	-360	360;
	802	1586	0.00083	0.00248	0.00029	140	140	140	0	0	1	-360	360;
	1483	803	0.00496	0.0157	0.00186	120	120	120	0	0	1	-360	360;
	1345	804	0.0124	0.0438	0.00457	114	114	114	0	0	1	-360	360;
	1426	804	0.01818	0.06281	0.00651	114	114	114	0	0	1	-360	360;
	805	1592	0	0.00083	0.00012	114	114	114	0	0	1	-360	360;
	806	807	0	0.00083	0.0001	140	140	140	0	0	1	-360	360;
	807	1328	0.01074	0.0281	0.00397	120	120	120	0	0	1	-360	360;
	807	1479	0.00579	0.02066	0.00203	140	140	140	0	0	1	-360	360;
	808	971	0.00826	0.02562	0.00269	114	114	114	0	0	1	-360	360;
	808	1227	0.00413	0.01488	0.00152	114	114	114	0	0	1	-360	360;
	904	809	0.00661	0.01901	0.00198	120	120	120	0	0	1	-360	360;
	1216	809	0.01818	0.04463	0.00482	120	120	120	0	0	1	-360	360;
	1502	810	0.02149	0.0686	0.00726	140	140	140	0	0	1	-360	360;
	811	812	0.00083	0.00124	0.0001	90	90	90	0	0	1	-360	360;
	812	860	0.02066	0.02645	0.00489	90	90	90	0	0	1	-360	360;
	918	812	0.01818	0.05868	0.00632	140	140	140	0	0	1	-360	360;
	813	877	0.00331	0.01074	0.00116	140	140	140	0	0	1	-360	360;
	813	1054	0.00579	0.02066	0.00218	114	114	114	0	0	1	-360	360;
	1462	814	0.00331	0.01157	0.00121	140	140	140	0	0	1	-360	360;
	1488	814	0.00413	0.01322	0.00145	112	112	112	0	0	1	-360	360;
	928	815	0.00083	0.00248	0.00027	140	140	140	0	0	1	-360	360;
	1156	815	0.00496	0.01488	0.0016	140	140	140	0	0	1	-360	360;
	1315	815	0.00248	0.00744	0.0009	112	112	112	0	0	1	-360	360;
	816	817	0.00083	0.00165	0.00019	140	140	140	0	0	1	-360	360;
	817	1079	0.02314	0.0314	0.00569	90	90	90	0	0	1	-360	360;
	1477	817	0.01653	0.02066	0.00392	90	90	90	0	0	1	-360	360;
	819	818	0.01653	0.02727	0.00295	19	19	19	0	0	1	-360	360;
	819	954	0.01818	0.05455	0.00649	57	57	57	0	0	1	-360	360;
	993	819	0.01405	0.03884	0.00431	57	57	57	0	0	1	-360	360;
	820	838	0.00413	0.0124	0.0014	114	114	114	0	0	1	-360	360;
	1393	820	0.03719	0.09174	0.00975	85	85	85	0	0	1	-360	360;
	822	821	0	0.0001	0	438	438	438	0	0	1	-360	360;
	843	821	0.01074	0.0314	0.00373	140	140	140	0	0	1	-360	360;
	920	821	0.01157	0.03636	0.00411	114	114	114	0	0	1	-360	360;
	1076	821	0.00661	0.02149	0.00235	114	114	114	0	0	1	-360	360;
	1199	821	0.00331	0.01074	0.00111	140	140	140	0	0	1	-360	360;
	1558	821	0.00661	0.02231	0.00232	114	114	114	0	0	1	-360	360;
	844	822	0.00992	0.03058	0.00363	140	140	140	0	0	1	-360	360;
	919	822	0.01157	0.03636	0.00411	114	114	114	0	0	1	-360	360;
	924	822	0.00909	0.03058	0.00322	114	114	114	0	0	1	-360	360;
	1355	822	0.00248	0.00826	0.00097	140	140	140	0	0	1	-360	360;
	1559	822	0.00661	0.02231	0.00235	114	114	114	0	0	1	-360	360;
	825	823	0.00083	0.00165	0.00019	90	90	90	0	0	1	-360	360;
	826	824	0.00083	0.00165	0.00019	90	90	90	0	0	1	-360	360;
	825	1232	0.00165	0.00579	0.0007	140	140	140	0	0	1	-360	360;
	1566	825	0.00496	0.01488	0.00174	140	140	140	0	0	1	-360	360;
	826	1003	0.00165	0.00579	0.00065	140	140	140	0	0	1	-360	360;
	1566	826	0.00496	0.01488	0.00174	140	140	140	0	0	1	-360	360;
	827	911	0.00413	0.01488	0.00143	114	114	114	0	0	1	-360	360;
	1337	827	0.03306	0.05702	0.00615	90	90	90	0	0	1	-360	360;
	828	829	0.00992	0.03058	0.00361	57	57	57	0	0	1	-360	360;
	829	1268	0.01901	0.05785	0.00687	114	114	114	0	0	1	-360	360;
	1489	829	0.00661	0.01983	0.00235	114	114	114	0	0	1	-360	360;
	830	883	0.00579	0.01736	0.00194	140	140	140	0	0	1	-360	360;
	830	1334	0.00165	0.00496	0.00053	140	140	140	0	0	1	-360	360;
	833	831	0.01405	0.01818	0.00324	76	76	76	0	0	1	-360	360;
	1154	832	0.00909	0.02645	0.00317	114	114	114	0	0	1	-360	360;
	833	1230	0.01818	0.04463	0.00489	120	120	120	0	0	1	-360	360;
	1553	833	0.02645	0.06364	0.00704	120	120	120	0	0	1	-360	360;
	886	834	0.0281	0.07025	0.00789	120	120	120	0	0	1	-360	360;
	991	834	0.03223	0.10248	0.01125	120	120	120	0	0	1	-360	360;
	1175	834	0.01488	0.04463	0.00523	120	120	120	0	0	1	-360	360;
	1178	834	0.01488	0.0405	0.00465	90	90	90	0	0	1	-360	360;
	1467	834	0.02479	0.06116	0.00682	120	120	120	0	0	1	-360	360;
	1020	835	0.03884	0.1	0.01108	120	120	120	0	0	1	-360	360;
	1106	835	0.00744	0.02231	0.00252	114	114	114	0	0	1	-360	360;
	890	836	0.00909	0.02231	0.00252	120	120	120	0	0	1	-360	360;
	1105	836	0.00744	0.02231	0.00254	114	114	114	0	0	1	-360	360;
	836	1365	0.03884	0.09587	0.01055	120	120	120	0	0	1	-360	360;
	837	1097	0.00909	0.02479	0.00276	120	120	120	0	0	1	-360	360;
	1552	837	0.00413	0.01322	0.0015	114	114	114	0	0	1	-360	360;
	966	838	0.00248	0.00826	0.00097	114	114	114	0	0	1	-360	360;
	840	839	0.02645	0.03636	0.00317	57	57	57	0	0	1	-360	360;
	1349	839	0.01818	0.05785	0.00593	57	57	57	0	0	1	-360	360;
	840	887	0.07107	0.12727	0.01229	57	57	57	0	0	1	-360	360;
	1562	840	0.0124	0.02397	0.00206	57	57	57	0	0	1	-360	360;
	841	1095	0.00083	0.00165	0.00012	140	140	140	0	0	1	-360	360;
	842	1096	0.00083	0.00165	0.00015	140	140	140	0	0	1	-360	360;
	845	870	0.00083	0.00165	0.00015	57	57	57	0	0	1	-360	360;
	846	871	0.00083	0.00165	0.00015	57	57	57	0	0	1	-360	360;
	847	871	0.00083	0.00165	0.00015	57	57	57	0	0	1	-360	360;
	848	870	0.00083	0.00124	0.00012	57	57	57	0	0	1	-360	360;
	849	1320	0.00909	0.02397	0.00315	120	120	120	0	0	1	-360	360;
	1426	849	0.01818	0.04215	0.00607	120	120	120	0	0	1	-360	360;
	1087	850	0.00496	0.01405	0.00165	140	140	140	0	0	1	-360	360;
	1594	850	0.00579	0.01818	0.00218	140	140	140	0	0	1	-360	360;
	1066	851	0.00579	0.01736	0.00213	140	140	140	0	0	1	-360	360;
	851	1328	0.00826	0.02727	0.0029	140	140	140	0	0	1	-360	360;
	1538	851	0.02397	0.07603	0.00825	140	140	140	0	0	1	-360	360;
	1560	852	0.00992	0.02479	0.00283	120	120	120	0	0	1	-360	360;
	852	1589	0.00331	0.00992	0.00114	140	140	140	0	0	1	-360	360;
	853	855	0.00083	0.00165	0.00022	114	114	114	0	0	1	-360	360;
	854	856	0.00165	0.00413	0.00046	114	114	114	0	0	1	-360	360;
	855	997	0.00083	0.00331	0.00039	140	140	140	0	0	1	-360	360;
	1573	855	0.00413	0.01157	0.00138	114	114	114	0	0	1	-360	360;
	864	856	0.00248	0.00744	0.0008	120	120	120	0	0	1	-360	360;
	856	997	0.00083	0.00165	0.00015	114	114	114	0	0	1	-360	360;
	857	1169	0.02479	0.06529	0.00661	120	120	120	0	0	1	-360	360;
	1293	857	0.02231	0.05455	0.00622	120	120	120	0	0	1	-360	360;
	858	945	0.00331	0.01074	0.00116	140	140	140	0	0	1	-360	360;
	1162	858	0.00661	0.01983	0.00225	140	140	140	0	0	1	-360	360;
	1173	858	0.00165	0.00248	0.00024	57	57	57	0	0	1	-360	360;
	858	1205	0.00496	0.01736	0.00191	114	114	114	0	0	1	-360	360;
	1372	858	0.00661	0.01653	0.00177	120	120	120	0	0	1	-360	360;
	859	946	0.00331	0.01074	0.00116	140	140	140	0	0	1	-360	360;
	1113	859	0.00826	0.02231	0.00242	120	120	120	0	0	1	-360	360;
	1174	859	0.00165	0.00248	0.00024	57	57	57	0	0	1	-360	360;
	1358	859	0.00661	0.01983	0.00223	114	114	114	0	0	1	-360	360;
	859	1362	0.00248	0.00826	0.00094	114	114	114	0	0	1	-360	360;
	860	1556	0.02314	0.02893	0.00549	90	90	90	0	0	1	-360	360;
	1107	861	0.01901	0.06033	0.00656	114	114	114	0	0	1	-360	360;
	1585	861	0.00496	0.0157	0.00181	114	114	114	0	0	1	-360	360;
	947	862	0.00248	0.00661	0.0007	120	120	120	0	0	1	-360	360;
	1561	862	0.01488	0.03388	0.00421	120	120	120	0	0	1	-360	360;
	864	863	0.00331	0.01157	0.00109	114	114	114	0	0	1	-360	360;
	990	864	0.00413	0.01405	0.00148	114	114	114	0	0	1	-360	360;
	1432	865	0.00413	0.00909	0.00131	120	120	120	0	0	1	-360	360;
	1575	865	0.03306	0.07934	0.00941	120	120	120	0	0	1	-360	360;
	866	1196	0.00661	0.02149	0.00225	114	114	114	0	0	1	-360	360;
	1531	866	0.00413	0.01405	0.00148	114	114	114	0	0	1	-360	360;
	867	869	0.00496	0.01405	0.00167	114	114	114	0	0	1	-360	360;
	1288	868	0.00496	0.0157	0.00157	140	140	140	0	0	1	-360	360;
	888	869	0	0.00083	2e-05	114	114	114	0	0	1	-360	360;
	869	914	0.01322	0.04298	0.00465	140	140	140	0	0	1	-360	360;
	1214	870	0.0157	0.03636	0.00554	120	120	120	0	0	1	-360	360;
	1411	870	0.00661	0.01983	0.00235	140	140	140	0	0	1	-360	360;
	1418	870	0.00826	0.02645	0.003	120	120	120	0	0	1	-360	360;
	896	871	0.01488	0.04132	0.00414	120	120	120	0	0	1	-360	360;
	1418	871	0.00826	0.02645	0.003	85	85	85	0	0	1	-360	360;
	1020	872	0.00413	0.01322	0.00143	114	114	114	0	0	1	-360	360;
	872	1384	0.02562	0.06694	0.00755	120	120	120	0	0	1	-360	360;
	873	874	0.00992	0.03223	0.00307	120	120	120	0	0	1	-360	360;
	874	1098	0	0.00083	0	120	120	120	0	0	1	-360	360;
	1552	874	0.00992	0.02975	0.00332	120	120	120	0	0	1	-360	360;
	875	876	0.00248	0.00331	0.00031	75	75	75	0	0	1	-360	360;
	1323	876	0.00661	0.01901	0.00177	90	90	90	0	0	1	-360	360;
	876	1389	0.02231	0.04132	0.00356	90	90	90	0	0	1	-360	360;
	1050	877	0.01074	0.03471	0.00373	114	114	114	0	0	1	-360	360;
	879	878	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1320	878	0.00661	0.0157	0.00225	120	120	120	0	0	1	-360	360;
	1543	878	0.01405	0.02645	0.00353	90	90	90	0	0	1	-360	360;
	879	1325	0.0124	0.03388	0.00375	120	120	120	0	0	1	-360	360;
	1426	879	0.02397	0.05868	0.00646	120	120	120	0	0	1	-360	360;
	1470	882	0.01901	0.0595	0.00644	114	114	114	0	0	1	-360	360;
	882	1503	0.03471	0.10909	0.01171	140	140	140	0	0	1	-360	360;
	1490	883	0.00165	0.00579	0.00063	140	140	140	0	0	1	-360	360;
	885	884	0.00165	0.00413	0.00046	140	140	140	0	0	1	-360	360;
	885	890	0.05702	0.0843	0.00837	75	75	75	0	0	1	-360	360;
	1476	885	0.05455	0.07107	0.0067	75	75	75	0	0	1	-360	360;
	1294	886	0.02645	0.06612	0.00733	120	120	120	0	0	1	-360	360;
	887	1178	0.03719	0.07521	0.00663	90	90	90	0	0	1	-360	360;
	996	888	0.00744	0.02314	0.00271	140	140	140	0	0	1	-360	360;
	1076	889	0.00579	0.01736	0.00186	140	140	140	0	0	1	-360	360;
	1207	889	0.00496	0.01488	0.00167	114	114	114	0	0	1	-360	360;
	891	1057	0.00331	0.00909	0.00106	140	140	140	0	0	1	-360	360;
	1459	891	0.00413	0.01488	0.00145	140	140	140	0	0	1	-360	360;
	893	892	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1013	892	0.00165	0.00496	0.00063	57	57	57	0	0	1	-360	360;
	1206	892	0.00496	0.01405	0.00162	90	90	90	0	0	1	-360	360;
	1448	892	0.00496	0.0157	0.00177	140	140	140	0	0	1	-360	360;
	1312	893	0.00496	0.01488	0.00177	140	140	140	0	0	1	-360	360;
	1449	893	0.00496	0.0157	0.00177	140	140	140	0	0	1	-360	360;
	894	1077	0.00744	0.02397	0.00278	140	140	140	0	0	1	-360	360;
	1514	894	0.00496	0.01653	0.00191	140	140	140	0	0	1	-360	360;
	986	895	0.00083	0.00331	0.00034	140	140	140	0	0	1	-360	360;
	1424	895	0.00661	0.02149	0.00208	140	140	140	0	0	1	-360	360;
	1083	896	0.00744	0.01818	0.00213	120	120	120	0	0	1	-360	360;
	897	898	0	0.00083	0	57	57	57	0	0	1	-360	360;
	898	1289	0.03636	0.05041	0.0083	57	57	57	0	0	1	-360	360;
	2089	898	0.02149	0.02727	0.00511	57	57	57	0	0	1	-360	360;
	923	899	0.01653	0.04959	0.00583	114	114	114	0	0	1	-360	360;
	1230	900	0.00083	0.00248	0.00029	140	140	140	0	0	1	-360	360;
	1482	900	0.01322	0.03884	0.00457	140	140	140	0	0	1	-360	360;
	961	901	0.01074	0.02397	0.00336	120	120	120	0	0	1	-360	360;
	901	1561	0.00331	0.00826	0.0009	120	120	120	0	0	1	-360	360;
	903	902	0.00165	0.00413	0.00056	141	141	141	0	0	1	-360	360;
	903	916	0.00413	0.0157	0.00186	140	140	140	0	0	1	-360	360;
	1184	903	0.00413	0.01653	0.00198	140	140	140	0	0	1	-360	360;
	1201	904	0.00413	0.0124	0.00131	114	114	114	0	0	1	-360	360;
	906	905	0	0.0001	0	438	438	438	0	0	1	-360	360;
	905	1372	0.00165	0.00413	0.00044	114	114	114	0	0	1	-360	360;
	905	1569	0.00165	0.00579	0.00065	114	114	114	0	0	1	-360	360;
	1095	906	0.00331	0.01157	0.00119	114	114	114	0	0	1	-360	360;
	1570	906	0.00165	0.00661	0.00065	114	114	114	0	0	1	-360	360;
	907	1201	0.00248	0.01488	0.00167	114	114	114	0	0	1	-360	360;
	908	1203	0.00248	0.01488	0.00169	114	114	114	0	0	1	-360	360;
	1387	908	0.00413	0.00744	0.01602	76	76	76	0	0	1	-360	360;
	1058	909	0.00579	0.00992	0.00211	120	120	120	0	0	1	-360	360;
	1245	909	0.01157	0.03554	0.00387	120	120	120	0	0	1	-360	360;
	910	1156	0.00661	0.01983	0.00213	140	140	140	0	0	1	-360	360;
	910	1251	0.00248	0.00744	0.00082	140	140	140	0	0	1	-360	360;
	911	979	0.00992	0.0686	0.00765	232	232	232	0	0	1	-360	360;
	911	1478	0.00579	0.0405	0.00453	232	232	232	0	0	1	-360	360;
	912	965	0.00909	0.04132	0.00457	114	114	114	0	0	1	-360	360;
	1025	912	0.05124	0.16198	0.01788	114	114	114	0	0	1	-360	360;
	1293	912	0.03471	0.11074	0.01162	114	114	114	0	0	1	-360	360;
	1294	912	0.03471	0.11074	0.01164	114	114	114	0	0	1	-360	360;
	1420	912	0.01488	0.04628	0.00508	114	114	114	0	0	1	-360	360;
	912	1572	0.00331	0.02231	0.00249	114	114	114	0	0	1	-360	360;
	1454	913	0.02645	0.06364	0.00726	57	57	57	0	0	1	-360	360;
	1577	913	0.01983	0.05124	0.00588	57	57	57	0	0	1	-360	360;
	1279	914	0.00248	0.00744	0.00085	140	140	140	0	0	1	-360	360;
	933	915	0.00083	0.00248	0.00022	114	114	114	0	0	1	-360	360;
	1072	915	0.00083	0.00248	0.00029	114	114	114	0	0	1	-360	360;
	1095	915	0.00331	0.01322	0.00138	141	141	141	0	0	1	-360	360;
	1236	915	0.00248	0.00826	0.00099	114	114	114	0	0	1	-360	360;
	934	916	0.00083	0.00248	0.00022	114	114	114	0	0	1	-360	360;
	1073	916	0.00083	0.00248	0.00031	114	114	114	0	0	1	-360	360;
	1095	916	0.00331	0.01322	0.00138	141	141	141	0	0	1	-360	360;
	917	1413	0.02149	0.06529	0.00777	140	140	140	0	0	1	-360	360;
	1426	917	0.02397	0.07273	0.00862	85	85	85	0	0	1	-360	360;
	1503	918	0.01488	0.04545	0.00506	140	140	140	0	0	1	-360	360;
	974	919	0.02066	0.05455	0.00605	120	120	120	0	0	1	-360	360;
	919	1049	0.01983	0.06364	0.00675	114	114	114	0	0	1	-360	360;
	1077	919	0.00744	0.02397	0.00281	140	140	140	0	0	1	-360	360;
	1102	920	0.00496	0.00826	0.00174	120	120	120	0	0	1	-360	360;
	920	1343	0.00744	0.02479	0.00259	114	114	114	0	0	1	-360	360;
	1575	920	0.02066	0.05124	0.0061	120	120	120	0	0	1	-360	360;
	921	1207	0.00909	0.0281	0.00302	114	114	114	0	0	1	-360	360;
	921	1344	0.00744	0.02479	0.00259	114	114	114	0	0	1	-360	360;
	1513	921	0.01983	0.06033	0.00711	140	140	140	0	0	1	-360	360;
	922	923	0	0.00083	2e-05	57	57	57	0	0	1	-360	360;
	924	1071	0.00579	0.01901	0.00206	140	140	140	0	0	1	-360	360;
	925	926	0.00083	0.00165	0.00017	114	114	114	0	0	1	-360	360;
	926	1190	0.01653	0.05041	0.0059	140	140	140	0	0	1	-360	360;
	927	928	0.00083	0.00331	0.00036	140	140	140	0	0	1	-360	360;
	1220	928	0.00248	0.00826	0.00082	140	140	140	0	0	1	-360	360;
	929	1139	0.00826	0.02645	0.00302	114	114	114	0	0	1	-360	360;
	929	1240	0.00413	0.01157	0.00128	120	120	120	0	0	1	-360	360;
	1410	929	0.02562	0.04215	0.00634	90	90	90	0	0	1	-360	360;
	1138	930	0.00248	0.00826	0.00094	114	114	114	0	0	1	-360	360;
	932	931	0.00083	0.00165	0.00019	140	140	140	0	0	1	-360	360;
	932	1381	0.00083	0.00331	0.00039	140	140	140	0	0	1	-360	360;
	1452	932	0.00165	0.00579	0.00068	140	140	140	0	0	1	-360	360;
	935	936	0.00083	0.00248	0.00024	114	114	114	0	0	1	-360	360;
	1235	936	0.00496	0.01322	0.0015	120	120	120	0	0	1	-360	360;
	936	1565	0.00165	0.00496	0.00051	85	85	85	0	0	1	-360	360;
	937	938	0	0.00083	2e-05	114	114	114	0	0	1	-360	360;
	1095	938	0.00165	0.00413	0.00046	114	114	114	0	0	1	-360	360;
	938	1531	0.00165	0.00579	0.00056	114	114	114	0	0	1	-360	360;
	939	1416	0.00909	0.02727	0.00319	140	140	140	0	0	1	-360	360;
	1513	939	0.00248	0.00826	0.00097	140	140	140	0	0	1	-360	360;
	940	944	0	0.00083	7e-05	114	114	114	0	0	1	-360	360;
	941	944	0	0.00083	7e-05	114	114	114	0	0	1	-360	360;
	957	942	0.00579	0.01983	0.00191	104	104	104	0	0	1	-360	360;
	942	1096	0.00165	0.00496	0.00056	114	114	114	0	0	1	-360	360;
	1274	943	0.00579	0.01653	0.00186	120	120	120	0	0	1	-360	360;
	1539	943	0.00331	0.00744	0.00087	120	120	120	0	0	1	-360	360;
	944	1117	0.00496	0.01488	0.00179	140	140	140	0	0	1	-360	360;
	944	1591	0.00413	0.0124	0.0015	140	140	140	0	0	1	-360	360;
	947	1229	0.00331	0.00744	0.00099	120	120	120	0	0	1	-360	360;
	948	1199	0.00496	0.01736	0.00179	140	140	140	0	0	1	-360	360;
	1256	948	0.00826	0.02727	0.0029	140	140	140	0	0	1	-360	360;
	1087	949	0.00413	0.01405	0.00131	140	140	140	0	0	1	-360	360;
	949	1422	0.00992	0.0314	0.00368	140	140	140	0	0	1	-360	360;
	950	979	0.00165	0.00248	0.00024	57	57	57	0	0	1	-360	360;
	951	978	0.00165	0.00248	0.00024	57	57	57	0	0	1	-360	360;
	953	952	0.00248	0.00331	0.00056	90	90	90	0	0	1	-360	360;
	953	1075	0.01157	0.03471	0.00387	140	140	140	0	0	1	-360	360;
	1184	953	0.00579	0.01736	0.00208	114	114	114	0	0	1	-360	360;
	954	968	0.01488	0.0438	0.00523	57	57	57	0	0	1	-360	360;
	997	955	0.00496	0.01653	0.0016	140	140	140	0	0	1	-360	360;
	997	956	0.00331	0.00992	0.00121	140	140	140	0	0	1	-360	360;
	1063	957	0.00331	0.01074	0.00126	140	140	140	0	0	1	-360	360;
	1469	958	0.00413	0.00744	0.00102	57	57	57	0	0	1	-360	360;
	1168	959	0.05372	0.07521	0.00663	57	57	57	0	0	1	-360	360;
	1350	959	0.05041	0.08264	0.00895	57	57	57	0	0	1	-360	360;
	960	961	0.00165	0.00579	0.00065	28	28	28	0	0	1	-360	360;
	1282	961	0.00248	0.00661	0.00077	114	114	114	0	0	1	-360	360;
	978	962	0.01157	0.03636	0.00382	114	114	114	0	0	1	-360	360;
	1581	962	0.02314	0.07273	0.00774	57	57	57	0	0	1	-360	360;
	963	1331	0.00413	0.00909	0.00136	120	120	120	0	0	1	-360	360;
	1460	963	0.00496	0.01405	0.00169	140	140	140	0	0	1	-360	360;
	1338	964	0.01322	0.03636	0.00387	120	120	120	0	0	1	-360	360;
	964	1345	0.01488	0.0405	0.00436	120	120	120	0	0	1	-360	360;
	965	973	0.00661	0.01983	0.0022	114	114	114	0	0	1	-360	360;
	967	966	0	0.0001	0	438	438	438	0	0	1	-360	360;
	966	1149	0.03306	0.09917	0.01169	85	85	85	0	0	1	-360	360;
	966	1215	0.03884	0.11983	0.01365	114	114	114	0	0	1	-360	360;
	1263	966	0.01074	0.03554	0.0037	114	114	114	0	0	1	-360	360;
	967	982	0.04132	0.07686	0.00799	90	90	90	0	0	1	-360	360;
	1268	967	0.0562	0.1876	0.01868	114	114	114	0	0	1	-360	360;
	967	1324	0.00909	0.01736	0.00179	90	90	90	0	0	1	-360	360;
	967	1502	0.04959	0.21074	0.02333	114	114	114	0	0	1	-360	360;
	979	968	0.06364	0.12975	0.01268	90	90	90	0	0	1	-360	360;
	1025	968	0.04711	0.08926	0.00871	57	57	57	0	0	1	-360	360;
	1516	968	0.01322	0.0405	0.00482	57	57	57	0	0	1	-360	360;
	969	971	0	0.00083	7e-05	114	114	114	0	0	1	-360	360;
	972	970	0.00083	0.00331	0.00034	57	57	57	0	0	1	-360	360;
	971	1382	0.00083	0.00248	0.00027	114	114	114	0	0	1	-360	360;
	972	1235	0.00826	0.02066	0.00232	120	120	120	0	0	1	-360	360;
	1384	972	0.00083	0.00165	0.00017	114	114	114	0	0	1	-360	360;
	979	973	0.00661	0.02149	0.00225	114	114	114	0	0	1	-360	360;
	1480	973	0.00248	0.00744	0.00075	57	57	57	0	0	1	-360	360;
	1481	973	0.00248	0.00744	0.00075	57	57	57	0	0	1	-360	360;
	974	1431	0.03802	0.09504	0.0105	120	120	120	0	0	1	-360	360;
	1354	975	0.00579	0.01818	0.00213	140	140	140	0	0	1	-360	360;
	1366	975	0.00661	0.02149	0.00223	114	114	114	0	0	1	-360	360;
	976	1415	0	0.00083	0.00012	114	114	114	0	0	1	-360	360;
	977	1415	0	0.00083	0.00012	114	114	114	0	0	1	-360	360;
	998	978	0.01653	0.05207	0.00559	140	140	140	0	0	1	-360	360;
	978	1024	0.09669	0.19504	0.01788	90	90	90	0	0	1	-360	360;
	1293	978	0.03884	0.07603	0.00661	114	114	114	0	0	1	-360	360;
	1318	978	0.03471	0.07355	0.0068	90	90	90	0	0	1	-360	360;
	1478	978	0.00496	0.0314	0.00358	152	152	152	0	0	1	-360	360;
	1319	979	0.03471	0.07355	0.0068	90	90	90	0	0	1	-360	360;
	979	1501	0.01157	0.03471	0.0039	114	114	114	0	0	1	-360	360;
	981	980	0.00331	0.00413	0.00075	57	57	57	0	0	1	-360	360;
	981	1292	0.00165	0.00496	0.00048	120	120	120	0	0	1	-360	360;
	1402	981	0.02149	0.06116	0.00501	120	120	120	0	0	1	-360	360;
	982	1470	0.03554	0.07025	0.00719	90	90	90	0	0	1	-360	360;
	985	983	0.00248	0.00496	0.0007	90	90	90	0	0	1	-360	360;
	986	984	0.00165	0.00413	0.00046	140	140	140	0	0	1	-360	360;
	1058	985	0.00579	0.01074	0.00223	120	120	120	0	0	1	-360	360;
	985	1306	0.00248	0.00413	0.00077	120	120	120	0	0	1	-360	360;
	1307	986	0.00165	0.00413	0.00053	140	140	140	0	0	1	-360	360;
	987	989	0.00248	0.00744	0.00085	114	114	114	0	0	1	-360	360;
	988	990	0.00248	0.00661	0.00077	114	114	114	0	0	1	-360	360;
	989	996	0.00744	0.02314	0.00242	120	120	120	0	0	1	-360	360;
	1125	989	0	0.00083	0.00012	114	114	114	0	0	1	-360	360;
	1126	990	0	0.00083	0.00012	114	114	114	0	0	1	-360	360;
	1501	991	0.01736	0.05289	0.00593	114	114	114	0	0	1	-360	360;
	1183	992	0.00496	0.01405	0.00162	140	140	140	0	0	1	-360	360;
	992	1459	0.00083	0.00165	0.00024	140	140	140	0	0	1	-360	360;
	994	993	0	0.0001	0	438	438	438	0	0	1	-360	360;
	994	1289	0.01488	0.02479	0.00356	57	57	57	0	0	1	-360	360;
	1407	994	0.03058	0.06033	0.00525	57	57	57	0	0	1	-360	360;
	1017	995	0.0124	0.03802	0.0044	114	114	114	0	0	1	-360	360;
	1112	995	0.00165	0.00496	0.00056	140	140	140	0	0	1	-360	360;
	1145	995	0.00909	0.02645	0.00312	140	140	140	0	0	1	-360	360;
	1378	995	0.00413	0.00909	0.00099	140	140	140	0	0	1	-360	360;
	1539	995	0.00826	0.02314	0.00264	140	140	140	0	0	1	-360	360;
	1401	996	0.00909	0.02727	0.00312	114	114	114	0	0	1	-360	360;
	1111	997	0.00083	0.00331	0.00039	140	140	140	0	0	1	-360	360;
	1127	997	0.00909	0.02562	0.00259	120	120	120	0	0	1	-360	360;
	1222	997	0.00909	0.02562	0.00259	120	120	120	0	0	1	-360	360;
	1572	998	0.00331	0.01074	0.00121	114	114	114	0	0	1	-360	360;
	1241	999	0.00579	0.0157	0.00181	90	90	90	0	0	1	-360	360;
	999	1311	0.00909	0.02975	0.00286	114	114	114	0	0	1	-360	360;
	1000	1556	0.00083	0.00165	0.00019	57	57	57	0	0	1	-360	360;
	1001	1556	0.00083	0.00165	0.00022	57	57	57	0	0	1	-360	360;
	1002	1003	0.00165	0.00496	0.00058	120	120	120	0	0	1	-360	360;
	1003	1491	0.00413	0.01157	0.00131	140	140	140	0	0	1	-360	360;
	1008	1004	0.00496	0.00909	0.00092	90	90	90	0	0	1	-360	360;
	1005	1007	0.00083	0.00248	0.00027	76	76	76	0	0	1	-360	360;
	1006	1008	0	0.00083	2e-05	140	140	140	0	0	1	-360	360;
	1007	1010	0.00248	0.00413	0.00044	90	90	90	0	0	1	-360	360;
	1553	1007	0.00413	0.00661	0.0007	90	90	90	0	0	1	-360	360;
	1552	1008	0.00413	0.00661	0.00073	90	90	90	0	0	1	-360	360;
	1371	1009	0	0.00083	0	90	90	90	0	0	1	-360	360;
	1552	1011	0.00744	0.0157	0.00177	90	90	90	0	0	1	-360	360;
	1193	1012	0.02645	0.04132	0.00639	90	90	90	0	0	1	-360	360;
	1553	1012	0.04545	0.05702	0.01079	90	90	90	0	0	1	-360	360;
	1014	1017	0.00083	0.00165	0.00012	114	114	114	0	0	1	-360	360;
	1015	1019	0.00083	0.00331	0.00029	114	114	114	0	0	1	-360	360;
	1016	1018	0.00083	0.00165	0.00017	114	114	114	0	0	1	-360	360;
	1191	1017	0.00083	0.00331	0.00039	114	114	114	0	0	1	-360	360;
	1192	1018	0.00083	0.00248	0.00029	114	114	114	0	0	1	-360	360;
	1018	1401	0.00413	0.0124	0.0014	114	114	114	0	0	1	-360	360;
	1019	1191	0.00083	0.00248	0.00024	114	114	114	0	0	1	-360	360;
	1287	1019	0.00661	0.02149	0.0023	114	114	114	0	0	1	-360	360;
	1020	1522	0.00248	0.00909	0.0009	114	114	114	0	0	1	-360	360;
	1021	1136	0.00496	0.0157	0.00186	140	140	140	0	0	1	-360	360;
	1468	1021	0	0.00083	0	90	90	90	0	0	1	-360	360;
	1230	1022	0.00331	0.00413	0.00073	90	90	90	0	0	1	-360	360;
	1231	1023	0.00331	0.00413	0.00075	90	90	90	0	0	1	-360	360;
	1025	1024	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1308	1024	0.01157	0.03223	0.00361	57	57	57	0	0	1	-360	360;
	2083	1024	0.07025	0.12066	0.0129	90	90	90	0	0	1	-360	360;
	1872	1025	0.03554	0.06612	0.00765	90	90	90	0	0	1	-360	360;
	1153	1026	0.00744	0.02314	0.00259	114	114	114	0	0	1	-360	360;
	1583	1026	0.00248	0.00744	0.00085	120	120	120	0	0	1	-360	360;
	1216	1027	0.00331	0.00661	0.00061	57	57	57	0	0	1	-360	360;
	1216	1028	0.00331	0.00661	0.00058	90	90	90	0	0	1	-360	360;
	1217	1029	0.00331	0.00661	0.00058	90	90	90	0	0	1	-360	360;
	1031	1030	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1524	1030	0.00579	0.01322	0.00254	114	114	114	0	0	1	-360	360;
	1216	1031	0.00248	0.00661	0.00111	114	114	114	0	0	1	-360	360;
	1524	1032	0.00165	0.00579	0.00065	114	114	114	0	0	1	-360	360;
	1523	1033	0.00165	0.00579	0.00068	114	114	114	0	0	1	-360	360;
	1217	1034	0.00083	0.00248	0.00041	120	120	120	0	0	1	-360	360;
	1216	1035	0.00083	0.00248	0.00044	120	120	120	0	0	1	-360	360;
	1217	1036	0.00083	0.00248	0.00031	114	114	114	0	0	1	-360	360;
	1523	1037	0.00083	0.00248	0.00031	114	114	114	0	0	1	-360	360;
	1524	1038	0.00083	0.00248	0.00036	114	114	114	0	0	1	-360	360;
	1040	1039	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1216	1039	0.00496	0.0124	0.00244	114	114	114	0	0	1	-360	360;
	1524	1040	0.00165	0.00496	0.00073	114	114	114	0	0	1	-360	360;
	1041	1043	0	0.00083	0.0001	120	120	120	0	0	1	-360	360;
	1044	1042	0	0.00083	0.00012	120	120	120	0	0	1	-360	360;
	1142	1043	0.03636	0.09008	0.00992	120	120	120	0	0	1	-360	360;
	1043	1217	0.00413	0.00992	0.00111	120	120	120	0	0	1	-360	360;
	1044	1217	0.00413	0.00992	0.00111	120	120	120	0	0	1	-360	360;
	1523	1044	0.00579	0.01736	0.00167	120	120	120	0	0	1	-360	360;
	1306	1045	0.00083	0.00248	0.00027	114	114	114	0	0	1	-360	360;
	1536	1045	0.00331	0.01157	0.00126	140	140	140	0	0	1	-360	360;
	1046	1050	0.00413	0.01322	0.00155	114	114	114	0	0	1	-360	360;
	1047	1050	0.00413	0.01157	0.0014	114	114	114	0	0	1	-360	360;
	1048	1049	0.00083	0.00331	0.00036	114	114	114	0	0	1	-360	360;
	1049	1450	0.00826	0.02645	0.00286	120	120	120	0	0	1	-360	360;
	1147	1050	0.00661	0.02149	0.00237	114	114	114	0	0	1	-360	360;
	1071	1051	0.00909	0.02727	0.00307	140	140	140	0	0	1	-360	360;
	1440	1051	0.00413	0.01074	0.00116	120	120	120	0	0	1	-360	360;
	1436	1052	0.00165	0.00413	0.00051	140	140	140	0	0	1	-360	360;
	1439	1052	0.00331	0.00909	0.00097	120	120	120	0	0	1	-360	360;
	1083	1053	0.00992	0.03058	0.00327	114	114	114	0	0	1	-360	360;
	1223	1053	0.00496	0.01653	0.00172	114	114	114	0	0	1	-360	360;
	1243	1053	0.00909	0.03223	0.00324	114	114	114	0	0	1	-360	360;
	1266	1053	0.00165	0.00413	0.00048	114	114	114	0	0	1	-360	360;
	1161	1054	0.01488	0.04628	0.00508	140	140	140	0	0	1	-360	360;
	1436	1054	0.00496	0.01488	0.00172	114	114	114	0	0	1	-360	360;
	1450	1054	0.00496	0.0157	0.00179	114	114	114	0	0	1	-360	360;
	1055	1079	0.04298	0.10331	0.0112	90	90	90	0	0	1	-360	360;
	1489	1055	0.05785	0.1314	0.01292	90	90	90	0	0	1	-360	360;
	1056	1057	0	0.00083	2e-05	120	120	120	0	0	1	-360	360;
	1057	1083	0.00331	0.00992	0.00116	140	140	140	0	0	1	-360	360;
	1237	1059	0.00165	0.00496	0.00058	140	140	140	0	0	1	-360	360;
	1059	1331	0.00165	0.00413	0.00051	140	140	140	0	0	1	-360	360;
	1061	1063	0	0.00083	0	140	140	140	0	0	1	-360	360;
	1062	1095	0.00413	0.01157	0.00128	140	140	140	0	0	1	-360	360;
	1464	1063	0.00413	0.01322	0.00121	104	104	104	0	0	1	-360	360;
	1064	1065	0.00331	0.01074	0.00121	140	140	140	0	0	1	-360	360;
	1065	1284	0.00496	0.0124	0.00169	120	120	120	0	0	1	-360	360;
	1549	1065	0.02397	0.04298	0.00898	120	120	120	0	0	1	-360	360;
	1425	1066	0.00165	0.00496	0.00044	140	140	140	0	0	1	-360	360;
	1589	1066	0.00248	0.00826	0.00094	140	140	140	0	0	1	-360	360;
	1067	1069	0.00083	0.00165	0.00022	120	120	120	0	0	1	-360	360;
	1070	1068	0.00083	0.00248	0.00024	120	120	120	0	0	1	-360	360;
	1069	1390	0.00826	0.02066	0.00218	120	120	120	0	0	1	-360	360;
	1546	1069	0.00496	0.01157	0.00133	120	120	120	0	0	1	-360	360;
	1070	1326	0.00909	0.02231	0.00254	120	120	120	0	0	1	-360	360;
	1356	1070	0.00496	0.01322	0.00157	120	120	120	0	0	1	-360	360;
	1133	1074	0.02066	0.03967	0.00757	120	120	120	0	0	1	-360	360;
	1552	1074	0.0314	0.06198	0.01181	120	120	120	0	0	1	-360	360;
	1335	1075	0.00331	0.01074	0.00106	140	140	140	0	0	1	-360	360;
	1120	1078	0.03636	0.1157	0.01222	114	114	114	0	0	1	-360	360;
	1080	1081	0	0.00083	7e-05	114	114	114	0	0	1	-360	360;
	1184	1081	0.00744	0.02314	0.00271	114	114	114	0	0	1	-360	360;
	1081	1385	0.00248	0.00909	0.0009	140	140	140	0	0	1	-360	360;
	1099	1082	0.00248	0.00661	0.00094	120	120	120	0	0	1	-360	360;
	1119	1082	0	0.00083	2e-05	120	120	120	0	0	1	-360	360;
	1082	1266	0.00826	0.02645	0.00281	114	114	114	0	0	1	-360	360;
	1138	1084	0.0157	0.05207	0.00501	114	114	114	0	0	1	-360	360;
	1084	1343	0.01074	0.03223	0.00361	114	114	114	0	0	1	-360	360;
	1233	1085	0.00248	0.00661	0.0007	120	120	120	0	0	1	-360	360;
	1244	1086	0.01901	0.06116	0.00646	140	140	140	0	0	1	-360	360;
	1086	1328	0.02149	0.0686	0.00714	140	140	140	0	0	1	-360	360;
	1087	1557	0.01074	0.03306	0.00283	120	120	120	0	0	1	-360	360;
	1088	1182	0.03388	0.09504	0.00932	85	85	85	0	0	1	-360	360;
	1088	1219	0.00992	0.01983	0.0037	120	120	120	0	0	1	-360	360;
	1088	1593	0.00661	0.01653	0.00261	140	140	140	0	0	1	-360	360;
	1431	1089	0.01322	0.04132	0.00486	114	114	114	0	0	1	-360	360;
	1574	1089	0.01736	0.05207	0.00612	114	114	114	0	0	1	-360	360;
	1090	1092	0.00744	0.00992	0.00092	66	66	66	0	0	1	-360	360;
	1091	1093	0.00826	0.0124	0.00116	61	61	61	0	0	1	-360	360;
	1428	1092	0.00909	0.02975	0.00315	114	114	114	0	0	1	-360	360;
	1092	1489	0.04298	0.05785	0.00515	57	57	57	0	0	1	-360	360;
	1429	1093	0.00909	0.02893	0.00307	114	114	114	0	0	1	-360	360;
	1093	1489	0.03471	0.0405	0.00721	57	57	57	0	0	1	-360	360;
	1094	1491	0.00331	0.01074	0.00123	140	140	140	0	0	1	-360	360;
	1545	1094	0.00413	0.01322	0.00145	140	140	140	0	0	1	-360	360;
	1511	1095	0.00165	0.00496	0.00048	140	140	140	0	0	1	-360	360;
	1095	1532	0.00331	0.00909	0.00094	140	140	140	0	0	1	-360	360;
	1220	1096	0.00579	0.01736	0.00191	140	140	140	0	0	1	-360	360;
	1096	1403	0.00248	0.00826	0.0009	140	140	140	0	0	1	-360	360;
	1096	1492	0.00165	0.00579	0.00065	140	140	140	0	0	1	-360	360;
	1495	1096	0.00413	0.01322	0.00174	140	140	140	0	0	1	-360	360;
	1096	1510	0.00165	0.00496	0.0009	140	140	140	0	0	1	-360	360;
	1098	1097	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1120	1097	0.02479	0.06116	0.00649	120	120	120	0	0	1	-360	360;
	1097	1471	0.00661	0.01157	0.00119	28	28	28	0	0	1	-360	360;
	1098	1419	0.00579	0.01405	0.00247	114	114	114	0	0	1	-360	360;
	1098	1472	0.00661	0.01157	0.00119	57	57	57	0	0	1	-360	360;
	1237	1099	0.00496	0.00909	0.00179	120	120	120	0	0	1	-360	360;
	1100	1101	0	0.00083	2e-05	120	120	120	0	0	1	-360	360;
	1101	1232	0.00165	0.00579	0.00065	140	140	140	0	0	1	-360	360;
	1374	1101	0.00661	0.01983	0.0022	140	140	140	0	0	1	-360	360;
	1102	1585	0.01736	0.02479	0.00438	90	90	90	0	0	1	-360	360;
	1571	1103	0.02314	0.04215	0.00852	120	120	120	0	0	1	-360	360;
	1104	1190	0.00992	0.01653	0.00179	90	90	90	0	0	1	-360	360;
	1359	1104	0.02314	0.03223	0.00506	90	90	90	0	0	1	-360	360;
	1167	1105	0.0157	0.04711	0.00414	120	120	120	0	0	1	-360	360;
	1166	1106	0.0157	0.04711	0.00414	120	120	120	0	0	1	-360	360;
	1170	1106	0.02893	0.05124	0.00499	90	90	90	0	0	1	-360	360;
	1108	1107	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1107	1343	0.01901	0.06198	0.00651	114	114	114	0	0	1	-360	360;
	1108	1451	0.00413	0.00992	0.00099	120	120	120	0	0	1	-360	360;
	1111	1109	0.00083	0.00165	0.00029	90	90	90	0	0	1	-360	360;
	1112	1110	0.00083	0.00165	0.00029	120	120	120	0	0	1	-360	360;
	1535	1111	0.00413	0.01405	0.00162	140	140	140	0	0	1	-360	360;
	1275	1112	0.00744	0.02231	0.00266	140	140	140	0	0	1	-360	360;
	1113	1511	0.00083	0.00165	0.00015	140	140	140	0	0	1	-360	360;
	1114	1267	0.00826	0.02397	0.00288	76	76	76	0	0	1	-360	360;
	1114	1354	0.00331	0.01074	0.00131	140	140	140	0	0	1	-360	360;
	1114	1409	0.02727	0.09174	0.00883	57	57	57	0	0	1	-360	360;
	1483	1114	0.00661	0.02149	0.00186	120	120	120	0	0	1	-360	360;
	1115	1181	0.02231	0.04298	0.00825	120	120	120	0	0	1	-360	360;
	1484	1115	0.00661	0.01901	0.00194	120	120	120	0	0	1	-360	360;
	1500	1115	0.00661	0.00992	0.00174	90	90	90	0	0	1	-360	360;
	1285	1116	0.00826	0.02562	0.00305	140	140	140	0	0	1	-360	360;
	1117	1538	0.01157	0.03719	0.00404	114	114	114	0	0	1	-360	360;
	1118	1119	0.00496	0.00826	0.00092	90	90	90	0	0	1	-360	360;
	1271	1119	0.00744	0.01983	0.00208	120	120	120	0	0	1	-360	360;
	1301	1120	0.01322	0.04298	0.00455	114	114	114	0	0	1	-360	360;
	1571	1120	0.00331	0.00826	0.00145	114	114	114	0	0	1	-360	360;
	1121	1231	0.01736	0.04793	0.00515	120	120	120	0	0	1	-360	360;
	1121	1553	0.0405	0.10496	0.01145	120	120	120	0	0	1	-360	360;
	1143	1122	0.0405	0.06694	0.00721	57	57	57	0	0	1	-360	360;
	1169	1122	0.00744	0.02149	0.00237	114	114	114	0	0	1	-360	360;
	1283	1122	0.02149	0.06612	0.00779	114	114	114	0	0	1	-360	360;
	1342	1123	0.03636	0.07025	0.00736	90	90	90	0	0	1	-360	360;
	1528	1123	0.03058	0.05041	0.00547	57	57	57	0	0	1	-360	360;
	1127	1124	0.00579	0.00909	0.00097	90	90	90	0	0	1	-360	360;
	1452	1127	0.00579	0.01488	0.00152	120	120	120	0	0	1	-360	360;
	1128	1129	0.00331	0.00992	0.00102	140	140	140	0	0	1	-360	360;
	1553	1129	0.02562	0.08182	0.00893	114	114	114	0	0	1	-360	360;
	1130	1131	0	0.00083	7e-05	114	114	114	0	0	1	-360	360;
	1232	1131	0.00083	0.00124	0.00015	120	120	120	0	0	1	-360	360;
	1131	1383	0.00744	0.02314	0.00242	120	120	120	0	0	1	-360	360;
	1132	1195	0.00165	0.00661	0.00068	114	114	114	0	0	1	-360	360;
	1532	1132	0.00909	0.02975	0.00315	114	114	114	0	0	1	-360	360;
	1430	1133	0.0281	0.06612	0.00985	120	120	120	0	0	1	-360	360;
	1512	1136	0.0124	0.04132	0.00397	140	140	140	0	0	1	-360	360;
	1284	1137	0.00083	0.00331	0.00034	76	76	76	0	0	1	-360	360;
	1368	1138	0.00661	0.02066	0.00232	114	114	114	0	0	1	-360	360;
	1435	1138	0.02231	0.07107	0.00748	114	114	114	0	0	1	-360	360;
	1525	1138	0.0124	0.02893	0.00414	120	120	120	0	0	1	-360	360;
	1600	1138	0.02479	0.07603	0.00905	114	114	114	0	0	1	-360	360;
	1229	1139	0.00331	0.00909	0.00099	114	114	114	0	0	1	-360	360;
	1451	1139	0.0157	0.04298	0.00438	120	120	120	0	0	1	-360	360;
	1140	1188	0.00248	0.00661	0.00073	140	140	140	0	0	1	-360	360;
	1257	1140	0.01322	0.04132	0.00474	140	140	140	0	0	1	-360	360;
	1357	1140	0.02314	0.06364	0.00905	140	140	140	0	0	1	-360	360;
	1396	1140	0.00165	0.00579	0.00063	140	140	140	0	0	1	-360	360;
	1598	1140	0.0124	0.03884	0.00407	140	140	140	0	0	1	-360	360;
	1189	1141	0.00083	0.00661	0.00068	152	152	152	0	0	1	-360	360;
	1191	1141	0.00083	0.00165	0.00017	140	140	140	0	0	1	-360	360;
	1191	1141	0.00083	0.00165	0.00017	140	140	140	0	0	1	-360	360;
	1302	1141	0.0124	0.03884	0.00407	140	140	140	0	0	1	-360	360;
	1397	1141	0.00083	0.00413	0.00039	152	152	152	0	0	1	-360	360;
	1142	1426	0.00744	0.02066	0.00225	120	120	120	0	0	1	-360	360;
	1143	1745	0.0405	0.05041	0.00719	57	57	57	0	0	1	-360	360;
	1212	1144	0.01074	0.03223	0.00378	114	114	114	0	0	1	-360	360;
	1595	1144	0.01901	0.05785	0.00687	114	114	114	0	0	1	-360	360;
	1145	1274	0.00248	0.00661	0.00075	140	140	140	0	0	1	-360	360;
	1146	1318	0.00496	0.00992	0.00097	90	90	90	0	0	1	-360	360;
	1581	1146	0.03802	0.07521	0.00666	90	90	90	0	0	1	-360	360;
	1485	1147	0.00826	0.02562	0.00286	114	114	114	0	0	1	-360	360;
	1382	1148	0.0405	0.10579	0.01188	120	120	120	0	0	1	-360	360;
	1576	1148	0.02562	0.0686	0.00779	120	120	120	0	0	1	-360	360;
	1258	1149	0.00661	0.02066	0.00223	114	114	114	0	0	1	-360	360;
	1313	1149	0.02231	0.07107	0.00745	114	114	114	0	0	1	-360	360;
	1151	1150	0.00083	0.00165	0.00019	140	140	140	0	0	1	-360	360;
	1151	1216	0.0438	0.11488	0.01195	120	120	120	0	0	1	-360	360;
	1417	1151	0.02231	0.06529	0.00634	120	120	120	0	0	1	-360	360;
	1153	1152	0.00413	0.00744	0.00068	90	90	90	0	0	1	-360	360;
	1490	1153	0	0.00083	7e-05	140	140	140	0	0	1	-360	360;
	1193	1154	0.01157	0.03636	0.00426	114	114	114	0	0	1	-360	360;
	1228	1155	0.00331	0.00826	0.0009	120	120	120	0	0	1	-360	360;
	1357	1155	0.00826	0.01488	0.00305	120	120	120	0	0	1	-360	360;
	1157	1158	0	0.00083	5e-05	140	140	140	0	0	1	-360	360;
	1158	1222	0.00579	0.01405	0.00152	120	120	120	0	0	1	-360	360;
	1453	1158	0	0.00083	2e-05	140	140	140	0	0	1	-360	360;
	1161	1159	0.00413	0.00826	0.00087	90	90	90	0	0	1	-360	360;
	1162	1160	0.00413	0.00826	0.00087	90	90	90	0	0	1	-360	360;
	1358	1161	0.00661	0.01983	0.00218	140	140	140	0	0	1	-360	360;
	1485	1162	0.00496	0.0157	0.00179	140	140	140	0	0	1	-360	360;
	1536	1163	0.01322	0.04132	0.00448	140	140	140	0	0	1	-360	360;
	1164	1166	0.00083	0.00124	0.00015	120	120	120	0	0	1	-360	360;
	1165	1167	0.00083	0.00124	0.00015	120	120	120	0	0	1	-360	360;
	1452	1166	0.0314	0.09421	0.00837	120	120	120	0	0	1	-360	360;
	1453	1167	0.0314	0.09421	0.00837	120	120	120	0	0	1	-360	360;
	1476	1168	0.03802	0.05207	0.00474	57	57	57	0	0	1	-360	360;
	1389	1170	0.0405	0.07025	0.00673	90	90	90	0	0	1	-360	360;
	1269	1171	0.04132	0.06116	0.01036	90	90	90	0	0	1	-360	360;
	1556	1171	0.00496	0.0157	0.00184	140	140	140	0	0	1	-360	360;
	1172	1539	0.00165	0.00496	0.00046	114	114	114	0	0	1	-360	360;
	1175	1580	0.00248	0.00744	0.0008	120	120	120	0	0	1	-360	360;
	1176	1178	0.00083	0.00124	0.0001	90	90	90	0	0	1	-360	360;
	1177	1580	0.01653	0.02893	0.00273	90	90	90	0	0	1	-360	360;
	1384	1179	0.01983	0.05289	0.00578	120	120	120	0	0	1	-360	360;
	1522	1179	0.00165	0.00579	0.0007	114	114	114	0	0	1	-360	360;
	1365	1180	0.00579	0.01736	0.00184	114	114	114	0	0	1	-360	360;
	1181	1190	0.02562	0.04711	0.00944	120	120	120	0	0	1	-360	360;
	1182	1448	0.00992	0.0314	0.00363	140	140	140	0	0	1	-360	360;
	1182	1449	0.00992	0.0314	0.00363	140	140	140	0	0	1	-360	360;
	1463	1182	0.00579	0.01488	0.00165	120	120	120	0	0	1	-360	360;
	1194	1183	0.00248	0.00744	0.00085	114	114	114	0	0	1	-360	360;
	1183	1315	0.00579	0.01901	0.00215	112	112	112	0	0	1	-360	360;
	1183	1460	0.00331	0.01074	0.00126	114	114	114	0	0	1	-360	360;
	1183	1488	0.00496	0.0157	0.00177	112	112	112	0	0	1	-360	360;
	1236	1184	0.00744	0.02727	0.00317	141	141	141	0	0	1	-360	360;
	1367	1185	0.02645	0.03471	0.00639	90	90	90	0	0	1	-360	360;
	1489	1185	0.0157	0.02479	0.00402	90	90	90	0	0	1	-360	360;
	1188	1186	0.00331	0.00579	0.00058	90	90	90	0	0	1	-360	360;
	1187	1189	0.00331	0.00579	0.00056	90	90	90	0	0	1	-360	360;
	1188	1256	0.01157	0.03471	0.00399	140	140	140	0	0	1	-360	360;
	1380	1189	0.00413	0.02975	0.00322	232	232	232	0	0	1	-360	360;
	1473	1190	0.00248	0.00579	0.0008	90	90	90	0	0	1	-360	360;
	1474	1190	0.00165	0.00496	0.00065	90	90	90	0	0	1	-360	360;
	1209	1192	0.0124	0.04545	0.00438	114	114	114	0	0	1	-360	360;
	1192	1282	0.0281	0.0719	0.0076	120	120	120	0	0	1	-360	360;
	1192	1288	0.00744	0.02397	0.00252	114	114	114	0	0	1	-360	360;
	1192	1578	0.01322	0.04628	0.00448	114	114	114	0	0	1	-360	360;
	1576	1193	0.0405	0.07025	0.00707	90	90	90	0	0	1	-360	360;
	1534	1194	0.01074	0.03306	0.00385	114	114	114	0	0	1	-360	360;
	1195	1278	0.00248	0.00744	0.00087	114	114	114	0	0	1	-360	360;
	1353	1196	0.00331	0.01074	0.00121	114	114	114	0	0	1	-360	360;
	1199	1197	0.00496	0.00909	0.00092	90	90	90	0	0	1	-360	360;
	1200	1198	0.00496	0.00909	0.00092	90	90	90	0	0	1	-360	360;
	1200	1355	0.00331	0.00909	0.00102	140	140	140	0	0	1	-360	360;
	1517	1200	0.00579	0.01901	0.00203	140	140	140	0	0	1	-360	360;
	1202	1201	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1373	1201	0.00496	0.0157	0.0016	114	114	114	0	0	1	-360	360;
	1527	1201	0.00413	0.0124	0.00126	114	114	114	0	0	1	-360	360;
	1202	1338	0.00413	0.0124	0.00133	114	114	114	0	0	1	-360	360;
	1523	1202	0.00248	0.01901	0.00196	114	114	114	0	0	1	-360	360;
	1325	1203	0.00248	0.00661	0.00075	114	114	114	0	0	1	-360	360;
	1203	1345	0.00826	0.02645	0.00281	114	114	114	0	0	1	-360	360;
	1524	1203	0.00248	0.01901	0.00196	114	114	114	0	0	1	-360	360;
	1204	1279	0.00248	0.00661	0.0008	114	114	114	0	0	1	-360	360;
	1536	1204	0.00909	0.02975	0.00322	140	140	140	0	0	1	-360	360;
	1205	1380	0.00331	0.02231	0.00249	114	114	114	0	0	1	-360	360;
	1599	1206	0.00083	0.00331	0.00036	114	114	114	0	0	1	-360	360;
	1208	1209	0	0.00083	5e-05	114	114	114	0	0	1	-360	360;
	1479	1209	0.00083	0.00165	0.00019	140	140	140	0	0	1	-360	360;
	1210	1345	0.00165	0.00579	0	96	96	96	0	0	1	-360	360;
	1211	1346	0.00165	0.00579	0	96	96	96	0	0	1	-360	360;
	1213	1212	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1280	1212	0.00661	0.01983	0.00215	114	114	114	0	0	1	-360	360;
	1212	1582	0.00083	0.00248	0.00027	140	140	140	0	0	1	-360	360;
	1281	1213	0.00661	0.01983	0.00213	114	114	114	0	0	1	-360	360;
	1336	1213	0.0157	0.05372	0.00513	114	114	114	0	0	1	-360	360;
	1213	1593	0.00165	0.00413	0.00044	140	140	140	0	0	1	-360	360;
	1594	1213	0.00165	0.00496	0.0007	120	120	120	0	0	1	-360	360;
	1214	1504	0.00744	0.02397	0.00271	140	140	140	0	0	1	-360	360;
	1249	1215	0.03967	0.09008	0.01897	85	85	85	0	0	1	-360	360;
	1348	1217	0.01818	0.05455	0.00649	114	114	114	0	0	1	-360	360;
	1444	1217	0.02479	0.0438	0.00912	85	85	85	0	0	1	-360	360;
	1219	1218	0.00248	0.00579	0.00056	120	120	120	0	0	1	-360	360;
	1219	1505	0.01488	0.0314	0.00537	120	120	120	0	0	1	-360	360;
	1222	1221	0.00579	0.00909	0.00097	90	90	90	0	0	1	-360	360;
	1250	1223	0.00826	0.0281	0.00281	140	140	140	0	0	1	-360	360;
	1224	1226	0.00248	0.00413	0.00041	90	90	90	0	0	1	-360	360;
	1225	1227	0.00248	0.00413	0.00041	90	90	90	0	0	1	-360	360;
	1261	1226	0.00496	0.0157	0.00165	114	114	114	0	0	1	-360	360;
	1226	1383	0.00909	0.02893	0.00302	114	114	114	0	0	1	-360	360;
	1227	1260	0.00496	0.0157	0.00167	114	114	114	0	0	1	-360	360;
	1228	1368	0.00496	0.0157	0.00181	114	114	114	0	0	1	-360	360;
	1498	1230	0.00992	0.02479	0.00271	120	120	120	0	0	1	-360	360;
	1499	1231	0.00992	0.02479	0.00271	120	120	120	0	0	1	-360	360;
	1233	1312	0.00992	0.03058	0.00351	140	140	140	0	0	1	-360	360;
	1363	1233	0.00992	0.02562	0.00288	120	120	120	0	0	1	-360	360;
	1233	1382	0.00826	0.02562	0.00264	120	120	120	0	0	1	-360	360;
	1526	1233	0.00165	0.00496	0.00053	120	120	120	0	0	1	-360	360;
	1599	1233	0.00661	0.02066	0.00237	140	140	140	0	0	1	-360	360;
	1347	1234	0.03719	0.06694	0.0067	90	90	90	0	0	1	-360	360;
	1564	1234	0.00744	0.01157	0.0015	90	90	90	0	0	1	-360	360;
	1239	1238	0.00083	0.00165	0.00024	90	90	90	0	0	1	-360	360;
	1239	1535	0.00496	0.01653	0.00186	140	140	140	0	0	1	-360	360;
	1565	1239	0.00248	0.00744	0.00085	140	140	140	0	0	1	-360	360;
	1518	1241	0.0157	0.03636	0.00387	90	90	90	0	0	1	-360	360;
	1243	1242	0	0.00083	2e-05	140	140	140	0	0	1	-360	360;
	1251	1243	0.00248	0.00661	0.00077	140	140	140	0	0	1	-360	360;
	1244	1311	0.01983	0.06281	0.00658	114	114	114	0	0	1	-360	360;
	1244	1326	0.00826	0.02149	0.00227	120	120	120	0	0	1	-360	360;
	1244	1330	0.00661	0.01736	0.0024	120	120	120	0	0	1	-360	360;
	1546	1244	0.01405	0.03388	0.0037	120	120	120	0	0	1	-360	360;
	1291	1245	0.03471	0.09339	0.01232	120	120	120	0	0	1	-360	360;
	1327	1245	0.01653	0.03802	0.00438	120	120	120	0	0	1	-360	360;
	1245	1425	0.00331	0.00826	0.00085	120	120	120	0	0	1	-360	360;
	1246	1248	0.00083	0.00248	0.00029	114	114	114	0	0	1	-360	360;
	1247	1375	0.00165	0.00496	0.00056	114	114	114	0	0	1	-360	360;
	1248	1375	0.00083	0.00331	0.00034	114	114	114	0	0	1	-360	360;
	1390	1248	0.00579	0.01818	0.00196	114	114	114	0	0	1	-360	360;
	1427	1249	0.01983	0.04711	0.00956	85	85	85	0	0	1	-360	360;
	1251	1250	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1250	1271	0.00413	0.00826	0.00085	120	120	120	0	0	1	-360	360;
	1290	1250	0.00165	0.00579	0.00073	140	140	140	0	0	1	-360	360;
	1310	1250	0.00661	0.01983	0.00213	140	140	140	0	0	1	-360	360;
	1250	1403	0.00413	0.01405	0.0015	140	140	140	0	0	1	-360	360;
	1251	1487	0.00248	0.00744	0.00085	140	140	140	0	0	1	-360	360;
	1514	1252	0.00165	0.00496	0.00075	120	120	120	0	0	1	-360	360;
	1514	1253	0	0.00083	2e-05	120	120	120	0	0	1	-360	360;
	1253	1544	0.00579	0.0157	0.00174	120	120	120	0	0	1	-360	360;
	1256	1254	0.01074	0.01322	0.00172	75	75	75	0	0	1	-360	360;
	1257	1255	0.01074	0.01322	0.00174	75	75	75	0	0	1	-360	360;
	1508	1257	0.00744	0.02397	0.00261	140	140	140	0	0	1	-360	360;
	1259	1336	0.00248	0.00579	0.00063	90	90	90	0	0	1	-360	360;
	1259	1563	0.00661	0.00744	0.00148	90	90	90	0	0	1	-360	360;
	1260	1261	0	0.00083	2e-05	114	114	114	0	0	1	-360	360;
	1340	1261	0.00413	0.00909	0.00077	90	90	90	0	0	1	-360	360;
	1337	1262	0.04215	0.07025	0.00755	57	57	57	0	0	1	-360	360;
	1528	1262	0.05041	0.08264	0.00891	57	57	57	0	0	1	-360	360;
	1264	1265	0.00331	0.01074	0.00114	114	114	114	0	0	1	-360	360;
	1313	1265	0.02893	0.1	0.00966	114	114	114	0	0	1	-360	360;
	1265	1503	0.03884	0.17934	0.02001	114	114	114	0	0	1	-360	360;
	1292	1267	0.0124	0.03719	0.00336	120	120	120	0	0	1	-360	360;
	1543	1269	0.01818	0.03471	0.00486	90	90	90	0	0	1	-360	360;
	1270	1271	0.00083	0.00165	0.00015	120	120	120	0	0	1	-360	360;
	1272	1274	0	0.00083	5e-05	90	90	90	0	0	1	-360	360;
	1273	1275	0	0.00083	5e-05	90	90	90	0	0	1	-360	360;
	1545	1275	0.00083	0.00331	0.00036	140	140	140	0	0	1	-360	360;
	1392	1276	0.00744	0.02231	0.00252	140	140	140	0	0	1	-360	360;
	1536	1276	0.00413	0.01157	0.00138	140	140	140	0	0	1	-360	360;
	1277	1339	0.00331	0.01074	0.00131	140	140	140	0	0	1	-360	360;
	1500	1277	0.00331	0.00992	0.00114	140	140	140	0	0	1	-360	360;
	1569	1278	0.00496	0.01488	0.00177	114	114	114	0	0	1	-360	360;
	1454	1283	0.01488	0.02562	0.00283	90	90	90	0	0	1	-360	360;
	1296	1284	0.01074	0.01322	0.00242	90	90	90	0	0	1	-360	360;
	1417	1284	0.0157	0.04463	0.0045	85	85	85	0	0	1	-360	360;
	1298	1285	0.00496	0.0124	0.00138	120	120	120	0	0	1	-360	360;
	1285	1408	0.00165	0.00413	0.00051	140	140	140	0	0	1	-360	360;
	1286	1288	0	0.00083	2e-05	140	140	140	0	0	1	-360	360;
	1290	1495	0.00413	0.0124	0.00143	140	140	140	0	0	1	-360	360;
	1291	1435	0.00248	0.00909	0.00097	114	114	114	0	0	1	-360	360;
	1467	1293	0.02562	0.06281	0.00692	120	120	120	0	0	1	-360	360;
	1577	1293	0.02479	0.06116	0.0068	120	120	120	0	0	1	-360	360;
	1577	1294	0.02479	0.06116	0.0068	120	120	120	0	0	1	-360	360;
	1295	1328	0.00331	0.00909	0.00111	140	140	140	0	0	1	-360	360;
	1475	1295	0.00826	0.02479	0.00302	140	140	140	0	0	1	-360	360;
	1297	1298	0.00413	0.01322	0.00155	140	140	140	0	0	1	-360	360;
	1418	1298	0.01074	0.03223	0.00312	120	120	120	0	0	1	-360	360;
	1342	1301	0.03223	0.10248	0.01084	114	114	114	0	0	1	-360	360;
	1507	1303	0.00744	0.02397	0.00252	140	140	140	0	0	1	-360	360;
	1303	1598	0.00496	0.0157	0.00165	140	140	140	0	0	1	-360	360;
	1306	1304	0	0.00083	0	114	114	114	0	0	1	-360	360;
	1305	1307	0	0.00083	0	114	114	114	0	0	1	-360	360;
	1538	1307	0.00413	0.01322	0.00148	140	140	140	0	0	1	-360	360;
	1308	1420	0.03471	0.10909	0.01203	114	114	114	0	0	1	-360	360;
	1309	1562	0.02975	0.09587	0.01036	57	57	57	0	0	1	-360	360;
	1309	1802	0.0124	0.03719	0.00436	114	114	114	0	0	1	-360	360;
	1462	1310	0.00165	0.00496	0.00053	140	140	140	0	0	1	-360	360;
	1311	1329	0.02066	0.06694	0.00707	140	140	140	0	0	1	-360	360;
	1315	1314	0.00248	0.00413	0.00077	57	57	57	0	0	1	-360	360;
	1318	1316	0.00331	0.00579	0.00058	19	19	19	0	0	1	-360	360;
	1319	1317	0.00331	0.00579	0.00058	19	19	19	0	0	1	-360	360;
	1580	1319	0.03802	0.07355	0.00658	90	90	90	0	0	1	-360	360;
	1321	1323	0	0.00083	5e-05	140	140	140	0	0	1	-360	360;
	1322	1476	0.0124	0.0281	0.00266	90	90	90	0	0	1	-360	360;
	1360	1323	0.00083	0.00124	0.00017	90	90	90	0	0	1	-360	360;
	1538	1329	0.02645	0.0843	0.00888	114	114	114	0	0	1	-360	360;
	1587	1329	0.00661	0.01405	0.00257	120	120	120	0	0	1	-360	360;
	1330	1587	0.00165	0.00331	0.00051	120	120	120	0	0	1	-360	360;
	1334	1332	0.00248	0.00661	0.00073	120	120	120	0	0	1	-360	360;
	1333	1335	0.00248	0.00744	0.00075	120	120	120	0	0	1	-360	360;
	1374	1335	0.00413	0.01157	0.00131	140	140	140	0	0	1	-360	360;
	1503	1339	0.00579	0.01901	0.00196	140	140	140	0	0	1	-360	360;
	1341	1468	0.00579	0.0157	0.00145	90	90	90	0	0	1	-360	360;
	1344	1343	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1574	1343	0.02397	0.07686	0.00832	114	114	114	0	0	1	-360	360;
	1520	1344	0.01901	0.06198	0.00651	140	140	140	0	0	1	-360	360;
	1426	1346	0.02479	0.08926	0.00888	85	85	85	0	0	1	-360	360;
	1527	1346	0.00496	0.01488	0.00157	114	114	114	0	0	1	-360	360;
	1579	1346	0.01488	0.04132	0.00411	120	120	120	0	0	1	-360	360;
	1553	1347	0.01736	0.03223	0.00312	90	90	90	0	0	1	-360	360;
	1452	1351	0.00248	0.00744	0.00077	140	140	140	0	0	1	-360	360;
	1494	1351	0.01901	0.06116	0.00656	140	140	140	0	0	1	-360	360;
	1352	1353	0.00248	0.00826	0.00077	57	57	57	0	0	1	-360	360;
	1539	1353	0.00083	0.00165	0.00024	114	114	114	0	0	1	-360	360;
	1356	1390	0.00579	0.01653	0.00184	120	120	120	0	0	1	-360	360;
	1476	1360	0.00744	0.0124	0.00179	90	90	90	0	0	1	-360	360;
	1362	1361	0.00165	0.00413	0.00044	57	57	57	0	0	1	-360	360;
	1362	1570	0.00413	0.0124	0.00128	114	114	114	0	0	1	-360	360;
	1363	1499	0.00826	0.02149	0.0024	120	120	120	0	0	1	-360	360;
	1364	1365	0	0.00083	2e-05	120	120	120	0	0	1	-360	360;
	1502	1366	0.00579	0.01818	0.00191	140	140	140	0	0	1	-360	360;
	1432	1367	0.0876	0.17025	0.01607	90	90	90	0	0	1	-360	360;
	1533	1369	0.0157	0.05041	0.00528	114	114	114	0	0	1	-360	360;
	1369	1601	0.02893	0.09008	0.01002	114	114	114	0	0	1	-360	360;
	1371	1370	0	0.00083	2e-05	90	90	90	0	0	1	-360	360;
	1552	1371	0.00661	0.01074	0.00114	90	90	90	0	0	1	-360	360;
	1524	1373	0.01901	0.05289	0.00552	120	120	120	0	0	1	-360	360;
	1376	1375	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1445	1375	0.00496	0.01488	0.00167	114	114	114	0	0	1	-360	360;
	1376	1392	0.00083	0.00331	0.00039	114	114	114	0	0	1	-360	360;
	1376	1538	0.01818	0.05702	0.00646	114	114	114	0	0	1	-360	360;
	1377	1378	0.00248	0.00579	0.00128	90	90	90	0	0	1	-360	360;
	1540	1378	0.00496	0.01405	0.00162	140	140	140	0	0	1	-360	360;
	1388	1379	0.00331	0.00992	0.00114	114	114	114	0	0	1	-360	360;
	1381	1512	0.00248	0.00826	0.00094	140	140	140	0	0	1	-360	360;
	1383	1382	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1383	1482	0.01488	0.0438	0.0052	114	114	114	0	0	1	-360	360;
	1576	1383	0.04793	0.11983	0.01324	120	120	120	0	0	1	-360	360;
	1384	1565	0.0124	0.03223	0.00353	120	120	120	0	0	1	-360	360;
	1426	1386	0.01488	0.03223	0.00499	120	120	120	0	0	1	-360	360;
	1552	1388	0.02397	0.07769	0.00799	114	114	114	0	0	1	-360	360;
	1537	1389	0.01157	0.03636	0.00426	114	114	114	0	0	1	-360	360;
	1391	1392	0.00165	0.00331	0.00044	140	140	140	0	0	1	-360	360;
	1394	1393	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1502	1394	0.03967	0.13388	0.0129	85	85	85	0	0	1	-360	360;
	1395	1397	0.00083	0.00165	0.00022	140	140	140	0	0	1	-360	360;
	1443	1397	0.00826	0.05207	0.00537	140	140	140	0	0	1	-360	360;
	1416	1398	0.00248	0.00826	0.00092	140	140	140	0	0	1	-360	360;
	1398	1544	0.00413	0.01405	0.00152	140	140	140	0	0	1	-360	360;
	1465	1399	0.00744	0.02397	0.0023	89	89	89	0	0	1	-360	360;
	1584	1399	0.00826	0.02645	0.00264	140	140	140	0	0	1	-360	360;
	1400	1401	0.00248	0.00661	0.00075	114	114	114	0	0	1	-360	360;
	1539	1404	0.00248	0.00744	0.00077	120	120	120	0	0	1	-360	360;
	1540	1405	0.00248	0.00744	0.00077	120	120	120	0	0	1	-360	360;
	1406	1407	0.00165	0.00331	0.00036	19	19	19	0	0	1	-360	360;
	1581	1407	0.10165	0.20083	0.01742	90	90	90	0	0	1	-360	360;
	1411	1408	0.00331	0.01074	0.00123	140	140	140	0	0	1	-360	360;
	1410	1601	0.01983	0.0314	0.00511	90	90	90	0	0	1	-360	360;
	1412	1413	0.00248	0.00744	0.00087	140	140	140	0	0	1	-360	360;
	1413	1556	0.0157	0.04793	0.00571	140	140	140	0	0	1	-360	360;
	1430	1414	0.0157	0.04793	0.00566	85	85	85	0	0	1	-360	360;
	1415	1453	0.00992	0.03223	0.00346	114	114	114	0	0	1	-360	360;
	1537	1415	0.01736	0.0562	0.00598	140	140	140	0	0	1	-360	360;
	1416	1440	0.01736	0.05537	0.00518	120	120	120	0	0	1	-360	360;
	1514	1416	0.00909	0.02727	0.00317	140	140	140	0	0	1	-360	360;
	1551	1416	0.00413	0.01322	0.00155	140	140	140	0	0	1	-360	360;
	1417	1548	0.01736	0.05207	0.00503	85	85	85	0	0	1	-360	360;
	1550	1418	0.00413	0.01322	0.00155	140	140	140	0	0	1	-360	360;
	1422	1421	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1421	1423	0.0124	0.03802	0.00448	140	140	140	0	0	1	-360	360;
	1423	1463	0.00744	0.02066	0.00213	120	120	120	0	0	1	-360	360;
	1445	1424	0.00331	0.01157	0.00109	140	140	140	0	0	1	-360	360;
	1489	1426	0.04545	0.23719	0.02485	114	114	114	0	0	1	-360	360;
	1431	1427	0.00083	0.00661	0.00075	152	152	152	0	0	1	-360	360;
	1432	1427	0.00083	0.00413	0.00058	152	152	152	0	0	1	-360	360;
	1595	1430	0.00826	0.02645	0.0031	114	114	114	0	0	1	-360	360;
	1432	1431	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1489	1431	0.04545	0.23388	0.02439	114	114	114	0	0	1	-360	360;
	1576	1433	0.00165	0.00331	0.00036	57	57	57	0	0	1	-360	360;
	1577	1434	0.00083	0.00331	0.00039	57	57	57	0	0	1	-360	360;
	1475	1435	0.02645	0.03388	0.0062	90	90	90	0	0	1	-360	360;
	1435	1518	0.00826	0.02479	0.00295	90	90	90	0	0	1	-360	360;
	1439	1437	0.0124	0.0157	0.00302	90	90	90	0	0	1	-360	360;
	1440	1438	0.01322	0.0157	0.00305	90	90	90	0	0	1	-360	360;
	1513	1439	0.0157	0.04628	0.00445	120	120	120	0	0	1	-360	360;
	1441	1443	0.00248	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	1539	1442	0.00248	0.00744	0.00085	140	140	140	0	0	1	-360	360;
	1540	1443	0.00744	0.02397	0.00271	114	114	114	0	0	1	-360	360;
	1448	1446	0.00496	0.00826	0.00092	90	90	90	0	0	1	-360	360;
	1449	1447	0.00496	0.00826	0.0009	90	90	90	0	0	1	-360	360;
	1455	1504	0.00248	0.01488	0.00174	232	232	232	0	0	1	-360	360;
	1456	1504	0.00248	0.01488	0.00174	232	232	232	0	0	1	-360	360;
	1457	1459	0	0.00083	5e-05	140	140	140	0	0	1	-360	360;
	1460	1458	0.00165	0.00579	0.00053	140	140	140	0	0	1	-360	360;
	1533	1461	0.02066	0.06529	0.0069	114	114	114	0	0	1	-360	360;
	1600	1461	0.00909	0.01488	0.00162	90	90	90	0	0	1	-360	360;
	1466	1482	0.00413	0.01322	0.0015	114	114	114	0	0	1	-360	360;
	1470	1469	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1469	1515	0.03719	0.11983	0.01268	114	114	114	0	0	1	-360	360;
	1469	1554	0.00744	0.01157	0.00126	90	90	90	0	0	1	-360	360;
	1470	1555	0.00744	0.01157	0.00123	90	90	90	0	0	1	-360	360;
	1477	1574	0.04132	0.05372	0.00987	90	90	90	0	0	1	-360	360;
	1503	1483	0.01074	0.02893	0.00334	120	120	120	0	0	1	-360	360;
	1502	1484	0.00992	0.03058	0.00356	140	140	140	0	0	1	-360	360;
	1549	1486	0.00083	0.00331	0.00044	120	120	120	0	0	1	-360	360;
	1492	1487	0.00331	0.01074	0.00114	140	140	140	0	0	1	-360	360;
	1491	1490	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1493	1494	0.00165	0.00579	0.00053	140	140	140	0	0	1	-360	360;
	1537	1494	0.01074	0.03388	0.00353	140	140	140	0	0	1	-360	360;
	1496	1498	0.00413	0.00579	0.00077	75	75	75	0	0	1	-360	360;
	1497	1499	0.00413	0.00579	0.0007	75	75	75	0	0	1	-360	360;
	1526	1498	0.01157	0.02975	0.00327	120	120	120	0	0	1	-360	360;
	1503	1502	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1515	1502	0.01157	0.03802	0.00409	140	140	140	0	0	1	-360	360;
	1534	1504	0.01157	0.03223	0.00327	120	120	120	0	0	1	-360	360;
	1542	1505	0.00413	0.0124	0.00121	140	140	140	0	0	1	-360	360;
	1505	1557	0.00909	0.0314	0.00278	120	120	120	0	0	1	-360	360;
	1508	1506	0.00413	0.01322	0.0014	114	114	114	0	0	1	-360	360;
	1517	1506	0.00413	0.00992	0.00203	140	140	140	0	0	1	-360	360;
	1517	1507	0.00992	0.03058	0.00324	114	114	114	0	0	1	-360	360;
	1509	1511	0.00083	0.00165	0.00019	140	140	140	0	0	1	-360	360;
	1517	1584	0.00826	0.02645	0.00273	140	140	140	0	0	1	-360	360;
	1541	1518	0.01405	0.04628	0.00486	114	114	114	0	0	1	-360	360;
	1519	1520	0.00661	0.00826	0.0016	90	90	90	0	0	1	-360	360;
	1521	1522	0	0.00083	2e-05	90	90	90	0	0	1	-360	360;
	1529	1531	0.00083	0.00124	0.00017	114	114	114	0	0	1	-360	360;
	1530	1532	0.00083	0.00248	0.00024	114	114	114	0	0	1	-360	360;
	1583	1540	0.00496	0.0124	0.00145	120	120	120	0	0	1	-360	360;
	1548	1547	0.00083	0.00331	0.00029	28	28	28	0	0	1	-360	360;
	1548	1579	0.01901	0.05289	0.00511	120	120	120	0	0	1	-360	360;
	1578	1560	0.00579	0.02066	0.00208	140	140	140	0	0	1	-360	360;
	1592	1560	0	0.00083	5e-05	140	140	140	0	0	1	-360	360;
	1563	1564	0.00083	0.00165	0.00017	90	90	90	0	0	1	-360	360;
	1565	1573	0.00579	0.01736	0.00196	140	140	140	0	0	1	-360	360;
	1567	1569	0	0.00083	2e-05	114	114	114	0	0	1	-360	360;
	1568	1570	0	0.00083	2e-05	140	140	140	0	0	1	-360	360;
	1581	1580	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1586	1582	0.00165	0.00496	0.00053	140	140	140	0	0	1	-360	360;
	1588	1589	0.00331	0.00992	0.00094	140	140	140	0	0	1	-360	360;
	1590	1592	0.00413	0.01405	0.00162	140	140	140	0	0	1	-360	360;
	1729	1602	0.01471	0.03736	0.00382	120	120	120	0	0	1	-360	360;
	2001	1602	0.00504	0.01413	0.00145	120	120	120	0	0	1	-360	360;
	1605	1603	0.01351	0.02349	0.00224	68	68	68	0	0	1	-360	360;
	1759	1603	0.03198	0.08107	0.00828	120	120	120	0	0	1	-360	360;
	2103	1603	0.00129	0.00374	0.00038	120	120	120	0	0	1	-360	360;
	1604	1605	0.00276	0.00483	0.00046	68	68	68	0	0	1	-360	360;
	1606	1673	0.00499	0.01691	0.00147	137	137	137	0	0	1	-360	360;
	2095	1606	0.0061	0.02065	0.00204	137	137	137	0	0	1	-360	360;
	1809	1607	0.02676	0.07689	0.00772	120	120	120	0	0	1	-360	360;
	2226	1607	0.03926	0.10744	0.01108	120	120	120	0	0	1	-360	360;
	1687	1608	0.02157	0.04835	0.00487	90	90	90	0	0	1	-360	360;
	1826	1608	0.01165	0.02074	0.00212	90	90	90	0	0	1	-360	360;
	1700	1609	0.03507	0.11878	0.01176	137	137	137	0	0	1	-360	360;
	1823	1609	0.04107	0.13909	0.01377	137	137	137	0	0	1	-360	360;
	2087	1609	0.01769	0.05744	0.00596	137	137	137	0	0	1	-360	360;
	1611	1610	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1623	1610	0.00661	0.01983	0.0023	90	90	90	0	0	1	-360	360;
	1987	1610	0.01762	0.04135	0.00402	90	90	90	0	0	1	-360	360;
	1641	1612	0.03793	0.0724	0.00708	90	90	90	0	0	1	-360	360;
	1662	1612	0.00347	0.00405	0.00162	90	90	90	0	0	1	-360	360;
	1613	1859	0.00577	0.01954	0.00193	137	137	137	0	0	1	-360	360;
	1921	1613	0.00228	0.00772	0.00076	137	137	137	0	0	1	-360	360;
	1656	1614	0.01165	0.03463	0.00356	90	90	90	0	0	1	-360	360;
	1867	1615	0.0376	0.0676	0.00651	90	90	90	0	0	1	-360	360;
	1848	1616	0.0138	0.02421	0.0023	90	90	90	0	0	1	-360	360;
	1616	2071	0.01877	0.03282	0.00313	90	90	90	0	0	1	-360	360;
	1618	1617	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1840	1617	0.04902	0.12753	0.01292	120	120	120	0	0	1	-360	360;
	2031	1617	0.00945	0.02846	0.0028	90	90	90	0	0	1	-360	360;
	1619	1618	0.0065	0.02202	0.00218	120	120	120	0	0	1	-360	360;
	1651	1618	0.04283	0.09787	0.00953	90	90	90	0	0	1	-360	360;
	1984	1618	0.02486	0.04348	0.00415	137	137	137	0	0	1	-360	360;
	1777	1619	0.01074	0.03471	0.00356	114	114	114	0	0	1	-360	360;
	1839	1619	0.05489	0.14743	0.01489	120	120	120	0	0	1	-360	360;
	2030	1619	0.00451	0.01529	0.00151	137	137	137	0	0	1	-360	360;
	1621	1620	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1897	1620	0.00661	0.00992	0.00106	68	68	68	0	0	1	-360	360;
	1620	2059	0.00405	0.01306	0.00136	120	120	120	0	0	1	-360	360;
	1622	1894	0.00372	0.01248	0.00116	120	120	120	0	0	1	-360	360;
	1622	2076	0.00617	0.01736	0.00174	120	120	120	0	0	1	-360	360;
	1830	1623	0.03223	0.05537	0.00307	90	90	90	0	0	1	-360	360;
	1832	1623	0.01157	0.0281	0.00286	120	120	120	0	0	1	-360	360;
	2383	1623	0.05787	0.10132	0.00967	90	90	90	0	0	1	-360	360;
	1734	1624	0.01753	0.05936	0.00588	137	137	137	0	0	1	-360	360;
	1889	1624	0.02479	0.04298	0.00423	90	90	90	0	0	1	-360	360;
	1624	1898	0.01135	0.03509	0.00346	90	90	90	0	0	1	-360	360;
	2383	1624	0.05787	0.10132	0.00967	90	90	90	0	0	1	-360	360;
	1820	1625	0.02213	0.07514	0.00742	91	91	91	0	0	1	-360	360;
	1940	1625	0.04678	0.05793	0.00462	91	91	91	0	0	1	-360	360;
	1626	2113	0.01499	0.03154	0.0031	90	90	90	0	0	1	-360	360;
	1627	2087	0.05234	0.09155	0.00873	68	68	68	0	0	1	-360	360;
	2107	1628	0.00744	0.02397	0.00244	120	120	120	0	0	1	-360	360;
	2112	1628	0.00661	0.00909	0.00116	120	120	120	0	0	1	-360	360;
	1659	1629	0.01711	0.05562	0.0048	137	137	137	0	0	1	-360	360;
	1823	1629	0.02099	0.06934	0.00699	137	137	137	0	0	1	-360	360;
	1840	1630	0.02727	0.0686	0.00666	120	120	120	0	0	1	-360	360;
	1631	1647	0.03669	0.09165	0.0094	120	120	120	0	0	1	-360	360;
	1632	1664	9e-05	0.00069	7e-05	137	137	137	0	0	1	-360	360;
	1693	1632	0.00555	0.01818	0.00186	137	137	137	0	0	1	-360	360;
	1633	1874	0.01452	0.04917	0.00487	90	90	90	0	0	1	-360	360;
	1633	1906	0.02276	0.0771	0.00763	137	137	137	0	0	1	-360	360;
	1860	1634	0.0295	0.05017	0.00484	90	90	90	0	0	1	-360	360;
	1634	2113	0.02711	0.04612	0.00445	90	90	90	0	0	1	-360	360;
	1636	1635	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1743	1635	0.03793	0.06612	0.00641	90	90	90	0	0	1	-360	360;
	1810	1635	0.01405	0.04463	0.00484	120	120	120	0	0	1	-360	360;
	1748	1637	0.02893	0.04711	0.00527	90	90	90	0	0	1	-360	360;
	1871	1637	0.0338	0.05537	0.00595	66	66	66	0	0	1	-360	360;
	1932	1637	0.0157	0.04793	0.00515	137	137	137	0	0	1	-360	360;
	2045	1637	0.00413	0.00661	0.00073	90	90	90	0	0	1	-360	360;
	1990	1638	0.01198	0.04056	0.00401	137	137	137	0	0	1	-360	360;
	2044	1638	0.00413	0.00661	0.00073	90	90	90	0	0	1	-360	360;
	2070	1638	0.01438	0.02405	0.00249	90	90	90	0	0	1	-360	360;
	1735	1639	0.02967	0.07661	0.00777	120	120	120	0	0	1	-360	360;
	1639	2103	0.02833	0.07349	0.00745	120	120	120	0	0	1	-360	360;
	1903	1640	0.01165	0.03957	0.00392	91	91	91	0	0	1	-360	360;
	2015	1640	0.02992	0.10136	0.01003	137	137	137	0	0	1	-360	360;
	2020	1641	0.02182	0.07107	0.00737	137	137	137	0	0	1	-360	360;
	1649	1642	0.03322	0.05661	0.00545	120	120	120	0	0	1	-360	360;
	1692	1642	0.01214	0.04112	0.00407	137	137	137	0	0	1	-360	360;
	1846	1643	0.05033	0.13388	0.01203	90	90	90	0	0	1	-360	360;
	2024	1643	0.02851	0.09843	0.00896	137	137	137	0	0	1	-360	360;
	1761	1644	0.04537	0.07694	0.00779	90	90	90	0	0	1	-360	360;
	1971	1644	0.02248	0.0386	0.00382	90	90	90	0	0	1	-360	360;
	1645	1650	0.06463	0.10992	0.01059	137	137	137	0	0	1	-360	360;
	1776	1645	0.02439	0.06359	0.01204	137	137	137	0	0	1	-360	360;
	1655	1646	0.00537	0.01512	0.00153	120	120	120	0	0	1	-360	360;
	1674	1646	0.00074	0.00231	0.00024	137	137	137	0	0	1	-360	360;
	1648	1647	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1731	1647	0.00592	0.01857	0.00199	90	90	90	0	0	1	-360	360;
	1767	1647	0.02719	0.04917	0.00478	90	90	90	0	0	1	-360	360;
	1886	1647	0.0129	0.02274	0.0022	90	90	90	0	0	1	-360	360;
	1887	1647	0.01204	0.02472	0.00244	90	90	90	0	0	1	-360	360;
	2027	1647	0.00157	0.00512	0.00053	120	120	120	0	0	1	-360	360;
	2028	1647	0.00153	0.00493	0.0005	120	120	120	0	0	1	-360	360;
	1752	1649	0.0157	0.04959	0.00511	120	120	120	0	0	1	-360	360;
	1884	1649	0.03719	0.11901	0.0122	114	114	114	0	0	1	-360	360;
	1948	1649	0.06583	0.22298	0.02208	137	137	137	0	0	1	-360	360;
	1956	1649	0.00413	0.0314	0.003	137	137	137	0	0	1	-360	360;
	1930	1650	0.00447	0.01463	0.00151	120	120	120	0	0	1	-360	360;
	1931	1650	0.02066	0.06612	0.00678	120	120	120	0	0	1	-360	360;
	2068	1650	0.0207	0.07012	0.00694	137	137	137	0	0	1	-360	360;
	1650	2077	0.00687	0.02326	0.0023	120	120	120	0	0	1	-360	360;
	1916	1651	0.01319	0.04467	0.00442	137	137	137	0	0	1	-360	360;
	1663	1652	0.02174	0.05	0.00501	90	90	90	0	0	1	-360	360;
	1804	1652	0.03471	0.06744	0.00663	90	90	90	0	0	1	-360	360;
	1918	1653	0.00165	0.00537	0.00055	137	137	137	0	0	1	-360	360;
	2018	1653	0.00182	0.00595	0.00063	137	137	137	0	0	1	-360	360;
	1669	1654	0.04421	0.11367	0.01112	91	91	91	0	0	1	-360	360;
	1950	1654	0.02228	0.07545	0.00747	91	91	91	0	0	1	-360	360;
	1901	1655	0.00686	0.02198	0.00228	137	137	137	0	0	1	-360	360;
	1673	1656	0.00603	0.01785	0.00183	91	91	91	0	0	1	-360	360;
	1917	1656	0.02204	0.07467	0.00739	91	91	91	0	0	1	-360	360;
	1657	2002	0.0157	0.05157	0.00528	137	137	137	0	0	1	-360	360;
	2106	1657	0.01031	0.01797	0.00171	90	90	90	0	0	1	-360	360;
	1693	1658	0.02058	0.0676	0.00569	137	137	137	0	0	1	-360	360;
	1845	1658	0.01983	0.05504	0.00595	76	76	76	0	0	1	-360	360;
	1913	1658	0.00926	0.0186	0.00181	90	90	90	0	0	1	-360	360;
	1658	2078	0.00375	0.01025	0.00103	76	76	76	0	0	1	-360	360;
	1985	1659	0.02521	0.08264	0.00847	137	137	137	0	0	1	-360	360;
	1737	1660	0.00161	0.00529	0.00054	137	137	137	0	0	1	-360	360;
	1805	1660	0.00302	0.01	0.00102	137	137	137	0	0	1	-360	360;
	1667	1661	0.05636	0.10521	0.01021	90	90	90	0	0	1	-360	360;
	1804	1661	0.04669	0.09545	0.00939	90	90	90	0	0	1	-360	360;
	1788	1662	0.03397	0.05942	0.00567	90	90	90	0	0	1	-360	360;
	1826	1662	0.0676	0.11446	0.01106	90	90	90	0	0	1	-360	360;
	1992	1663	0.04463	0.09421	0.00963	76	76	76	0	0	1	-360	360;
	1665	1664	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1664	1775	0.00064	0.00483	0.00047	137	137	137	0	0	1	-360	360;
	2020	1664	0.01289	0.04198	0.00436	137	137	137	0	0	1	-360	360;
	1667	1666	0.01835	0.06256	0.00605	137	137	137	0	0	1	-360	360;
	1983	1666	0.02521	0.08182	0.00917	137	137	137	0	0	1	-360	360;
	2038	1667	0.04116	0.10446	0.01043	120	120	120	0	0	1	-360	360;
	1668	1743	0.03853	0.06806	0.0065	90	90	90	0	0	1	-360	360;
	1797	1668	0.02515	0.0455	0.00437	120	120	120	0	0	1	-360	360;
	1670	1669	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1700	1669	0.05702	0.11331	0.01091	90	90	90	0	0	1	-360	360;
	1758	1669	0.01033	0.01802	0.00172	90	90	90	0	0	1	-360	360;
	1671	2060	0.00744	0.01917	0.00197	120	120	120	0	0	1	-360	360;
	2059	1672	0.00182	0.00463	0.00047	120	120	120	0	0	1	-360	360;
	1851	1673	0.00292	0.00988	0.00098	120	120	120	0	0	1	-360	360;
	1986	1673	0.01126	0.03814	0.00378	91	91	91	0	0	1	-360	360;
	1854	1674	0.00281	0.00909	0.00094	137	137	137	0	0	1	-360	360;
	1893	1674	0.00259	0.00876	0.00087	137	137	137	0	0	1	-360	360;
	1918	1674	0.00519	0.01413	0.00143	120	120	120	0	0	1	-360	360;
	1684	1675	0.01393	0.04721	0.00467	91	91	91	0	0	1	-360	360;
	1675	1917	0.01214	0.04112	0.00407	91	91	91	0	0	1	-360	360;
	1864	1676	0.04152	0.07429	0.0071	90	90	90	0	0	1	-360	360;
	1945	1676	0.05017	0.08774	0.00837	90	90	90	0	0	1	-360	360;
	1907	1677	0.00731	0.01279	0.00122	90	90	90	0	0	1	-360	360;
	1926	1678	0.02035	0.03558	0.0034	90	90	90	0	0	1	-360	360;
	1757	1679	0.06926	0.12157	0.01174	90	90	90	0	0	1	-360	360;
	1998	1679	0.01818	0.05884	0.00612	137	137	137	0	0	1	-360	360;
	1681	1680	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1921	1680	0.02689	0.05343	0.00384	90	90	90	0	0	1	-360	360;
	1960	1680	0.00628	0.01058	0.00108	90	90	90	0	0	1	-360	360;
	1997	1680	0.0096	0.02474	0.00251	120	120	120	0	0	1	-360	360;
	2012	1680	0.01093	0.037	0.00366	137	137	137	0	0	1	-360	360;
	1834	1681	0.00843	0.02298	0.00232	90	90	90	0	0	1	-360	360;
	1859	1681	0.0078	0.02641	0.00262	137	137	137	0	0	1	-360	360;
	1904	1681	0.01144	0.03023	0.00306	120	120	120	0	0	1	-360	360;
	2096	1681	0.01777	0.03157	0.00301	90	90	90	0	0	1	-360	360;
	1683	1682	0.00688	0.02328	0.0023	137	137	137	0	0	1	-360	360;
	2029	1682	0.01445	0.04894	0.00484	137	137	137	0	0	1	-360	360;
	1684	1683	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2015	1684	0.04207	0.14132	0.01394	137	137	137	0	0	1	-360	360;
	2069	1685	0.04843	0.07405	0.00689	90	90	90	0	0	1	-360	360;
	1697	1686	0.0104	0.03704	0.00282	90	90	90	0	0	1	-360	360;
	1720	1686	0.0014	0.00463	0.00046	91	91	91	0	0	1	-360	360;
	1827	1686	0.02612	0.04421	0.00441	90	90	90	0	0	1	-360	360;
	1962	1686	0.02736	0.09182	0.00907	90	90	90	0	0	1	-360	360;
	1702	1687	0.00415	0.00726	0.00069	90	90	90	0	0	1	-360	360;
	1983	1687	0.02719	0.08793	0.0091	137	137	137	0	0	1	-360	360;
	1835	1688	0.06537	0.11488	0.01096	90	90	90	0	0	1	-360	360;
	2086	1688	0.03983	0.06967	0.00666	90	90	90	0	0	1	-360	360;
	1689	1702	0.00652	0.0114	0.00109	90	90	90	0	0	1	-360	360;
	1689	2062	0.00711	0.01244	0.00119	90	90	90	0	0	1	-360	360;
	1690	1878	0.02737	0.09213	0.00912	137	137	137	0	0	1	-360	360;
	1879	1690	0.01729	0.05855	0.0058	137	137	137	0	0	1	-360	360;
	1861	1691	0.0414	0.08355	0.00786	90	90	90	0	0	1	-360	360;
	1874	1691	0.01	0.03479	0.00317	137	137	137	0	0	1	-360	360;
	1695	1694	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1832	1694	0.01405	0.04463	0.0046	120	120	120	0	0	1	-360	360;
	1963	1694	0.0281	0.08926	0.00924	114	114	114	0	0	1	-360	360;
	1696	1697	0.00375	0.00656	0.00063	90	90	90	0	0	1	-360	360;
	1698	1814	0.03771	0.12774	0.01265	137	137	137	0	0	1	-360	360;
	1793	1699	0.05149	0.17438	0.01725	137	137	137	0	0	1	-360	360;
	1912	1701	0.01289	0.03372	0.00333	120	120	120	0	0	1	-360	360;
	1922	1701	0.00661	0.01826	0.00194	120	120	120	0	0	1	-360	360;
	1788	1703	0.02967	0.04926	0.00486	90	90	90	0	0	1	-360	360;
	1951	1703	0.03149	0.05215	0.00515	90	90	90	0	0	1	-360	360;
	1956	1704	0.02893	0.08843	0.00973	120	120	120	0	0	1	-360	360;
	2112	1704	0.04298	0.10248	0.0105	90	90	90	0	0	1	-360	360;
	1705	1814	0.06808	0.1244	0.01294	90	90	90	0	0	1	-360	360;
	1974	1705	0.0043	0.01028	0.00143	90	90	90	0	0	1	-360	360;
	1706	2112	0.00245	0.00833	0.00083	114	114	114	0	0	1	-360	360;
	1707	2113	0.00245	0.00833	0.00083	114	114	114	0	0	1	-360	360;
	2113	1708	0.00496	0.01488	0.00167	120	120	120	0	0	1	-360	360;
	2046	1709	0.05893	0.12397	0.01197	90	90	90	0	0	1	-360	360;
	2112	1709	0.00496	0.01488	0.00167	120	120	120	0	0	1	-360	360;
	1710	1884	0.00435	0.0076	0.00072	68	68	68	0	0	1	-360	360;
	1711	1885	0.00435	0.0076	0.00072	68	68	68	0	0	1	-360	360;
	1713	1712	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1760	1712	0.0005	0.00397	0.00056	274	274	274	0	0	1	-360	360;
	1762	1712	0.0005	0.00397	0.00056	160	160	160	0	0	1	-360	360;
	2017	1712	0.00099	0.00793	0.00077	171	171	171	0	0	1	-360	360;
	2056	1714	0.00083	0.00248	0.00027	90	90	90	0	0	1	-360	360;
	1748	1715	0.01157	0.01983	0.00194	90	90	90	0	0	1	-360	360;
	1715	2022	0.00794	0.01591	0.00153	90	90	90	0	0	1	-360	360;
	1739	1716	0.02901	0.05165	0.00489	90	90	90	0	0	1	-360	360;
	1847	1716	0.01661	0.0295	0.00288	90	90	90	0	0	1	-360	360;
	1718	1717	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1717	1954	0.0166	0.05623	0.00557	9	9	9	0	0	1	-360	360;
	1717	1967	0.00826	0.01653	0.00194	120	120	120	0	0	1	-360	360;
	1717	2108	0.01676	0.05678	0.00562	114	114	114	0	0	1	-360	360;
	2085	1719	0.01132	0.03744	0.0037	137	137	137	0	0	1	-360	360;
	2087	1719	0.01157	0.03942	0.0039	137	137	137	0	0	1	-360	360;
	2071	1720	0.05945	0.10398	0.00992	90	90	90	0	0	1	-360	360;
	1871	1721	0.0157	0.04628	0.00501	68	68	68	0	0	1	-360	360;
	1722	1844	0.00752	0.01256	0.0013	57	57	57	0	0	1	-360	360;
	1731	1723	0.00579	0.01322	0.00138	90	90	90	0	0	1	-360	360;
	1838	1723	0.02893	0.05124	0.00469	90	90	90	0	0	1	-360	360;
	1795	1724	0.00405	0.01331	0.00138	137	137	137	0	0	1	-360	360;
	1906	1724	0.00574	0.01944	0.00192	137	137	137	0	0	1	-360	360;
	1725	1882	0.01364	0.0238	0.00227	68	68	68	0	0	1	-360	360;
	1727	1726	0.0038	0.01215	0.00123	137	137	137	0	0	1	-360	360;
	1756	1726	0.01529	0.04967	0.00518	91	91	91	0	0	1	-360	360;
	1766	1726	0.02843	0.05207	0.00498	90	90	90	0	0	1	-360	360;
	1825	1727	0.02017	0.04959	0.00508	120	120	120	0	0	1	-360	360;
	1870	1728	0.01711	0.05769	0.00567	137	137	137	0	0	1	-360	360;
	2104	1728	0.01455	0.05314	0.00523	137	137	137	0	0	1	-360	360;
	1787	1729	0.02504	0.06364	0.00724	120	120	120	0	0	1	-360	360;
	1884	1730	0.04628	0.07686	0.00755	76	76	76	0	0	1	-360	360;
	1981	1730	0.05124	0.08182	0.00949	90	90	90	0	0	1	-360	360;
	2027	1732	0.00661	0.0157	0.00165	120	120	120	0	0	1	-360	360;
	1735	1733	0.00504	0.01421	0.0015	120	120	120	0	0	1	-360	360;
	1737	1733	0.01645	0.04298	0.00443	120	120	120	0	0	1	-360	360;
	1767	1734	0.01893	0.0595	0.00656	120	120	120	0	0	1	-360	360;
	1808	1734	0.009	0.03048	0.00302	68	68	68	0	0	1	-360	360;
	1830	1734	0.01405	0.02314	0.00232	90	90	90	0	0	1	-360	360;
	2065	1736	0.00702	0.01752	0.00078	90	90	90	0	0	1	-360	360;
	1993	1737	0.0176	0.05694	0.00575	137	137	137	0	0	1	-360	360;
	1738	1883	0.00868	0.01512	0.00145	68	68	68	0	0	1	-360	360;
	1959	1739	0.04645	0.08174	0.00801	90	90	90	0	0	1	-360	360;
	1969	1739	0.01848	0.03232	0.00308	90	90	90	0	0	1	-360	360;
	1740	2064	0.02042	0.03616	0.00345	137	137	137	0	0	1	-360	360;
	1741	1882	0.02826	0.04942	0.00471	90	90	90	0	0	1	-360	360;
	1743	1742	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1963	1742	0.02479	0.03471	0.00419	90	90	90	0	0	1	-360	360;
	1901	1744	0.01413	0.04628	0.00475	137	137	137	0	0	1	-360	360;
	1906	1744	0.01612	0.05405	0.00532	137	137	137	0	0	1	-360	360;
	1999	1744	0.01372	0.04446	0.0046	91	91	91	0	0	1	-360	360;
	2043	1745	0.02983	0.05463	0.00552	90	90	90	0	0	1	-360	360;
	1862	1746	0.02269	0.06221	0.00629	90	90	90	0	0	1	-360	360;
	1746	2085	0.03124	0.10231	0.01048	137	137	137	0	0	1	-360	360;
	1800	1747	0.02893	0.04711	0.0053	90	90	90	0	0	1	-360	360;
	2041	1747	0.00331	0.00579	0.00055	90	90	90	0	0	1	-360	360;
	2044	1747	0.02562	0.0438	0.00455	90	90	90	0	0	1	-360	360;
	2056	1747	0.01157	0.01893	0.00191	90	90	90	0	0	1	-360	360;
	2082	1747	0.02149	0.0405	0.00358	90	90	90	0	0	1	-360	360;
	2042	1748	0.00331	0.00579	0.00061	90	90	90	0	0	1	-360	360;
	2055	1748	0.01157	0.01893	0.00201	90	90	90	0	0	1	-360	360;
	2061	1748	0.1	0.16529	0.01822	76	76	76	0	0	1	-360	360;
	2114	1748	0.04711	0.08182	0.00806	90	90	90	0	0	1	-360	360;
	1749	1755	0.00455	0.01263	0.00127	114	114	114	0	0	1	-360	360;
	1750	1919	0.01248	0.03219	0.00326	114	114	114	0	0	1	-360	360;
	1751	2072	0.0006	0.00103	0.0001	90	90	90	0	0	1	-360	360;
	1783	1752	0.00909	0.02893	0.00317	120	120	120	0	0	1	-360	360;
	1772	1753	0.00909	0.02645	0.00269	120	120	120	0	0	1	-360	360;
	1754	1920	0.01028	0.01795	0.00171	114	114	114	0	0	1	-360	360;
	1755	1773	0.01642	0.05563	0.00551	137	137	137	0	0	1	-360	360;
	1794	1756	0.01752	0.05438	0.00564	91	91	91	0	0	1	-360	360;
	1945	1757	0.03397	0.0581	0.00559	90	90	90	0	0	1	-360	360;
	1822	1758	0.0362	0.06339	0.00612	90	90	90	0	0	1	-360	360;
	1801	1759	0.00692	0.01922	0.00194	120	120	120	0	0	1	-360	360;
	1764	1760	0.01124	0.46322	0	80	80	80	0.9851	0	1	-360	360;
	1863	1760	0.01322	0.03289	0.00347	120	120	120	0	0	1	-360	360;
	1888	1760	0.01033	0.03405	0.00348	120	120	120	0	0	1	-360	360;
	1964	1760	0.01622	0.04179	0.00424	120	120	120	0	0	1	-360	360;
	1763	1761	0.01124	0.45248	0	80	80	80	0.9479	0	1	-360	360;
	1855	1761	0.00975	0.03207	0.00329	120	120	120	0	0	1	-360	360;
	1883	1761	0.00537	0.01545	0.00181	240	240	240	0	0	1	-360	360;
	2234	1761	0.04132	0.0876	0.0122	68	68	68	0	0	1	-360	360;
	1765	1883	0.00687	0.02322	0.0023	68	68	68	0	0	1	-360	360;
	1935	1766	0.02843	0.05207	0.00498	90	90	90	0	0	1	-360	360;
	1768	1919	0.00257	0.00449	0.00043	114	114	114	0	0	1	-360	360;
	1769	1919	0.00257	0.00449	0.00043	114	114	114	0	0	1	-360	360;
	1770	1920	0.00257	0.00449	0.00043	114	114	114	0	0	1	-360	360;
	1771	2066	0.00102	0.00347	0.00034	120	120	120	0	0	1	-360	360;
	1772	1801	0.02617	0.07269	0.00732	120	120	120	0	0	1	-360	360;
	1773	2066	0.00431	0.01388	0.00116	120	120	120	0	0	1	-360	360;
	1791	1774	0.00645	0.02187	0.00216	120	120	120	0	0	1	-360	360;
	1777	1776	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1942	1776	0.00579	0.01893	0.00191	76	76	76	0	0	1	-360	360;
	1782	1778	0.00496	0.01653	0.00177	137	137	137	0	0	1	-360	360;
	1919	1778	0.00248	0.00661	0.00068	137	137	137	0	0	1	-360	360;
	1920	1779	0.00248	0.00661	0.00068	137	137	137	0	0	1	-360	360;
	2067	1780	0.00031	0.00103	0.0001	90	90	90	0	0	1	-360	360;
	1920	1781	0.00579	0.01818	0.00186	120	120	120	0	0	1	-360	360;
	2077	1781	0.01209	0.04096	0.00406	120	120	120	0	0	1	-360	360;
	1783	1782	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1784	1919	0.00277	0.00937	0.00093	120	120	120	0	0	1	-360	360;
	2067	1784	0.01126	0.01969	0.00188	90	90	90	0	0	1	-360	360;
	1920	1785	0.00277	0.00937	0.00093	120	120	120	0	0	1	-360	360;
	1791	1786	0.00992	0.03058	0.00329	120	120	120	0	0	1	-360	360;
	2113	1786	0.00909	0.02727	0.0029	120	120	120	0	0	1	-360	360;
	1790	1789	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1919	1789	0.00826	0.02479	0.00278	137	137	137	0	0	1	-360	360;
	2113	1790	0.01322	0.04207	0.0046	120	120	120	0	0	1	-360	360;
	1792	1919	0.00942	0.03193	0.00316	120	120	120	0	0	1	-360	360;
	1796	1793	0.00653	0.02207	0.00216	91	91	91	0	0	1	-360	360;
	1796	1794	0.0024	0.00413	0.00039	90	90	90	0	0	1	-360	360;
	1894	1795	0.00174	0.00479	0.00048	120	120	120	0	0	1	-360	360;
	1796	1843	0.05967	0.10455	0.00995	90	90	90	0	0	1	-360	360;
	1878	1796	0.03793	0.09752	0.00999	120	120	120	0	0	1	-360	360;
	1798	1797	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1885	1799	0.10413	0.16851	0.01897	90	90	90	0	0	1	-360	360;
	1803	1802	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1802	2092	0.01475	0.04826	0.00495	120	120	120	0	0	1	-360	360;
	2065	1806	0.00355	0.00959	0.0008	90	90	90	0	0	1	-360	360;
	1829	1807	0.02562	0.07851	0.00842	137	137	137	0	0	1	-360	360;
	1839	1807	0.03223	0.07769	0.0044	120	120	120	0	0	1	-360	360;
	1964	1809	0.01348	0.03929	0.00394	120	120	120	0	0	1	-360	360;
	1811	1810	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2090	1810	0.04876	0.06942	0.01254	120	120	120	0	0	1	-360	360;
	1813	1812	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1865	1812	0.00122	0.00413	0.00041	34	34	34	0	0	1	-360	360;
	1865	1812	0.00122	0.00413	0.00041	34	34	34	0	0	1	-360	360;
	1815	1814	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1820	1814	0.00389	0.01322	0.0013	91	91	91	0	0	1	-360	360;
	1969	1814	0.03196	0.05589	0.00533	90	90	90	0	0	1	-360	360;
	2069	1814	0.03843	0.07041	0.00652	90	90	90	0	0	1	-360	360;
	1816	2068	0.00615	0.02083	0.00206	137	137	137	0	0	1	-360	360;
	1817	2061	0.0157	0.04628	0.00501	76	76	76	0	0	1	-360	360;
	1819	1818	0.00826	0.0124	0.00128	120	120	120	0	0	1	-360	360;
	1818	2068	0.00349	0.0118	0.00117	137	137	137	0	0	1	-360	360;
	1885	1819	0.0157	0.02562	0.00227	120	120	120	0	0	1	-360	360;
	1845	1821	0.02264	0.07355	0.00762	137	137	137	0	0	1	-360	360;
	1828	1822	0.02818	0.05818	0.0059	90	90	90	0	0	1	-360	360;
	1857	1822	0.02595	0.08512	0.00874	137	137	137	0	0	1	-360	360;
	1952	1822	0.03934	0.12917	0.0132	137	137	137	0	0	1	-360	360;
	1910	1823	0.02	0.03744	0.00365	90	90	90	0	0	1	-360	360;
	2084	1823	0.01421	0.04661	0.00477	137	137	137	0	0	1	-360	360;
	1824	1906	0.01344	0.02383	0.00227	90	90	90	0	0	1	-360	360;
	1926	1824	0.00698	0.01279	0.00098	90	90	90	0	0	1	-360	360;
	1825	2101	0.03744	0.09653	0.00989	120	120	120	0	0	1	-360	360;
	1985	1827	0.05901	0.1038	0.00996	90	90	90	0	0	1	-360	360;
	2098	1828	0.01256	0.0219	0.00212	90	90	90	0	0	1	-360	360;
	1942	1829	0.0124	0.04132	0.00419	120	120	120	0	0	1	-360	360;
	1838	1830	0.0157	0.02727	0.00252	90	90	90	0	0	1	-360	360;
	1846	1831	0.02706	0.09164	0.00907	90	90	90	0	0	1	-360	360;
	1864	1831	0.02078	0.03802	0.00364	90	90	90	0	0	1	-360	360;
	1976	1833	0.0343	0.06	0.00574	90	90	90	0	0	1	-360	360;
	2047	1833	0.03967	0.06934	0.00663	90	90	90	0	0	1	-360	360;
	1960	1834	0.00802	0.02174	0.0022	90	90	90	0	0	1	-360	360;
	1944	1835	0.03769	0.06554	0.00624	90	90	90	0	0	1	-360	360;
	1975	1836	0.03347	0.05893	0.00578	90	90	90	0	0	1	-360	360;
	2102	1836	0.02959	0.05471	0.00503	90	90	90	0	0	1	-360	360;
	1962	1837	0.02198	0.0738	0.00736	90	90	90	0	0	1	-360	360;
	2102	1837	0.03306	0.0586	0.00557	90	90	90	0	0	1	-360	360;
	2010	1839	0.00514	0.03512	0.0079	120	120	120	0	0	1	-360	360;
	2100	1839	0.01317	0.0446	0.00442	120	120	120	0	0	1	-360	360;
	2010	1840	0.00514	0.03512	0.0079	120	120	120	0	0	1	-360	360;
	2032	1841	0.06744	0.11802	0.01126	10	10	10	0	0	1	-360	360;
	1842	2054	0.02008	0.06818	0.00674	10	10	10	0	0	1	-360	360;
	2000	1843	0.06215	0.10504	0.01058	90	90	90	0	0	1	-360	360;
	2070	1844	0.01165	0.02124	0.00221	90	90	90	0	0	1	-360	360;
	1939	1845	0.06942	0.1405	0.01368	90	90	90	0	0	1	-360	360;
	1945	1845	0.0343	0.24545	0.02408	137	137	137	0	0	1	-360	360;
	1992	1846	0.0286	0.05322	0.00515	76	76	76	0	0	1	-360	360;
	2080	1846	0.04008	0.10222	0.01016	90	90	90	0	0	1	-360	360;
	1925	1847	0.02272	0.03973	0.00379	90	90	90	0	0	1	-360	360;
	1939	1848	0.04802	0.10264	0.01344	90	90	90	0	0	1	-360	360;
	1849	2071	0.02111	0.0715	0.00708	90	90	90	0	0	1	-360	360;
	1945	1850	0.02306	0.05736	0.00587	120	120	120	0	0	1	-360	360;
	1991	1850	0.01107	0.02744	0.00281	120	120	120	0	0	1	-360	360;
	1918	1852	0.00182	0.00455	0.00046	91	91	91	0	0	1	-360	360;
	1926	1853	0.01475	0.04998	0.00495	90	90	90	0	0	1	-360	360;
	1986	1853	0.01124	0.03818	0.00378	91	91	91	0	0	1	-360	360;
	1924	1854	0.00339	0.01099	0.00114	137	137	137	0	0	1	-360	360;
	2101	1855	0.03488	0.09488	0.00972	120	120	120	0	0	1	-360	360;
	1986	1856	0.04033	0.06893	0.00692	91	91	91	0	0	1	-360	360;
	2047	1856	0.02504	0.04289	0.00428	137	137	137	0	0	1	-360	360;
	1858	1998	0.01947	0.06595	0.00653	137	137	137	0	0	1	-360	360;
	1862	1860	0.00943	0.01889	0.00185	90	90	90	0	0	1	-360	360;
	2093	1861	0.02413	0.07851	0.0082	137	137	137	0	0	1	-360	360;
	2023	1863	0.03669	0.0943	0.00985	120	120	120	0	0	1	-360	360;
	1866	1865	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1949	1865	0.0338	0.08099	0.00927	91	91	91	0	0	1	-360	360;
	1963	1865	0.01818	0.04132	0.00465	114	114	114	0	0	1	-360	360;
	2090	1865	0.03025	0.10165	0.01002	120	120	120	0	0	1	-360	360;
	1946	1867	0.01702	0.05512	0.00571	137	137	137	0	0	1	-360	360;
	1880	1868	0.02314	0.05868	0.00574	120	120	120	0	0	1	-360	360;
	2105	1868	0.03967	0.06942	0.00666	90	90	90	0	0	1	-360	360;
	1877	1869	0.01793	0.05818	0.00603	91	91	91	0	0	1	-360	360;
	1978	1869	0.01438	0.04653	0.00481	137	137	137	0	0	1	-360	360;
	1881	1873	0.02231	0.07182	0.00702	137	137	137	0	0	1	-360	360;
	1994	1873	0.0314	0.10545	0.01041	34	34	34	0	0	1	-360	360;
	2013	1873	0.02546	0.08496	0.00635	137	137	137	0	0	1	-360	360;
	1873	2070	0.03876	0.06463	0.00668	90	90	90	0	0	1	-360	360;
	1876	1875	0.01661	0.02917	0.00278	90	90	90	0	0	1	-360	360;
	1877	1875	0.00388	0.00669	0.00063	90	90	90	0	0	1	-360	360;
	1878	1876	0.0076	0.01802	0.00179	90	90	90	0	0	1	-360	360;
	1877	1880	0.01975	0.20967	0.0325	137	137	137	0	0	1	-360	360;
	2065	1877	0.02388	0.06711	0.00621	90	90	90	0	0	1	-360	360;
	1935	1878	0.06438	0.1138	0.01096	90	90	90	0	0	1	-360	360;
	1932	1880	0.00744	0.02397	0.00257	137	137	137	0	0	1	-360	360;
	1947	1880	0.02975	0.1	0.01009	137	137	137	0	0	1	-360	360;
	2050	1880	0.00744	0.02562	0.00278	137	137	137	0	0	1	-360	360;
	2000	1881	0.01372	0.04446	0.00439	137	137	137	0	0	1	-360	360;
	2033	1881	0.03793	0.11653	0.01251	120	120	120	0	0	1	-360	360;
	2035	1881	0.00909	0.02975	0.00319	137	137	137	0	0	1	-360	360;
	2079	1881	0.00877	0.02969	0.00294	137	137	137	0	0	1	-360	360;
	2016	1882	0.00397	0.02917	0.00283	274	274	274	0	0	1	-360	360;
	2273	1882	0.08207	0.20008	0.02217	91	91	91	0	0	1	-360	360;
	2333	1882	0.03719	0.09669	0.01016	120	120	120	0	0	1	-360	360;
	2064	1883	0.01654	0.05601	0.00554	137	137	137	0	0	1	-360	360;
	2244	1883	0.05628	0.18322	0.01876	120	120	120	0	0	1	-360	360;
	2278	1883	0.04463	0.11521	0.01205	120	120	120	0	0	1	-360	360;
	1884	2061	0.03306	0.04959	0.00605	76	76	76	0	0	1	-360	360;
	2110	1884	0.02209	0.05774	0.00565	76	76	76	0	0	1	-360	360;
	1934	1885	0.04207	0.07025	0.00733	68	68	68	0	0	1	-360	360;
	2111	1885	0.01902	0.04153	0.00864	90	90	90	0	0	1	-360	360;
	1961	1886	0.00636	0.02155	0.00213	91	91	91	0	0	1	-360	360;
	1943	1888	0.01463	0.04793	0.00491	137	137	137	0	0	1	-360	360;
	1890	1889	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1987	1889	0.01405	0.02727	0.00278	90	90	90	0	0	1	-360	360;
	1892	1891	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2021	1891	0.00992	0.01736	0.00172	90	90	90	0	0	1	-360	360;
	2041	1892	0.00909	0.01736	0.00165	90	90	90	0	0	1	-360	360;
	1923	1893	0.00968	0.03279	0.00325	137	137	137	0	0	1	-360	360;
	1900	1895	0.00864	0.0173	0.00166	90	90	90	0	0	1	-360	360;
	1927	1895	0.00793	0.02678	0.00264	137	137	137	0	0	1	-360	360;
	1896	2060	0.00013	0.00034	3e-05	120	120	120	0	0	1	-360	360;
	1897	1988	0.01801	0.04644	0.00935	114	114	114	0	0	1	-360	360;
	1899	1898	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2014	1898	0.01201	0.02671	0.00259	90	90	90	0	0	1	-360	360;
	1903	1900	0.00983	0.03322	0.00328	137	137	137	0	0	1	-360	360;
	2073	1900	0.00116	0.0038	0.00038	137	137	137	0	0	1	-360	360;
	1901	1924	0.0019	0.00603	0.00061	137	137	137	0	0	1	-360	360;
	1902	2002	0.02479	0.08132	0.00834	137	137	137	0	0	1	-360	360;
	2073	1902	0.01917	0.06388	0.00598	137	137	137	0	0	1	-360	360;
	2075	1902	0.01669	0.03529	0.00341	90	90	90	0	0	1	-360	360;
	2104	1903	0.0605	0.11818	0.01159	90	90	90	0	0	1	-360	360;
	1907	1906	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1906	1928	0.00959	0.02474	0.00251	120	120	120	0	0	1	-360	360;
	1959	1906	0.02397	0.04223	0.00414	90	90	90	0	0	1	-360	360;
	1914	1907	0.08066	0.14207	0.01348	90	90	90	0	0	1	-360	360;
	1907	1929	0.00959	0.02474	0.00251	120	120	120	0	0	1	-360	360;
	1908	1920	0.00012	0.0004	4e-05	137	137	137	0	0	1	-360	360;
	1909	1919	0.0001	0.00031	3e-05	137	137	137	0	0	1	-360	360;
	2097	1910	0.00793	0.01537	0.0015	90	90	90	0	0	1	-360	360;
	1996	1911	0.01612	0.05281	0.00541	114	114	114	0	0	1	-360	360;
	2112	1911	0.02479	0.08008	0.0083	114	114	114	0	0	1	-360	360;
	2096	1912	0.00818	0.02149	0.00212	120	120	120	0	0	1	-360	360;
	2086	1913	0.01314	0.02554	0.00246	90	90	90	0	0	1	-360	360;
	1915	1914	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1975	1914	0.02347	0.05785	0.00593	91	91	91	0	0	1	-360	360;
	2038	1914	0.03364	0.08545	0.00874	91	91	91	0	0	1	-360	360;
	2100	1916	0.0126	0.04265	0.00422	137	137	137	0	0	1	-360	360;
	2066	1920	0.00061	0.00208	0.00021	120	120	120	0	0	1	-360	360;
	2072	1920	0.01249	0.03219	0.00326	90	90	90	0	0	1	-360	360;
	1922	1921	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1995	1921	0.00595	0.02016	0.002	90	90	90	0	0	1	-360	360;
	2012	1922	0.00486	0.01645	0.00163	120	120	120	0	0	1	-360	360;
	2080	1922	0.01179	0.03074	0.00305	90	90	90	0	0	1	-360	360;
	2076	1923	0.00303	0.01029	0.00102	120	120	120	0	0	1	-360	360;
	1933	1925	0.01028	0.02164	0.0021	90	90	90	0	0	1	-360	360;
	2073	1927	0.0038	0.01264	0.00119	137	137	137	0	0	1	-360	360;
	2018	1929	0.00413	0.01405	0.00138	137	137	137	0	0	1	-360	360;
	1930	2074	0.01431	0.03325	0.00323	90	90	90	0	0	1	-360	360;
	1977	1931	0.02149	0.06942	0.00711	137	137	137	0	0	1	-360	360;
	2095	1933	0.00711	0.01942	0.00201	120	120	120	0	0	1	-360	360;
	1988	1934	0.04959	0.08678	0.009	68	68	68	0	0	1	-360	360;
	1936	2044	0.00266	0.00902	0.00089	137	137	137	0	0	1	-360	360;
	1937	2045	0.00266	0.00902	0.00089	137	137	137	0	0	1	-360	360;
	1938	2091	0.01979	0.03629	0.00348	90	90	90	0	0	1	-360	360;
	1941	2105	0.03843	0.06562	0.00661	90	90	90	0	0	1	-360	360;
	1993	1943	0.02207	0.07149	0.00747	137	137	137	0	0	1	-360	360;
	2049	1944	0.02479	0.08041	0.00832	137	137	137	0	0	1	-360	360;
	2015	1946	0.0395	0.07231	0.00728	90	90	90	0	0	1	-360	360;
	1948	1947	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2025	1949	0.00992	0.02314	0.00261	91	91	91	0	0	1	-360	360;
	1951	1950	0.02661	0.08661	0.00899	137	137	137	0	0	1	-360	360;
	1953	1952	0.00595	0.01917	0.00198	137	137	137	0	0	1	-360	360;
	1953	2093	0.02743	0.08885	0.00915	137	137	137	0	0	1	-360	360;
	1956	1955	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2033	1955	0.02479	0.07686	0.00835	120	120	120	0	0	1	-360	360;
	1958	1957	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1957	1987	0.01467	0.0404	0.00628	114	114	114	0	0	1	-360	360;
	2060	1957	0.02208	0.04735	0.00778	120	120	120	0	0	1	-360	360;
	1973	1963	0.00744	0.02314	0.0024	114	114	114	0	0	1	-360	360;
	2048	1965	0.0762	0.13	0.01309	90	90	90	0	0	1	-360	360;
	2084	1965	0.01777	0.05818	0.00595	137	137	137	0	0	1	-360	360;
	1966	2090	0.02835	0.09504	0.00937	137	137	137	0	0	1	-360	360;
	2114	1966	0.0281	0.04876	0.00477	90	90	90	0	0	1	-360	360;
	1987	1967	0.0081	0.02742	0.00272	114	114	114	0	0	1	-360	360;
	2048	1968	0.03174	0.1075	0.01064	137	137	137	0	0	1	-360	360;
	1968	2113	0.03366	0.11402	0.01129	137	137	137	0	0	1	-360	360;
	1999	1970	0.01661	0.0538	0.00557	91	91	91	0	0	1	-360	360;
	2038	1970	0.03529	0.06033	0.00605	90	90	90	0	0	1	-360	360;
	2047	1971	0.04281	0.07322	0.00733	90	90	90	0	0	1	-360	360;
	2091	1972	0.02727	0.09165	0.00901	137	137	137	0	0	1	-360	360;
	1976	1974	0.05388	0.0943	0.00898	90	90	90	0	0	1	-360	360;
	2037	1977	0.02562	0.08264	0.00854	137	137	137	0	0	1	-360	360;
	1978	2013	0.02066	0.06686	0.00692	137	137	137	0	0	1	-360	360;
	1979	2074	0.00513	0.00898	0.00086	90	90	90	0	0	1	-360	360;
	1980	2077	0.00553	0.00967	0.00092	120	120	120	0	0	1	-360	360;
	1982	1981	0	0.0001	0	438	438	438	0	0	1	-360	360;
	1987	1981	0.02975	0.04207	0.00404	68	68	68	0	0	1	-360	360;
	2063	1984	0.02263	0.03957	0.00378	137	137	137	0	0	1	-360	360;
	1987	2014	0.01127	0.02548	0.00247	90	90	90	0	0	1	-360	360;
	1988	2108	0.0157	0.02727	0.00286	68	68	68	0	0	1	-360	360;
	1991	1989	0.00752	0.01835	0.00196	90	90	90	0	0	1	-360	360;
	2049	1989	0.00752	0.01835	0.00196	90	90	90	0	0	1	-360	360;
	1990	2079	0.00445	0.01505	0.00149	137	137	137	0	0	1	-360	360;
	2078	1995	0.01093	0.03048	0.00307	76	76	76	0	0	1	-360	360;
	2085	1996	0.02496	0.08446	0.00847	137	137	137	0	0	1	-360	360;
	2023	2001	0.02289	0.06215	0.00636	120	120	120	0	0	1	-360	360;
	2011	2003	0.00413	0.00909	0.00094	137	137	137	0	0	1	-360	360;
	2006	2004	0.00331	0.00992	0.00099	137	137	137	0	0	1	-360	360;
	2007	2005	0.00413	0.01157	0.00104	137	137	137	0	0	1	-360	360;
	2008	2006	0.00909	0.0314	0.00327	137	137	137	0	0	1	-360	360;
	2010	2006	0.00413	0.00992	0.00099	137	137	137	0	0	1	-360	360;
	2009	2007	0.0124	0.0405	0.00416	140	140	140	0	0	1	-360	360;
	2010	2007	0.00413	0.01074	0.00099	137	137	137	0	0	1	-360	360;
	2011	2010	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2019	2018	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2040	2021	0.00697	0.0236	0.00234	137	137	137	0	0	1	-360	360;
	2056	2021	0.00496	0.0157	0.0008	90	90	90	0	0	1	-360	360;
	2058	2021	0.0157	0.02727	0.00264	137	137	137	0	0	1	-360	360;
	2035	2022	0.00909	0.0281	0.00307	137	137	137	0	0	1	-360	360;
	2037	2022	0.01157	0.03636	0.00399	120	120	120	0	0	1	-360	360;
	2026	2025	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2029	2064	0.02679	0.09072	0.00898	137	137	137	0	0	1	-360	360;
	2075	2032	0.0576	0.12215	0.01179	90	90	90	0	0	1	-360	360;
	2050	2034	0.00165	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2058	2034	0.00909	0.0281	0.00307	137	137	137	0	0	1	-360	360;
	2037	2036	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2036	2039	0.00707	0.02395	0.00237	137	137	137	0	0	1	-360	360;
	2055	2037	0.01983	0.0338	0.00329	90	90	90	0	0	1	-360	360;
	2106	2038	0.05808	0.10375	0.00991	90	90	90	0	0	1	-360	360;
	2053	2042	0.00992	0.02231	0.00242	90	90	90	0	0	1	-360	360;
	2052	2045	0.01818	0.03554	0.0039	90	90	90	0	0	1	-360	360;
	2069	2046	0.00207	0.00364	0.00034	90	90	90	0	0	1	-360	360;
	2051	2079	0.00497	0.01683	0.00167	137	137	137	0	0	1	-360	360;
	2057	2052	0.00055	0.00182	0.02683	118	118	118	0	0	1	-360	360;
	2248	2054	0.03074	0.09917	0.01021	137	137	137	0	0	1	-360	360;
	2059	2091	0.02364	0.05992	0.00618	120	120	120	0	0	1	-360	360;
	2067	2107	0.02174	0.0516	0.00502	90	90	90	0	0	1	-360	360;
	2074	2072	0.00474	0.00829	0.00079	90	90	90	0	0	1	-360	360;
	2081	2076	4e-05	0.00014	1e-05	120	120	120	0	0	1	-360	360;
	2094	2078	0.00383	0.00669	0.00064	76	76	76	0	0	1	-360	360;
	2115	2080	0.00014	0.00024	2e-05	90	90	90	0	0	1	-360	360;
	2089	2088	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2092	2088	0.02231	0.07182	0.00745	114	114	114	0	0	1	-360	360;
	2091	2090	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2099	2097	0.01008	0.01736	0.00172	90	90	90	0	0	1	-360	360;
	2099	2098	0.01083	0.01893	0.00181	90	90	90	0	0	1	-360	360;
	2109	2108	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2166	2116	0.00612	0.0157	0.00157	120	120	120	0	0	1	-360	360;
	2116	2167	0.00331	0.01091	0.00111	137	137	137	0	0	1	-360	360;
	2216	2117	0.03769	0.12149	0.01249	68	68	68	0	0	1	-360	360;
	2117	2235	0.0414	0.06942	0.00711	68	68	68	0	0	1	-360	360;
	2118	2131	0.00653	0.02116	0.0022	137	137	137	0	0	1	-360	360;
	2118	2134	0.01397	0.04463	0.00462	125	125	125	0	0	1	-360	360;
	2123	2119	0.00231	0.00752	0.00077	137	137	137	0	0	1	-360	360;
	2119	2220	0.00264	0.00752	0.00075	120	120	120	0	0	1	-360	360;
	2119	2311	0.01314	0.04182	0.00448	137	137	137	0	0	1	-360	360;
	2368	2119	0.00157	0.00496	0.00051	137	137	137	0	0	1	-360	360;
	2368	2119	0.00157	0.00496	0.00051	137	137	137	0	0	1	-360	360;
	2369	2119	0.00215	0.00719	0.00072	57	57	57	0	0	1	-360	360;
	2245	2120	0.03905	0.12628	0.01297	95	95	95	0	0	1	-360	360;
	2120	2365	0.0214	0.06917	0.0071	137	137	137	0	0	1	-360	360;
	2122	2121	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2121	2158	0.02355	0.06215	0.00639	81	81	81	0	0	1	-360	360;
	2199	2121	0.0276	0.0495	0.00448	68	68	68	0	0	1	-360	360;
	2121	2380	0.06645	0.17719	0.01791	70	70	70	0	0	1	-360	360;
	2122	2315	0.0376	0.09174	0.00968	99	99	99	0	0	1	-360	360;
	2306	2123	0.00397	0.01298	0.00131	137	137	137	0	0	1	-360	360;
	2124	2129	0.01322	0.01777	0.00191	61	61	61	0	0	1	-360	360;
	2250	2124	0.03636	0.12066	0.01181	114	114	114	0	0	1	-360	360;
	2124	2308	0.02331	0.07893	0.00745	68	68	68	0	0	1	-360	360;
	2229	2125	0.021	0.0679	0.00696	122	122	122	0	0	1	-360	360;
	2125	2377	0.02139	0.06954	0.00729	120	120	120	0	0	1	-360	360;
	2126	2132	0.00306	0.00992	0.00102	137	137	137	0	0	1	-360	360;
	2194	2126	0.00331	0.01083	0.00109	137	137	137	0	0	1	-360	360;
	2127	2284	0.01653	0.0314	0.0029	47	47	47	0	0	1	-360	360;
	2290	2127	0.03347	0.06529	0.00593	68	68	68	0	0	1	-360	360;
	2128	2365	0.00281	0.00917	0.00094	122	122	122	0	0	1	-360	360;
	2129	2193	0.02231	0.07231	0.01493	75	75	75	0	0	1	-360	360;
	2130	2137	0.0374	0.12066	0.01272	140	140	140	0	0	1	-360	360;
	2131	2306	0.00198	0.00628	0.00065	137	137	137	0	0	1	-360	360;
	2132	2196	0.00421	0.01058	0.00106	120	120	120	0	0	1	-360	360;
	2134	2133	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2269	2133	0.00868	0.0281	0.00295	87	87	87	0	0	1	-360	360;
	2194	2134	0.0186	0.0562	0.00581	81	81	81	0	0	1	-360	360;
	2337	2134	0.0205	0.06876	0.00688	137	137	137	0	0	1	-360	360;
	2164	2135	0.03669	0.06471	0.00611	90	90	90	0	0	1	-360	360;
	2135	2268	0.01975	0.06215	0.00675	90	90	90	0	0	1	-360	360;
	2251	2136	0.03124	0.05603	0.00563	83	83	83	0	0	1	-360	360;
	2136	2282	0.0262	0.04397	0.00434	78	78	78	0	0	1	-360	360;
	2137	2142	0.00545	0.0076	0.00077	68	68	68	0	0	1	-360	360;
	2146	2137	0.03413	0.05992	0.00566	47	47	47	0	0	1	-360	360;
	2137	2348	0.06843	0.09157	0.0084	68	68	68	0	0	1	-360	360;
	2139	2138	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2138	2169	0.03025	0.09752	0.01002	85	85	85	0	0	1	-360	360;
	2173	2138	0.00983	0.01736	0.0016	137	137	137	0	0	1	-360	360;
	2138	2377	0.03669	0.11818	0.01217	95	95	95	0	0	1	-360	360;
	2255	2139	0.00711	0.02314	0.00234	123	123	123	0	0	1	-360	360;
	2139	2304	0.00331	0.01074	0.00109	137	137	137	0	0	1	-360	360;
	2140	2339	0.01719	0.05777	0.00578	68	68	68	0	0	1	-360	360;
	2349	2140	0.01636	0.05289	0.00558	140	140	140	0	0	1	-360	360;
	2349	2140	0.01636	0.05289	0.00558	140	140	140	0	0	1	-360	360;
	2345	2141	0.02132	0.06942	0.00707	137	137	137	0	0	1	-360	360;
	2141	2357	0.02769	0.0895	0.00917	95	95	95	0	0	1	-360	360;
	2142	2316	0.06661	0.11306	0.01118	68	68	68	0	0	1	-360	360;
	2143	2187	0.02868	0.09256	0.00951	57	57	57	0	0	1	-360	360;
	2294	2143	0.01851	0.0595	0.00627	125	125	125	0	0	1	-360	360;
	2145	2144	0.01223	0.0386	0.0042	30	30	30	0	0	1	-360	360;
	2145	2328	0.0395	0.12455	0.01176	38	38	38	0	0	1	-360	360;
	2189	2146	0.01455	0.04702	0.00483	68	68	68	0	0	1	-360	360;
	2169	2147	0.01116	0.01529	0.00275	114	114	114	0	0	1	-360	360;
	2147	2233	0.01116	0.01529	0.00275	114	114	114	0	0	1	-360	360;
	2148	2374	0.00182	0.00388	0.00027	76	76	76	0	0	1	-360	360;
	2313	2149	0.01824	0.05899	0.00605	122	122	122	0	0	1	-360	360;
	2229	2150	0.0405	0.07107	0.00673	90	90	90	0	0	1	-360	360;
	2150	2322	0.04628	0.07107	0.0076	78	78	78	0	0	1	-360	360;
	2164	2151	0.03587	0.07132	0.00624	90	90	90	0	0	1	-360	360;
	2151	2323	0.03587	0.07132	0.00624	38	38	38	0	0	1	-360	360;
	2152	2260	0.02234	0.07496	0.00748	68	68	68	0	0	1	-360	360;
	2290	2152	0.02041	0.07165	0.0075	68	68	68	0	0	1	-360	360;
	2374	2153	0.03653	0.06413	0.00605	68	68	68	0	0	1	-360	360;
	2154	2200	0.01364	0.03554	0.0037	120	120	120	0	0	1	-360	360;
	2154	2303	0.00851	0.02174	0.0022	120	120	120	0	0	1	-360	360;
	2360	2155	0.00967	0.01702	0.0016	90	90	90	0	0	1	-360	360;
	2155	2362	0.0057	0.01017	0.00094	68	68	68	0	0	1	-360	360;
	2156	2157	0.05504	0.1643	0.01682	68	68	68	0	0	1	-360	360;
	2366	2156	0.0214	0.06887	0.00708	68	68	68	0	0	1	-360	360;
	2158	2157	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2214	2157	0.00926	0.03008	0.00307	119	119	119	0	0	1	-360	360;
	2351	2157	0.02661	0.08942	0.00895	137	137	137	0	0	1	-360	360;
	2213	2158	0.00909	0.02975	0.00302	137	137	137	0	0	1	-360	360;
	2160	2159	0.00909	0.0281	0.00288	133	133	133	0	0	1	-360	360;
	2159	2165	0.1	0.1595	0.01597	85	85	85	0	0	1	-360	360;
	2159	2251	0.03587	0.05868	0.00646	90	90	90	0	0	1	-360	360;
	2284	2159	0.01653	0.0314	0.00315	47	47	47	0	0	1	-360	360;
	2375	2159	0.00165	0.00529	0.00053	137	137	137	0	0	1	-360	360;
	2279	2160	0.02041	0.06612	0.00678	95	95	95	0	0	1	-360	360;
	2298	2161	0.02975	0.09587	0.01007	137	137	137	0	0	1	-360	360;
	2161	2375	0.00331	0.01058	0.00109	137	137	137	0	0	1	-360	360;
	2162	2195	0.00562	0.01893	0.00189	32	32	32	0	0	1	-360	360;
	2163	2196	0.00562	0.01893	0.00189	32	32	32	0	0	1	-360	360;
	2233	2165	0.00124	0.00413	0.00039	127	127	127	0	0	1	-360	360;
	2165	2263	0.00793	0.02231	0.00215	122	122	122	0	0	1	-360	360;
	2296	2165	0.00124	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2328	2165	0.05455	0.18017	0.0242	99	99	99	0	0	1	-360	360;
	2166	2168	0.02074	0.06727	0.00682	137	137	137	0	0	1	-360	360;
	2171	2166	0.0076	0.01983	0.00206	120	120	120	0	0	1	-360	360;
	2282	2166	0.01281	0.02149	0.00212	78	78	78	0	0	1	-360	360;
	2297	2166	0.00124	0.00413	0.00041	137	137	137	0	0	1	-360	360;
	2338	2166	0.03248	0.1081	0.01445	137	137	137	0	0	1	-360	360;
	2167	2169	0.01917	0.02595	0.00467	68	68	68	0	0	1	-360	360;
	2286	2167	0.00504	0.01686	0.00174	137	137	137	0	0	1	-360	360;
	2167	2287	0.00463	0.01488	0.00152	137	137	137	0	0	1	-360	360;
	2167	2371	0.00463	0.01488	0.00152	120	120	120	0	0	1	-360	360;
	2263	2168	0.00132	0.00421	0.00044	137	137	137	0	0	1	-360	360;
	2168	2275	0.00661	0.0157	0.00169	102	102	102	0	0	1	-360	360;
	2168	2370	0.00463	0.01488	0.00152	120	120	120	0	0	1	-360	360;
	2299	2169	0.03587	0.09008	0.00924	114	114	114	0	0	1	-360	360;
	2307	2169	0.00124	0.00413	0.00039	127	127	127	0	0	1	-360	360;
	2205	2170	0.0395	0.06959	0.00657	72	72	72	0	0	1	-360	360;
	2206	2170	0.01149	0.03471	0.00293	120	120	120	0	0	1	-360	360;
	2241	2170	0.03479	0.1119	0.01176	76	76	76	0	0	1	-360	360;
	2275	2170	0.01405	0.03636	0.00399	102	102	102	0	0	1	-360	360;
	2170	2327	0.01496	0.0438	0.00445	114	114	114	0	0	1	-360	360;
	2367	2170	0.015	0.04714	0.00466	114	114	114	0	0	1	-360	360;
	2330	2171	0.01545	0.04603	0.00472	120	120	120	0	0	1	-360	360;
	2173	2172	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2180	2172	0.00124	0.00413	0.00039	127	127	127	0	0	1	-360	360;
	2172	2341	0.00099	0.00347	0.00036	137	137	137	0	0	1	-360	360;
	2172	2356	0.01083	0.03471	0.00358	137	137	137	0	0	1	-360	360;
	2173	2179	0.00496	0.01273	0.00128	95	95	95	0	0	1	-360	360;
	2173	2332	0.00124	0.00413	0.00039	127	127	127	0	0	1	-360	360;
	2174	2257	0.01039	0.05083	0.00494	133	133	133	0	0	1	-360	360;
	2267	2174	0.02446	0.04347	0.00404	68	68	68	0	0	1	-360	360;
	2185	2175	0.00149	0.00496	0.00048	137	137	137	0	0	1	-360	360;
	2175	2186	0.0057	0.01818	0.00189	137	137	137	0	0	1	-360	360;
	2176	2247	0.0181	0.05702	0.0062	68	68	68	0	0	1	-360	360;
	2177	2232	0.0676	0.11901	0.0112	68	68	68	0	0	1	-360	360;
	2352	2177	0.03868	0.0681	0.00639	68	68	68	0	0	1	-360	360;
	2178	2199	0.03967	0.07157	0.00641	68	68	68	0	0	1	-360	360;
	2209	2178	0.02983	0.05793	0.00547	68	68	68	0	0	1	-360	360;
	2179	2299	0.00372	0.00934	0.00094	120	120	120	0	0	1	-360	360;
	2332	2180	0.00124	0.00413	0.00039	127	127	127	0	0	1	-360	360;
	2181	2339	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2182	2340	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2183	2235	0.03314	0.06116	0.00639	68	68	68	0	0	1	-360	360;
	2184	2286	0.00909	0.02893	0.0029	137	137	137	0	0	1	-360	360;
	2296	2184	0.00545	0.01736	0.00177	137	137	137	0	0	1	-360	360;
	2325	2185	0.00273	0.00826	0.00085	120	120	120	0	0	1	-360	360;
	2188	2186	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2193	2186	0.0314	0.09884	0.01074	125	125	125	0	0	1	-360	360;
	2309	2186	0.00736	0.0238	0.00251	114	114	114	0	0	1	-360	360;
	2221	2187	0.04025	0.13025	0.01336	106	106	106	0	0	1	-360	360;
	2225	2187	0.02124	0.0686	0.00704	99	99	99	0	0	1	-360	360;
	2352	2187	0.04248	0.11207	0.01135	68	68	68	0	0	1	-360	360;
	2221	2188	0.04	0.12959	0.01329	114	114	114	0	0	1	-360	360;
	2324	2188	0.0095	0.02455	0.00256	114	114	114	0	0	1	-360	360;
	2285	2190	0.03669	0.11669	0.01251	68	68	68	0	0	1	-360	360;
	2190	2382	0.03306	0.08264	0.00968	68	68	68	0	0	1	-360	360;
	2228	2191	0.00983	0.01727	0.00163	68	68	68	0	0	1	-360	360;
	2250	2191	0.04669	0.08182	0.00774	90	90	90	0	0	1	-360	360;
	2191	2276	0.00992	0.03322	0.00419	106	106	106	0	0	1	-360	360;
	2191	2335	0.02455	0.07992	0.00823	137	137	137	0	0	1	-360	360;
	2192	2237	0.00926	0.0238	0.00242	120	120	120	0	0	1	-360	360;
	2274	2192	0.01033	0.02653	0.00269	108	108	108	0	0	1	-360	360;
	2196	2195	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2212	2195	0.03025	0.06281	0.00061	99	99	99	0	0	1	-360	360;
	2336	2195	0.0376	0.12165	0.01249	80	80	80	0	0	1	-360	360;
	2368	2195	0.00736	0.0238	0.00244	89	89	89	0	0	1	-360	360;
	2204	2196	0.04124	0.07231	0.00687	68	68	68	0	0	1	-360	360;
	2220	2196	0.00405	0.01058	0.00109	95	95	95	0	0	1	-360	360;
	2302	2196	0.00091	0.00306	0.00031	45	45	45	0	0	1	-360	360;
	2274	2197	0.00851	0.02074	0.00232	114	114	114	0	0	1	-360	360;
	2197	2333	0.0405	0.09669	0.01016	120	120	120	0	0	1	-360	360;
	2198	2258	0.03025	0.09752	0.01028	140	140	140	0	0	1	-360	360;
	2198	2272	0.01446	0.05554	0.00448	68	68	68	0	0	1	-360	360;
	2200	2361	0.05769	0.14545	0.015	76	76	76	0	0	1	-360	360;
	2202	2201	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2202	2376	0.04702	0.07851	0.00808	68	68	68	0	0	1	-360	360;
	2203	2205	0.05306	0.09355	0.00884	72	72	72	0	0	1	-360	360;
	2320	2203	0.05807	0.10306	0.00937	76	76	76	0	0	1	-360	360;
	2328	2203	0.05397	0.17008	0.01848	137	137	137	0	0	1	-360	360;
	2210	2204	0.00361	0.01166	0.0012	137	137	137	0	0	1	-360	360;
	2356	2206	0.00826	0.02893	0.00363	120	120	120	0	0	1	-360	360;
	2207	2209	0.00521	0.01413	0.0014	90	90	90	0	0	1	-360	360;
	2208	2255	0.00289	0.00926	0.00094	137	137	137	0	0	1	-360	360;
	2341	2208	0.00207	0.00694	0.0007	137	137	137	0	0	1	-360	360;
	2209	2351	0.01843	0.0619	0.0062	137	137	137	0	0	1	-360	360;
	2316	2210	0.06898	0.12121	0.01145	57	57	57	0	0	1	-360	360;
	2211	2214	0.00132	0.00421	0.00044	99	99	99	0	0	1	-360	360;
	2224	2211	0.00744	0.02397	0.00246	125	125	125	0	0	1	-360	360;
	2295	2212	0.01322	0.03306	0.00327	114	114	114	0	0	1	-360	360;
	2224	2213	0.01595	0.05124	0.0053	137	137	137	0	0	1	-360	360;
	2215	2217	0.00661	0.01372	0.00133	114	114	114	0	0	1	-360	360;
	2278	2215	0.03545	0.08736	0.00882	114	114	114	0	0	1	-360	360;
	2218	2216	0.01942	0.06281	0.00649	68	68	68	0	0	1	-360	360;
	2237	2217	0.00785	0.01983	0.00203	120	120	120	0	0	1	-360	360;
	2245	2218	0.02339	0.07587	0.00784	34	34	34	0	0	1	-360	360;
	2301	2218	0.01568	0.0507	0.0052	83	83	83	0	0	1	-360	360;
	2219	2251	0.03347	0.06529	0.00593	21	21	21	0	0	1	-360	360;
	2223	2221	0.00405	0.01331	0.00138	95	95	95	0	0	1	-360	360;
	2221	2238	0.04033	0.13041	0.01336	137	137	137	0	0	1	-360	360;
	2222	2227	0.0181	0.05702	0.0062	95	95	95	0	0	1	-360	360;
	2222	2352	0.02041	0.06843	0.00685	122	122	122	0	0	1	-360	360;
	2240	2223	0.02074	0.06628	0.00699	125	125	125	0	0	1	-360	360;
	2224	2318	0.03347	0.06529	0.00593	68	68	68	0	0	1	-360	360;
	2276	2225	0.03364	0.10744	0.01016	106	106	106	0	0	1	-360	360;
	2362	2226	0.03479	0.10281	0.01045	99	99	99	0	0	1	-360	360;
	2227	2339	0.00851	0.02686	0.0029	95	95	95	0	0	1	-360	360;
	2267	2228	0.05322	0.09347	0.00882	68	68	68	0	0	1	-360	360;
	2230	2229	0.00413	0.01372	0.00138	137	137	137	0	0	1	-360	360;
	2355	2230	0.03438	0.06099	0.00569	137	137	137	0	0	1	-360	360;
	2231	2236	0.01992	0.05245	0.00519	120	120	120	0	0	1	-360	360;
	2334	2231	0.01187	0.03176	0.00315	120	120	120	0	0	1	-360	360;
	2292	2232	0.05042	0.10487	0.0102	68	68	68	0	0	1	-360	360;
	2232	2362	0.03198	0.07876	0.00786	90	90	90	0	0	1	-360	360;
	2233	2259	0.00124	0.00413	0.00039	127	127	127	0	0	1	-360	360;
	2233	2259	0.00124	0.00413	0.00039	127	127	127	0	0	1	-360	360;
	2234	2361	0.01579	0.04017	0.00408	77	77	77	0	0	1	-360	360;
	2235	2257	0.03603	0.12893	0.01251	68	68	68	0	0	1	-360	360;
	2236	2359	0.03678	0.09397	0.00951	120	120	120	0	0	1	-360	360;
	2247	2237	0.00826	0.02628	0.00286	68	68	68	0	0	1	-360	360;
	2273	2237	0.0162	0.0338	0.00351	90	90	90	0	0	1	-360	360;
	2238	2298	0.00512	0.01653	0.00174	137	137	137	0	0	1	-360	360;
	2268	2239	0.05661	0.09983	0.00943	45	45	45	0	0	1	-360	360;
	2239	2380	0.04438	0.07826	0.00739	45	45	45	0	0	1	-360	360;
	2335	2240	0.02835	0.09223	0.00951	137	137	137	0	0	1	-360	360;
	2338	2241	0.00702	0.0224	0.00237	122	122	122	0	0	1	-360	360;
	2246	2242	0.0205	0.06876	0.00688	68	68	68	0	0	1	-360	360;
	2242	2280	0.0205	0.06876	0.00688	137	137	137	0	0	1	-360	360;
	2309	2243	0.00826	0.01653	0.00194	114	114	114	0	0	1	-360	360;
	2324	2243	0.00421	0.01074	0.00121	114	114	114	0	0	1	-360	360;
	2310	2244	0.02901	0.09438	0.00966	76	76	76	0	0	1	-360	360;
	2346	2244	0.03058	0.05372	0.00508	78	78	78	0	0	1	-360	360;
	2246	2258	0.0331	0.11107	0.01106	114	114	114	0	0	1	-360	360;
	2248	2269	0.02479	0.08	0.00823	137	137	137	0	0	1	-360	360;
	2249	2262	0.02818	0.09116	0.00934	68	68	68	0	0	1	-360	360;
	2252	2311	0.03099	0.07901	0.00801	120	120	120	0	0	1	-360	360;
	2253	2274	0.02231	0.05702	0.00576	120	120	120	0	0	1	-360	360;
	2323	2254	0.03091	0.08107	0.00774	68	68	68	0	0	1	-360	360;
	2254	2380	0.04207	0.11074	0.01053	68	68	68	0	0	1	-360	360;
	2256	2283	0.00248	0.00744	0.00073	120	120	120	0	0	1	-360	360;
	2287	2256	0.00306	0.00992	0.00102	137	137	137	0	0	1	-360	360;
	2258	2257	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2257	2260	0.01281	0.04298	0.00428	114	114	114	0	0	1	-360	360;
	2262	2257	0.03587	0.1157	0.0122	140	140	140	0	0	1	-360	360;
	2258	2261	0.01281	0.04298	0.00428	114	114	114	0	0	1	-360	360;
	2261	2260	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2271	2260	0.01157	0.03769	0.00387	68	68	68	0	0	1	-360	360;
	2331	2260	0.15802	0.18273	0.01643	45	45	45	0	0	1	-360	360;
	2266	2261	0.00661	0.01372	0.00133	114	114	114	0	0	1	-360	360;
	2272	2261	0.00983	0.01752	0.0016	80	80	80	0	0	1	-360	360;
	2365	2261	0.01165	0.03769	0.00387	137	137	137	0	0	1	-360	360;
	2270	2264	0.00661	0.01372	0.00133	68	68	68	0	0	1	-360	360;
	2264	2271	0.00537	0.01736	0.00179	68	68	68	0	0	1	-360	360;
	2355	2265	0.0395	0.1281	0.01314	137	137	137	0	0	1	-360	360;
	2265	2378	0.00165	0.00496	0.00053	137	137	137	0	0	1	-360	360;
	2272	2270	0.00661	0.01372	0.00133	114	114	114	0	0	1	-360	360;
	2274	2273	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2310	2273	0.00942	0.03066	0.00315	102	102	102	0	0	1	-360	360;
	2376	2273	0.06223	0.10413	0.01072	62	62	62	0	0	1	-360	360;
	2277	2366	0.00026	0.00066	7e-05	68	68	68	0	0	1	-360	360;
	2280	2279	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2281	2334	0.00843	0.02149	0.00216	120	120	120	0	0	1	-360	360;
	2338	2281	0.00843	0.02149	0.00216	120	120	120	0	0	1	-360	360;
	2283	2326	0.00364	0.01074	0.00106	114	114	114	0	0	1	-360	360;
	2285	2314	0.01967	0.08612	0.00924	57	57	57	0	0	1	-360	360;
	2288	2344	0.00529	0.01074	0.00111	90	90	90	0	0	1	-360	360;
	2288	2345	0.01554	0.05455	0.00557	137	137	137	0	0	1	-360	360;
	2310	2289	0.02781	0.08994	0.01845	114	114	114	0	0	1	-360	360;
	2291	2305	0.034	0.10995	0.02256	68	68	68	0	0	1	-360	360;
	2308	2292	0.01976	0.0514	0.00515	68	68	68	0	0	1	-360	360;
	2327	2293	0.00777	0.02479	0.00257	137	137	137	0	0	1	-360	360;
	2293	2330	0.00736	0.02372	0.00242	137	137	137	0	0	1	-360	360;
	2336	2294	0.00207	0.00727	0.0007	125	125	125	0	0	1	-360	360;
	2379	2295	0.05686	0.09339	0.00944	114	114	114	0	0	1	-360	360;
	2304	2300	0.00645	0.02066	0.00213	137	137	137	0	0	1	-360	360;
	2300	2353	0.04174	0.07322	0.00692	90	90	90	0	0	1	-360	360;
	2354	2300	0.01132	0.03636	0.00375	137	137	137	0	0	1	-360	360;
	2303	2343	0.00281	0.00702	0.00059	114	114	114	0	0	1	-360	360;
	2305	2316	0.01607	0.05279	0.01083	68	68	68	0	0	1	-360	360;
	2312	2313	0.00347	0.01264	0.00119	122	122	122	0	0	1	-360	360;
	2319	2313	0.05314	0.09339	0.0089	68	68	68	0	0	1	-360	360;
	2313	2381	0.07661	0.13182	0.013	68	68	68	0	0	1	-360	360;
	2329	2317	0.01405	0.02314	0.00234	90	90	90	0	0	1	-360	360;
	2317	2350	0.0281	0.04711	0.00465	68	68	68	0	0	1	-360	360;
	2318	2321	0.03347	0.06529	0.00593	68	68	68	0	0	1	-360	360;
	2374	2319	0.08314	0.14628	0.01392	68	68	68	0	0	1	-360	360;
	2321	2323	0.05107	0.08512	0.00898	51	51	51	0	0	1	-360	360;
	2322	2323	0.01653	0.03306	0.00242	68	68	68	0	0	1	-360	360;
	2323	2329	0.00496	0.00826	0.00085	78	78	78	0	0	1	-360	360;
	2323	2380	0.07306	0.1919	0.01832	68	68	68	0	0	1	-360	360;
	2359	2324	0.02017	0.05223	0.00545	120	120	120	0	0	1	-360	360;
	2324	2379	0.03562	0.10942	0.01146	68	68	68	0	0	1	-360	360;
	2326	2367	0.00525	0.0165	0.00163	114	114	114	0	0	1	-360	360;
	2340	2339	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2342	2339	0.00421	0.01355	0.0014	131	131	131	0	0	1	-360	360;
	2343	2339	0.00306	0.00992	0.00102	114	114	114	0	0	1	-360	360;
	2342	2343	0.00554	0.01793	0.00184	137	137	137	0	0	1	-360	360;
	2344	2342	0.01777	0.05736	0.00588	137	137	137	0	0	1	-360	360;
	2347	2342	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2347	2342	0.00992	0.03488	0.00407	76	76	76	0	0	1	-360	360;
	2348	2379	0.08653	0.11405	0.01019	57	57	57	0	0	1	-360	360;
	2350	2366	0.01686	0.05427	0.00558	68	68	68	0	0	1	-360	360;
	2353	2378	0.02306	0.07438	0.00765	137	137	137	0	0	1	-360	360;
	2354	2377	0.01736	0.05686	0.00578	137	137	137	0	0	1	-360	360;
	2358	2357	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2357	2363	0.01504	0.04132	0.00426	90	90	90	0	0	1	-360	360;
	2357	2372	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2357	2372	0.00496	0.00744	0.00073	114	114	114	0	0	1	-360	360;
	2358	2361	0.01843	0.06	0.00615	137	137	137	0	0	1	-360	360;
	2363	2360	0.00934	0.01653	0.00174	90	90	90	0	0	1	-360	360;
	2362	2361	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2364	2367	0.00026	0.00066	7e-05	114	114	114	0	0	1	-360	360;
	2373	2372	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2378	2377	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2381	2380	0	0.0001	0	438	438	438	0	0	1	-360	360;
	2382	2381	0.01264	0.03802	0.00273	114	114	114	0	0	1	-360	360;
];

%%-----  OPF Data  -----%%
%% area data
%	area	refbus
mpc.areas = [
	1	18;
];

%% generator cost data
%	1	startup	shutdown	n	x1	y1	...	xn	yn
%	2	startup	shutdown	n	c(n-1)	...	c0
mpc.gencost = [
	2	0	0	3	0	117.95	0;
	2	0	0	3	0	48.89	0;
	2	0	0	3	0	98.47	0;
	2	0	0	3	0	128.73	0;
	2	0	0	3	0	158.23	0;
	2	0	0	3	0	165.62	0;
	2	0	0	3	0	71.22	0;
	2	0	0	3	0	102.25	0;
	2	0	0	3	0	147.83	0;
	2	0	0	3	0	75.37	0;
	2	0	0	3	0	86.01	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	68.74	0;
	2	0	0	3	0	81.91	0;
	2	0	0	3	0	81.88	0;
	2	0	0	3	0	58.78	0;
	2	0	0	3	0	85.57	0;
	2	0	0	3	0	101.38	0;
	2	0	0	3	0	122.43	0;
	2	0	0	3	0	96.62	0;
	2	0	0	3	0	106.73	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	151.94	0;
	2	0	0	3	0	107.51	0;
	2	0	0	3	0	103.53	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	136.48	0;
	2	0	0	3	0	157.46	0;
	2	0	0	3	0	83.97	0;
	2	0	0	3	0	170.74	0;
	2	0	0	3	0	80.91	0;
	2	0	0	3	0	147.6	0;
	2	0	0	3	0	158.75	0;
	2	0	0	3	0	146.94	0;
	2	0	0	3	0	96.32	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	134.98	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	142.94	0;
	2	0	0	3	0	128.22	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	141.73	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	100.82	0;
	2	0	0	3	0	151.9	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	114.15	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	87.95	0;
	2	0	0	3	0	130.25	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	145.97	0;
	2	0	0	3	0	137.58	0;
	2	0	0	3	0	147.36	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	82.92	0;
	2	0	0	3	0	133.59	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	152.95	0;
	2	0	0	3	0	67.35	0;
	2	0	0	3	0	134.93	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	61.32	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	61.4	0;
	2	0	0	3	0	114.99	0;
	2	0	0	3	0	122.64	0;
	2	0	0	3	0	118.84	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	143.83	0;
	2	0	0	3	0	67.48	0;
	2	0	0	3	0	88	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	129.86	0;
	2	0	0	3	0	108.16	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	75.66	0;
	2	0	0	3	0	76.87	0;
	2	0	0	3	0	143.58	0;
	2	0	0	3	0	153.15	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	131.78	0;
	2	0	0	3	0	53.88	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
	2	0	0	3	0	0	0;
];
